package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;

import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;

import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;

import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.eam_core.domain.EMBidding;
import cn.ibizlab.eam.core.eam_core.service.IEMBiddingService;
import cn.ibizlab.eam.core.eam_core.filter.EMBiddingSearchContext;




@Slf4j
@Api(tags = {"EMBidding" })
@RestController("WebApi-embidding")
@RequestMapping("")
public class EMBiddingResource {

    @Autowired
    private IEMBiddingService embiddingService;

    @Autowired
    @Lazy
    private EMBiddingMapping embiddingMapping;




    @PreAuthorize("hasPermission(#embidding_id,'Update',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Update", tags = {"EMBidding" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/embiddings/{embidding_id}")
    @Transactional
    public ResponseEntity<EMBiddingDTO> update(@PathVariable("embidding_id") String embidding_id, @RequestBody EMBiddingDTO embiddingdto) {
		EMBidding domain = embiddingMapping.toDomain(embiddingdto);
        domain.setEmbiddingid(embidding_id);
		embiddingService.update(domain);
		EMBiddingDTO dto = embiddingMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(#embidding_id,'Update',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "UpdateBatch", tags = {"EMBidding" },  notes = "UpdateBatch")
	@RequestMapping(method = RequestMethod.PUT, value = "/embiddings/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<EMBiddingDTO> embiddingdtos) {
        embiddingService.updateBatch(embiddingMapping.toDomain(embiddingdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission(#embidding_id,'Remove',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Remove", tags = {"EMBidding" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/embiddings/{embidding_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("embidding_id") String embidding_id) {
         return ResponseEntity.status(HttpStatus.OK).body(embiddingService.remove(embidding_id));
    }

    @ApiOperation(value = "RemoveBatch", tags = {"EMBidding" },  notes = "RemoveBatch")
	@RequestMapping(method = RequestMethod.DELETE, value = "/embiddings/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        embiddingService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @ApiOperation(value = "Save", tags = {"EMBidding" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/embiddings/save")
    public ResponseEntity<Boolean> save(@RequestBody EMBiddingDTO embiddingdto) {
        return ResponseEntity.status(HttpStatus.OK).body(embiddingService.save(embiddingMapping.toDomain(embiddingdto)));
    }

    @ApiOperation(value = "SaveBatch", tags = {"EMBidding" },  notes = "SaveBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/embiddings/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<EMBiddingDTO> embiddingdtos) {
        embiddingService.saveBatch(embiddingMapping.toDomain(embiddingdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Create", tags = {"EMBidding" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/embiddings")
    @Transactional
    public ResponseEntity<EMBiddingDTO> create(@RequestBody EMBiddingDTO embiddingdto) {
        EMBidding domain = embiddingMapping.toDomain(embiddingdto);
		embiddingService.create(domain);
        EMBiddingDTO dto = embiddingMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }
    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "createBatch", tags = {"EMBidding" },  notes = "createBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/embiddings/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<EMBiddingDTO> embiddingdtos) {
        embiddingService.createBatch(embiddingMapping.toDomain(embiddingdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @ApiOperation(value = "CheckKey", tags = {"EMBidding" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/embiddings/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody EMBiddingDTO embiddingdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(embiddingService.checkKey(embiddingMapping.toDomain(embiddingdto)));
    }




    @PreAuthorize("hasPermission(#embidding_id,'Get',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Get", tags = {"EMBidding" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/embiddings/{embidding_id}")
    public ResponseEntity<EMBiddingDTO> get(@PathVariable("embidding_id") String embidding_id) {
        EMBidding domain = embiddingService.get(embidding_id);
        EMBiddingDTO dto = embiddingMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }




    @ApiOperation(value = "GetDraft", tags = {"EMBidding" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/embiddings/getdraft")
    public ResponseEntity<EMBiddingDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(embiddingMapping.toDto(embiddingService.getDraft(new EMBidding())));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMBidding-Default-all')")
	@ApiOperation(value = "fetchDEFAULT", tags = {"EMBidding" } ,notes = "fetchDEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/embiddings/fetchdefault")
	public ResponseEntity<List<EMBiddingDTO>> fetchDefault(EMBiddingSearchContext context) {
        Page<EMBidding> domains = embiddingService.searchDefault(context) ;
        List<EMBiddingDTO> list = embiddingMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMBidding-Default-all')")
	@ApiOperation(value = "searchDEFAULT", tags = {"EMBidding" } ,notes = "searchDEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/embiddings/searchdefault")
	public ResponseEntity<Page<EMBiddingDTO>> searchDefault(@RequestBody EMBiddingSearchContext context) {
        Page<EMBidding> domains = embiddingService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(embiddingMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}


    /**
     * 用户权限校验
     * @return
     */
	public EMBidding getEntity(){
        return new EMBidding();
    }

}
