package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;

import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;

import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;

import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.eam_core.domain.EMProduct;
import cn.ibizlab.eam.core.eam_core.service.IEMProductService;
import cn.ibizlab.eam.core.eam_core.filter.EMProductSearchContext;




@Slf4j
@Api(tags = {"EMProduct" })
@RestController("WebApi-emproduct")
@RequestMapping("")
public class EMProductResource {

    @Autowired
    private IEMProductService emproductService;

    @Autowired
    @Lazy
    private EMProductMapping emproductMapping;




    @ApiOperation(value = "GetDraft", tags = {"EMProduct" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/emproducts/getdraft")
    public ResponseEntity<EMProductDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(emproductMapping.toDto(emproductService.getDraft(new EMProduct())));
    }




    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Create", tags = {"EMProduct" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/emproducts")
    @Transactional
    public ResponseEntity<EMProductDTO> create(@RequestBody EMProductDTO emproductdto) {
        EMProduct domain = emproductMapping.toDomain(emproductdto);
		emproductService.create(domain);
        EMProductDTO dto = emproductMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }
    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "createBatch", tags = {"EMProduct" },  notes = "createBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emproducts/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<EMProductDTO> emproductdtos) {
        emproductService.createBatch(emproductMapping.toDomain(emproductdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @ApiOperation(value = "Save", tags = {"EMProduct" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/emproducts/save")
    public ResponseEntity<Boolean> save(@RequestBody EMProductDTO emproductdto) {
        return ResponseEntity.status(HttpStatus.OK).body(emproductService.save(emproductMapping.toDomain(emproductdto)));
    }

    @ApiOperation(value = "SaveBatch", tags = {"EMProduct" },  notes = "SaveBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emproducts/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<EMProductDTO> emproductdtos) {
        emproductService.saveBatch(emproductMapping.toDomain(emproductdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @ApiOperation(value = "CheckKey", tags = {"EMProduct" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/emproducts/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody EMProductDTO emproductdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emproductService.checkKey(emproductMapping.toDomain(emproductdto)));
    }




    @PreAuthorize("hasPermission(#emproduct_id,'Remove',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Remove", tags = {"EMProduct" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emproducts/{emproduct_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("emproduct_id") String emproduct_id) {
         return ResponseEntity.status(HttpStatus.OK).body(emproductService.remove(emproduct_id));
    }

    @ApiOperation(value = "RemoveBatch", tags = {"EMProduct" },  notes = "RemoveBatch")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emproducts/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        emproductService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission(#emproduct_id,'Update',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Update", tags = {"EMProduct" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/emproducts/{emproduct_id}")
    @Transactional
    public ResponseEntity<EMProductDTO> update(@PathVariable("emproduct_id") String emproduct_id, @RequestBody EMProductDTO emproductdto) {
		EMProduct domain = emproductMapping.toDomain(emproductdto);
        domain.setEmproductid(emproduct_id);
		emproductService.update(domain);
		EMProductDTO dto = emproductMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(#emproduct_id,'Update',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "UpdateBatch", tags = {"EMProduct" },  notes = "UpdateBatch")
	@RequestMapping(method = RequestMethod.PUT, value = "/emproducts/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<EMProductDTO> emproductdtos) {
        emproductService.updateBatch(emproductMapping.toDomain(emproductdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission(#emproduct_id,'Get',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Get", tags = {"EMProduct" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/emproducts/{emproduct_id}")
    public ResponseEntity<EMProductDTO> get(@PathVariable("emproduct_id") String emproduct_id) {
        EMProduct domain = emproductService.get(emproduct_id);
        EMProductDTO dto = emproductMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMProduct-Default-all')")
	@ApiOperation(value = "fetchDEFAULT", tags = {"EMProduct" } ,notes = "fetchDEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emproducts/fetchdefault")
	public ResponseEntity<List<EMProductDTO>> fetchDefault(EMProductSearchContext context) {
        Page<EMProduct> domains = emproductService.searchDefault(context) ;
        List<EMProductDTO> list = emproductMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMProduct-Default-all')")
	@ApiOperation(value = "searchDEFAULT", tags = {"EMProduct" } ,notes = "searchDEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emproducts/searchdefault")
	public ResponseEntity<Page<EMProductDTO>> searchDefault(@RequestBody EMProductSearchContext context) {
        Page<EMProduct> domains = emproductService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emproductMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}


    /**
     * 用户权限校验
     * @return
     */
	public EMProduct getEntity(){
        return new EMProduct();
    }

}
