package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;

import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;

import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;

import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.eam_core.domain.EMPO;
import cn.ibizlab.eam.core.eam_core.service.IEMPOService;
import cn.ibizlab.eam.core.eam_core.filter.EMPOSearchContext;




@Slf4j
@Api(tags = {"EMPO" })
@RestController("WebApi-empo")
@RequestMapping("")
public class EMPOResource {

    @Autowired
    private IEMPOService empoService;

    @Autowired
    @Lazy
    private EMPOMapping empoMapping;




    @PreAuthorize("hasPermission(#empo_id,'Get',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Get", tags = {"EMPO" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/empos/{empo_id}")
    public ResponseEntity<EMPODTO> get(@PathVariable("empo_id") String empo_id) {
        EMPO domain = empoService.get(empo_id);
        EMPODTO dto = empoMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }




    @ApiOperation(value = "CheckKey", tags = {"EMPO" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/empos/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody EMPODTO empodto) {
        return  ResponseEntity.status(HttpStatus.OK).body(empoService.checkKey(empoMapping.toDomain(empodto)));
    }




    @PreAuthorize("hasPermission(#empo_id,'Remove',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Remove", tags = {"EMPO" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/empos/{empo_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("empo_id") String empo_id) {
         return ResponseEntity.status(HttpStatus.OK).body(empoService.remove(empo_id));
    }

    @ApiOperation(value = "RemoveBatch", tags = {"EMPO" },  notes = "RemoveBatch")
	@RequestMapping(method = RequestMethod.DELETE, value = "/empos/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        empoService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @ApiOperation(value = "GetDraft", tags = {"EMPO" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/empos/getdraft")
    public ResponseEntity<EMPODTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(empoMapping.toDto(empoService.getDraft(new EMPO())));
    }




    @PreAuthorize("hasPermission(#empo_id,'Update',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Update", tags = {"EMPO" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/empos/{empo_id}")
    @Transactional
    public ResponseEntity<EMPODTO> update(@PathVariable("empo_id") String empo_id, @RequestBody EMPODTO empodto) {
		EMPO domain = empoMapping.toDomain(empodto);
        domain.setEmpoid(empo_id);
		empoService.update(domain);
		EMPODTO dto = empoMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(#empo_id,'Update',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "UpdateBatch", tags = {"EMPO" },  notes = "UpdateBatch")
	@RequestMapping(method = RequestMethod.PUT, value = "/empos/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<EMPODTO> empodtos) {
        empoService.updateBatch(empoMapping.toDomain(empodtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Create", tags = {"EMPO" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/empos")
    @Transactional
    public ResponseEntity<EMPODTO> create(@RequestBody EMPODTO empodto) {
        EMPO domain = empoMapping.toDomain(empodto);
		empoService.create(domain);
        EMPODTO dto = empoMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }
    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "createBatch", tags = {"EMPO" },  notes = "createBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/empos/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<EMPODTO> empodtos) {
        empoService.createBatch(empoMapping.toDomain(empodtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @ApiOperation(value = "Save", tags = {"EMPO" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/empos/save")
    public ResponseEntity<Boolean> save(@RequestBody EMPODTO empodto) {
        return ResponseEntity.status(HttpStatus.OK).body(empoService.save(empoMapping.toDomain(empodto)));
    }

    @ApiOperation(value = "SaveBatch", tags = {"EMPO" },  notes = "SaveBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/empos/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<EMPODTO> empodtos) {
        empoService.saveBatch(empoMapping.toDomain(empodtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPO-Default-all')")
	@ApiOperation(value = "fetchDEFAULT", tags = {"EMPO" } ,notes = "fetchDEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/empos/fetchdefault")
	public ResponseEntity<List<EMPODTO>> fetchDefault(EMPOSearchContext context) {
        Page<EMPO> domains = empoService.searchDefault(context) ;
        List<EMPODTO> list = empoMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMPO-Default-all')")
	@ApiOperation(value = "searchDEFAULT", tags = {"EMPO" } ,notes = "searchDEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/empos/searchdefault")
	public ResponseEntity<Page<EMPODTO>> searchDefault(@RequestBody EMPOSearchContext context) {
        Page<EMPO> domains = empoService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(empoMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}


    /**
     * 用户权限校验
     * @return
     */
	public EMPO getEntity(){
        return new EMPO();
    }

}
