package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;

import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;

import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;

import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.eam_core.domain.EMEQLCTRHY;
import cn.ibizlab.eam.core.eam_core.service.IEMEQLCTRHYService;
import cn.ibizlab.eam.core.eam_core.filter.EMEQLCTRHYSearchContext;




@Slf4j
@Api(tags = {"EMEQLCTRHY" })
@RestController("WebApi-emeqlctrhy")
@RequestMapping("")
public class EMEQLCTRHYResource {

    @Autowired
    private IEMEQLCTRHYService emeqlctrhyService;

    @Autowired
    @Lazy
    private EMEQLCTRHYMapping emeqlctrhyMapping;




    @ApiOperation(value = "GetDraft", tags = {"EMEQLCTRHY" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/emeqlctrhies/getdraft")
    public ResponseEntity<EMEQLCTRHYDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(emeqlctrhyMapping.toDto(emeqlctrhyService.getDraft(new EMEQLCTRHY())));
    }




    @PreAuthorize("hasPermission(#emeqlctrhy_id,'Remove',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Remove", tags = {"EMEQLCTRHY" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emeqlctrhies/{emeqlctrhy_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("emeqlctrhy_id") String emeqlctrhy_id) {
         return ResponseEntity.status(HttpStatus.OK).body(emeqlctrhyService.remove(emeqlctrhy_id));
    }

    @ApiOperation(value = "RemoveBatch", tags = {"EMEQLCTRHY" },  notes = "RemoveBatch")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emeqlctrhies/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        emeqlctrhyService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @ApiOperation(value = "Save", tags = {"EMEQLCTRHY" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqlctrhies/save")
    public ResponseEntity<Boolean> save(@RequestBody EMEQLCTRHYDTO emeqlctrhydto) {
        return ResponseEntity.status(HttpStatus.OK).body(emeqlctrhyService.save(emeqlctrhyMapping.toDomain(emeqlctrhydto)));
    }

    @ApiOperation(value = "SaveBatch", tags = {"EMEQLCTRHY" },  notes = "SaveBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqlctrhies/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<EMEQLCTRHYDTO> emeqlctrhydtos) {
        emeqlctrhyService.saveBatch(emeqlctrhyMapping.toDomain(emeqlctrhydtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission(#emeqlctrhy_id,'Update',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Update", tags = {"EMEQLCTRHY" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/emeqlctrhies/{emeqlctrhy_id}")
    @Transactional
    public ResponseEntity<EMEQLCTRHYDTO> update(@PathVariable("emeqlctrhy_id") String emeqlctrhy_id, @RequestBody EMEQLCTRHYDTO emeqlctrhydto) {
		EMEQLCTRHY domain = emeqlctrhyMapping.toDomain(emeqlctrhydto);
        domain.setEmeqlocationid(emeqlctrhy_id);
		emeqlctrhyService.update(domain);
		EMEQLCTRHYDTO dto = emeqlctrhyMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(#emeqlctrhy_id,'Update',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "UpdateBatch", tags = {"EMEQLCTRHY" },  notes = "UpdateBatch")
	@RequestMapping(method = RequestMethod.PUT, value = "/emeqlctrhies/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<EMEQLCTRHYDTO> emeqlctrhydtos) {
        emeqlctrhyService.updateBatch(emeqlctrhyMapping.toDomain(emeqlctrhydtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @ApiOperation(value = "CheckKey", tags = {"EMEQLCTRHY" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqlctrhies/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody EMEQLCTRHYDTO emeqlctrhydto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emeqlctrhyService.checkKey(emeqlctrhyMapping.toDomain(emeqlctrhydto)));
    }




    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Create", tags = {"EMEQLCTRHY" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqlctrhies")
    @Transactional
    public ResponseEntity<EMEQLCTRHYDTO> create(@RequestBody EMEQLCTRHYDTO emeqlctrhydto) {
        EMEQLCTRHY domain = emeqlctrhyMapping.toDomain(emeqlctrhydto);
		emeqlctrhyService.create(domain);
        EMEQLCTRHYDTO dto = emeqlctrhyMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }
    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "createBatch", tags = {"EMEQLCTRHY" },  notes = "createBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqlctrhies/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<EMEQLCTRHYDTO> emeqlctrhydtos) {
        emeqlctrhyService.createBatch(emeqlctrhyMapping.toDomain(emeqlctrhydtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission(#emeqlctrhy_id,'Get',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Get", tags = {"EMEQLCTRHY" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/emeqlctrhies/{emeqlctrhy_id}")
    public ResponseEntity<EMEQLCTRHYDTO> get(@PathVariable("emeqlctrhy_id") String emeqlctrhy_id) {
        EMEQLCTRHY domain = emeqlctrhyService.get(emeqlctrhy_id);
        EMEQLCTRHYDTO dto = emeqlctrhyMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEQLCTRHY-Default-all')")
	@ApiOperation(value = "fetchDEFAULT", tags = {"EMEQLCTRHY" } ,notes = "fetchDEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emeqlctrhies/fetchdefault")
	public ResponseEntity<List<EMEQLCTRHYDTO>> fetchDefault(EMEQLCTRHYSearchContext context) {
        Page<EMEQLCTRHY> domains = emeqlctrhyService.searchDefault(context) ;
        List<EMEQLCTRHYDTO> list = emeqlctrhyMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEQLCTRHY-Default-all')")
	@ApiOperation(value = "searchDEFAULT", tags = {"EMEQLCTRHY" } ,notes = "searchDEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emeqlctrhies/searchdefault")
	public ResponseEntity<Page<EMEQLCTRHYDTO>> searchDefault(@RequestBody EMEQLCTRHYSearchContext context) {
        Page<EMEQLCTRHY> domains = emeqlctrhyService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emeqlctrhyMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}


    /**
     * 用户权限校验
     * @return
     */
	public EMEQLCTRHY getEntity(){
        return new EMEQLCTRHY();
    }

}
