package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;

import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;

import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;

import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.eam_core.domain.EMEICellReturn;
import cn.ibizlab.eam.core.eam_core.service.IEMEICellReturnService;
import cn.ibizlab.eam.core.eam_core.filter.EMEICellReturnSearchContext;




@Slf4j
@Api(tags = {"EMEICellReturn" })
@RestController("WebApi-emeicellreturn")
@RequestMapping("")
public class EMEICellReturnResource {

    @Autowired
    private IEMEICellReturnService emeicellreturnService;

    @Autowired
    @Lazy
    private EMEICellReturnMapping emeicellreturnMapping;




    @ApiOperation(value = "CheckKey", tags = {"EMEICellReturn" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/emeicellreturns/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody EMEICellReturnDTO emeicellreturndto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emeicellreturnService.checkKey(emeicellreturnMapping.toDomain(emeicellreturndto)));
    }




    @ApiOperation(value = "Save", tags = {"EMEICellReturn" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/emeicellreturns/save")
    public ResponseEntity<Boolean> save(@RequestBody EMEICellReturnDTO emeicellreturndto) {
        return ResponseEntity.status(HttpStatus.OK).body(emeicellreturnService.save(emeicellreturnMapping.toDomain(emeicellreturndto)));
    }

    @ApiOperation(value = "SaveBatch", tags = {"EMEICellReturn" },  notes = "SaveBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emeicellreturns/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<EMEICellReturnDTO> emeicellreturndtos) {
        emeicellreturnService.saveBatch(emeicellreturnMapping.toDomain(emeicellreturndtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Create", tags = {"EMEICellReturn" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/emeicellreturns")
    @Transactional
    public ResponseEntity<EMEICellReturnDTO> create(@RequestBody EMEICellReturnDTO emeicellreturndto) {
        EMEICellReturn domain = emeicellreturnMapping.toDomain(emeicellreturndto);
		emeicellreturnService.create(domain);
        EMEICellReturnDTO dto = emeicellreturnMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }
    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "createBatch", tags = {"EMEICellReturn" },  notes = "createBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emeicellreturns/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<EMEICellReturnDTO> emeicellreturndtos) {
        emeicellreturnService.createBatch(emeicellreturnMapping.toDomain(emeicellreturndtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission(#emeicellreturn_id,'Get',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Get", tags = {"EMEICellReturn" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/emeicellreturns/{emeicellreturn_id}")
    public ResponseEntity<EMEICellReturnDTO> get(@PathVariable("emeicellreturn_id") String emeicellreturn_id) {
        EMEICellReturn domain = emeicellreturnService.get(emeicellreturn_id);
        EMEICellReturnDTO dto = emeicellreturnMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }




    @ApiOperation(value = "GetDraft", tags = {"EMEICellReturn" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/emeicellreturns/getdraft")
    public ResponseEntity<EMEICellReturnDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(emeicellreturnMapping.toDto(emeicellreturnService.getDraft(new EMEICellReturn())));
    }




    @PreAuthorize("hasPermission(#emeicellreturn_id,'Update',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Update", tags = {"EMEICellReturn" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/emeicellreturns/{emeicellreturn_id}")
    @Transactional
    public ResponseEntity<EMEICellReturnDTO> update(@PathVariable("emeicellreturn_id") String emeicellreturn_id, @RequestBody EMEICellReturnDTO emeicellreturndto) {
		EMEICellReturn domain = emeicellreturnMapping.toDomain(emeicellreturndto);
        domain.setEmeicellreturnid(emeicellreturn_id);
		emeicellreturnService.update(domain);
		EMEICellReturnDTO dto = emeicellreturnMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(#emeicellreturn_id,'Update',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "UpdateBatch", tags = {"EMEICellReturn" },  notes = "UpdateBatch")
	@RequestMapping(method = RequestMethod.PUT, value = "/emeicellreturns/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<EMEICellReturnDTO> emeicellreturndtos) {
        emeicellreturnService.updateBatch(emeicellreturnMapping.toDomain(emeicellreturndtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission(#emeicellreturn_id,'Remove',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Remove", tags = {"EMEICellReturn" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emeicellreturns/{emeicellreturn_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("emeicellreturn_id") String emeicellreturn_id) {
         return ResponseEntity.status(HttpStatus.OK).body(emeicellreturnService.remove(emeicellreturn_id));
    }

    @ApiOperation(value = "RemoveBatch", tags = {"EMEICellReturn" },  notes = "RemoveBatch")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emeicellreturns/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        emeicellreturnService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEICellReturn-Default-all')")
	@ApiOperation(value = "fetchDEFAULT", tags = {"EMEICellReturn" } ,notes = "fetchDEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emeicellreturns/fetchdefault")
	public ResponseEntity<List<EMEICellReturnDTO>> fetchDefault(EMEICellReturnSearchContext context) {
        Page<EMEICellReturn> domains = emeicellreturnService.searchDefault(context) ;
        List<EMEICellReturnDTO> list = emeicellreturnMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEICellReturn-Default-all')")
	@ApiOperation(value = "searchDEFAULT", tags = {"EMEICellReturn" } ,notes = "searchDEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emeicellreturns/searchdefault")
	public ResponseEntity<Page<EMEICellReturnDTO>> searchDefault(@RequestBody EMEICellReturnSearchContext context) {
        Page<EMEICellReturn> domains = emeicellreturnService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emeicellreturnMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}


    /**
     * 用户权限校验
     * @return
     */
	public EMEICellReturn getEntity(){
        return new EMEICellReturn();
    }

}
