package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;

import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;

import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;

import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.eam_core.domain.EMDisableAssess;
import cn.ibizlab.eam.core.eam_core.service.IEMDisableAssessService;
import cn.ibizlab.eam.core.eam_core.filter.EMDisableAssessSearchContext;




@Slf4j
@Api(tags = {"EMDisableAssess" })
@RestController("WebApi-emdisableassess")
@RequestMapping("")
public class EMDisableAssessResource {

    @Autowired
    private IEMDisableAssessService emdisableassessService;

    @Autowired
    @Lazy
    private EMDisableAssessMapping emdisableassessMapping;




    @ApiOperation(value = "CheckKey", tags = {"EMDisableAssess" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/emdisableassesses/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody EMDisableAssessDTO emdisableassessdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emdisableassessService.checkKey(emdisableassessMapping.toDomain(emdisableassessdto)));
    }




    @ApiOperation(value = "GetDraft", tags = {"EMDisableAssess" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/emdisableassesses/getdraft")
    public ResponseEntity<EMDisableAssessDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(emdisableassessMapping.toDto(emdisableassessService.getDraft(new EMDisableAssess())));
    }




    @PreAuthorize("hasPermission(#emdisableassess_id,'Update',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Update", tags = {"EMDisableAssess" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/emdisableassesses/{emdisableassess_id}")
    @Transactional
    public ResponseEntity<EMDisableAssessDTO> update(@PathVariable("emdisableassess_id") String emdisableassess_id, @RequestBody EMDisableAssessDTO emdisableassessdto) {
		EMDisableAssess domain = emdisableassessMapping.toDomain(emdisableassessdto);
        domain.setEmdisableassessid(emdisableassess_id);
		emdisableassessService.update(domain);
		EMDisableAssessDTO dto = emdisableassessMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(#emdisableassess_id,'Update',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "UpdateBatch", tags = {"EMDisableAssess" },  notes = "UpdateBatch")
	@RequestMapping(method = RequestMethod.PUT, value = "/emdisableassesses/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<EMDisableAssessDTO> emdisableassessdtos) {
        emdisableassessService.updateBatch(emdisableassessMapping.toDomain(emdisableassessdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Create", tags = {"EMDisableAssess" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/emdisableassesses")
    @Transactional
    public ResponseEntity<EMDisableAssessDTO> create(@RequestBody EMDisableAssessDTO emdisableassessdto) {
        EMDisableAssess domain = emdisableassessMapping.toDomain(emdisableassessdto);
		emdisableassessService.create(domain);
        EMDisableAssessDTO dto = emdisableassessMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }
    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "createBatch", tags = {"EMDisableAssess" },  notes = "createBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emdisableassesses/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<EMDisableAssessDTO> emdisableassessdtos) {
        emdisableassessService.createBatch(emdisableassessMapping.toDomain(emdisableassessdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission(#emdisableassess_id,'Remove',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Remove", tags = {"EMDisableAssess" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emdisableassesses/{emdisableassess_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("emdisableassess_id") String emdisableassess_id) {
         return ResponseEntity.status(HttpStatus.OK).body(emdisableassessService.remove(emdisableassess_id));
    }

    @ApiOperation(value = "RemoveBatch", tags = {"EMDisableAssess" },  notes = "RemoveBatch")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emdisableassesses/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        emdisableassessService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @ApiOperation(value = "Save", tags = {"EMDisableAssess" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/emdisableassesses/save")
    public ResponseEntity<Boolean> save(@RequestBody EMDisableAssessDTO emdisableassessdto) {
        return ResponseEntity.status(HttpStatus.OK).body(emdisableassessService.save(emdisableassessMapping.toDomain(emdisableassessdto)));
    }

    @ApiOperation(value = "SaveBatch", tags = {"EMDisableAssess" },  notes = "SaveBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emdisableassesses/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<EMDisableAssessDTO> emdisableassessdtos) {
        emdisableassessService.saveBatch(emdisableassessMapping.toDomain(emdisableassessdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission(#emdisableassess_id,'Get',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Get", tags = {"EMDisableAssess" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/emdisableassesses/{emdisableassess_id}")
    public ResponseEntity<EMDisableAssessDTO> get(@PathVariable("emdisableassess_id") String emdisableassess_id) {
        EMDisableAssess domain = emdisableassessService.get(emdisableassess_id);
        EMDisableAssessDTO dto = emdisableassessMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMDisableAssess-Default-all')")
	@ApiOperation(value = "fetchDEFAULT", tags = {"EMDisableAssess" } ,notes = "fetchDEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emdisableassesses/fetchdefault")
	public ResponseEntity<List<EMDisableAssessDTO>> fetchDefault(EMDisableAssessSearchContext context) {
        Page<EMDisableAssess> domains = emdisableassessService.searchDefault(context) ;
        List<EMDisableAssessDTO> list = emdisableassessMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMDisableAssess-Default-all')")
	@ApiOperation(value = "searchDEFAULT", tags = {"EMDisableAssess" } ,notes = "searchDEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emdisableassesses/searchdefault")
	public ResponseEntity<Page<EMDisableAssessDTO>> searchDefault(@RequestBody EMDisableAssessSearchContext context) {
        Page<EMDisableAssess> domains = emdisableassessService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emdisableassessMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}


    /**
     * 用户权限校验
     * @return
     */
	public EMDisableAssess getEntity(){
        return new EMDisableAssess();
    }

}
