package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;

import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;

import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;

import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.eam_core.domain.EMBerth;
import cn.ibizlab.eam.core.eam_core.service.IEMBerthService;
import cn.ibizlab.eam.core.eam_core.filter.EMBerthSearchContext;




@Slf4j
@Api(tags = {"EMBerth" })
@RestController("WebApi-emberth")
@RequestMapping("")
public class EMBerthResource {

    @Autowired
    private IEMBerthService emberthService;

    @Autowired
    @Lazy
    private EMBerthMapping emberthMapping;




    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Create", tags = {"EMBerth" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/emberths")
    @Transactional
    public ResponseEntity<EMBerthDTO> create(@RequestBody EMBerthDTO emberthdto) {
        EMBerth domain = emberthMapping.toDomain(emberthdto);
		emberthService.create(domain);
        EMBerthDTO dto = emberthMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }
    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "createBatch", tags = {"EMBerth" },  notes = "createBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emberths/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<EMBerthDTO> emberthdtos) {
        emberthService.createBatch(emberthMapping.toDomain(emberthdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @ApiOperation(value = "GetDraft", tags = {"EMBerth" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/emberths/getdraft")
    public ResponseEntity<EMBerthDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(emberthMapping.toDto(emberthService.getDraft(new EMBerth())));
    }




    @PreAuthorize("hasPermission(#emberth_id,'Get',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Get", tags = {"EMBerth" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/emberths/{emberth_id}")
    public ResponseEntity<EMBerthDTO> get(@PathVariable("emberth_id") String emberth_id) {
        EMBerth domain = emberthService.get(emberth_id);
        EMBerthDTO dto = emberthMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }




    @PreAuthorize("hasPermission(#emberth_id,'Update',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Update", tags = {"EMBerth" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/emberths/{emberth_id}")
    @Transactional
    public ResponseEntity<EMBerthDTO> update(@PathVariable("emberth_id") String emberth_id, @RequestBody EMBerthDTO emberthdto) {
		EMBerth domain = emberthMapping.toDomain(emberthdto);
        domain.setEmberthid(emberth_id);
		emberthService.update(domain);
		EMBerthDTO dto = emberthMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(#emberth_id,'Update',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "UpdateBatch", tags = {"EMBerth" },  notes = "UpdateBatch")
	@RequestMapping(method = RequestMethod.PUT, value = "/emberths/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<EMBerthDTO> emberthdtos) {
        emberthService.updateBatch(emberthMapping.toDomain(emberthdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @ApiOperation(value = "Save", tags = {"EMBerth" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/emberths/save")
    public ResponseEntity<Boolean> save(@RequestBody EMBerthDTO emberthdto) {
        return ResponseEntity.status(HttpStatus.OK).body(emberthService.save(emberthMapping.toDomain(emberthdto)));
    }

    @ApiOperation(value = "SaveBatch", tags = {"EMBerth" },  notes = "SaveBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emberths/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<EMBerthDTO> emberthdtos) {
        emberthService.saveBatch(emberthMapping.toDomain(emberthdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @ApiOperation(value = "CheckKey", tags = {"EMBerth" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/emberths/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody EMBerthDTO emberthdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emberthService.checkKey(emberthMapping.toDomain(emberthdto)));
    }




    @PreAuthorize("hasPermission(#emberth_id,'Remove',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Remove", tags = {"EMBerth" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emberths/{emberth_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("emberth_id") String emberth_id) {
         return ResponseEntity.status(HttpStatus.OK).body(emberthService.remove(emberth_id));
    }

    @ApiOperation(value = "RemoveBatch", tags = {"EMBerth" },  notes = "RemoveBatch")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emberths/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        emberthService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMBerth-Default-all')")
	@ApiOperation(value = "fetchDEFAULT", tags = {"EMBerth" } ,notes = "fetchDEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emberths/fetchdefault")
	public ResponseEntity<List<EMBerthDTO>> fetchDefault(EMBerthSearchContext context) {
        Page<EMBerth> domains = emberthService.searchDefault(context) ;
        List<EMBerthDTO> list = emberthMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMBerth-Default-all')")
	@ApiOperation(value = "searchDEFAULT", tags = {"EMBerth" } ,notes = "searchDEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emberths/searchdefault")
	public ResponseEntity<Page<EMBerthDTO>> searchDefault(@RequestBody EMBerthSearchContext context) {
        Page<EMBerth> domains = emberthService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emberthMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}


    /**
     * 用户权限校验
     * @return
     */
	public EMBerth getEntity(){
        return new EMBerth();
    }

}
