package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;

import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;

import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;

import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.eam_core.domain.EMAssetClass;
import cn.ibizlab.eam.core.eam_core.service.IEMAssetClassService;
import cn.ibizlab.eam.core.eam_core.filter.EMAssetClassSearchContext;




@Slf4j
@Api(tags = {"EMAssetClass" })
@RestController("WebApi-emassetclass")
@RequestMapping("")
public class EMAssetClassResource {

    @Autowired
    private IEMAssetClassService emassetclassService;

    @Autowired
    @Lazy
    private EMAssetClassMapping emassetclassMapping;




    @ApiOperation(value = "CheckKey", tags = {"EMAssetClass" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/emassetclasses/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody EMAssetClassDTO emassetclassdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emassetclassService.checkKey(emassetclassMapping.toDomain(emassetclassdto)));
    }




    @ApiOperation(value = "GetDraft", tags = {"EMAssetClass" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/emassetclasses/getdraft")
    public ResponseEntity<EMAssetClassDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(emassetclassMapping.toDto(emassetclassService.getDraft(new EMAssetClass())));
    }




    @ApiOperation(value = "Save", tags = {"EMAssetClass" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/emassetclasses/save")
    public ResponseEntity<Boolean> save(@RequestBody EMAssetClassDTO emassetclassdto) {
        return ResponseEntity.status(HttpStatus.OK).body(emassetclassService.save(emassetclassMapping.toDomain(emassetclassdto)));
    }

    @ApiOperation(value = "SaveBatch", tags = {"EMAssetClass" },  notes = "SaveBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emassetclasses/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<EMAssetClassDTO> emassetclassdtos) {
        emassetclassService.saveBatch(emassetclassMapping.toDomain(emassetclassdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission(#emassetclass_id,'Update',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Update", tags = {"EMAssetClass" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/emassetclasses/{emassetclass_id}")
    @Transactional
    public ResponseEntity<EMAssetClassDTO> update(@PathVariable("emassetclass_id") String emassetclass_id, @RequestBody EMAssetClassDTO emassetclassdto) {
		EMAssetClass domain = emassetclassMapping.toDomain(emassetclassdto);
        domain.setEmassetclassid(emassetclass_id);
		emassetclassService.update(domain);
		EMAssetClassDTO dto = emassetclassMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(#emassetclass_id,'Update',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "UpdateBatch", tags = {"EMAssetClass" },  notes = "UpdateBatch")
	@RequestMapping(method = RequestMethod.PUT, value = "/emassetclasses/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<EMAssetClassDTO> emassetclassdtos) {
        emassetclassService.updateBatch(emassetclassMapping.toDomain(emassetclassdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission(#emassetclass_id,'Remove',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Remove", tags = {"EMAssetClass" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emassetclasses/{emassetclass_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("emassetclass_id") String emassetclass_id) {
         return ResponseEntity.status(HttpStatus.OK).body(emassetclassService.remove(emassetclass_id));
    }

    @ApiOperation(value = "RemoveBatch", tags = {"EMAssetClass" },  notes = "RemoveBatch")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emassetclasses/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        emassetclassService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Create", tags = {"EMAssetClass" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/emassetclasses")
    @Transactional
    public ResponseEntity<EMAssetClassDTO> create(@RequestBody EMAssetClassDTO emassetclassdto) {
        EMAssetClass domain = emassetclassMapping.toDomain(emassetclassdto);
		emassetclassService.create(domain);
        EMAssetClassDTO dto = emassetclassMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }
    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "createBatch", tags = {"EMAssetClass" },  notes = "createBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emassetclasses/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<EMAssetClassDTO> emassetclassdtos) {
        emassetclassService.createBatch(emassetclassMapping.toDomain(emassetclassdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission(#emassetclass_id,'Get',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Get", tags = {"EMAssetClass" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/emassetclasses/{emassetclass_id}")
    public ResponseEntity<EMAssetClassDTO> get(@PathVariable("emassetclass_id") String emassetclass_id) {
        EMAssetClass domain = emassetclassService.get(emassetclass_id);
        EMAssetClassDTO dto = emassetclassMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMAssetClass-Default-all')")
	@ApiOperation(value = "fetchDEFAULT", tags = {"EMAssetClass" } ,notes = "fetchDEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emassetclasses/fetchdefault")
	public ResponseEntity<List<EMAssetClassDTO>> fetchDefault(EMAssetClassSearchContext context) {
        Page<EMAssetClass> domains = emassetclassService.searchDefault(context) ;
        List<EMAssetClassDTO> list = emassetclassMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMAssetClass-Default-all')")
	@ApiOperation(value = "searchDEFAULT", tags = {"EMAssetClass" } ,notes = "searchDEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emassetclasses/searchdefault")
	public ResponseEntity<Page<EMAssetClassDTO>> searchDefault(@RequestBody EMAssetClassSearchContext context) {
        Page<EMAssetClass> domains = emassetclassService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emassetclassMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}


    /**
     * 用户权限校验
     * @return
     */
	public EMAssetClass getEntity(){
        return new EMAssetClass();
    }

}
