package cn.ibizlab.eam.webapi.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.alibaba.fastjson.annotation.JSONField;
import cn.ibizlab.eam.util.domain.DTOBase;
import lombok.Data;

/**
 * 服务DTO对象[EMServiceDTO]
 */
@Data
public class EMServiceDTO extends DTOBase implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 属性 [CREATEDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "createdate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("createdate")
    private Timestamp createdate;

    /**
     * 属性 [ACCODE]
     *
     */
    @JSONField(name = "accode")
    @JsonProperty("accode")
    private String accode;

    /**
     * 属性 [ORGID]
     *
     */
    @JSONField(name = "orgid")
    @JsonProperty("orgid")
    private String orgid;

    /**
     * 属性 [ENABLE]
     *
     */
    @JSONField(name = "enable")
    @JsonProperty("enable")
    private Integer enable;

    /**
     * 属性 [LSAREAID]
     *
     */
    @JSONField(name = "lsareaid")
    @JsonProperty("lsareaid")
    private String lsareaid;

    /**
     * 属性 [FAX]
     *
     */
    @JSONField(name = "fax")
    @JsonProperty("fax")
    private String fax;

    /**
     * 属性 [ZZYW]
     *
     */
    @JSONField(name = "zzyw")
    @JsonProperty("zzyw")
    private String zzyw;

    /**
     * 属性 [PAYWAY]
     *
     */
    @JSONField(name = "payway")
    @JsonProperty("payway")
    private String payway;

    /**
     * 属性 [WFSTEP]
     *
     */
    @JSONField(name = "wfstep")
    @JsonProperty("wfstep")
    private String wfstep;

    /**
     * 属性 [SERVICEINFO]
     *
     */
    @JSONField(name = "serviceinfo")
    @JsonProperty("serviceinfo")
    private String serviceinfo;

    /**
     * 属性 [PGRADE]
     *
     */
    @JSONField(name = "pgrade")
    @JsonProperty("pgrade")
    private Double pgrade;

    /**
     * 属性 [ACCODEDESC]
     *
     */
    @JSONField(name = "accodedesc")
    @JsonProperty("accodedesc")
    private String accodedesc;

    /**
     * 属性 [LABSERVICELEVELID]
     *
     */
    @JSONField(name = "labservicelevelid")
    @JsonProperty("labservicelevelid")
    private String labservicelevelid;

    /**
     * 属性 [SUMS]
     *
     */
    @JSONField(name = "sums")
    @JsonProperty("sums")
    private Integer sums;

    /**
     * 属性 [LABSERVICETYPEID]
     *
     */
    @JSONField(name = "labservicetypeid")
    @JsonProperty("labservicetypeid")
    private String labservicetypeid;

    /**
     * 属性 [TEL]
     *
     */
    @JSONField(name = "tel")
    @JsonProperty("tel")
    private String tel;

    /**
     * 属性 [WFSTATE]
     *
     */
    @JSONField(name = "wfstate")
    @JsonProperty("wfstate")
    private Integer wfstate;

    /**
     * 属性 [PRMAN]
     *
     */
    @JSONField(name = "prman")
    @JsonProperty("prman")
    private String prman;

    /**
     * 属性 [CONTENT]
     *
     */
    @JSONField(name = "content")
    @JsonProperty("content")
    private String content;

    /**
     * 属性 [EMSERVICEID]
     *
     */
    @JSONField(name = "emserviceid")
    @JsonProperty("emserviceid")
    private String emserviceid;

    /**
     * 属性 [QUALITYMANA]
     *
     */
    @JSONField(name = "qualitymana")
    @JsonProperty("qualitymana")
    private String qualitymana;

    /**
     * 属性 [CREATEMAN]
     *
     */
    @JSONField(name = "createman")
    @JsonProperty("createman")
    private String createman;

    /**
     * 属性 [TAXCODE]
     *
     */
    @JSONField(name = "taxcode")
    @JsonProperty("taxcode")
    private String taxcode;

    /**
     * 属性 [WFINSTANCEID]
     *
     */
    @JSONField(name = "wfinstanceid")
    @JsonProperty("wfinstanceid")
    private String wfinstanceid;

    /**
     * 属性 [UPDATEMAN]
     *
     */
    @JSONField(name = "updateman")
    @JsonProperty("updateman")
    private String updateman;

    /**
     * 属性 [ZIP]
     *
     */
    @JSONField(name = "zip")
    @JsonProperty("zip")
    private String zip;

    /**
     * 属性 [RANGE]
     *
     */
    @JSONField(name = "range")
    @JsonProperty("range")
    private Integer range;

    /**
     * 属性 [ENABLEBZ]
     *
     */
    @JSONField(name = "enablebz")
    @JsonProperty("enablebz")
    private String enablebz;

    /**
     * 属性 [EMSERVICENAME]
     *
     */
    @JSONField(name = "emservicename")
    @JsonProperty("emservicename")
    private String emservicename;

    /**
     * 属性 [SERVICECODE]
     *
     */
    @JSONField(name = "servicecode")
    @JsonProperty("servicecode")
    private String servicecode;

    /**
     * 属性 [PAYWAYDESC]
     *
     */
    @JSONField(name = "paywaydesc")
    @JsonProperty("paywaydesc")
    private String paywaydesc;

    /**
     * 属性 [SERVICEGROUP]
     *
     */
    @JSONField(name = "servicegroup")
    @JsonProperty("servicegroup")
    private Integer servicegroup;

    /**
     * 属性 [ATT]
     *
     */
    @JSONField(name = "att")
    @JsonProperty("att")
    private String att;

    /**
     * 属性 [WEBSITE]
     *
     */
    @JSONField(name = "website")
    @JsonProperty("website")
    private String website;

    /**
     * 属性 [UPDATEDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "updatedate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("updatedate")
    private Timestamp updatedate;

    /**
     * 属性 [DESCRIPTION]
     *
     */
    @JSONField(name = "description")
    @JsonProperty("description")
    private String description;

    /**
     * 属性 [LOGO]
     *
     */
    @JSONField(name = "logo")
    @JsonProperty("logo")
    private String logo;

    /**
     * 属性 [ADDR]
     *
     */
    @JSONField(name = "addr")
    @JsonProperty("addr")
    private String addr;

    /**
     * 属性 [TAXTYPEID]
     *
     */
    @JSONField(name = "taxtypeid")
    @JsonProperty("taxtypeid")
    private String taxtypeid;

    /**
     * 属性 [TAXDESC]
     *
     */
    @JSONField(name = "taxdesc")
    @JsonProperty("taxdesc")
    private String taxdesc;

    /**
     * 属性 [SHDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "shdate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("shdate")
    private Timestamp shdate;

    /**
     * 属性 [QUALIFICATIONS]
     *
     */
    @JSONField(name = "qualifications")
    @JsonProperty("qualifications")
    private String qualifications;

    /**
     * 属性 [SERVICESTATE]
     *
     */
    @JSONField(name = "servicestate")
    @JsonProperty("servicestate")
    private String servicestate;


    /**
     * 设置 [ACCODE]
     */
    public void setAccode(String  accode){
        this.accode = accode ;
        this.modify("accode",accode);
    }

    /**
     * 设置 [LSAREAID]
     */
    public void setLsareaid(String  lsareaid){
        this.lsareaid = lsareaid ;
        this.modify("lsareaid",lsareaid);
    }

    /**
     * 设置 [FAX]
     */
    public void setFax(String  fax){
        this.fax = fax ;
        this.modify("fax",fax);
    }

    /**
     * 设置 [ZZYW]
     */
    public void setZzyw(String  zzyw){
        this.zzyw = zzyw ;
        this.modify("zzyw",zzyw);
    }

    /**
     * 设置 [PAYWAY]
     */
    public void setPayway(String  payway){
        this.payway = payway ;
        this.modify("payway",payway);
    }

    /**
     * 设置 [WFSTEP]
     */
    public void setWfstep(String  wfstep){
        this.wfstep = wfstep ;
        this.modify("wfstep",wfstep);
    }

    /**
     * 设置 [PGRADE]
     */
    public void setPgrade(Double  pgrade){
        this.pgrade = pgrade ;
        this.modify("pgrade",pgrade);
    }

    /**
     * 设置 [ACCODEDESC]
     */
    public void setAccodedesc(String  accodedesc){
        this.accodedesc = accodedesc ;
        this.modify("accodedesc",accodedesc);
    }

    /**
     * 设置 [LABSERVICELEVELID]
     */
    public void setLabservicelevelid(String  labservicelevelid){
        this.labservicelevelid = labservicelevelid ;
        this.modify("labservicelevelid",labservicelevelid);
    }

    /**
     * 设置 [LABSERVICETYPEID]
     */
    public void setLabservicetypeid(String  labservicetypeid){
        this.labservicetypeid = labservicetypeid ;
        this.modify("labservicetypeid",labservicetypeid);
    }

    /**
     * 设置 [TEL]
     */
    public void setTel(String  tel){
        this.tel = tel ;
        this.modify("tel",tel);
    }

    /**
     * 设置 [WFSTATE]
     */
    public void setWfstate(Integer  wfstate){
        this.wfstate = wfstate ;
        this.modify("wfstate",wfstate);
    }

    /**
     * 设置 [PRMAN]
     */
    public void setPrman(String  prman){
        this.prman = prman ;
        this.modify("prman",prman);
    }

    /**
     * 设置 [CONTENT]
     */
    public void setContent(String  content){
        this.content = content ;
        this.modify("content",content);
    }

    /**
     * 设置 [QUALITYMANA]
     */
    public void setQualitymana(String  qualitymana){
        this.qualitymana = qualitymana ;
        this.modify("qualitymana",qualitymana);
    }

    /**
     * 设置 [TAXCODE]
     */
    public void setTaxcode(String  taxcode){
        this.taxcode = taxcode ;
        this.modify("taxcode",taxcode);
    }

    /**
     * 设置 [WFINSTANCEID]
     */
    public void setWfinstanceid(String  wfinstanceid){
        this.wfinstanceid = wfinstanceid ;
        this.modify("wfinstanceid",wfinstanceid);
    }

    /**
     * 设置 [ZIP]
     */
    public void setZip(String  zip){
        this.zip = zip ;
        this.modify("zip",zip);
    }

    /**
     * 设置 [RANGE]
     */
    public void setRange(Integer  range){
        this.range = range ;
        this.modify("range",range);
    }

    /**
     * 设置 [ENABLEBZ]
     */
    public void setEnablebz(String  enablebz){
        this.enablebz = enablebz ;
        this.modify("enablebz",enablebz);
    }

    /**
     * 设置 [EMSERVICENAME]
     */
    public void setEmservicename(String  emservicename){
        this.emservicename = emservicename ;
        this.modify("emservicename",emservicename);
    }

    /**
     * 设置 [SERVICECODE]
     */
    public void setServicecode(String  servicecode){
        this.servicecode = servicecode ;
        this.modify("servicecode",servicecode);
    }

    /**
     * 设置 [PAYWAYDESC]
     */
    public void setPaywaydesc(String  paywaydesc){
        this.paywaydesc = paywaydesc ;
        this.modify("paywaydesc",paywaydesc);
    }

    /**
     * 设置 [SERVICEGROUP]
     */
    public void setServicegroup(Integer  servicegroup){
        this.servicegroup = servicegroup ;
        this.modify("servicegroup",servicegroup);
    }

    /**
     * 设置 [ATT]
     */
    public void setAtt(String  att){
        this.att = att ;
        this.modify("att",att);
    }

    /**
     * 设置 [WEBSITE]
     */
    public void setWebsite(String  website){
        this.website = website ;
        this.modify("website",website);
    }

    /**
     * 设置 [DESCRIPTION]
     */
    public void setDescription(String  description){
        this.description = description ;
        this.modify("description",description);
    }

    /**
     * 设置 [LOGO]
     */
    public void setLogo(String  logo){
        this.logo = logo ;
        this.modify("logo",logo);
    }

    /**
     * 设置 [ADDR]
     */
    public void setAddr(String  addr){
        this.addr = addr ;
        this.modify("addr",addr);
    }

    /**
     * 设置 [TAXTYPEID]
     */
    public void setTaxtypeid(String  taxtypeid){
        this.taxtypeid = taxtypeid ;
        this.modify("taxtypeid",taxtypeid);
    }

    /**
     * 设置 [TAXDESC]
     */
    public void setTaxdesc(String  taxdesc){
        this.taxdesc = taxdesc ;
        this.modify("taxdesc",taxdesc);
    }

    /**
     * 设置 [SHDATE]
     */
    public void setShdate(Timestamp  shdate){
        this.shdate = shdate ;
        this.modify("shdate",shdate);
    }

    /**
     * 设置 [QUALIFICATIONS]
     */
    public void setQualifications(String  qualifications){
        this.qualifications = qualifications ;
        this.modify("qualifications",qualifications);
    }

    /**
     * 设置 [SERVICESTATE]
     */
    public void setServicestate(String  servicestate){
        this.servicestate = servicestate ;
        this.modify("servicestate",servicestate);
    }


}

