package cn.ibizlab.eam.webapi.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.alibaba.fastjson.annotation.JSONField;
import cn.ibizlab.eam.util.domain.DTOBase;
import lombok.Data;

/**
 * 服务DTO对象[EMFileMenuDTO]
 */
@Data
public class EMFileMenuDTO extends DTOBase implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 属性 [EMFILEMENUNAME]
     *
     */
    @JSONField(name = "emfilemenuname")
    @JsonProperty("emfilemenuname")
    private String emfilemenuname;

    /**
     * 属性 [UPDATEMAN]
     *
     */
    @JSONField(name = "updateman")
    @JsonProperty("updateman")
    private String updateman;

    /**
     * 属性 [EMFILEMENUID]
     *
     */
    @JSONField(name = "emfilemenuid")
    @JsonProperty("emfilemenuid")
    private String emfilemenuid;

    /**
     * 属性 [DEIDS]
     *
     */
    @JSONField(name = "deids")
    @JsonProperty("deids")
    private String deids;

    /**
     * 属性 [CREATEDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "createdate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("createdate")
    private Timestamp createdate;

    /**
     * 属性 [CREATEMAN]
     *
     */
    @JSONField(name = "createman")
    @JsonProperty("createman")
    private String createman;

    /**
     * 属性 [ENABLE]
     *
     */
    @JSONField(name = "enable")
    @JsonProperty("enable")
    private Integer enable;

    /**
     * 属性 [UPDATEDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "updatedate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("updatedate")
    private Timestamp updatedate;


    /**
     * 设置 [EMFILEMENUNAME]
     */
    public void setEmfilemenuname(String  emfilemenuname){
        this.emfilemenuname = emfilemenuname ;
        this.modify("emfilemenuname",emfilemenuname);
    }

    /**
     * 设置 [DEIDS]
     */
    public void setDeids(String  deids){
        this.deids = deids ;
        this.modify("deids",deids);
    }


}

