package cn.ibizlab.eam.webapi.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.alibaba.fastjson.annotation.JSONField;
import cn.ibizlab.eam.util.domain.DTOBase;
import lombok.Data;

/**
 * 服务DTO对象[EMAssetClassDTO]
 */
@Data
public class EMAssetClassDTO extends DTOBase implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 属性 [ASSETCLASSCODE]
     *
     */
    @JSONField(name = "assetclasscode")
    @JsonProperty("assetclasscode")
    private String assetclasscode;

    /**
     * 属性 [ORGID]
     *
     */
    @JSONField(name = "orgid")
    @JsonProperty("orgid")
    private String orgid;

    /**
     * 属性 [CREATEDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "createdate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("createdate")
    private Timestamp createdate;

    /**
     * 属性 [RESERVER]
     *
     */
    @JSONField(name = "reserver")
    @JsonProperty("reserver")
    private String reserver;

    /**
     * 属性 [UPDATEMAN]
     *
     */
    @JSONField(name = "updateman")
    @JsonProperty("updateman")
    private String updateman;

    /**
     * 属性 [DESCRIPTION]
     *
     */
    @JSONField(name = "description")
    @JsonProperty("description")
    private String description;

    /**
     * 属性 [UPDATEDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "updatedate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("updatedate")
    private Timestamp updatedate;

    /**
     * 属性 [RESERVER2]
     *
     */
    @JSONField(name = "reserver2")
    @JsonProperty("reserver2")
    private String reserver2;

    /**
     * 属性 [EMASSETCLASSNAME]
     *
     */
    @JSONField(name = "emassetclassname")
    @JsonProperty("emassetclassname")
    private String emassetclassname;

    /**
     * 属性 [ASSETCLASSGROUP]
     *
     */
    @JSONField(name = "assetclassgroup")
    @JsonProperty("assetclassgroup")
    private String assetclassgroup;

    /**
     * 属性 [CREATEMAN]
     *
     */
    @JSONField(name = "createman")
    @JsonProperty("createman")
    private String createman;

    /**
     * 属性 [EMASSETCLASSID]
     *
     */
    @JSONField(name = "emassetclassid")
    @JsonProperty("emassetclassid")
    private String emassetclassid;

    /**
     * 属性 [LIFE]
     *
     */
    @JSONField(name = "life")
    @JsonProperty("life")
    private Double life;

    /**
     * 属性 [ENABLE]
     *
     */
    @JSONField(name = "enable")
    @JsonProperty("enable")
    private Integer enable;

    /**
     * 属性 [ASSETCLASSINFO]
     *
     */
    @JSONField(name = "assetclassinfo")
    @JsonProperty("assetclassinfo")
    private String assetclassinfo;

    /**
     * 属性 [ASSETCLASSPNAME]
     *
     */
    @JSONField(name = "assetclasspname")
    @JsonProperty("assetclasspname")
    private String assetclasspname;

    /**
     * 属性 [ASSETCLASSPCODE]
     *
     */
    @JSONField(name = "assetclasspcode")
    @JsonProperty("assetclasspcode")
    private String assetclasspcode;

    /**
     * 属性 [ASSETCLASSPID]
     *
     */
    @JSONField(name = "assetclasspid")
    @JsonProperty("assetclasspid")
    private String assetclasspid;


    /**
     * 设置 [ASSETCLASSCODE]
     */
    public void setAssetclasscode(String  assetclasscode){
        this.assetclasscode = assetclasscode ;
        this.modify("assetclasscode",assetclasscode);
    }

    /**
     * 设置 [RESERVER]
     */
    public void setReserver(String  reserver){
        this.reserver = reserver ;
        this.modify("reserver",reserver);
    }

    /**
     * 设置 [DESCRIPTION]
     */
    public void setDescription(String  description){
        this.description = description ;
        this.modify("description",description);
    }

    /**
     * 设置 [RESERVER2]
     */
    public void setReserver2(String  reserver2){
        this.reserver2 = reserver2 ;
        this.modify("reserver2",reserver2);
    }

    /**
     * 设置 [EMASSETCLASSNAME]
     */
    public void setEmassetclassname(String  emassetclassname){
        this.emassetclassname = emassetclassname ;
        this.modify("emassetclassname",emassetclassname);
    }

    /**
     * 设置 [ASSETCLASSGROUP]
     */
    public void setAssetclassgroup(String  assetclassgroup){
        this.assetclassgroup = assetclassgroup ;
        this.modify("assetclassgroup",assetclassgroup);
    }

    /**
     * 设置 [LIFE]
     */
    public void setLife(Double  life){
        this.life = life ;
        this.modify("life",life);
    }

    /**
     * 设置 [ASSETCLASSPID]
     */
    public void setAssetclasspid(String  assetclasspid){
        this.assetclasspid = assetclasspid ;
        this.modify("assetclasspid",assetclasspid);
    }


}

