package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;

import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;

import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;

import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.eam_pf.domain.PFDept;
import cn.ibizlab.eam.core.eam_pf.service.IPFDeptService;
import cn.ibizlab.eam.core.eam_pf.filter.PFDeptSearchContext;




@Slf4j
@Api(tags = {"PFDept" })
@RestController("WebApi-pfdept")
@RequestMapping("")
public class PFDeptResource {

    @Autowired
    private IPFDeptService pfdeptService;

    @Autowired
    @Lazy
    private PFDeptMapping pfdeptMapping;




    @ApiOperation(value = "Save", tags = {"PFDept" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/pfdepts/save")
    public ResponseEntity<Boolean> save(@RequestBody PFDeptDTO pfdeptdto) {
        return ResponseEntity.status(HttpStatus.OK).body(pfdeptService.save(pfdeptMapping.toDomain(pfdeptdto)));
    }

    @ApiOperation(value = "SaveBatch", tags = {"PFDept" },  notes = "SaveBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/pfdepts/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<PFDeptDTO> pfdeptdtos) {
        pfdeptService.saveBatch(pfdeptMapping.toDomain(pfdeptdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission(#pfdept_id,'Remove',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Remove", tags = {"PFDept" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfdepts/{pfdept_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("pfdept_id") String pfdept_id) {
         return ResponseEntity.status(HttpStatus.OK).body(pfdeptService.remove(pfdept_id));
    }

    @ApiOperation(value = "RemoveBatch", tags = {"PFDept" },  notes = "RemoveBatch")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfdepts/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        pfdeptService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Create", tags = {"PFDept" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/pfdepts")
    @Transactional
    public ResponseEntity<PFDeptDTO> create(@RequestBody PFDeptDTO pfdeptdto) {
        PFDept domain = pfdeptMapping.toDomain(pfdeptdto);
		pfdeptService.create(domain);
        PFDeptDTO dto = pfdeptMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }
    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "createBatch", tags = {"PFDept" },  notes = "createBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/pfdepts/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<PFDeptDTO> pfdeptdtos) {
        pfdeptService.createBatch(pfdeptMapping.toDomain(pfdeptdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @ApiOperation(value = "GetDraft", tags = {"PFDept" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/pfdepts/getdraft")
    public ResponseEntity<PFDeptDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(pfdeptMapping.toDto(pfdeptService.getDraft(new PFDept())));
    }




    @PreAuthorize("hasPermission(#pfdept_id,'Get',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Get", tags = {"PFDept" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/pfdepts/{pfdept_id}")
    public ResponseEntity<PFDeptDTO> get(@PathVariable("pfdept_id") String pfdept_id) {
        PFDept domain = pfdeptService.get(pfdept_id);
        PFDeptDTO dto = pfdeptMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }




    @PreAuthorize("hasPermission(#pfdept_id,'Update',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Update", tags = {"PFDept" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfdepts/{pfdept_id}")
    @Transactional
    public ResponseEntity<PFDeptDTO> update(@PathVariable("pfdept_id") String pfdept_id, @RequestBody PFDeptDTO pfdeptdto) {
		PFDept domain = pfdeptMapping.toDomain(pfdeptdto);
        domain.setPfdeptid(pfdept_id);
		pfdeptService.update(domain);
		PFDeptDTO dto = pfdeptMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(#pfdept_id,'Update',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "UpdateBatch", tags = {"PFDept" },  notes = "UpdateBatch")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfdepts/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<PFDeptDTO> pfdeptdtos) {
        pfdeptService.updateBatch(pfdeptMapping.toDomain(pfdeptdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @ApiOperation(value = "CheckKey", tags = {"PFDept" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/pfdepts/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody PFDeptDTO pfdeptdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(pfdeptService.checkKey(pfdeptMapping.toDomain(pfdeptdto)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-PFDept-Default-all')")
	@ApiOperation(value = "fetchDEFAULT", tags = {"PFDept" } ,notes = "fetchDEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/pfdepts/fetchdefault")
	public ResponseEntity<List<PFDeptDTO>> fetchDefault(PFDeptSearchContext context) {
        Page<PFDept> domains = pfdeptService.searchDefault(context) ;
        List<PFDeptDTO> list = pfdeptMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-PFDept-Default-all')")
	@ApiOperation(value = "searchDEFAULT", tags = {"PFDept" } ,notes = "searchDEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/pfdepts/searchdefault")
	public ResponseEntity<Page<PFDeptDTO>> searchDefault(@RequestBody PFDeptSearchContext context) {
        Page<PFDept> domains = pfdeptService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(pfdeptMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}


    /**
     * 用户权限校验
     * @return
     */
	public PFDept getEntity(){
        return new PFDept();
    }

}
