package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;

import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;

import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;

import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.eam_core.domain.EMRigging;
import cn.ibizlab.eam.core.eam_core.service.IEMRiggingService;
import cn.ibizlab.eam.core.eam_core.filter.EMRiggingSearchContext;




@Slf4j
@Api(tags = {"EMRigging" })
@RestController("WebApi-emrigging")
@RequestMapping("")
public class EMRiggingResource {

    @Autowired
    private IEMRiggingService emriggingService;

    @Autowired
    @Lazy
    private EMRiggingMapping emriggingMapping;




    @ApiOperation(value = "GetDraft", tags = {"EMRigging" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/emriggings/getdraft")
    public ResponseEntity<EMRiggingDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(emriggingMapping.toDto(emriggingService.getDraft(new EMRigging())));
    }




    @PreAuthorize("hasPermission(#emrigging_id,'Remove',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Remove", tags = {"EMRigging" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emriggings/{emrigging_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("emrigging_id") String emrigging_id) {
         return ResponseEntity.status(HttpStatus.OK).body(emriggingService.remove(emrigging_id));
    }

    @ApiOperation(value = "RemoveBatch", tags = {"EMRigging" },  notes = "RemoveBatch")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emriggings/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        emriggingService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @ApiOperation(value = "Save", tags = {"EMRigging" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/emriggings/save")
    public ResponseEntity<Boolean> save(@RequestBody EMRiggingDTO emriggingdto) {
        return ResponseEntity.status(HttpStatus.OK).body(emriggingService.save(emriggingMapping.toDomain(emriggingdto)));
    }

    @ApiOperation(value = "SaveBatch", tags = {"EMRigging" },  notes = "SaveBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emriggings/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<EMRiggingDTO> emriggingdtos) {
        emriggingService.saveBatch(emriggingMapping.toDomain(emriggingdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Create", tags = {"EMRigging" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/emriggings")
    @Transactional
    public ResponseEntity<EMRiggingDTO> create(@RequestBody EMRiggingDTO emriggingdto) {
        EMRigging domain = emriggingMapping.toDomain(emriggingdto);
		emriggingService.create(domain);
        EMRiggingDTO dto = emriggingMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }
    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "createBatch", tags = {"EMRigging" },  notes = "createBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emriggings/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<EMRiggingDTO> emriggingdtos) {
        emriggingService.createBatch(emriggingMapping.toDomain(emriggingdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission(#emrigging_id,'Update',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Update", tags = {"EMRigging" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/emriggings/{emrigging_id}")
    @Transactional
    public ResponseEntity<EMRiggingDTO> update(@PathVariable("emrigging_id") String emrigging_id, @RequestBody EMRiggingDTO emriggingdto) {
		EMRigging domain = emriggingMapping.toDomain(emriggingdto);
        domain.setEmriggingid(emrigging_id);
		emriggingService.update(domain);
		EMRiggingDTO dto = emriggingMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(#emrigging_id,'Update',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "UpdateBatch", tags = {"EMRigging" },  notes = "UpdateBatch")
	@RequestMapping(method = RequestMethod.PUT, value = "/emriggings/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<EMRiggingDTO> emriggingdtos) {
        emriggingService.updateBatch(emriggingMapping.toDomain(emriggingdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission(#emrigging_id,'Get',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Get", tags = {"EMRigging" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/emriggings/{emrigging_id}")
    public ResponseEntity<EMRiggingDTO> get(@PathVariable("emrigging_id") String emrigging_id) {
        EMRigging domain = emriggingService.get(emrigging_id);
        EMRiggingDTO dto = emriggingMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }




    @ApiOperation(value = "CheckKey", tags = {"EMRigging" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/emriggings/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody EMRiggingDTO emriggingdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emriggingService.checkKey(emriggingMapping.toDomain(emriggingdto)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMRigging-Default-all')")
	@ApiOperation(value = "fetchDEFAULT", tags = {"EMRigging" } ,notes = "fetchDEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emriggings/fetchdefault")
	public ResponseEntity<List<EMRiggingDTO>> fetchDefault(EMRiggingSearchContext context) {
        Page<EMRigging> domains = emriggingService.searchDefault(context) ;
        List<EMRiggingDTO> list = emriggingMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMRigging-Default-all')")
	@ApiOperation(value = "searchDEFAULT", tags = {"EMRigging" } ,notes = "searchDEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emriggings/searchdefault")
	public ResponseEntity<Page<EMRiggingDTO>> searchDefault(@RequestBody EMRiggingSearchContext context) {
        Page<EMRigging> domains = emriggingService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emriggingMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}


    /**
     * 用户权限校验
     * @return
     */
	public EMRigging getEntity(){
        return new EMRigging();
    }

}
