package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;

import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;

import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;

import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.eam_core.domain.EMEQWL;
import cn.ibizlab.eam.core.eam_core.service.IEMEQWLService;
import cn.ibizlab.eam.core.eam_core.filter.EMEQWLSearchContext;




@Slf4j
@Api(tags = {"EMEQWL" })
@RestController("WebApi-emeqwl")
@RequestMapping("")
public class EMEQWLResource {

    @Autowired
    private IEMEQWLService emeqwlService;

    @Autowired
    @Lazy
    private EMEQWLMapping emeqwlMapping;




    @PreAuthorize("hasPermission(#emeqwl_id,'Remove',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Remove", tags = {"EMEQWL" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emeqwls/{emeqwl_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("emeqwl_id") String emeqwl_id) {
         return ResponseEntity.status(HttpStatus.OK).body(emeqwlService.remove(emeqwl_id));
    }

    @ApiOperation(value = "RemoveBatch", tags = {"EMEQWL" },  notes = "RemoveBatch")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emeqwls/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        emeqwlService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @ApiOperation(value = "CheckKey", tags = {"EMEQWL" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqwls/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody EMEQWLDTO emeqwldto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emeqwlService.checkKey(emeqwlMapping.toDomain(emeqwldto)));
    }




    @ApiOperation(value = "Save", tags = {"EMEQWL" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqwls/save")
    public ResponseEntity<Boolean> save(@RequestBody EMEQWLDTO emeqwldto) {
        return ResponseEntity.status(HttpStatus.OK).body(emeqwlService.save(emeqwlMapping.toDomain(emeqwldto)));
    }

    @ApiOperation(value = "SaveBatch", tags = {"EMEQWL" },  notes = "SaveBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqwls/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<EMEQWLDTO> emeqwldtos) {
        emeqwlService.saveBatch(emeqwlMapping.toDomain(emeqwldtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission(#emeqwl_id,'Update',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Update", tags = {"EMEQWL" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/emeqwls/{emeqwl_id}")
    @Transactional
    public ResponseEntity<EMEQWLDTO> update(@PathVariable("emeqwl_id") String emeqwl_id, @RequestBody EMEQWLDTO emeqwldto) {
		EMEQWL domain = emeqwlMapping.toDomain(emeqwldto);
        domain.setEmeqwlid(emeqwl_id);
		emeqwlService.update(domain);
		EMEQWLDTO dto = emeqwlMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(#emeqwl_id,'Update',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "UpdateBatch", tags = {"EMEQWL" },  notes = "UpdateBatch")
	@RequestMapping(method = RequestMethod.PUT, value = "/emeqwls/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<EMEQWLDTO> emeqwldtos) {
        emeqwlService.updateBatch(emeqwlMapping.toDomain(emeqwldtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission(#emeqwl_id,'Get',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Get", tags = {"EMEQWL" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/emeqwls/{emeqwl_id}")
    public ResponseEntity<EMEQWLDTO> get(@PathVariable("emeqwl_id") String emeqwl_id) {
        EMEQWL domain = emeqwlService.get(emeqwl_id);
        EMEQWLDTO dto = emeqwlMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }




    @ApiOperation(value = "GetDraft", tags = {"EMEQWL" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/emeqwls/getdraft")
    public ResponseEntity<EMEQWLDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(emeqwlMapping.toDto(emeqwlService.getDraft(new EMEQWL())));
    }




    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Create", tags = {"EMEQWL" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqwls")
    @Transactional
    public ResponseEntity<EMEQWLDTO> create(@RequestBody EMEQWLDTO emeqwldto) {
        EMEQWL domain = emeqwlMapping.toDomain(emeqwldto);
		emeqwlService.create(domain);
        EMEQWLDTO dto = emeqwlMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }
    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "createBatch", tags = {"EMEQWL" },  notes = "createBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqwls/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<EMEQWLDTO> emeqwldtos) {
        emeqwlService.createBatch(emeqwlMapping.toDomain(emeqwldtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEQWL-Default-all')")
	@ApiOperation(value = "fetchDEFAULT", tags = {"EMEQWL" } ,notes = "fetchDEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emeqwls/fetchdefault")
	public ResponseEntity<List<EMEQWLDTO>> fetchDefault(EMEQWLSearchContext context) {
        Page<EMEQWL> domains = emeqwlService.searchDefault(context) ;
        List<EMEQWLDTO> list = emeqwlMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEQWL-Default-all')")
	@ApiOperation(value = "searchDEFAULT", tags = {"EMEQWL" } ,notes = "searchDEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emeqwls/searchdefault")
	public ResponseEntity<Page<EMEQWLDTO>> searchDefault(@RequestBody EMEQWLSearchContext context) {
        Page<EMEQWL> domains = emeqwlService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emeqwlMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}


    /**
     * 用户权限校验
     * @return
     */
	public EMEQWL getEntity(){
        return new EMEQWL();
    }

}
