package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;

import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;

import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;

import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.eam_core.domain.EMEQKeep;
import cn.ibizlab.eam.core.eam_core.service.IEMEQKeepService;
import cn.ibizlab.eam.core.eam_core.filter.EMEQKeepSearchContext;




@Slf4j
@Api(tags = {"EMEQKeep" })
@RestController("WebApi-emeqkeep")
@RequestMapping("")
public class EMEQKeepResource {

    @Autowired
    private IEMEQKeepService emeqkeepService;

    @Autowired
    @Lazy
    private EMEQKeepMapping emeqkeepMapping;




    @ApiOperation(value = "CheckKey", tags = {"EMEQKeep" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqkeeps/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody EMEQKeepDTO emeqkeepdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emeqkeepService.checkKey(emeqkeepMapping.toDomain(emeqkeepdto)));
    }




    @ApiOperation(value = "Save", tags = {"EMEQKeep" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqkeeps/save")
    public ResponseEntity<Boolean> save(@RequestBody EMEQKeepDTO emeqkeepdto) {
        return ResponseEntity.status(HttpStatus.OK).body(emeqkeepService.save(emeqkeepMapping.toDomain(emeqkeepdto)));
    }

    @ApiOperation(value = "SaveBatch", tags = {"EMEQKeep" },  notes = "SaveBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqkeeps/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<EMEQKeepDTO> emeqkeepdtos) {
        emeqkeepService.saveBatch(emeqkeepMapping.toDomain(emeqkeepdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @ApiOperation(value = "GetDraft", tags = {"EMEQKeep" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/emeqkeeps/getdraft")
    public ResponseEntity<EMEQKeepDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(emeqkeepMapping.toDto(emeqkeepService.getDraft(new EMEQKeep())));
    }




    @PreAuthorize("hasPermission(#emeqkeep_id,'Remove',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Remove", tags = {"EMEQKeep" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emeqkeeps/{emeqkeep_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("emeqkeep_id") String emeqkeep_id) {
         return ResponseEntity.status(HttpStatus.OK).body(emeqkeepService.remove(emeqkeep_id));
    }

    @ApiOperation(value = "RemoveBatch", tags = {"EMEQKeep" },  notes = "RemoveBatch")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emeqkeeps/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        emeqkeepService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission(#emeqkeep_id,'Update',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Update", tags = {"EMEQKeep" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/emeqkeeps/{emeqkeep_id}")
    @Transactional
    public ResponseEntity<EMEQKeepDTO> update(@PathVariable("emeqkeep_id") String emeqkeep_id, @RequestBody EMEQKeepDTO emeqkeepdto) {
		EMEQKeep domain = emeqkeepMapping.toDomain(emeqkeepdto);
        domain.setEmeqkeepid(emeqkeep_id);
		emeqkeepService.update(domain);
		EMEQKeepDTO dto = emeqkeepMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(#emeqkeep_id,'Update',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "UpdateBatch", tags = {"EMEQKeep" },  notes = "UpdateBatch")
	@RequestMapping(method = RequestMethod.PUT, value = "/emeqkeeps/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<EMEQKeepDTO> emeqkeepdtos) {
        emeqkeepService.updateBatch(emeqkeepMapping.toDomain(emeqkeepdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Create", tags = {"EMEQKeep" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqkeeps")
    @Transactional
    public ResponseEntity<EMEQKeepDTO> create(@RequestBody EMEQKeepDTO emeqkeepdto) {
        EMEQKeep domain = emeqkeepMapping.toDomain(emeqkeepdto);
		emeqkeepService.create(domain);
        EMEQKeepDTO dto = emeqkeepMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }
    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "createBatch", tags = {"EMEQKeep" },  notes = "createBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqkeeps/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<EMEQKeepDTO> emeqkeepdtos) {
        emeqkeepService.createBatch(emeqkeepMapping.toDomain(emeqkeepdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission(#emeqkeep_id,'Get',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Get", tags = {"EMEQKeep" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/emeqkeeps/{emeqkeep_id}")
    public ResponseEntity<EMEQKeepDTO> get(@PathVariable("emeqkeep_id") String emeqkeep_id) {
        EMEQKeep domain = emeqkeepService.get(emeqkeep_id);
        EMEQKeepDTO dto = emeqkeepMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEQKeep-Default-all')")
	@ApiOperation(value = "fetchDEFAULT", tags = {"EMEQKeep" } ,notes = "fetchDEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emeqkeeps/fetchdefault")
	public ResponseEntity<List<EMEQKeepDTO>> fetchDefault(EMEQKeepSearchContext context) {
        Page<EMEQKeep> domains = emeqkeepService.searchDefault(context) ;
        List<EMEQKeepDTO> list = emeqkeepMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEQKeep-Default-all')")
	@ApiOperation(value = "searchDEFAULT", tags = {"EMEQKeep" } ,notes = "searchDEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emeqkeeps/searchdefault")
	public ResponseEntity<Page<EMEQKeepDTO>> searchDefault(@RequestBody EMEQKeepSearchContext context) {
        Page<EMEQKeep> domains = emeqkeepService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emeqkeepMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}



    @ApiOperation(value = "CheckKeyByEMEquip", tags = {"EMEQKeep" },  notes = "CheckKeyByEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emequips/{emequip_id}/emeqkeeps/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMEquip(@PathVariable("emequip_id") String emequip_id, @RequestBody EMEQKeepDTO emeqkeepdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emeqkeepService.checkKey(emeqkeepMapping.toDomain(emeqkeepdto)));
    }

    @ApiOperation(value = "SaveByEMEquip", tags = {"EMEQKeep" },  notes = "SaveByEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emequips/{emequip_id}/emeqkeeps/save")
    public ResponseEntity<Boolean> saveByEMEquip(@PathVariable("emequip_id") String emequip_id, @RequestBody EMEQKeepDTO emeqkeepdto) {
        EMEQKeep domain = emeqkeepMapping.toDomain(emeqkeepdto);
        domain.setEquipid(emequip_id);
        return ResponseEntity.status(HttpStatus.OK).body(emeqkeepService.save(domain));
    }

    @ApiOperation(value = "SaveBatchByEMEquip", tags = {"EMEQKeep" },  notes = "SaveBatchByEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emequips/{emequip_id}/emeqkeeps/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMEquip(@PathVariable("emequip_id") String emequip_id, @RequestBody List<EMEQKeepDTO> emeqkeepdtos) {
        List<EMEQKeep> domainlist=emeqkeepMapping.toDomain(emeqkeepdtos);
        for(EMEQKeep domain:domainlist){
             domain.setEquipid(emequip_id);
        }
        emeqkeepService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetDraftByEMEquip", tags = {"EMEQKeep" },  notes = "GetDraftByEMEquip")
    @RequestMapping(method = RequestMethod.GET, value = "/emequips/{emequip_id}/emeqkeeps/getdraft")
    public ResponseEntity<EMEQKeepDTO> getDraftByEMEquip(@PathVariable("emequip_id") String emequip_id) {
        EMEQKeep domain = new EMEQKeep();
        domain.setEquipid(emequip_id);
        return ResponseEntity.status(HttpStatus.OK).body(emeqkeepMapping.toDto(emeqkeepService.getDraft(domain)));
    }

    @ApiOperation(value = "RemoveByEMEquip", tags = {"EMEQKeep" },  notes = "RemoveByEMEquip")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emequips/{emequip_id}/emeqkeeps/{emeqkeep_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMEquip(@PathVariable("emequip_id") String emequip_id, @PathVariable("emeqkeep_id") String emeqkeep_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emeqkeepService.remove(emeqkeep_id));
    }

    @ApiOperation(value = "RemoveBatchByEMEquip", tags = {"EMEQKeep" },  notes = "RemoveBatchByEMEquip")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emequips/{emequip_id}/emeqkeeps/batch")
    public ResponseEntity<Boolean> removeBatchByEMEquip(@RequestBody List<String> ids) {
        emeqkeepService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "UpdateByEMEquip", tags = {"EMEQKeep" },  notes = "UpdateByEMEquip")
	@RequestMapping(method = RequestMethod.PUT, value = "/emequips/{emequip_id}/emeqkeeps/{emeqkeep_id}")
    @Transactional
    public ResponseEntity<EMEQKeepDTO> updateByEMEquip(@PathVariable("emequip_id") String emequip_id, @PathVariable("emeqkeep_id") String emeqkeep_id, @RequestBody EMEQKeepDTO emeqkeepdto) {
        EMEQKeep domain = emeqkeepMapping.toDomain(emeqkeepdto);
        domain.setEquipid(emequip_id);
        domain.setEmeqkeepid(emeqkeep_id);
		emeqkeepService.update(domain);
        EMEQKeepDTO dto = emeqkeepMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateBatchByEMEquip", tags = {"EMEQKeep" },  notes = "UpdateBatchByEMEquip")
	@RequestMapping(method = RequestMethod.PUT, value = "/emequips/{emequip_id}/emeqkeeps/batch")
    public ResponseEntity<Boolean> updateBatchByEMEquip(@PathVariable("emequip_id") String emequip_id, @RequestBody List<EMEQKeepDTO> emeqkeepdtos) {
        List<EMEQKeep> domainlist=emeqkeepMapping.toDomain(emeqkeepdtos);
        for(EMEQKeep domain:domainlist){
            domain.setEquipid(emequip_id);
        }
        emeqkeepService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "CreateByEMEquip", tags = {"EMEQKeep" },  notes = "CreateByEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emequips/{emequip_id}/emeqkeeps")
    @Transactional
    public ResponseEntity<EMEQKeepDTO> createByEMEquip(@PathVariable("emequip_id") String emequip_id, @RequestBody EMEQKeepDTO emeqkeepdto) {
        EMEQKeep domain = emeqkeepMapping.toDomain(emeqkeepdto);
        domain.setEquipid(emequip_id);
		emeqkeepService.create(domain);
        EMEQKeepDTO dto = emeqkeepMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "createBatchByEMEquip", tags = {"EMEQKeep" },  notes = "createBatchByEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emequips/{emequip_id}/emeqkeeps/batch")
    public ResponseEntity<Boolean> createBatchByEMEquip(@PathVariable("emequip_id") String emequip_id, @RequestBody List<EMEQKeepDTO> emeqkeepdtos) {
        List<EMEQKeep> domainlist=emeqkeepMapping.toDomain(emeqkeepdtos);
        for(EMEQKeep domain:domainlist){
            domain.setEquipid(emequip_id);
        }
        emeqkeepService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetByEMEquip", tags = {"EMEQKeep" },  notes = "GetByEMEquip")
	@RequestMapping(method = RequestMethod.GET, value = "/emequips/{emequip_id}/emeqkeeps/{emeqkeep_id}")
    public ResponseEntity<EMEQKeepDTO> getByEMEquip(@PathVariable("emequip_id") String emequip_id, @PathVariable("emeqkeep_id") String emeqkeep_id) {
        EMEQKeep domain = emeqkeepService.get(emeqkeep_id);
        EMEQKeepDTO dto = emeqkeepMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

	@ApiOperation(value = "fetchDEFAULTByEMEquip", tags = {"EMEQKeep" } ,notes = "fetchDEFAULTByEMEquip")
    @RequestMapping(method= RequestMethod.GET , value="/emequips/{emequip_id}/emeqkeeps/fetchdefault")
	public ResponseEntity<List<EMEQKeepDTO>> fetchEMEQKeepDefaultByEMEquip(@PathVariable("emequip_id") String emequip_id,EMEQKeepSearchContext context) {
        context.setN_equipid_eq(emequip_id);
        Page<EMEQKeep> domains = emeqkeepService.searchDefault(context) ;
        List<EMEQKeepDTO> list = emeqkeepMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "searchDEFAULTByEMEquip", tags = {"EMEQKeep" } ,notes = "searchDEFAULTByEMEquip")
    @RequestMapping(method= RequestMethod.POST , value="/emequips/{emequip_id}/emeqkeeps/searchdefault")
	public ResponseEntity<Page<EMEQKeepDTO>> searchEMEQKeepDefaultByEMEquip(@PathVariable("emequip_id") String emequip_id, @RequestBody EMEQKeepSearchContext context) {
        context.setN_equipid_eq(emequip_id);
        Page<EMEQKeep> domains = emeqkeepService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emeqkeepMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}




    @ApiOperation(value = "CheckKeyByEMEQTypeEMEquip", tags = {"EMEQKeep" },  notes = "CheckKeyByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emeqkeeps/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMEQKeepDTO emeqkeepdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emeqkeepService.checkKey(emeqkeepMapping.toDomain(emeqkeepdto)));
    }

    @ApiOperation(value = "SaveByEMEQTypeEMEquip", tags = {"EMEQKeep" },  notes = "SaveByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emeqkeeps/save")
    public ResponseEntity<Boolean> saveByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMEQKeepDTO emeqkeepdto) {
        EMEQKeep domain = emeqkeepMapping.toDomain(emeqkeepdto);
        domain.setEquipid(emequip_id);
        return ResponseEntity.status(HttpStatus.OK).body(emeqkeepService.save(domain));
    }

    @ApiOperation(value = "SaveBatchByEMEQTypeEMEquip", tags = {"EMEQKeep" },  notes = "SaveBatchByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emeqkeeps/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @RequestBody List<EMEQKeepDTO> emeqkeepdtos) {
        List<EMEQKeep> domainlist=emeqkeepMapping.toDomain(emeqkeepdtos);
        for(EMEQKeep domain:domainlist){
             domain.setEquipid(emequip_id);
        }
        emeqkeepService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetDraftByEMEQTypeEMEquip", tags = {"EMEQKeep" },  notes = "GetDraftByEMEQTypeEMEquip")
    @RequestMapping(method = RequestMethod.GET, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emeqkeeps/getdraft")
    public ResponseEntity<EMEQKeepDTO> getDraftByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id) {
        EMEQKeep domain = new EMEQKeep();
        domain.setEquipid(emequip_id);
        return ResponseEntity.status(HttpStatus.OK).body(emeqkeepMapping.toDto(emeqkeepService.getDraft(domain)));
    }

    @ApiOperation(value = "RemoveByEMEQTypeEMEquip", tags = {"EMEQKeep" },  notes = "RemoveByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emeqkeeps/{emeqkeep_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emeqkeep_id") String emeqkeep_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emeqkeepService.remove(emeqkeep_id));
    }

    @ApiOperation(value = "RemoveBatchByEMEQTypeEMEquip", tags = {"EMEQKeep" },  notes = "RemoveBatchByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emeqkeeps/batch")
    public ResponseEntity<Boolean> removeBatchByEMEQTypeEMEquip(@RequestBody List<String> ids) {
        emeqkeepService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "UpdateByEMEQTypeEMEquip", tags = {"EMEQKeep" },  notes = "UpdateByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.PUT, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emeqkeeps/{emeqkeep_id}")
    @Transactional
    public ResponseEntity<EMEQKeepDTO> updateByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emeqkeep_id") String emeqkeep_id, @RequestBody EMEQKeepDTO emeqkeepdto) {
        EMEQKeep domain = emeqkeepMapping.toDomain(emeqkeepdto);
        domain.setEquipid(emequip_id);
        domain.setEmeqkeepid(emeqkeep_id);
		emeqkeepService.update(domain);
        EMEQKeepDTO dto = emeqkeepMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateBatchByEMEQTypeEMEquip", tags = {"EMEQKeep" },  notes = "UpdateBatchByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.PUT, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emeqkeeps/batch")
    public ResponseEntity<Boolean> updateBatchByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @RequestBody List<EMEQKeepDTO> emeqkeepdtos) {
        List<EMEQKeep> domainlist=emeqkeepMapping.toDomain(emeqkeepdtos);
        for(EMEQKeep domain:domainlist){
            domain.setEquipid(emequip_id);
        }
        emeqkeepService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "CreateByEMEQTypeEMEquip", tags = {"EMEQKeep" },  notes = "CreateByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emeqkeeps")
    @Transactional
    public ResponseEntity<EMEQKeepDTO> createByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMEQKeepDTO emeqkeepdto) {
        EMEQKeep domain = emeqkeepMapping.toDomain(emeqkeepdto);
        domain.setEquipid(emequip_id);
		emeqkeepService.create(domain);
        EMEQKeepDTO dto = emeqkeepMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "createBatchByEMEQTypeEMEquip", tags = {"EMEQKeep" },  notes = "createBatchByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emeqkeeps/batch")
    public ResponseEntity<Boolean> createBatchByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @RequestBody List<EMEQKeepDTO> emeqkeepdtos) {
        List<EMEQKeep> domainlist=emeqkeepMapping.toDomain(emeqkeepdtos);
        for(EMEQKeep domain:domainlist){
            domain.setEquipid(emequip_id);
        }
        emeqkeepService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetByEMEQTypeEMEquip", tags = {"EMEQKeep" },  notes = "GetByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.GET, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emeqkeeps/{emeqkeep_id}")
    public ResponseEntity<EMEQKeepDTO> getByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emeqkeep_id") String emeqkeep_id) {
        EMEQKeep domain = emeqkeepService.get(emeqkeep_id);
        EMEQKeepDTO dto = emeqkeepMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

	@ApiOperation(value = "fetchDEFAULTByEMEQTypeEMEquip", tags = {"EMEQKeep" } ,notes = "fetchDEFAULTByEMEQTypeEMEquip")
    @RequestMapping(method= RequestMethod.GET , value="/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emeqkeeps/fetchdefault")
	public ResponseEntity<List<EMEQKeepDTO>> fetchEMEQKeepDefaultByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id,EMEQKeepSearchContext context) {
        context.setN_equipid_eq(emequip_id);
        Page<EMEQKeep> domains = emeqkeepService.searchDefault(context) ;
        List<EMEQKeepDTO> list = emeqkeepMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "searchDEFAULTByEMEQTypeEMEquip", tags = {"EMEQKeep" } ,notes = "searchDEFAULTByEMEQTypeEMEquip")
    @RequestMapping(method= RequestMethod.POST , value="/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emeqkeeps/searchdefault")
	public ResponseEntity<Page<EMEQKeepDTO>> searchEMEQKeepDefaultByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMEQKeepSearchContext context) {
        context.setN_equipid_eq(emequip_id);
        Page<EMEQKeep> domains = emeqkeepService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emeqkeepMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}




    @ApiOperation(value = "CheckKeyByPFTeamEMEquip", tags = {"EMEQKeep" },  notes = "CheckKeyByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emeqkeeps/checkkey")
    public ResponseEntity<Boolean> checkKeyByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMEQKeepDTO emeqkeepdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emeqkeepService.checkKey(emeqkeepMapping.toDomain(emeqkeepdto)));
    }

    @ApiOperation(value = "SaveByPFTeamEMEquip", tags = {"EMEQKeep" },  notes = "SaveByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emeqkeeps/save")
    public ResponseEntity<Boolean> saveByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMEQKeepDTO emeqkeepdto) {
        EMEQKeep domain = emeqkeepMapping.toDomain(emeqkeepdto);
        domain.setEquipid(emequip_id);
        return ResponseEntity.status(HttpStatus.OK).body(emeqkeepService.save(domain));
    }

    @ApiOperation(value = "SaveBatchByPFTeamEMEquip", tags = {"EMEQKeep" },  notes = "SaveBatchByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emeqkeeps/savebatch")
    public ResponseEntity<Boolean> saveBatchByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @RequestBody List<EMEQKeepDTO> emeqkeepdtos) {
        List<EMEQKeep> domainlist=emeqkeepMapping.toDomain(emeqkeepdtos);
        for(EMEQKeep domain:domainlist){
             domain.setEquipid(emequip_id);
        }
        emeqkeepService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetDraftByPFTeamEMEquip", tags = {"EMEQKeep" },  notes = "GetDraftByPFTeamEMEquip")
    @RequestMapping(method = RequestMethod.GET, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emeqkeeps/getdraft")
    public ResponseEntity<EMEQKeepDTO> getDraftByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id) {
        EMEQKeep domain = new EMEQKeep();
        domain.setEquipid(emequip_id);
        return ResponseEntity.status(HttpStatus.OK).body(emeqkeepMapping.toDto(emeqkeepService.getDraft(domain)));
    }

    @ApiOperation(value = "RemoveByPFTeamEMEquip", tags = {"EMEQKeep" },  notes = "RemoveByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emeqkeeps/{emeqkeep_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emeqkeep_id") String emeqkeep_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emeqkeepService.remove(emeqkeep_id));
    }

    @ApiOperation(value = "RemoveBatchByPFTeamEMEquip", tags = {"EMEQKeep" },  notes = "RemoveBatchByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emeqkeeps/batch")
    public ResponseEntity<Boolean> removeBatchByPFTeamEMEquip(@RequestBody List<String> ids) {
        emeqkeepService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "UpdateByPFTeamEMEquip", tags = {"EMEQKeep" },  notes = "UpdateByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emeqkeeps/{emeqkeep_id}")
    @Transactional
    public ResponseEntity<EMEQKeepDTO> updateByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emeqkeep_id") String emeqkeep_id, @RequestBody EMEQKeepDTO emeqkeepdto) {
        EMEQKeep domain = emeqkeepMapping.toDomain(emeqkeepdto);
        domain.setEquipid(emequip_id);
        domain.setEmeqkeepid(emeqkeep_id);
		emeqkeepService.update(domain);
        EMEQKeepDTO dto = emeqkeepMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateBatchByPFTeamEMEquip", tags = {"EMEQKeep" },  notes = "UpdateBatchByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emeqkeeps/batch")
    public ResponseEntity<Boolean> updateBatchByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @RequestBody List<EMEQKeepDTO> emeqkeepdtos) {
        List<EMEQKeep> domainlist=emeqkeepMapping.toDomain(emeqkeepdtos);
        for(EMEQKeep domain:domainlist){
            domain.setEquipid(emequip_id);
        }
        emeqkeepService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "CreateByPFTeamEMEquip", tags = {"EMEQKeep" },  notes = "CreateByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emeqkeeps")
    @Transactional
    public ResponseEntity<EMEQKeepDTO> createByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMEQKeepDTO emeqkeepdto) {
        EMEQKeep domain = emeqkeepMapping.toDomain(emeqkeepdto);
        domain.setEquipid(emequip_id);
		emeqkeepService.create(domain);
        EMEQKeepDTO dto = emeqkeepMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "createBatchByPFTeamEMEquip", tags = {"EMEQKeep" },  notes = "createBatchByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emeqkeeps/batch")
    public ResponseEntity<Boolean> createBatchByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @RequestBody List<EMEQKeepDTO> emeqkeepdtos) {
        List<EMEQKeep> domainlist=emeqkeepMapping.toDomain(emeqkeepdtos);
        for(EMEQKeep domain:domainlist){
            domain.setEquipid(emequip_id);
        }
        emeqkeepService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetByPFTeamEMEquip", tags = {"EMEQKeep" },  notes = "GetByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.GET, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emeqkeeps/{emeqkeep_id}")
    public ResponseEntity<EMEQKeepDTO> getByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emeqkeep_id") String emeqkeep_id) {
        EMEQKeep domain = emeqkeepService.get(emeqkeep_id);
        EMEQKeepDTO dto = emeqkeepMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

	@ApiOperation(value = "fetchDEFAULTByPFTeamEMEquip", tags = {"EMEQKeep" } ,notes = "fetchDEFAULTByPFTeamEMEquip")
    @RequestMapping(method= RequestMethod.GET , value="/pfteams/{pfteam_id}/emequips/{emequip_id}/emeqkeeps/fetchdefault")
	public ResponseEntity<List<EMEQKeepDTO>> fetchEMEQKeepDefaultByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id,EMEQKeepSearchContext context) {
        context.setN_equipid_eq(emequip_id);
        Page<EMEQKeep> domains = emeqkeepService.searchDefault(context) ;
        List<EMEQKeepDTO> list = emeqkeepMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "searchDEFAULTByPFTeamEMEquip", tags = {"EMEQKeep" } ,notes = "searchDEFAULTByPFTeamEMEquip")
    @RequestMapping(method= RequestMethod.POST , value="/pfteams/{pfteam_id}/emequips/{emequip_id}/emeqkeeps/searchdefault")
	public ResponseEntity<Page<EMEQKeepDTO>> searchEMEQKeepDefaultByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMEQKeepSearchContext context) {
        context.setN_equipid_eq(emequip_id);
        Page<EMEQKeep> domains = emeqkeepService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emeqkeepMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}


    /**
     * 用户权限校验
     * @return
     */
	public EMEQKeep getEntity(){
        return new EMEQKeep();
    }

}
