package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;

import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;

import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;

import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.eam_core.domain.EMEQAH;
import cn.ibizlab.eam.core.eam_core.service.IEMEQAHService;
import cn.ibizlab.eam.core.eam_core.filter.EMEQAHSearchContext;




@Slf4j
@Api(tags = {"EMEQAH" })
@RestController("WebApi-emeqah")
@RequestMapping("")
public class EMEQAHResource {

    @Autowired
    private IEMEQAHService emeqahService;

    @Autowired
    @Lazy
    private EMEQAHMapping emeqahMapping;




    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Create", tags = {"EMEQAH" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqahs")
    @Transactional
    public ResponseEntity<EMEQAHDTO> create(@RequestBody EMEQAHDTO emeqahdto) {
        EMEQAH domain = emeqahMapping.toDomain(emeqahdto);
		emeqahService.create(domain);
        EMEQAHDTO dto = emeqahMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }
    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "createBatch", tags = {"EMEQAH" },  notes = "createBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqahs/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<EMEQAHDTO> emeqahdtos) {
        emeqahService.createBatch(emeqahMapping.toDomain(emeqahdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission(#emeqah_id,'Update',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Update", tags = {"EMEQAH" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/emeqahs/{emeqah_id}")
    @Transactional
    public ResponseEntity<EMEQAHDTO> update(@PathVariable("emeqah_id") String emeqah_id, @RequestBody EMEQAHDTO emeqahdto) {
		EMEQAH domain = emeqahMapping.toDomain(emeqahdto);
        domain.setEmeqahid(emeqah_id);
		emeqahService.update(domain);
		EMEQAHDTO dto = emeqahMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(#emeqah_id,'Update',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "UpdateBatch", tags = {"EMEQAH" },  notes = "UpdateBatch")
	@RequestMapping(method = RequestMethod.PUT, value = "/emeqahs/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<EMEQAHDTO> emeqahdtos) {
        emeqahService.updateBatch(emeqahMapping.toDomain(emeqahdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @ApiOperation(value = "Save", tags = {"EMEQAH" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqahs/save")
    public ResponseEntity<Boolean> save(@RequestBody EMEQAHDTO emeqahdto) {
        return ResponseEntity.status(HttpStatus.OK).body(emeqahService.save(emeqahMapping.toDomain(emeqahdto)));
    }

    @ApiOperation(value = "SaveBatch", tags = {"EMEQAH" },  notes = "SaveBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqahs/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<EMEQAHDTO> emeqahdtos) {
        emeqahService.saveBatch(emeqahMapping.toDomain(emeqahdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission(#emeqah_id,'Get',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Get", tags = {"EMEQAH" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/emeqahs/{emeqah_id}")
    public ResponseEntity<EMEQAHDTO> get(@PathVariable("emeqah_id") String emeqah_id) {
        EMEQAH domain = emeqahService.get(emeqah_id);
        EMEQAHDTO dto = emeqahMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }




    @ApiOperation(value = "CheckKey", tags = {"EMEQAH" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqahs/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody EMEQAHDTO emeqahdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emeqahService.checkKey(emeqahMapping.toDomain(emeqahdto)));
    }




    @PreAuthorize("hasPermission(#emeqah_id,'Remove',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Remove", tags = {"EMEQAH" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emeqahs/{emeqah_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("emeqah_id") String emeqah_id) {
         return ResponseEntity.status(HttpStatus.OK).body(emeqahService.remove(emeqah_id));
    }

    @ApiOperation(value = "RemoveBatch", tags = {"EMEQAH" },  notes = "RemoveBatch")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emeqahs/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        emeqahService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @ApiOperation(value = "GetDraft", tags = {"EMEQAH" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/emeqahs/getdraft")
    public ResponseEntity<EMEQAHDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(emeqahMapping.toDto(emeqahService.getDraft(new EMEQAH())));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEQAH-Default-all')")
	@ApiOperation(value = "fetchDEFAULT", tags = {"EMEQAH" } ,notes = "fetchDEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emeqahs/fetchdefault")
	public ResponseEntity<List<EMEQAHDTO>> fetchDefault(EMEQAHSearchContext context) {
        Page<EMEQAH> domains = emeqahService.searchDefault(context) ;
        List<EMEQAHDTO> list = emeqahMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEQAH-Default-all')")
	@ApiOperation(value = "searchDEFAULT", tags = {"EMEQAH" } ,notes = "searchDEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emeqahs/searchdefault")
	public ResponseEntity<Page<EMEQAHDTO>> searchDefault(@RequestBody EMEQAHSearchContext context) {
        Page<EMEQAH> domains = emeqahService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emeqahMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEQAH-IndexDER-all')")
	@ApiOperation(value = "fetchIndexDER", tags = {"EMEQAH" } ,notes = "fetchIndexDER")
    @RequestMapping(method= RequestMethod.GET , value="/emeqahs/fetchindexder")
	public ResponseEntity<List<EMEQAHDTO>> fetchIndexDER(EMEQAHSearchContext context) {
        Page<EMEQAH> domains = emeqahService.searchIndexDER(context) ;
        List<EMEQAHDTO> list = emeqahMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEQAH-IndexDER-all')")
	@ApiOperation(value = "searchIndexDER", tags = {"EMEQAH" } ,notes = "searchIndexDER")
    @RequestMapping(method= RequestMethod.POST , value="/emeqahs/searchindexder")
	public ResponseEntity<Page<EMEQAHDTO>> searchIndexDER(@RequestBody EMEQAHSearchContext context) {
        Page<EMEQAH> domains = emeqahService.searchIndexDER(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emeqahMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}



    @ApiOperation(value = "CreateByEMEquip", tags = {"EMEQAH" },  notes = "CreateByEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emequips/{emequip_id}/emeqahs")
    @Transactional
    public ResponseEntity<EMEQAHDTO> createByEMEquip(@PathVariable("emequip_id") String emequip_id, @RequestBody EMEQAHDTO emeqahdto) {
        EMEQAH domain = emeqahMapping.toDomain(emeqahdto);
        domain.setEquipid(emequip_id);
		emeqahService.create(domain);
        EMEQAHDTO dto = emeqahMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "createBatchByEMEquip", tags = {"EMEQAH" },  notes = "createBatchByEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emequips/{emequip_id}/emeqahs/batch")
    public ResponseEntity<Boolean> createBatchByEMEquip(@PathVariable("emequip_id") String emequip_id, @RequestBody List<EMEQAHDTO> emeqahdtos) {
        List<EMEQAH> domainlist=emeqahMapping.toDomain(emeqahdtos);
        for(EMEQAH domain:domainlist){
            domain.setEquipid(emequip_id);
        }
        emeqahService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "UpdateByEMEquip", tags = {"EMEQAH" },  notes = "UpdateByEMEquip")
	@RequestMapping(method = RequestMethod.PUT, value = "/emequips/{emequip_id}/emeqahs/{emeqah_id}")
    @Transactional
    public ResponseEntity<EMEQAHDTO> updateByEMEquip(@PathVariable("emequip_id") String emequip_id, @PathVariable("emeqah_id") String emeqah_id, @RequestBody EMEQAHDTO emeqahdto) {
        EMEQAH domain = emeqahMapping.toDomain(emeqahdto);
        domain.setEquipid(emequip_id);
        domain.setEmeqahid(emeqah_id);
		emeqahService.update(domain);
        EMEQAHDTO dto = emeqahMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateBatchByEMEquip", tags = {"EMEQAH" },  notes = "UpdateBatchByEMEquip")
	@RequestMapping(method = RequestMethod.PUT, value = "/emequips/{emequip_id}/emeqahs/batch")
    public ResponseEntity<Boolean> updateBatchByEMEquip(@PathVariable("emequip_id") String emequip_id, @RequestBody List<EMEQAHDTO> emeqahdtos) {
        List<EMEQAH> domainlist=emeqahMapping.toDomain(emeqahdtos);
        for(EMEQAH domain:domainlist){
            domain.setEquipid(emequip_id);
        }
        emeqahService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "SaveByEMEquip", tags = {"EMEQAH" },  notes = "SaveByEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emequips/{emequip_id}/emeqahs/save")
    public ResponseEntity<Boolean> saveByEMEquip(@PathVariable("emequip_id") String emequip_id, @RequestBody EMEQAHDTO emeqahdto) {
        EMEQAH domain = emeqahMapping.toDomain(emeqahdto);
        domain.setEquipid(emequip_id);
        return ResponseEntity.status(HttpStatus.OK).body(emeqahService.save(domain));
    }

    @ApiOperation(value = "SaveBatchByEMEquip", tags = {"EMEQAH" },  notes = "SaveBatchByEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emequips/{emequip_id}/emeqahs/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMEquip(@PathVariable("emequip_id") String emequip_id, @RequestBody List<EMEQAHDTO> emeqahdtos) {
        List<EMEQAH> domainlist=emeqahMapping.toDomain(emeqahdtos);
        for(EMEQAH domain:domainlist){
             domain.setEquipid(emequip_id);
        }
        emeqahService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetByEMEquip", tags = {"EMEQAH" },  notes = "GetByEMEquip")
	@RequestMapping(method = RequestMethod.GET, value = "/emequips/{emequip_id}/emeqahs/{emeqah_id}")
    public ResponseEntity<EMEQAHDTO> getByEMEquip(@PathVariable("emequip_id") String emequip_id, @PathVariable("emeqah_id") String emeqah_id) {
        EMEQAH domain = emeqahService.get(emeqah_id);
        EMEQAHDTO dto = emeqahMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "CheckKeyByEMEquip", tags = {"EMEQAH" },  notes = "CheckKeyByEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emequips/{emequip_id}/emeqahs/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMEquip(@PathVariable("emequip_id") String emequip_id, @RequestBody EMEQAHDTO emeqahdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emeqahService.checkKey(emeqahMapping.toDomain(emeqahdto)));
    }

    @ApiOperation(value = "RemoveByEMEquip", tags = {"EMEQAH" },  notes = "RemoveByEMEquip")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emequips/{emequip_id}/emeqahs/{emeqah_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMEquip(@PathVariable("emequip_id") String emequip_id, @PathVariable("emeqah_id") String emeqah_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emeqahService.remove(emeqah_id));
    }

    @ApiOperation(value = "RemoveBatchByEMEquip", tags = {"EMEQAH" },  notes = "RemoveBatchByEMEquip")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emequips/{emequip_id}/emeqahs/batch")
    public ResponseEntity<Boolean> removeBatchByEMEquip(@RequestBody List<String> ids) {
        emeqahService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetDraftByEMEquip", tags = {"EMEQAH" },  notes = "GetDraftByEMEquip")
    @RequestMapping(method = RequestMethod.GET, value = "/emequips/{emequip_id}/emeqahs/getdraft")
    public ResponseEntity<EMEQAHDTO> getDraftByEMEquip(@PathVariable("emequip_id") String emequip_id) {
        EMEQAH domain = new EMEQAH();
        domain.setEquipid(emequip_id);
        return ResponseEntity.status(HttpStatus.OK).body(emeqahMapping.toDto(emeqahService.getDraft(domain)));
    }

	@ApiOperation(value = "fetchDEFAULTByEMEquip", tags = {"EMEQAH" } ,notes = "fetchDEFAULTByEMEquip")
    @RequestMapping(method= RequestMethod.GET , value="/emequips/{emequip_id}/emeqahs/fetchdefault")
	public ResponseEntity<List<EMEQAHDTO>> fetchEMEQAHDefaultByEMEquip(@PathVariable("emequip_id") String emequip_id,EMEQAHSearchContext context) {
        context.setN_equipid_eq(emequip_id);
        Page<EMEQAH> domains = emeqahService.searchDefault(context) ;
        List<EMEQAHDTO> list = emeqahMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "searchDEFAULTByEMEquip", tags = {"EMEQAH" } ,notes = "searchDEFAULTByEMEquip")
    @RequestMapping(method= RequestMethod.POST , value="/emequips/{emequip_id}/emeqahs/searchdefault")
	public ResponseEntity<Page<EMEQAHDTO>> searchEMEQAHDefaultByEMEquip(@PathVariable("emequip_id") String emequip_id, @RequestBody EMEQAHSearchContext context) {
        context.setN_equipid_eq(emequip_id);
        Page<EMEQAH> domains = emeqahService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emeqahMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}

	@ApiOperation(value = "fetchIndexDERByEMEquip", tags = {"EMEQAH" } ,notes = "fetchIndexDERByEMEquip")
    @RequestMapping(method= RequestMethod.GET , value="/emequips/{emequip_id}/emeqahs/fetchindexder")
	public ResponseEntity<List<EMEQAHDTO>> fetchEMEQAHIndexDERByEMEquip(@PathVariable("emequip_id") String emequip_id,EMEQAHSearchContext context) {
        context.setN_equipid_eq(emequip_id);
        Page<EMEQAH> domains = emeqahService.searchIndexDER(context) ;
        List<EMEQAHDTO> list = emeqahMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "searchIndexDERByEMEquip", tags = {"EMEQAH" } ,notes = "searchIndexDERByEMEquip")
    @RequestMapping(method= RequestMethod.POST , value="/emequips/{emequip_id}/emeqahs/searchindexder")
	public ResponseEntity<Page<EMEQAHDTO>> searchEMEQAHIndexDERByEMEquip(@PathVariable("emequip_id") String emequip_id, @RequestBody EMEQAHSearchContext context) {
        context.setN_equipid_eq(emequip_id);
        Page<EMEQAH> domains = emeqahService.searchIndexDER(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emeqahMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}




    @ApiOperation(value = "CreateByEMEQTypeEMEquip", tags = {"EMEQAH" },  notes = "CreateByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emeqahs")
    @Transactional
    public ResponseEntity<EMEQAHDTO> createByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMEQAHDTO emeqahdto) {
        EMEQAH domain = emeqahMapping.toDomain(emeqahdto);
        domain.setEquipid(emequip_id);
		emeqahService.create(domain);
        EMEQAHDTO dto = emeqahMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "createBatchByEMEQTypeEMEquip", tags = {"EMEQAH" },  notes = "createBatchByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emeqahs/batch")
    public ResponseEntity<Boolean> createBatchByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @RequestBody List<EMEQAHDTO> emeqahdtos) {
        List<EMEQAH> domainlist=emeqahMapping.toDomain(emeqahdtos);
        for(EMEQAH domain:domainlist){
            domain.setEquipid(emequip_id);
        }
        emeqahService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "UpdateByEMEQTypeEMEquip", tags = {"EMEQAH" },  notes = "UpdateByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.PUT, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emeqahs/{emeqah_id}")
    @Transactional
    public ResponseEntity<EMEQAHDTO> updateByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emeqah_id") String emeqah_id, @RequestBody EMEQAHDTO emeqahdto) {
        EMEQAH domain = emeqahMapping.toDomain(emeqahdto);
        domain.setEquipid(emequip_id);
        domain.setEmeqahid(emeqah_id);
		emeqahService.update(domain);
        EMEQAHDTO dto = emeqahMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateBatchByEMEQTypeEMEquip", tags = {"EMEQAH" },  notes = "UpdateBatchByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.PUT, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emeqahs/batch")
    public ResponseEntity<Boolean> updateBatchByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @RequestBody List<EMEQAHDTO> emeqahdtos) {
        List<EMEQAH> domainlist=emeqahMapping.toDomain(emeqahdtos);
        for(EMEQAH domain:domainlist){
            domain.setEquipid(emequip_id);
        }
        emeqahService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "SaveByEMEQTypeEMEquip", tags = {"EMEQAH" },  notes = "SaveByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emeqahs/save")
    public ResponseEntity<Boolean> saveByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMEQAHDTO emeqahdto) {
        EMEQAH domain = emeqahMapping.toDomain(emeqahdto);
        domain.setEquipid(emequip_id);
        return ResponseEntity.status(HttpStatus.OK).body(emeqahService.save(domain));
    }

    @ApiOperation(value = "SaveBatchByEMEQTypeEMEquip", tags = {"EMEQAH" },  notes = "SaveBatchByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emeqahs/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @RequestBody List<EMEQAHDTO> emeqahdtos) {
        List<EMEQAH> domainlist=emeqahMapping.toDomain(emeqahdtos);
        for(EMEQAH domain:domainlist){
             domain.setEquipid(emequip_id);
        }
        emeqahService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetByEMEQTypeEMEquip", tags = {"EMEQAH" },  notes = "GetByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.GET, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emeqahs/{emeqah_id}")
    public ResponseEntity<EMEQAHDTO> getByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emeqah_id") String emeqah_id) {
        EMEQAH domain = emeqahService.get(emeqah_id);
        EMEQAHDTO dto = emeqahMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "CheckKeyByEMEQTypeEMEquip", tags = {"EMEQAH" },  notes = "CheckKeyByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emeqahs/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMEQAHDTO emeqahdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emeqahService.checkKey(emeqahMapping.toDomain(emeqahdto)));
    }

    @ApiOperation(value = "RemoveByEMEQTypeEMEquip", tags = {"EMEQAH" },  notes = "RemoveByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emeqahs/{emeqah_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emeqah_id") String emeqah_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emeqahService.remove(emeqah_id));
    }

    @ApiOperation(value = "RemoveBatchByEMEQTypeEMEquip", tags = {"EMEQAH" },  notes = "RemoveBatchByEMEQTypeEMEquip")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emeqahs/batch")
    public ResponseEntity<Boolean> removeBatchByEMEQTypeEMEquip(@RequestBody List<String> ids) {
        emeqahService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetDraftByEMEQTypeEMEquip", tags = {"EMEQAH" },  notes = "GetDraftByEMEQTypeEMEquip")
    @RequestMapping(method = RequestMethod.GET, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emeqahs/getdraft")
    public ResponseEntity<EMEQAHDTO> getDraftByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id) {
        EMEQAH domain = new EMEQAH();
        domain.setEquipid(emequip_id);
        return ResponseEntity.status(HttpStatus.OK).body(emeqahMapping.toDto(emeqahService.getDraft(domain)));
    }

	@ApiOperation(value = "fetchDEFAULTByEMEQTypeEMEquip", tags = {"EMEQAH" } ,notes = "fetchDEFAULTByEMEQTypeEMEquip")
    @RequestMapping(method= RequestMethod.GET , value="/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emeqahs/fetchdefault")
	public ResponseEntity<List<EMEQAHDTO>> fetchEMEQAHDefaultByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id,EMEQAHSearchContext context) {
        context.setN_equipid_eq(emequip_id);
        Page<EMEQAH> domains = emeqahService.searchDefault(context) ;
        List<EMEQAHDTO> list = emeqahMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "searchDEFAULTByEMEQTypeEMEquip", tags = {"EMEQAH" } ,notes = "searchDEFAULTByEMEQTypeEMEquip")
    @RequestMapping(method= RequestMethod.POST , value="/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emeqahs/searchdefault")
	public ResponseEntity<Page<EMEQAHDTO>> searchEMEQAHDefaultByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMEQAHSearchContext context) {
        context.setN_equipid_eq(emequip_id);
        Page<EMEQAH> domains = emeqahService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emeqahMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}

	@ApiOperation(value = "fetchIndexDERByEMEQTypeEMEquip", tags = {"EMEQAH" } ,notes = "fetchIndexDERByEMEQTypeEMEquip")
    @RequestMapping(method= RequestMethod.GET , value="/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emeqahs/fetchindexder")
	public ResponseEntity<List<EMEQAHDTO>> fetchEMEQAHIndexDERByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id,EMEQAHSearchContext context) {
        context.setN_equipid_eq(emequip_id);
        Page<EMEQAH> domains = emeqahService.searchIndexDER(context) ;
        List<EMEQAHDTO> list = emeqahMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "searchIndexDERByEMEQTypeEMEquip", tags = {"EMEQAH" } ,notes = "searchIndexDERByEMEQTypeEMEquip")
    @RequestMapping(method= RequestMethod.POST , value="/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emeqahs/searchindexder")
	public ResponseEntity<Page<EMEQAHDTO>> searchEMEQAHIndexDERByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMEQAHSearchContext context) {
        context.setN_equipid_eq(emequip_id);
        Page<EMEQAH> domains = emeqahService.searchIndexDER(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emeqahMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}




    @ApiOperation(value = "CreateByPFTeamEMEquip", tags = {"EMEQAH" },  notes = "CreateByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emeqahs")
    @Transactional
    public ResponseEntity<EMEQAHDTO> createByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMEQAHDTO emeqahdto) {
        EMEQAH domain = emeqahMapping.toDomain(emeqahdto);
        domain.setEquipid(emequip_id);
		emeqahService.create(domain);
        EMEQAHDTO dto = emeqahMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "createBatchByPFTeamEMEquip", tags = {"EMEQAH" },  notes = "createBatchByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emeqahs/batch")
    public ResponseEntity<Boolean> createBatchByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @RequestBody List<EMEQAHDTO> emeqahdtos) {
        List<EMEQAH> domainlist=emeqahMapping.toDomain(emeqahdtos);
        for(EMEQAH domain:domainlist){
            domain.setEquipid(emequip_id);
        }
        emeqahService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "UpdateByPFTeamEMEquip", tags = {"EMEQAH" },  notes = "UpdateByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emeqahs/{emeqah_id}")
    @Transactional
    public ResponseEntity<EMEQAHDTO> updateByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emeqah_id") String emeqah_id, @RequestBody EMEQAHDTO emeqahdto) {
        EMEQAH domain = emeqahMapping.toDomain(emeqahdto);
        domain.setEquipid(emequip_id);
        domain.setEmeqahid(emeqah_id);
		emeqahService.update(domain);
        EMEQAHDTO dto = emeqahMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateBatchByPFTeamEMEquip", tags = {"EMEQAH" },  notes = "UpdateBatchByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emeqahs/batch")
    public ResponseEntity<Boolean> updateBatchByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @RequestBody List<EMEQAHDTO> emeqahdtos) {
        List<EMEQAH> domainlist=emeqahMapping.toDomain(emeqahdtos);
        for(EMEQAH domain:domainlist){
            domain.setEquipid(emequip_id);
        }
        emeqahService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "SaveByPFTeamEMEquip", tags = {"EMEQAH" },  notes = "SaveByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emeqahs/save")
    public ResponseEntity<Boolean> saveByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMEQAHDTO emeqahdto) {
        EMEQAH domain = emeqahMapping.toDomain(emeqahdto);
        domain.setEquipid(emequip_id);
        return ResponseEntity.status(HttpStatus.OK).body(emeqahService.save(domain));
    }

    @ApiOperation(value = "SaveBatchByPFTeamEMEquip", tags = {"EMEQAH" },  notes = "SaveBatchByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emeqahs/savebatch")
    public ResponseEntity<Boolean> saveBatchByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @RequestBody List<EMEQAHDTO> emeqahdtos) {
        List<EMEQAH> domainlist=emeqahMapping.toDomain(emeqahdtos);
        for(EMEQAH domain:domainlist){
             domain.setEquipid(emequip_id);
        }
        emeqahService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetByPFTeamEMEquip", tags = {"EMEQAH" },  notes = "GetByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.GET, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emeqahs/{emeqah_id}")
    public ResponseEntity<EMEQAHDTO> getByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emeqah_id") String emeqah_id) {
        EMEQAH domain = emeqahService.get(emeqah_id);
        EMEQAHDTO dto = emeqahMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "CheckKeyByPFTeamEMEquip", tags = {"EMEQAH" },  notes = "CheckKeyByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emeqahs/checkkey")
    public ResponseEntity<Boolean> checkKeyByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMEQAHDTO emeqahdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emeqahService.checkKey(emeqahMapping.toDomain(emeqahdto)));
    }

    @ApiOperation(value = "RemoveByPFTeamEMEquip", tags = {"EMEQAH" },  notes = "RemoveByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emeqahs/{emeqah_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emeqah_id") String emeqah_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emeqahService.remove(emeqah_id));
    }

    @ApiOperation(value = "RemoveBatchByPFTeamEMEquip", tags = {"EMEQAH" },  notes = "RemoveBatchByPFTeamEMEquip")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emeqahs/batch")
    public ResponseEntity<Boolean> removeBatchByPFTeamEMEquip(@RequestBody List<String> ids) {
        emeqahService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetDraftByPFTeamEMEquip", tags = {"EMEQAH" },  notes = "GetDraftByPFTeamEMEquip")
    @RequestMapping(method = RequestMethod.GET, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emeqahs/getdraft")
    public ResponseEntity<EMEQAHDTO> getDraftByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id) {
        EMEQAH domain = new EMEQAH();
        domain.setEquipid(emequip_id);
        return ResponseEntity.status(HttpStatus.OK).body(emeqahMapping.toDto(emeqahService.getDraft(domain)));
    }

	@ApiOperation(value = "fetchDEFAULTByPFTeamEMEquip", tags = {"EMEQAH" } ,notes = "fetchDEFAULTByPFTeamEMEquip")
    @RequestMapping(method= RequestMethod.GET , value="/pfteams/{pfteam_id}/emequips/{emequip_id}/emeqahs/fetchdefault")
	public ResponseEntity<List<EMEQAHDTO>> fetchEMEQAHDefaultByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id,EMEQAHSearchContext context) {
        context.setN_equipid_eq(emequip_id);
        Page<EMEQAH> domains = emeqahService.searchDefault(context) ;
        List<EMEQAHDTO> list = emeqahMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "searchDEFAULTByPFTeamEMEquip", tags = {"EMEQAH" } ,notes = "searchDEFAULTByPFTeamEMEquip")
    @RequestMapping(method= RequestMethod.POST , value="/pfteams/{pfteam_id}/emequips/{emequip_id}/emeqahs/searchdefault")
	public ResponseEntity<Page<EMEQAHDTO>> searchEMEQAHDefaultByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMEQAHSearchContext context) {
        context.setN_equipid_eq(emequip_id);
        Page<EMEQAH> domains = emeqahService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emeqahMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}

	@ApiOperation(value = "fetchIndexDERByPFTeamEMEquip", tags = {"EMEQAH" } ,notes = "fetchIndexDERByPFTeamEMEquip")
    @RequestMapping(method= RequestMethod.GET , value="/pfteams/{pfteam_id}/emequips/{emequip_id}/emeqahs/fetchindexder")
	public ResponseEntity<List<EMEQAHDTO>> fetchEMEQAHIndexDERByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id,EMEQAHSearchContext context) {
        context.setN_equipid_eq(emequip_id);
        Page<EMEQAH> domains = emeqahService.searchIndexDER(context) ;
        List<EMEQAHDTO> list = emeqahMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "searchIndexDERByPFTeamEMEquip", tags = {"EMEQAH" } ,notes = "searchIndexDERByPFTeamEMEquip")
    @RequestMapping(method= RequestMethod.POST , value="/pfteams/{pfteam_id}/emequips/{emequip_id}/emeqahs/searchindexder")
	public ResponseEntity<Page<EMEQAHDTO>> searchEMEQAHIndexDERByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMEQAHSearchContext context) {
        context.setN_equipid_eq(emequip_id);
        Page<EMEQAH> domains = emeqahService.searchIndexDER(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emeqahMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}


    /**
     * 用户权限校验
     * @return
     */
	public EMEQAH getEntity(){
        return new EMEQAH();
    }

}
