package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;

import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;

import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;

import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.eam_core.domain.EMAssess;
import cn.ibizlab.eam.core.eam_core.service.IEMAssessService;
import cn.ibizlab.eam.core.eam_core.filter.EMAssessSearchContext;




@Slf4j
@Api(tags = {"EMAssess" })
@RestController("WebApi-emassess")
@RequestMapping("")
public class EMAssessResource {

    @Autowired
    private IEMAssessService emassessService;

    @Autowired
    @Lazy
    private EMAssessMapping emassessMapping;




    @PreAuthorize("hasPermission(#emassess_id,'Get',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Get", tags = {"EMAssess" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/emassesses/{emassess_id}")
    public ResponseEntity<EMAssessDTO> get(@PathVariable("emassess_id") String emassess_id) {
        EMAssess domain = emassessService.get(emassess_id);
        EMAssessDTO dto = emassessMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }




    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Create", tags = {"EMAssess" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/emassesses")
    @Transactional
    public ResponseEntity<EMAssessDTO> create(@RequestBody EMAssessDTO emassessdto) {
        EMAssess domain = emassessMapping.toDomain(emassessdto);
		emassessService.create(domain);
        EMAssessDTO dto = emassessMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }
    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "createBatch", tags = {"EMAssess" },  notes = "createBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emassesses/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<EMAssessDTO> emassessdtos) {
        emassessService.createBatch(emassessMapping.toDomain(emassessdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission(#emassess_id,'Remove',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Remove", tags = {"EMAssess" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emassesses/{emassess_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("emassess_id") String emassess_id) {
         return ResponseEntity.status(HttpStatus.OK).body(emassessService.remove(emassess_id));
    }

    @ApiOperation(value = "RemoveBatch", tags = {"EMAssess" },  notes = "RemoveBatch")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emassesses/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        emassessService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @ApiOperation(value = "Save", tags = {"EMAssess" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/emassesses/save")
    public ResponseEntity<Boolean> save(@RequestBody EMAssessDTO emassessdto) {
        return ResponseEntity.status(HttpStatus.OK).body(emassessService.save(emassessMapping.toDomain(emassessdto)));
    }

    @ApiOperation(value = "SaveBatch", tags = {"EMAssess" },  notes = "SaveBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/emassesses/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<EMAssessDTO> emassessdtos) {
        emassessService.saveBatch(emassessMapping.toDomain(emassessdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @ApiOperation(value = "GetDraft", tags = {"EMAssess" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/emassesses/getdraft")
    public ResponseEntity<EMAssessDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(emassessMapping.toDto(emassessService.getDraft(new EMAssess())));
    }




    @PreAuthorize("hasPermission(#emassess_id,'Update',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Update", tags = {"EMAssess" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/emassesses/{emassess_id}")
    @Transactional
    public ResponseEntity<EMAssessDTO> update(@PathVariable("emassess_id") String emassess_id, @RequestBody EMAssessDTO emassessdto) {
		EMAssess domain = emassessMapping.toDomain(emassessdto);
        domain.setEmassessid(emassess_id);
		emassessService.update(domain);
		EMAssessDTO dto = emassessMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(#emassess_id,'Update',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "UpdateBatch", tags = {"EMAssess" },  notes = "UpdateBatch")
	@RequestMapping(method = RequestMethod.PUT, value = "/emassesses/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<EMAssessDTO> emassessdtos) {
        emassessService.updateBatch(emassessMapping.toDomain(emassessdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @ApiOperation(value = "CheckKey", tags = {"EMAssess" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/emassesses/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody EMAssessDTO emassessdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emassessService.checkKey(emassessMapping.toDomain(emassessdto)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMAssess-Default-all')")
	@ApiOperation(value = "fetchDEFAULT", tags = {"EMAssess" } ,notes = "fetchDEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emassesses/fetchdefault")
	public ResponseEntity<List<EMAssessDTO>> fetchDefault(EMAssessSearchContext context) {
        Page<EMAssess> domains = emassessService.searchDefault(context) ;
        List<EMAssessDTO> list = emassessMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMAssess-Default-all')")
	@ApiOperation(value = "searchDEFAULT", tags = {"EMAssess" } ,notes = "searchDEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emassesses/searchdefault")
	public ResponseEntity<Page<EMAssessDTO>> searchDefault(@RequestBody EMAssessSearchContext context) {
        Page<EMAssess> domains = emassessService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emassessMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}


    /**
     * 用户权限校验
     * @return
     */
	public EMAssess getEntity(){
        return new EMAssess();
    }

}
