package cn.ibizlab.eam.webapi.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.alibaba.fastjson.annotation.JSONField;
import cn.ibizlab.eam.util.domain.DTOBase;
import lombok.Data;

/**
 * 服务DTO对象[EMSubListDTO]
 */
@Data
public class EMSubListDTO extends DTOBase implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 属性 [EMSUBLISTID]
     *
     */
    @JSONField(name = "emsublistid")
    @JsonProperty("emsublistid")
    private String emsublistid;

    /**
     * 属性 [TIME]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "time" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("time")
    private Timestamp time;

    /**
     * 属性 [VERSION]
     *
     */
    @JSONField(name = "version")
    @JsonProperty("version")
    private String version;

    /**
     * 属性 [ENABLE]
     *
     */
    @JSONField(name = "enable")
    @JsonProperty("enable")
    private Integer enable;

    /**
     * 属性 [EMSUBLISTNAME]
     *
     */
    @JSONField(name = "emsublistname")
    @JsonProperty("emsublistname")
    private String emsublistname;

    /**
     * 属性 [PRELIMINARY]
     *
     */
    @JSONField(name = "preliminary")
    @JsonProperty("preliminary")
    private String preliminary;

    /**
     * 属性 [CREATEDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "createdate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("createdate")
    private Timestamp createdate;

    /**
     * 属性 [REMARKS]
     *
     */
    @JSONField(name = "remarks")
    @JsonProperty("remarks")
    private String remarks;

    /**
     * 属性 [UPDATEDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "updatedate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("updatedate")
    private Timestamp updatedate;

    /**
     * 属性 [APPLICATION]
     *
     */
    @JSONField(name = "application")
    @JsonProperty("application")
    private String application;

    /**
     * 属性 [CREATEMAN]
     *
     */
    @JSONField(name = "createman")
    @JsonProperty("createman")
    private String createman;

    /**
     * 属性 [UPDATEMAN]
     *
     */
    @JSONField(name = "updateman")
    @JsonProperty("updateman")
    private String updateman;

    /**
     * 属性 [PFTEAMNAME]
     *
     */
    @JSONField(name = "pfteamname")
    @JsonProperty("pfteamname")
    private String pfteamname;

    /**
     * 属性 [PFTEAMID]
     *
     */
    @JSONField(name = "pfteamid")
    @JsonProperty("pfteamid")
    private String pfteamid;


    /**
     * 设置 [TIME]
     */
    public void setTime(Timestamp  time){
        this.time = time ;
        this.modify("time",time);
    }

    /**
     * 设置 [VERSION]
     */
    public void setVersion(String  version){
        this.version = version ;
        this.modify("version",version);
    }

    /**
     * 设置 [EMSUBLISTNAME]
     */
    public void setEmsublistname(String  emsublistname){
        this.emsublistname = emsublistname ;
        this.modify("emsublistname",emsublistname);
    }

    /**
     * 设置 [PRELIMINARY]
     */
    public void setPreliminary(String  preliminary){
        this.preliminary = preliminary ;
        this.modify("preliminary",preliminary);
    }

    /**
     * 设置 [REMARKS]
     */
    public void setRemarks(String  remarks){
        this.remarks = remarks ;
        this.modify("remarks",remarks);
    }

    /**
     * 设置 [APPLICATION]
     */
    public void setApplication(String  application){
        this.application = application ;
        this.modify("application",application);
    }

    /**
     * 设置 [PFTEAMID]
     */
    public void setPfteamid(String  pfteamid){
        this.pfteamid = pfteamid ;
        this.modify("pfteamid",pfteamid);
    }


}

