/**
 * Main2 部件模型
 *
 * @export
 * @class Main2Model
 */
export default class Main2Model {

	/**
	 * 是否是实体数据导出
	 *
	 * @returns {any[]}
	 * @memberof Main2GridMode
	 */
	public isDEExport: boolean = false;

	/**
	 * 获取数据项集合
	 *
	 * @returns {any[]}
	 * @memberof Main2GridMode
	 */
	public getDataItems(): any[] {
    if(this.isDEExport){
		  return [
      ]
    }else{
		  return [
        {
          name: 'acclassid',
          prop: 'acclassid',
          dataType: 'PICKUP',
        },
        {
          name: 'mdate',
          prop: 'mdate',
          dataType: 'DATETIME',
        },
        {
          name: 'rteamname',
          prop: 'rteamname',
          dataType: 'PICKUPTEXT',
        },
        {
          name: 'eqstoplength',
          prop: 'eqstoplength',
          dataType: 'FLOAT',
        },
        {
          name: 'srfmajortext',
          prop: 'emplantemplname',
          dataType: 'TEXT',
        },
        {
          name: 'emplantemplid',
          prop: 'emplantemplid',
          dataType: 'GUID',
        },
        {
          name: 'srfkey',
          prop: 'emplantemplid',
          dataType: 'GUID',
        },
        {
          name: 'srfdataaccaction',
          prop: 'emplantemplid',
          dataType: 'GUID',
        },
        {
          name: 'mpersonid',
          prop: 'mpersonid',
          dataType: 'PICKUP',
        },
        {
          name: 'plandesc',
          prop: 'plandesc',
          dataType: 'LONGTEXT_1000',
        },
        {
          name: 'activelengths',
          prop: 'activelengths',
          dataType: 'FLOAT',
        },
        {
          name: 'rdeptname',
          prop: 'rdeptname',
          dataType: 'PICKUPTEXT',
        },
        {
          name: 'rempid',
          prop: 'rempid',
          dataType: 'PICKUP',
        },
        {
          name: 'rempname',
          prop: 'rempname',
          dataType: 'PICKUPTEXT',
        },
        {
          name: 'mpersonname',
          prop: 'mpersonname',
          dataType: 'PICKUPTEXT',
        },
        {
          name: 'recvpersonname',
          prop: 'recvpersonname',
          dataType: 'PICKUPTEXT',
        },
        {
          name: 'rteamid',
          prop: 'rteamid',
          dataType: 'PICKUP',
        },
        {
          name: 'planstate',
          prop: 'planstate',
          dataType: 'NSCODELIST',
        },
        {
          name: 'plantype',
          prop: 'plantype',
          dataType: 'SSCODELIST',
        },
        {
          name: 'rservicename',
          prop: 'rservicename',
          dataType: 'PICKUPTEXT',
        },
        {
          name: 'rserviceid',
          prop: 'rserviceid',
          dataType: 'PICKUP',
        },
        {
          name: 'rdeptid',
          prop: 'rdeptid',
          dataType: 'PICKUP',
        },
        {
          name: 'emplantemplname',
          prop: 'emplantemplname',
          dataType: 'TEXT',
        },
        {
          name: 'prefee',
          prop: 'prefee',
          dataType: 'CURRENCY',
        },
        {
          name: 'mtflag',
          prop: 'mtflag',
          dataType: 'YESNO',
        },
        {
          name: 'recvpersonid',
          prop: 'recvpersonid',
          dataType: 'PICKUP',
        },
        {
          name: 'archive',
          prop: 'archive',
          dataType: 'SMCODELIST',
        },
        {
          name: 'emplantempl',
          prop: 'emplantemplid',
        },

        {
          name:'size',
          prop:'size'
        },
        {
          name:'query',
          prop:'query'
        },
        {
          name:'page',
          prop:'page'
        },
        {
          name:'sort',
          prop:'sort'
        },
        {
          name:'srfparentdata',
          prop:'srfparentdata'
        },
        // 前端新增修改标识，新增为"0",修改为"1"或未设值
        {
          name: 'srffrontuf',
          prop: 'srffrontuf',
          dataType: 'TEXT',
        },
      ]
    }
  }

}