/**
 * Main2 部件模型
 *
 * @export
 * @class Main2Model
 */
export default class Main2Model {

	/**
	 * 是否是实体数据导出
	 *
	 * @returns {any[]}
	 * @memberof Main2GridMode
	 */
	public isDEExport: boolean = false;

	/**
	 * 获取数据项集合
	 *
	 * @returns {any[]}
	 * @memberof Main2GridMode
	 */
	public getDataItems(): any[] {
    if(this.isDEExport){
		  return [
      ]
    }else{
		  return [
        {
          name: 'eqmodelcode',
          prop: 'eqmodelcode',
          dataType: 'TEXT',
        },
        {
          name: 'emeqlocationid',
          prop: 'emeqlocationid',
          dataType: 'PICKUP',
        },
        {
          name: 'equipname',
          prop: 'equipname',
          dataType: 'PICKUPTEXT',
        },
        {
          name: 'haveinner',
          prop: 'haveinner',
          dataType: 'YESNO',
        },
        {
          name: 'labserviceid',
          prop: 'labserviceid',
          dataType: 'PICKUP',
        },
        {
          name: 'tiresstate',
          prop: 'tiresstate',
          dataType: 'SSCODELIST',
        },
        {
          name: 'equipid',
          prop: 'equipid',
          dataType: 'PICKUP',
        },
        {
          name: 'changp',
          prop: 'changp',
          dataType: 'TEXT',
        },
        {
          name: 'srfmajortext',
          prop: 'eqlocationinfo',
          dataType: 'PICKUPTEXT',
        },
        {
          name: 'srfdataaccaction',
          prop: 'emeqlocationid',
          dataType: 'PICKUP',
        },
        {
          name: 'srfkey',
          prop: 'emeqlocationid',
          dataType: 'PICKUP',
        },
        {
          name: 'mccode',
          prop: 'mccode',
          dataType: 'TEXT',
        },
        {
          name: 'par',
          prop: 'par',
          dataType: 'TEXT',
        },
        {
          name: 'amount',
          prop: 'amount',
          dataType: 'CURRENCY',
        },
        {
          name: 'mserviceid',
          prop: 'mserviceid',
          dataType: 'PICKUP',
        },
        {
          name: 'lcttiresinfo',
          prop: 'lcttiresinfo',
          dataType: 'TEXT',
        },
        {
          name: 'systemparam',
          prop: 'systemparam',
          dataType: 'TEXT',
        },
        {
          name: 'replacedate',
          prop: 'replacedate',
          dataType: 'DATETIME',
        },
        {
          name: 'replacereason',
          prop: 'replacereason',
          dataType: 'TEXT',
        },
        {
          name: 'newoldflag',
          prop: 'newoldflag',
          dataType: 'SSCODELIST',
        },
        {
          name: 'mservicename',
          prop: 'mservicename',
          dataType: 'PICKUPTEXT',
        },
        {
          name: 'labservicename',
          prop: 'labservicename',
          dataType: 'PICKUPTEXT',
        },
        {
          name: 'emeqlcttires',
          prop: 'emeqlocationid',
        },

        {
          name:'size',
          prop:'size'
        },
        {
          name:'query',
          prop:'query'
        },
        {
          name:'page',
          prop:'page'
        },
        {
          name:'sort',
          prop:'sort'
        },
        {
          name:'srfparentdata',
          prop:'srfparentdata'
        },
        // 前端新增修改标识，新增为"0",修改为"1"或未设值
        {
          name: 'srffrontuf',
          prop: 'srffrontuf',
          dataType: 'TEXT',
        },
      ]
    }
  }

}