package cn.ibizlab.eam.webapi.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.alibaba.fastjson.annotation.JSONField;
import cn.ibizlab.eam.util.domain.DTOBase;
import lombok.Data;

/**
 * 服务DTO对象[EMItemSubMapDTO]
 */
@Data
public class EMItemSubMapDTO extends DTOBase implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 属性 [EMITEMSUBMAPID]
     *
     */
    @JSONField(name = "emitemsubmapid")
    @JsonProperty("emitemsubmapid")
    private String emitemsubmapid;

    /**
     * 属性 [EMITEMSUBMAPNAME]
     *
     */
    @JSONField(name = "emitemsubmapname")
    @JsonProperty("emitemsubmapname")
    private String emitemsubmapname;

    /**
     * 属性 [UPDATEDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "updatedate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("updatedate")
    private Timestamp updatedate;

    /**
     * 属性 [CREATEMAN]
     *
     */
    @JSONField(name = "createman")
    @JsonProperty("createman")
    private String createman;

    /**
     * 属性 [SUBCOEFF]
     *
     */
    @JSONField(name = "subcoeff")
    @JsonProperty("subcoeff")
    private Double subcoeff;

    /**
     * 属性 [EXCFLAG]
     *
     */
    @JSONField(name = "excflag")
    @JsonProperty("excflag")
    private Integer excflag;

    /**
     * 属性 [ORGID]
     *
     */
    @JSONField(name = "orgid")
    @JsonProperty("orgid")
    private String orgid;

    /**
     * 属性 [CREATEDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "createdate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("createdate")
    private Timestamp createdate;

    /**
     * 属性 [ENABLE]
     *
     */
    @JSONField(name = "enable")
    @JsonProperty("enable")
    private Integer enable;

    /**
     * 属性 [DESCRIPTION]
     *
     */
    @JSONField(name = "description")
    @JsonProperty("description")
    private String description;

    /**
     * 属性 [UPDATEMAN]
     *
     */
    @JSONField(name = "updateman")
    @JsonProperty("updateman")
    private String updateman;

    /**
     * 属性 [SUBITEMNAME]
     *
     */
    @JSONField(name = "subitemname")
    @JsonProperty("subitemname")
    private String subitemname;

    /**
     * 属性 [ITEMNAME]
     *
     */
    @JSONField(name = "itemname")
    @JsonProperty("itemname")
    private String itemname;

    /**
     * 属性 [ITEMID]
     *
     */
    @JSONField(name = "itemid")
    @JsonProperty("itemid")
    private String itemid;

    /**
     * 属性 [SUBITEMID]
     *
     */
    @JSONField(name = "subitemid")
    @JsonProperty("subitemid")
    private String subitemid;


    /**
     * 设置 [EMITEMSUBMAPNAME]
     */
    public void setEmitemsubmapname(String  emitemsubmapname){
        this.emitemsubmapname = emitemsubmapname ;
        this.modify("emitemsubmapname",emitemsubmapname);
    }

    /**
     * 设置 [SUBCOEFF]
     */
    public void setSubcoeff(Double  subcoeff){
        this.subcoeff = subcoeff ;
        this.modify("subcoeff",subcoeff);
    }

    /**
     * 设置 [EXCFLAG]
     */
    public void setExcflag(Integer  excflag){
        this.excflag = excflag ;
        this.modify("excflag",excflag);
    }

    /**
     * 设置 [DESCRIPTION]
     */
    public void setDescription(String  description){
        this.description = description ;
        this.modify("description",description);
    }

    /**
     * 设置 [ITEMID]
     */
    public void setItemid(String  itemid){
        this.itemid = itemid ;
        this.modify("itemid",itemid);
    }

    /**
     * 设置 [SUBITEMID]
     */
    public void setSubitemid(String  subitemid){
        this.subitemid = subitemid ;
        this.modify("subitemid",subitemid);
    }


}

