package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.access.prepost.PostAuthorize;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.eam_core.domain.EMItemRIn;
import cn.ibizlab.eam.core.eam_core.service.IEMItemRInService;
import cn.ibizlab.eam.core.eam_core.filter.EMItemRInSearchContext;

@Slf4j
@Api(tags = {"入库单" })
@RestController("WebApi-emitemrin")
@RequestMapping("")
public class EMItemRInResource {

    @Autowired
    public IEMItemRInService emitemrinService;

    @Autowired
    @Lazy
    public EMItemRInMapping emitemrinMapping;

    @ApiOperation(value = "检查入库单", tags = {"入库单" },  notes = "检查入库单")
	@RequestMapping(method = RequestMethod.POST, value = "/emitemrins/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody EMItemRInDTO emitemrindto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emitemrinService.checkKey(emitemrinMapping.toDomain(emitemrindto)));
    }

    @ApiOperation(value = "获取入库单草稿", tags = {"入库单" },  notes = "获取入库单草稿")
	@RequestMapping(method = RequestMethod.GET, value = "/emitemrins/getdraft")
    public ResponseEntity<EMItemRInDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(emitemrinMapping.toDto(emitemrinService.getDraft(new EMItemRIn())));
    }

    @PreAuthorize("hasPermission(this.emitemrinMapping.toDomain(#emitemrindto),'eam_practice01-EMItemRIn-Create')")
    @ApiOperation(value = "新建入库单", tags = {"入库单" },  notes = "新建入库单")
	@RequestMapping(method = RequestMethod.POST, value = "/emitemrins")
    @Transactional
    public ResponseEntity<EMItemRInDTO> create(@RequestBody EMItemRInDTO emitemrindto) {
        EMItemRIn domain = emitemrinMapping.toDomain(emitemrindto);
		emitemrinService.create(domain);
        EMItemRInDTO dto = emitemrinMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.emitemrinMapping.toDomain(#emitemrindtos),'eam_practice01-EMItemRIn-Create')")
    @ApiOperation(value = "批量新建入库单", tags = {"入库单" },  notes = "批量新建入库单")
	@RequestMapping(method = RequestMethod.POST, value = "/emitemrins/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<EMItemRInDTO> emitemrindtos) {
        emitemrinService.createBatch(emitemrinMapping.toDomain(emitemrindtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(this.emitemrinService.get(#emitemrin_id),'eam_practice01-EMItemRIn-Update')")
    @ApiOperation(value = "更新入库单", tags = {"入库单" },  notes = "更新入库单")
	@RequestMapping(method = RequestMethod.PUT, value = "/emitemrins/{emitemrin_id}")
    @Transactional
    public ResponseEntity<EMItemRInDTO> update(@PathVariable("emitemrin_id") String emitemrin_id, @RequestBody EMItemRInDTO emitemrindto) {
		EMItemRIn domain  = emitemrinMapping.toDomain(emitemrindto);
        domain .setEmitemrinid(emitemrin_id);
		emitemrinService.update(domain );
		EMItemRInDTO dto = emitemrinMapping.toDto(domain );
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.emitemrinService.getEmitemrinByEntities(this.emitemrinMapping.toDomain(#emitemrindtos)),'eam_practice01-EMItemRIn-Update')")
    @ApiOperation(value = "批量更新入库单", tags = {"入库单" },  notes = "批量更新入库单")
	@RequestMapping(method = RequestMethod.PUT, value = "/emitemrins/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<EMItemRInDTO> emitemrindtos) {
        emitemrinService.updateBatch(emitemrinMapping.toDomain(emitemrindtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(this.emitemrinMapping.toDomain(#emitemrindto),'eam_practice01-EMItemRIn-Save')")
    @ApiOperation(value = "保存入库单", tags = {"入库单" },  notes = "保存入库单")
	@RequestMapping(method = RequestMethod.POST, value = "/emitemrins/save")
    public ResponseEntity<Boolean> save(@RequestBody EMItemRInDTO emitemrindto) {
        return ResponseEntity.status(HttpStatus.OK).body(emitemrinService.save(emitemrinMapping.toDomain(emitemrindto)));
    }

    @PreAuthorize("hasPermission(this.emitemrinMapping.toDomain(#emitemrindtos),'eam_practice01-EMItemRIn-Save')")
    @ApiOperation(value = "批量保存入库单", tags = {"入库单" },  notes = "批量保存入库单")
	@RequestMapping(method = RequestMethod.POST, value = "/emitemrins/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<EMItemRInDTO> emitemrindtos) {
        emitemrinService.saveBatch(emitemrinMapping.toDomain(emitemrindtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PostAuthorize("hasPermission(this.emitemrinMapping.toDomain(returnObject.body),'eam_practice01-EMItemRIn-Get')")
    @ApiOperation(value = "获取入库单", tags = {"入库单" },  notes = "获取入库单")
	@RequestMapping(method = RequestMethod.GET, value = "/emitemrins/{emitemrin_id}")
    public ResponseEntity<EMItemRInDTO> get(@PathVariable("emitemrin_id") String emitemrin_id) {
        EMItemRIn domain = emitemrinService.get(emitemrin_id);
        EMItemRInDTO dto = emitemrinMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.emitemrinService.get(#emitemrin_id),'eam_practice01-EMItemRIn-Remove')")
    @ApiOperation(value = "删除入库单", tags = {"入库单" },  notes = "删除入库单")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emitemrins/{emitemrin_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("emitemrin_id") String emitemrin_id) {
         return ResponseEntity.status(HttpStatus.OK).body(emitemrinService.remove(emitemrin_id));
    }

    @PreAuthorize("hasPermission(this.emitemrinService.getEmitemrinByIds(#ids),'eam_practice01-EMItemRIn-Remove')")
    @ApiOperation(value = "批量删除入库单", tags = {"入库单" },  notes = "批量删除入库单")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emitemrins/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        emitemrinService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMItemRIn-Default-all')")
	@ApiOperation(value = "获取DEFAULT", tags = {"入库单" } ,notes = "获取DEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emitemrins/fetchdefault")
	public ResponseEntity<List<EMItemRInDTO>> fetchDefault(EMItemRInSearchContext context) {
        Page<EMItemRIn> domains = emitemrinService.searchDefault(context) ;
        List<EMItemRInDTO> list = emitemrinMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMItemRIn-Default-all')")
	@ApiOperation(value = "查询DEFAULT", tags = {"入库单" } ,notes = "查询DEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emitemrins/searchdefault")
	public ResponseEntity<Page<EMItemRInDTO>> searchDefault(@RequestBody EMItemRInSearchContext context) {
        Page<EMItemRIn> domains = emitemrinService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emitemrinMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @ApiOperation(value = "根据物品检查入库单", tags = {"入库单" },  notes = "根据物品检查入库单")
	@RequestMapping(method = RequestMethod.POST, value = "/emitems/{emitem_id}/emitemrins/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMItem(@PathVariable("emitem_id") String emitem_id, @RequestBody EMItemRInDTO emitemrindto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emitemrinService.checkKey(emitemrinMapping.toDomain(emitemrindto)));
    }

    @ApiOperation(value = "根据物品获取入库单草稿", tags = {"入库单" },  notes = "根据物品获取入库单草稿")
    @RequestMapping(method = RequestMethod.GET, value = "/emitems/{emitem_id}/emitemrins/getdraft")
    public ResponseEntity<EMItemRInDTO> getDraftByEMItem(@PathVariable("emitem_id") String emitem_id) {
        EMItemRIn domain = new EMItemRIn();
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emitemrinMapping.toDto(emitemrinService.getDraft(domain)));
    }

    @PreAuthorize("hasPermission(this.emitemrinMapping.toDomain(#emitemrindto),'eam_practice01-EMItemRIn-Create')")
    @ApiOperation(value = "根据物品建立入库单", tags = {"入库单" },  notes = "根据物品建立入库单")
	@RequestMapping(method = RequestMethod.POST, value = "/emitems/{emitem_id}/emitemrins")
    @Transactional
    public ResponseEntity<EMItemRInDTO> createByEMItem(@PathVariable("emitem_id") String emitem_id, @RequestBody EMItemRInDTO emitemrindto) {
        EMItemRIn domain = emitemrinMapping.toDomain(emitemrindto);
        domain.setItemid(emitem_id);
		emitemrinService.create(domain);
        EMItemRInDTO dto = emitemrinMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.emitemrinMapping.toDomain(#emitemrindtos),'eam_practice01-EMItemRIn-Create')")
    @ApiOperation(value = "根据物品批量建立入库单", tags = {"入库单" },  notes = "根据物品批量建立入库单")
	@RequestMapping(method = RequestMethod.POST, value = "/emitems/{emitem_id}/emitemrins/batch")
    public ResponseEntity<Boolean> createBatchByEMItem(@PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemRInDTO> emitemrindtos) {
        List<EMItemRIn> domainlist=emitemrinMapping.toDomain(emitemrindtos);
        for(EMItemRIn domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emitemrinService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(this.emitemrinService.get(#emitemrin_id),'eam_practice01-EMItemRIn-Update')")
    @ApiOperation(value = "根据物品更新入库单", tags = {"入库单" },  notes = "根据物品更新入库单")
	@RequestMapping(method = RequestMethod.PUT, value = "/emitems/{emitem_id}/emitemrins/{emitemrin_id}")
    @Transactional
    public ResponseEntity<EMItemRInDTO> updateByEMItem(@PathVariable("emitem_id") String emitem_id, @PathVariable("emitemrin_id") String emitemrin_id, @RequestBody EMItemRInDTO emitemrindto) {
        EMItemRIn domain = emitemrinMapping.toDomain(emitemrindto);
        domain.setItemid(emitem_id);
        domain.setEmitemrinid(emitemrin_id);
		emitemrinService.update(domain);
        EMItemRInDTO dto = emitemrinMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.emitemrinService.getEmitemrinByEntities(this.emitemrinMapping.toDomain(#emitemrindtos)),'eam_practice01-EMItemRIn-Update')")
    @ApiOperation(value = "根据物品批量更新入库单", tags = {"入库单" },  notes = "根据物品批量更新入库单")
	@RequestMapping(method = RequestMethod.PUT, value = "/emitems/{emitem_id}/emitemrins/batch")
    public ResponseEntity<Boolean> updateBatchByEMItem(@PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemRInDTO> emitemrindtos) {
        List<EMItemRIn> domainlist=emitemrinMapping.toDomain(emitemrindtos);
        for(EMItemRIn domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emitemrinService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(this.emitemrinMapping.toDomain(#emitemrindto),'eam_practice01-EMItemRIn-Save')")
    @ApiOperation(value = "根据物品保存入库单", tags = {"入库单" },  notes = "根据物品保存入库单")
	@RequestMapping(method = RequestMethod.POST, value = "/emitems/{emitem_id}/emitemrins/save")
    public ResponseEntity<Boolean> saveByEMItem(@PathVariable("emitem_id") String emitem_id, @RequestBody EMItemRInDTO emitemrindto) {
        EMItemRIn domain = emitemrinMapping.toDomain(emitemrindto);
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emitemrinService.save(domain));
    }

    @PreAuthorize("hasPermission(this.emitemrinMapping.toDomain(#emitemrindtos),'eam_practice01-EMItemRIn-Save')")
    @ApiOperation(value = "根据物品批量保存入库单", tags = {"入库单" },  notes = "根据物品批量保存入库单")
	@RequestMapping(method = RequestMethod.POST, value = "/emitems/{emitem_id}/emitemrins/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMItem(@PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemRInDTO> emitemrindtos) {
        List<EMItemRIn> domainlist=emitemrinMapping.toDomain(emitemrindtos);
        for(EMItemRIn domain:domainlist){
             domain.setItemid(emitem_id);
        }
        emitemrinService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PostAuthorize("hasPermission(this.emitemrinMapping.toDomain(returnObject.body),'eam_practice01-EMItemRIn-Get')")
    @ApiOperation(value = "根据物品获取入库单", tags = {"入库单" },  notes = "根据物品获取入库单")
	@RequestMapping(method = RequestMethod.GET, value = "/emitems/{emitem_id}/emitemrins/{emitemrin_id}")
    public ResponseEntity<EMItemRInDTO> getByEMItem(@PathVariable("emitem_id") String emitem_id, @PathVariable("emitemrin_id") String emitemrin_id) {
        EMItemRIn domain = emitemrinService.get(emitemrin_id);
        EMItemRInDTO dto = emitemrinMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.emitemrinService.get(#emitemrin_id),'eam_practice01-EMItemRIn-Remove')")
    @ApiOperation(value = "根据物品删除入库单", tags = {"入库单" },  notes = "根据物品删除入库单")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emitems/{emitem_id}/emitemrins/{emitemrin_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMItem(@PathVariable("emitem_id") String emitem_id, @PathVariable("emitemrin_id") String emitemrin_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emitemrinService.remove(emitemrin_id));
    }

    @PreAuthorize("hasPermission(this.emitemrinService.getEmitemrinByIds(#ids),'eam_practice01-EMItemRIn-Remove')")
    @ApiOperation(value = "根据物品批量删除入库单", tags = {"入库单" },  notes = "根据物品批量删除入库单")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emitems/{emitem_id}/emitemrins/batch")
    public ResponseEntity<Boolean> removeBatchByEMItem(@RequestBody List<String> ids) {
        emitemrinService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMItemRIn-Default-all')")
	@ApiOperation(value = "根据物品获取DEFAULT", tags = {"入库单" } ,notes = "根据物品获取DEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emitems/{emitem_id}/emitemrins/fetchdefault")
	public ResponseEntity<List<EMItemRInDTO>> fetchEMItemRInDefaultByEMItem(@PathVariable("emitem_id") String emitem_id,EMItemRInSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMItemRIn> domains = emitemrinService.searchDefault(context) ;
        List<EMItemRInDTO> list = emitemrinMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMItemRIn-Default-all')")
	@ApiOperation(value = "根据物品查询DEFAULT", tags = {"入库单" } ,notes = "根据物品查询DEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emitems/{emitem_id}/emitemrins/searchdefault")
	public ResponseEntity<Page<EMItemRInDTO>> searchEMItemRInDefaultByEMItem(@PathVariable("emitem_id") String emitem_id, @RequestBody EMItemRInSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMItemRIn> domains = emitemrinService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emitemrinMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @ApiOperation(value = "根据服务商物品检查入库单", tags = {"入库单" },  notes = "根据服务商物品检查入库单")
	@RequestMapping(method = RequestMethod.POST, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emitemrins/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemRInDTO emitemrindto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emitemrinService.checkKey(emitemrinMapping.toDomain(emitemrindto)));
    }

    @ApiOperation(value = "根据服务商物品获取入库单草稿", tags = {"入库单" },  notes = "根据服务商物品获取入库单草稿")
    @RequestMapping(method = RequestMethod.GET, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emitemrins/getdraft")
    public ResponseEntity<EMItemRInDTO> getDraftByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id) {
        EMItemRIn domain = new EMItemRIn();
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emitemrinMapping.toDto(emitemrinService.getDraft(domain)));
    }

    @PreAuthorize("hasPermission(this.emitemrinMapping.toDomain(#emitemrindto),'eam_practice01-EMItemRIn-Create')")
    @ApiOperation(value = "根据服务商物品建立入库单", tags = {"入库单" },  notes = "根据服务商物品建立入库单")
	@RequestMapping(method = RequestMethod.POST, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emitemrins")
    @Transactional
    public ResponseEntity<EMItemRInDTO> createByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemRInDTO emitemrindto) {
        EMItemRIn domain = emitemrinMapping.toDomain(emitemrindto);
        domain.setItemid(emitem_id);
		emitemrinService.create(domain);
        EMItemRInDTO dto = emitemrinMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.emitemrinMapping.toDomain(#emitemrindtos),'eam_practice01-EMItemRIn-Create')")
    @ApiOperation(value = "根据服务商物品批量建立入库单", tags = {"入库单" },  notes = "根据服务商物品批量建立入库单")
	@RequestMapping(method = RequestMethod.POST, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emitemrins/batch")
    public ResponseEntity<Boolean> createBatchByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemRInDTO> emitemrindtos) {
        List<EMItemRIn> domainlist=emitemrinMapping.toDomain(emitemrindtos);
        for(EMItemRIn domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emitemrinService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(this.emitemrinService.get(#emitemrin_id),'eam_practice01-EMItemRIn-Update')")
    @ApiOperation(value = "根据服务商物品更新入库单", tags = {"入库单" },  notes = "根据服务商物品更新入库单")
	@RequestMapping(method = RequestMethod.PUT, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emitemrins/{emitemrin_id}")
    @Transactional
    public ResponseEntity<EMItemRInDTO> updateByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emitemrin_id") String emitemrin_id, @RequestBody EMItemRInDTO emitemrindto) {
        EMItemRIn domain = emitemrinMapping.toDomain(emitemrindto);
        domain.setItemid(emitem_id);
        domain.setEmitemrinid(emitemrin_id);
		emitemrinService.update(domain);
        EMItemRInDTO dto = emitemrinMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.emitemrinService.getEmitemrinByEntities(this.emitemrinMapping.toDomain(#emitemrindtos)),'eam_practice01-EMItemRIn-Update')")
    @ApiOperation(value = "根据服务商物品批量更新入库单", tags = {"入库单" },  notes = "根据服务商物品批量更新入库单")
	@RequestMapping(method = RequestMethod.PUT, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emitemrins/batch")
    public ResponseEntity<Boolean> updateBatchByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemRInDTO> emitemrindtos) {
        List<EMItemRIn> domainlist=emitemrinMapping.toDomain(emitemrindtos);
        for(EMItemRIn domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emitemrinService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(this.emitemrinMapping.toDomain(#emitemrindto),'eam_practice01-EMItemRIn-Save')")
    @ApiOperation(value = "根据服务商物品保存入库单", tags = {"入库单" },  notes = "根据服务商物品保存入库单")
	@RequestMapping(method = RequestMethod.POST, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emitemrins/save")
    public ResponseEntity<Boolean> saveByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemRInDTO emitemrindto) {
        EMItemRIn domain = emitemrinMapping.toDomain(emitemrindto);
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emitemrinService.save(domain));
    }

    @PreAuthorize("hasPermission(this.emitemrinMapping.toDomain(#emitemrindtos),'eam_practice01-EMItemRIn-Save')")
    @ApiOperation(value = "根据服务商物品批量保存入库单", tags = {"入库单" },  notes = "根据服务商物品批量保存入库单")
	@RequestMapping(method = RequestMethod.POST, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emitemrins/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemRInDTO> emitemrindtos) {
        List<EMItemRIn> domainlist=emitemrinMapping.toDomain(emitemrindtos);
        for(EMItemRIn domain:domainlist){
             domain.setItemid(emitem_id);
        }
        emitemrinService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PostAuthorize("hasPermission(this.emitemrinMapping.toDomain(returnObject.body),'eam_practice01-EMItemRIn-Get')")
    @ApiOperation(value = "根据服务商物品获取入库单", tags = {"入库单" },  notes = "根据服务商物品获取入库单")
	@RequestMapping(method = RequestMethod.GET, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emitemrins/{emitemrin_id}")
    public ResponseEntity<EMItemRInDTO> getByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emitemrin_id") String emitemrin_id) {
        EMItemRIn domain = emitemrinService.get(emitemrin_id);
        EMItemRInDTO dto = emitemrinMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.emitemrinService.get(#emitemrin_id),'eam_practice01-EMItemRIn-Remove')")
    @ApiOperation(value = "根据服务商物品删除入库单", tags = {"入库单" },  notes = "根据服务商物品删除入库单")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emitemrins/{emitemrin_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emitemrin_id") String emitemrin_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emitemrinService.remove(emitemrin_id));
    }

    @PreAuthorize("hasPermission(this.emitemrinService.getEmitemrinByIds(#ids),'eam_practice01-EMItemRIn-Remove')")
    @ApiOperation(value = "根据服务商物品批量删除入库单", tags = {"入库单" },  notes = "根据服务商物品批量删除入库单")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emservices/{emservice_id}/emitems/{emitem_id}/emitemrins/batch")
    public ResponseEntity<Boolean> removeBatchByEMServiceEMItem(@RequestBody List<String> ids) {
        emitemrinService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMItemRIn-Default-all')")
	@ApiOperation(value = "根据服务商物品获取DEFAULT", tags = {"入库单" } ,notes = "根据服务商物品获取DEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emservices/{emservice_id}/emitems/{emitem_id}/emitemrins/fetchdefault")
	public ResponseEntity<List<EMItemRInDTO>> fetchEMItemRInDefaultByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id,EMItemRInSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMItemRIn> domains = emitemrinService.searchDefault(context) ;
        List<EMItemRInDTO> list = emitemrinMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMItemRIn-Default-all')")
	@ApiOperation(value = "根据服务商物品查询DEFAULT", tags = {"入库单" } ,notes = "根据服务商物品查询DEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emservices/{emservice_id}/emitems/{emitem_id}/emitemrins/searchdefault")
	public ResponseEntity<Page<EMItemRInDTO>> searchEMItemRInDefaultByEMServiceEMItem(@PathVariable("emservice_id") String emservice_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemRInSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMItemRIn> domains = emitemrinService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emitemrinMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @ApiOperation(value = "根据仓库库位物品检查入库单", tags = {"入库单" },  notes = "根据仓库库位物品检查入库单")
	@RequestMapping(method = RequestMethod.POST, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemrins/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemRInDTO emitemrindto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emitemrinService.checkKey(emitemrinMapping.toDomain(emitemrindto)));
    }

    @ApiOperation(value = "根据仓库库位物品获取入库单草稿", tags = {"入库单" },  notes = "根据仓库库位物品获取入库单草稿")
    @RequestMapping(method = RequestMethod.GET, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemrins/getdraft")
    public ResponseEntity<EMItemRInDTO> getDraftByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id) {
        EMItemRIn domain = new EMItemRIn();
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emitemrinMapping.toDto(emitemrinService.getDraft(domain)));
    }

    @PreAuthorize("hasPermission(this.emitemrinMapping.toDomain(#emitemrindto),'eam_practice01-EMItemRIn-Create')")
    @ApiOperation(value = "根据仓库库位物品建立入库单", tags = {"入库单" },  notes = "根据仓库库位物品建立入库单")
	@RequestMapping(method = RequestMethod.POST, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemrins")
    @Transactional
    public ResponseEntity<EMItemRInDTO> createByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemRInDTO emitemrindto) {
        EMItemRIn domain = emitemrinMapping.toDomain(emitemrindto);
        domain.setItemid(emitem_id);
		emitemrinService.create(domain);
        EMItemRInDTO dto = emitemrinMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.emitemrinMapping.toDomain(#emitemrindtos),'eam_practice01-EMItemRIn-Create')")
    @ApiOperation(value = "根据仓库库位物品批量建立入库单", tags = {"入库单" },  notes = "根据仓库库位物品批量建立入库单")
	@RequestMapping(method = RequestMethod.POST, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemrins/batch")
    public ResponseEntity<Boolean> createBatchByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemRInDTO> emitemrindtos) {
        List<EMItemRIn> domainlist=emitemrinMapping.toDomain(emitemrindtos);
        for(EMItemRIn domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emitemrinService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(this.emitemrinService.get(#emitemrin_id),'eam_practice01-EMItemRIn-Update')")
    @ApiOperation(value = "根据仓库库位物品更新入库单", tags = {"入库单" },  notes = "根据仓库库位物品更新入库单")
	@RequestMapping(method = RequestMethod.PUT, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemrins/{emitemrin_id}")
    @Transactional
    public ResponseEntity<EMItemRInDTO> updateByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emitemrin_id") String emitemrin_id, @RequestBody EMItemRInDTO emitemrindto) {
        EMItemRIn domain = emitemrinMapping.toDomain(emitemrindto);
        domain.setItemid(emitem_id);
        domain.setEmitemrinid(emitemrin_id);
		emitemrinService.update(domain);
        EMItemRInDTO dto = emitemrinMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.emitemrinService.getEmitemrinByEntities(this.emitemrinMapping.toDomain(#emitemrindtos)),'eam_practice01-EMItemRIn-Update')")
    @ApiOperation(value = "根据仓库库位物品批量更新入库单", tags = {"入库单" },  notes = "根据仓库库位物品批量更新入库单")
	@RequestMapping(method = RequestMethod.PUT, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemrins/batch")
    public ResponseEntity<Boolean> updateBatchByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemRInDTO> emitemrindtos) {
        List<EMItemRIn> domainlist=emitemrinMapping.toDomain(emitemrindtos);
        for(EMItemRIn domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emitemrinService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(this.emitemrinMapping.toDomain(#emitemrindto),'eam_practice01-EMItemRIn-Save')")
    @ApiOperation(value = "根据仓库库位物品保存入库单", tags = {"入库单" },  notes = "根据仓库库位物品保存入库单")
	@RequestMapping(method = RequestMethod.POST, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemrins/save")
    public ResponseEntity<Boolean> saveByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemRInDTO emitemrindto) {
        EMItemRIn domain = emitemrinMapping.toDomain(emitemrindto);
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emitemrinService.save(domain));
    }

    @PreAuthorize("hasPermission(this.emitemrinMapping.toDomain(#emitemrindtos),'eam_practice01-EMItemRIn-Save')")
    @ApiOperation(value = "根据仓库库位物品批量保存入库单", tags = {"入库单" },  notes = "根据仓库库位物品批量保存入库单")
	@RequestMapping(method = RequestMethod.POST, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemrins/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemRInDTO> emitemrindtos) {
        List<EMItemRIn> domainlist=emitemrinMapping.toDomain(emitemrindtos);
        for(EMItemRIn domain:domainlist){
             domain.setItemid(emitem_id);
        }
        emitemrinService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PostAuthorize("hasPermission(this.emitemrinMapping.toDomain(returnObject.body),'eam_practice01-EMItemRIn-Get')")
    @ApiOperation(value = "根据仓库库位物品获取入库单", tags = {"入库单" },  notes = "根据仓库库位物品获取入库单")
	@RequestMapping(method = RequestMethod.GET, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemrins/{emitemrin_id}")
    public ResponseEntity<EMItemRInDTO> getByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emitemrin_id") String emitemrin_id) {
        EMItemRIn domain = emitemrinService.get(emitemrin_id);
        EMItemRInDTO dto = emitemrinMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.emitemrinService.get(#emitemrin_id),'eam_practice01-EMItemRIn-Remove')")
    @ApiOperation(value = "根据仓库库位物品删除入库单", tags = {"入库单" },  notes = "根据仓库库位物品删除入库单")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemrins/{emitemrin_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emitemrin_id") String emitemrin_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emitemrinService.remove(emitemrin_id));
    }

    @PreAuthorize("hasPermission(this.emitemrinService.getEmitemrinByIds(#ids),'eam_practice01-EMItemRIn-Remove')")
    @ApiOperation(value = "根据仓库库位物品批量删除入库单", tags = {"入库单" },  notes = "根据仓库库位物品批量删除入库单")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemrins/batch")
    public ResponseEntity<Boolean> removeBatchByEMStorePartEMItem(@RequestBody List<String> ids) {
        emitemrinService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMItemRIn-Default-all')")
	@ApiOperation(value = "根据仓库库位物品获取DEFAULT", tags = {"入库单" } ,notes = "根据仓库库位物品获取DEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemrins/fetchdefault")
	public ResponseEntity<List<EMItemRInDTO>> fetchEMItemRInDefaultByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id,EMItemRInSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMItemRIn> domains = emitemrinService.searchDefault(context) ;
        List<EMItemRInDTO> list = emitemrinMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMItemRIn-Default-all')")
	@ApiOperation(value = "根据仓库库位物品查询DEFAULT", tags = {"入库单" } ,notes = "根据仓库库位物品查询DEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemrins/searchdefault")
	public ResponseEntity<Page<EMItemRInDTO>> searchEMItemRInDefaultByEMStorePartEMItem(@PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemRInSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMItemRIn> domains = emitemrinService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emitemrinMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @ApiOperation(value = "根据仓库物品检查入库单", tags = {"入库单" },  notes = "根据仓库物品检查入库单")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emitemrins/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemRInDTO emitemrindto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emitemrinService.checkKey(emitemrinMapping.toDomain(emitemrindto)));
    }

    @ApiOperation(value = "根据仓库物品获取入库单草稿", tags = {"入库单" },  notes = "根据仓库物品获取入库单草稿")
    @RequestMapping(method = RequestMethod.GET, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emitemrins/getdraft")
    public ResponseEntity<EMItemRInDTO> getDraftByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id) {
        EMItemRIn domain = new EMItemRIn();
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emitemrinMapping.toDto(emitemrinService.getDraft(domain)));
    }

    @PreAuthorize("hasPermission(this.emitemrinMapping.toDomain(#emitemrindto),'eam_practice01-EMItemRIn-Create')")
    @ApiOperation(value = "根据仓库物品建立入库单", tags = {"入库单" },  notes = "根据仓库物品建立入库单")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emitemrins")
    @Transactional
    public ResponseEntity<EMItemRInDTO> createByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemRInDTO emitemrindto) {
        EMItemRIn domain = emitemrinMapping.toDomain(emitemrindto);
        domain.setItemid(emitem_id);
		emitemrinService.create(domain);
        EMItemRInDTO dto = emitemrinMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.emitemrinMapping.toDomain(#emitemrindtos),'eam_practice01-EMItemRIn-Create')")
    @ApiOperation(value = "根据仓库物品批量建立入库单", tags = {"入库单" },  notes = "根据仓库物品批量建立入库单")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emitemrins/batch")
    public ResponseEntity<Boolean> createBatchByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemRInDTO> emitemrindtos) {
        List<EMItemRIn> domainlist=emitemrinMapping.toDomain(emitemrindtos);
        for(EMItemRIn domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emitemrinService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(this.emitemrinService.get(#emitemrin_id),'eam_practice01-EMItemRIn-Update')")
    @ApiOperation(value = "根据仓库物品更新入库单", tags = {"入库单" },  notes = "根据仓库物品更新入库单")
	@RequestMapping(method = RequestMethod.PUT, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emitemrins/{emitemrin_id}")
    @Transactional
    public ResponseEntity<EMItemRInDTO> updateByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emitemrin_id") String emitemrin_id, @RequestBody EMItemRInDTO emitemrindto) {
        EMItemRIn domain = emitemrinMapping.toDomain(emitemrindto);
        domain.setItemid(emitem_id);
        domain.setEmitemrinid(emitemrin_id);
		emitemrinService.update(domain);
        EMItemRInDTO dto = emitemrinMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.emitemrinService.getEmitemrinByEntities(this.emitemrinMapping.toDomain(#emitemrindtos)),'eam_practice01-EMItemRIn-Update')")
    @ApiOperation(value = "根据仓库物品批量更新入库单", tags = {"入库单" },  notes = "根据仓库物品批量更新入库单")
	@RequestMapping(method = RequestMethod.PUT, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emitemrins/batch")
    public ResponseEntity<Boolean> updateBatchByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemRInDTO> emitemrindtos) {
        List<EMItemRIn> domainlist=emitemrinMapping.toDomain(emitemrindtos);
        for(EMItemRIn domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emitemrinService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(this.emitemrinMapping.toDomain(#emitemrindto),'eam_practice01-EMItemRIn-Save')")
    @ApiOperation(value = "根据仓库物品保存入库单", tags = {"入库单" },  notes = "根据仓库物品保存入库单")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emitemrins/save")
    public ResponseEntity<Boolean> saveByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemRInDTO emitemrindto) {
        EMItemRIn domain = emitemrinMapping.toDomain(emitemrindto);
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emitemrinService.save(domain));
    }

    @PreAuthorize("hasPermission(this.emitemrinMapping.toDomain(#emitemrindtos),'eam_practice01-EMItemRIn-Save')")
    @ApiOperation(value = "根据仓库物品批量保存入库单", tags = {"入库单" },  notes = "根据仓库物品批量保存入库单")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emitemrins/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemRInDTO> emitemrindtos) {
        List<EMItemRIn> domainlist=emitemrinMapping.toDomain(emitemrindtos);
        for(EMItemRIn domain:domainlist){
             domain.setItemid(emitem_id);
        }
        emitemrinService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PostAuthorize("hasPermission(this.emitemrinMapping.toDomain(returnObject.body),'eam_practice01-EMItemRIn-Get')")
    @ApiOperation(value = "根据仓库物品获取入库单", tags = {"入库单" },  notes = "根据仓库物品获取入库单")
	@RequestMapping(method = RequestMethod.GET, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emitemrins/{emitemrin_id}")
    public ResponseEntity<EMItemRInDTO> getByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emitemrin_id") String emitemrin_id) {
        EMItemRIn domain = emitemrinService.get(emitemrin_id);
        EMItemRInDTO dto = emitemrinMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.emitemrinService.get(#emitemrin_id),'eam_practice01-EMItemRIn-Remove')")
    @ApiOperation(value = "根据仓库物品删除入库单", tags = {"入库单" },  notes = "根据仓库物品删除入库单")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emitemrins/{emitemrin_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emitemrin_id") String emitemrin_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emitemrinService.remove(emitemrin_id));
    }

    @PreAuthorize("hasPermission(this.emitemrinService.getEmitemrinByIds(#ids),'eam_practice01-EMItemRIn-Remove')")
    @ApiOperation(value = "根据仓库物品批量删除入库单", tags = {"入库单" },  notes = "根据仓库物品批量删除入库单")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emstores/{emstore_id}/emitems/{emitem_id}/emitemrins/batch")
    public ResponseEntity<Boolean> removeBatchByEMStoreEMItem(@RequestBody List<String> ids) {
        emitemrinService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMItemRIn-Default-all')")
	@ApiOperation(value = "根据仓库物品获取DEFAULT", tags = {"入库单" } ,notes = "根据仓库物品获取DEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emstores/{emstore_id}/emitems/{emitem_id}/emitemrins/fetchdefault")
	public ResponseEntity<List<EMItemRInDTO>> fetchEMItemRInDefaultByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id,EMItemRInSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMItemRIn> domains = emitemrinService.searchDefault(context) ;
        List<EMItemRInDTO> list = emitemrinMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMItemRIn-Default-all')")
	@ApiOperation(value = "根据仓库物品查询DEFAULT", tags = {"入库单" } ,notes = "根据仓库物品查询DEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emstores/{emstore_id}/emitems/{emitem_id}/emitemrins/searchdefault")
	public ResponseEntity<Page<EMItemRInDTO>> searchEMItemRInDefaultByEMStoreEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemRInSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMItemRIn> domains = emitemrinService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emitemrinMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @ApiOperation(value = "根据职员物品检查入库单", tags = {"入库单" },  notes = "根据职员物品检查入库单")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emitemrins/checkkey")
    public ResponseEntity<Boolean> checkKeyByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemRInDTO emitemrindto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emitemrinService.checkKey(emitemrinMapping.toDomain(emitemrindto)));
    }

    @ApiOperation(value = "根据职员物品获取入库单草稿", tags = {"入库单" },  notes = "根据职员物品获取入库单草稿")
    @RequestMapping(method = RequestMethod.GET, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emitemrins/getdraft")
    public ResponseEntity<EMItemRInDTO> getDraftByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id) {
        EMItemRIn domain = new EMItemRIn();
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emitemrinMapping.toDto(emitemrinService.getDraft(domain)));
    }

    @PreAuthorize("hasPermission(this.emitemrinMapping.toDomain(#emitemrindto),'eam_practice01-EMItemRIn-Create')")
    @ApiOperation(value = "根据职员物品建立入库单", tags = {"入库单" },  notes = "根据职员物品建立入库单")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emitemrins")
    @Transactional
    public ResponseEntity<EMItemRInDTO> createByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemRInDTO emitemrindto) {
        EMItemRIn domain = emitemrinMapping.toDomain(emitemrindto);
        domain.setItemid(emitem_id);
		emitemrinService.create(domain);
        EMItemRInDTO dto = emitemrinMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.emitemrinMapping.toDomain(#emitemrindtos),'eam_practice01-EMItemRIn-Create')")
    @ApiOperation(value = "根据职员物品批量建立入库单", tags = {"入库单" },  notes = "根据职员物品批量建立入库单")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emitemrins/batch")
    public ResponseEntity<Boolean> createBatchByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemRInDTO> emitemrindtos) {
        List<EMItemRIn> domainlist=emitemrinMapping.toDomain(emitemrindtos);
        for(EMItemRIn domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emitemrinService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(this.emitemrinService.get(#emitemrin_id),'eam_practice01-EMItemRIn-Update')")
    @ApiOperation(value = "根据职员物品更新入库单", tags = {"入库单" },  notes = "根据职员物品更新入库单")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emitemrins/{emitemrin_id}")
    @Transactional
    public ResponseEntity<EMItemRInDTO> updateByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emitemrin_id") String emitemrin_id, @RequestBody EMItemRInDTO emitemrindto) {
        EMItemRIn domain = emitemrinMapping.toDomain(emitemrindto);
        domain.setItemid(emitem_id);
        domain.setEmitemrinid(emitemrin_id);
		emitemrinService.update(domain);
        EMItemRInDTO dto = emitemrinMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.emitemrinService.getEmitemrinByEntities(this.emitemrinMapping.toDomain(#emitemrindtos)),'eam_practice01-EMItemRIn-Update')")
    @ApiOperation(value = "根据职员物品批量更新入库单", tags = {"入库单" },  notes = "根据职员物品批量更新入库单")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emitemrins/batch")
    public ResponseEntity<Boolean> updateBatchByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemRInDTO> emitemrindtos) {
        List<EMItemRIn> domainlist=emitemrinMapping.toDomain(emitemrindtos);
        for(EMItemRIn domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emitemrinService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(this.emitemrinMapping.toDomain(#emitemrindto),'eam_practice01-EMItemRIn-Save')")
    @ApiOperation(value = "根据职员物品保存入库单", tags = {"入库单" },  notes = "根据职员物品保存入库单")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emitemrins/save")
    public ResponseEntity<Boolean> saveByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemRInDTO emitemrindto) {
        EMItemRIn domain = emitemrinMapping.toDomain(emitemrindto);
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emitemrinService.save(domain));
    }

    @PreAuthorize("hasPermission(this.emitemrinMapping.toDomain(#emitemrindtos),'eam_practice01-EMItemRIn-Save')")
    @ApiOperation(value = "根据职员物品批量保存入库单", tags = {"入库单" },  notes = "根据职员物品批量保存入库单")
	@RequestMapping(method = RequestMethod.POST, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emitemrins/savebatch")
    public ResponseEntity<Boolean> saveBatchByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemRInDTO> emitemrindtos) {
        List<EMItemRIn> domainlist=emitemrinMapping.toDomain(emitemrindtos);
        for(EMItemRIn domain:domainlist){
             domain.setItemid(emitem_id);
        }
        emitemrinService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PostAuthorize("hasPermission(this.emitemrinMapping.toDomain(returnObject.body),'eam_practice01-EMItemRIn-Get')")
    @ApiOperation(value = "根据职员物品获取入库单", tags = {"入库单" },  notes = "根据职员物品获取入库单")
	@RequestMapping(method = RequestMethod.GET, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emitemrins/{emitemrin_id}")
    public ResponseEntity<EMItemRInDTO> getByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emitemrin_id") String emitemrin_id) {
        EMItemRIn domain = emitemrinService.get(emitemrin_id);
        EMItemRInDTO dto = emitemrinMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.emitemrinService.get(#emitemrin_id),'eam_practice01-EMItemRIn-Remove')")
    @ApiOperation(value = "根据职员物品删除入库单", tags = {"入库单" },  notes = "根据职员物品删除入库单")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emitemrins/{emitemrin_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emitemrin_id") String emitemrin_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emitemrinService.remove(emitemrin_id));
    }

    @PreAuthorize("hasPermission(this.emitemrinService.getEmitemrinByIds(#ids),'eam_practice01-EMItemRIn-Remove')")
    @ApiOperation(value = "根据职员物品批量删除入库单", tags = {"入库单" },  notes = "根据职员物品批量删除入库单")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfemps/{pfemp_id}/emitems/{emitem_id}/emitemrins/batch")
    public ResponseEntity<Boolean> removeBatchByPFEmpEMItem(@RequestBody List<String> ids) {
        emitemrinService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMItemRIn-Default-all')")
	@ApiOperation(value = "根据职员物品获取DEFAULT", tags = {"入库单" } ,notes = "根据职员物品获取DEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/pfemps/{pfemp_id}/emitems/{emitem_id}/emitemrins/fetchdefault")
	public ResponseEntity<List<EMItemRInDTO>> fetchEMItemRInDefaultByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id,EMItemRInSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMItemRIn> domains = emitemrinService.searchDefault(context) ;
        List<EMItemRInDTO> list = emitemrinMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMItemRIn-Default-all')")
	@ApiOperation(value = "根据职员物品查询DEFAULT", tags = {"入库单" } ,notes = "根据职员物品查询DEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/pfemps/{pfemp_id}/emitems/{emitem_id}/emitemrins/searchdefault")
	public ResponseEntity<Page<EMItemRInDTO>> searchEMItemRInDefaultByPFEmpEMItem(@PathVariable("pfemp_id") String pfemp_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemRInSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMItemRIn> domains = emitemrinService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emitemrinMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @ApiOperation(value = "根据计量单位物品检查入库单", tags = {"入库单" },  notes = "根据计量单位物品检查入库单")
	@RequestMapping(method = RequestMethod.POST, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emitemrins/checkkey")
    public ResponseEntity<Boolean> checkKeyByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemRInDTO emitemrindto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emitemrinService.checkKey(emitemrinMapping.toDomain(emitemrindto)));
    }

    @ApiOperation(value = "根据计量单位物品获取入库单草稿", tags = {"入库单" },  notes = "根据计量单位物品获取入库单草稿")
    @RequestMapping(method = RequestMethod.GET, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emitemrins/getdraft")
    public ResponseEntity<EMItemRInDTO> getDraftByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id) {
        EMItemRIn domain = new EMItemRIn();
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emitemrinMapping.toDto(emitemrinService.getDraft(domain)));
    }

    @PreAuthorize("hasPermission(this.emitemrinMapping.toDomain(#emitemrindto),'eam_practice01-EMItemRIn-Create')")
    @ApiOperation(value = "根据计量单位物品建立入库单", tags = {"入库单" },  notes = "根据计量单位物品建立入库单")
	@RequestMapping(method = RequestMethod.POST, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emitemrins")
    @Transactional
    public ResponseEntity<EMItemRInDTO> createByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemRInDTO emitemrindto) {
        EMItemRIn domain = emitemrinMapping.toDomain(emitemrindto);
        domain.setItemid(emitem_id);
		emitemrinService.create(domain);
        EMItemRInDTO dto = emitemrinMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.emitemrinMapping.toDomain(#emitemrindtos),'eam_practice01-EMItemRIn-Create')")
    @ApiOperation(value = "根据计量单位物品批量建立入库单", tags = {"入库单" },  notes = "根据计量单位物品批量建立入库单")
	@RequestMapping(method = RequestMethod.POST, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emitemrins/batch")
    public ResponseEntity<Boolean> createBatchByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemRInDTO> emitemrindtos) {
        List<EMItemRIn> domainlist=emitemrinMapping.toDomain(emitemrindtos);
        for(EMItemRIn domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emitemrinService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(this.emitemrinService.get(#emitemrin_id),'eam_practice01-EMItemRIn-Update')")
    @ApiOperation(value = "根据计量单位物品更新入库单", tags = {"入库单" },  notes = "根据计量单位物品更新入库单")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emitemrins/{emitemrin_id}")
    @Transactional
    public ResponseEntity<EMItemRInDTO> updateByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emitemrin_id") String emitemrin_id, @RequestBody EMItemRInDTO emitemrindto) {
        EMItemRIn domain = emitemrinMapping.toDomain(emitemrindto);
        domain.setItemid(emitem_id);
        domain.setEmitemrinid(emitemrin_id);
		emitemrinService.update(domain);
        EMItemRInDTO dto = emitemrinMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.emitemrinService.getEmitemrinByEntities(this.emitemrinMapping.toDomain(#emitemrindtos)),'eam_practice01-EMItemRIn-Update')")
    @ApiOperation(value = "根据计量单位物品批量更新入库单", tags = {"入库单" },  notes = "根据计量单位物品批量更新入库单")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emitemrins/batch")
    public ResponseEntity<Boolean> updateBatchByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemRInDTO> emitemrindtos) {
        List<EMItemRIn> domainlist=emitemrinMapping.toDomain(emitemrindtos);
        for(EMItemRIn domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emitemrinService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(this.emitemrinMapping.toDomain(#emitemrindto),'eam_practice01-EMItemRIn-Save')")
    @ApiOperation(value = "根据计量单位物品保存入库单", tags = {"入库单" },  notes = "根据计量单位物品保存入库单")
	@RequestMapping(method = RequestMethod.POST, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emitemrins/save")
    public ResponseEntity<Boolean> saveByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemRInDTO emitemrindto) {
        EMItemRIn domain = emitemrinMapping.toDomain(emitemrindto);
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emitemrinService.save(domain));
    }

    @PreAuthorize("hasPermission(this.emitemrinMapping.toDomain(#emitemrindtos),'eam_practice01-EMItemRIn-Save')")
    @ApiOperation(value = "根据计量单位物品批量保存入库单", tags = {"入库单" },  notes = "根据计量单位物品批量保存入库单")
	@RequestMapping(method = RequestMethod.POST, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emitemrins/savebatch")
    public ResponseEntity<Boolean> saveBatchByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemRInDTO> emitemrindtos) {
        List<EMItemRIn> domainlist=emitemrinMapping.toDomain(emitemrindtos);
        for(EMItemRIn domain:domainlist){
             domain.setItemid(emitem_id);
        }
        emitemrinService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PostAuthorize("hasPermission(this.emitemrinMapping.toDomain(returnObject.body),'eam_practice01-EMItemRIn-Get')")
    @ApiOperation(value = "根据计量单位物品获取入库单", tags = {"入库单" },  notes = "根据计量单位物品获取入库单")
	@RequestMapping(method = RequestMethod.GET, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emitemrins/{emitemrin_id}")
    public ResponseEntity<EMItemRInDTO> getByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emitemrin_id") String emitemrin_id) {
        EMItemRIn domain = emitemrinService.get(emitemrin_id);
        EMItemRInDTO dto = emitemrinMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.emitemrinService.get(#emitemrin_id),'eam_practice01-EMItemRIn-Remove')")
    @ApiOperation(value = "根据计量单位物品删除入库单", tags = {"入库单" },  notes = "根据计量单位物品删除入库单")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emitemrins/{emitemrin_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emitemrin_id") String emitemrin_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emitemrinService.remove(emitemrin_id));
    }

    @PreAuthorize("hasPermission(this.emitemrinService.getEmitemrinByIds(#ids),'eam_practice01-EMItemRIn-Remove')")
    @ApiOperation(value = "根据计量单位物品批量删除入库单", tags = {"入库单" },  notes = "根据计量单位物品批量删除入库单")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfunits/{pfunit_id}/emitems/{emitem_id}/emitemrins/batch")
    public ResponseEntity<Boolean> removeBatchByPFUnitEMItem(@RequestBody List<String> ids) {
        emitemrinService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMItemRIn-Default-all')")
	@ApiOperation(value = "根据计量单位物品获取DEFAULT", tags = {"入库单" } ,notes = "根据计量单位物品获取DEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/pfunits/{pfunit_id}/emitems/{emitem_id}/emitemrins/fetchdefault")
	public ResponseEntity<List<EMItemRInDTO>> fetchEMItemRInDefaultByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id,EMItemRInSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMItemRIn> domains = emitemrinService.searchDefault(context) ;
        List<EMItemRInDTO> list = emitemrinMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMItemRIn-Default-all')")
	@ApiOperation(value = "根据计量单位物品查询DEFAULT", tags = {"入库单" } ,notes = "根据计量单位物品查询DEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/pfunits/{pfunit_id}/emitems/{emitem_id}/emitemrins/searchdefault")
	public ResponseEntity<Page<EMItemRInDTO>> searchEMItemRInDefaultByPFUnitEMItem(@PathVariable("pfunit_id") String pfunit_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemRInSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMItemRIn> domains = emitemrinService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emitemrinMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @ApiOperation(value = "根据仓库仓库库位物品检查入库单", tags = {"入库单" },  notes = "根据仓库仓库库位物品检查入库单")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemrins/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemRInDTO emitemrindto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emitemrinService.checkKey(emitemrinMapping.toDomain(emitemrindto)));
    }

    @ApiOperation(value = "根据仓库仓库库位物品获取入库单草稿", tags = {"入库单" },  notes = "根据仓库仓库库位物品获取入库单草稿")
    @RequestMapping(method = RequestMethod.GET, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemrins/getdraft")
    public ResponseEntity<EMItemRInDTO> getDraftByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id) {
        EMItemRIn domain = new EMItemRIn();
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emitemrinMapping.toDto(emitemrinService.getDraft(domain)));
    }

    @PreAuthorize("hasPermission(this.emitemrinMapping.toDomain(#emitemrindto),'eam_practice01-EMItemRIn-Create')")
    @ApiOperation(value = "根据仓库仓库库位物品建立入库单", tags = {"入库单" },  notes = "根据仓库仓库库位物品建立入库单")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemrins")
    @Transactional
    public ResponseEntity<EMItemRInDTO> createByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemRInDTO emitemrindto) {
        EMItemRIn domain = emitemrinMapping.toDomain(emitemrindto);
        domain.setItemid(emitem_id);
		emitemrinService.create(domain);
        EMItemRInDTO dto = emitemrinMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.emitemrinMapping.toDomain(#emitemrindtos),'eam_practice01-EMItemRIn-Create')")
    @ApiOperation(value = "根据仓库仓库库位物品批量建立入库单", tags = {"入库单" },  notes = "根据仓库仓库库位物品批量建立入库单")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemrins/batch")
    public ResponseEntity<Boolean> createBatchByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemRInDTO> emitemrindtos) {
        List<EMItemRIn> domainlist=emitemrinMapping.toDomain(emitemrindtos);
        for(EMItemRIn domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emitemrinService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(this.emitemrinService.get(#emitemrin_id),'eam_practice01-EMItemRIn-Update')")
    @ApiOperation(value = "根据仓库仓库库位物品更新入库单", tags = {"入库单" },  notes = "根据仓库仓库库位物品更新入库单")
	@RequestMapping(method = RequestMethod.PUT, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemrins/{emitemrin_id}")
    @Transactional
    public ResponseEntity<EMItemRInDTO> updateByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emitemrin_id") String emitemrin_id, @RequestBody EMItemRInDTO emitemrindto) {
        EMItemRIn domain = emitemrinMapping.toDomain(emitemrindto);
        domain.setItemid(emitem_id);
        domain.setEmitemrinid(emitemrin_id);
		emitemrinService.update(domain);
        EMItemRInDTO dto = emitemrinMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.emitemrinService.getEmitemrinByEntities(this.emitemrinMapping.toDomain(#emitemrindtos)),'eam_practice01-EMItemRIn-Update')")
    @ApiOperation(value = "根据仓库仓库库位物品批量更新入库单", tags = {"入库单" },  notes = "根据仓库仓库库位物品批量更新入库单")
	@RequestMapping(method = RequestMethod.PUT, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemrins/batch")
    public ResponseEntity<Boolean> updateBatchByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemRInDTO> emitemrindtos) {
        List<EMItemRIn> domainlist=emitemrinMapping.toDomain(emitemrindtos);
        for(EMItemRIn domain:domainlist){
            domain.setItemid(emitem_id);
        }
        emitemrinService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(this.emitemrinMapping.toDomain(#emitemrindto),'eam_practice01-EMItemRIn-Save')")
    @ApiOperation(value = "根据仓库仓库库位物品保存入库单", tags = {"入库单" },  notes = "根据仓库仓库库位物品保存入库单")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemrins/save")
    public ResponseEntity<Boolean> saveByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemRInDTO emitemrindto) {
        EMItemRIn domain = emitemrinMapping.toDomain(emitemrindto);
        domain.setItemid(emitem_id);
        return ResponseEntity.status(HttpStatus.OK).body(emitemrinService.save(domain));
    }

    @PreAuthorize("hasPermission(this.emitemrinMapping.toDomain(#emitemrindtos),'eam_practice01-EMItemRIn-Save')")
    @ApiOperation(value = "根据仓库仓库库位物品批量保存入库单", tags = {"入库单" },  notes = "根据仓库仓库库位物品批量保存入库单")
	@RequestMapping(method = RequestMethod.POST, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemrins/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody List<EMItemRInDTO> emitemrindtos) {
        List<EMItemRIn> domainlist=emitemrinMapping.toDomain(emitemrindtos);
        for(EMItemRIn domain:domainlist){
             domain.setItemid(emitem_id);
        }
        emitemrinService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PostAuthorize("hasPermission(this.emitemrinMapping.toDomain(returnObject.body),'eam_practice01-EMItemRIn-Get')")
    @ApiOperation(value = "根据仓库仓库库位物品获取入库单", tags = {"入库单" },  notes = "根据仓库仓库库位物品获取入库单")
	@RequestMapping(method = RequestMethod.GET, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemrins/{emitemrin_id}")
    public ResponseEntity<EMItemRInDTO> getByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emitemrin_id") String emitemrin_id) {
        EMItemRIn domain = emitemrinService.get(emitemrin_id);
        EMItemRInDTO dto = emitemrinMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.emitemrinService.get(#emitemrin_id),'eam_practice01-EMItemRIn-Remove')")
    @ApiOperation(value = "根据仓库仓库库位物品删除入库单", tags = {"入库单" },  notes = "根据仓库仓库库位物品删除入库单")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemrins/{emitemrin_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @PathVariable("emitemrin_id") String emitemrin_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emitemrinService.remove(emitemrin_id));
    }

    @PreAuthorize("hasPermission(this.emitemrinService.getEmitemrinByIds(#ids),'eam_practice01-EMItemRIn-Remove')")
    @ApiOperation(value = "根据仓库仓库库位物品批量删除入库单", tags = {"入库单" },  notes = "根据仓库仓库库位物品批量删除入库单")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemrins/batch")
    public ResponseEntity<Boolean> removeBatchByEMStoreEMStorePartEMItem(@RequestBody List<String> ids) {
        emitemrinService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMItemRIn-Default-all')")
	@ApiOperation(value = "根据仓库仓库库位物品获取DEFAULT", tags = {"入库单" } ,notes = "根据仓库仓库库位物品获取DEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemrins/fetchdefault")
	public ResponseEntity<List<EMItemRInDTO>> fetchEMItemRInDefaultByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id,EMItemRInSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMItemRIn> domains = emitemrinService.searchDefault(context) ;
        List<EMItemRInDTO> list = emitemrinMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMItemRIn-Default-all')")
	@ApiOperation(value = "根据仓库仓库库位物品查询DEFAULT", tags = {"入库单" } ,notes = "根据仓库仓库库位物品查询DEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emstores/{emstore_id}/emstoreparts/{emstorepart_id}/emitems/{emitem_id}/emitemrins/searchdefault")
	public ResponseEntity<Page<EMItemRInDTO>> searchEMItemRInDefaultByEMStoreEMStorePartEMItem(@PathVariable("emstore_id") String emstore_id, @PathVariable("emstorepart_id") String emstorepart_id, @PathVariable("emitem_id") String emitem_id, @RequestBody EMItemRInSearchContext context) {
        context.setN_itemid_eq(emitem_id);
        Page<EMItemRIn> domains = emitemrinService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emitemrinMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
}

