package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.access.prepost.PostAuthorize;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.eam_core.domain.EMEQWL;
import cn.ibizlab.eam.core.eam_core.service.IEMEQWLService;
import cn.ibizlab.eam.core.eam_core.filter.EMEQWLSearchContext;

@Slf4j
@Api(tags = {"设备运行日志" })
@RestController("WebApi-emeqwl")
@RequestMapping("")
public class EMEQWLResource {

    @Autowired
    public IEMEQWLService emeqwlService;

    @Autowired
    @Lazy
    public EMEQWLMapping emeqwlMapping;

    @PreAuthorize("hasPermission(this.emeqwlService.get(#emeqwl_id),'eam_practice01-EMEQWL-Remove')")
    @ApiOperation(value = "删除设备运行日志", tags = {"设备运行日志" },  notes = "删除设备运行日志")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emeqwls/{emeqwl_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("emeqwl_id") String emeqwl_id) {
         return ResponseEntity.status(HttpStatus.OK).body(emeqwlService.remove(emeqwl_id));
    }

    @PreAuthorize("hasPermission(this.emeqwlService.getEmeqwlByIds(#ids),'eam_practice01-EMEQWL-Remove')")
    @ApiOperation(value = "批量删除设备运行日志", tags = {"设备运行日志" },  notes = "批量删除设备运行日志")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emeqwls/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        emeqwlService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "检查设备运行日志", tags = {"设备运行日志" },  notes = "检查设备运行日志")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqwls/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody EMEQWLDTO emeqwldto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emeqwlService.checkKey(emeqwlMapping.toDomain(emeqwldto)));
    }

    @PreAuthorize("hasPermission(this.emeqwlMapping.toDomain(#emeqwldto),'eam_practice01-EMEQWL-Save')")
    @ApiOperation(value = "保存设备运行日志", tags = {"设备运行日志" },  notes = "保存设备运行日志")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqwls/save")
    public ResponseEntity<Boolean> save(@RequestBody EMEQWLDTO emeqwldto) {
        return ResponseEntity.status(HttpStatus.OK).body(emeqwlService.save(emeqwlMapping.toDomain(emeqwldto)));
    }

    @PreAuthorize("hasPermission(this.emeqwlMapping.toDomain(#emeqwldtos),'eam_practice01-EMEQWL-Save')")
    @ApiOperation(value = "批量保存设备运行日志", tags = {"设备运行日志" },  notes = "批量保存设备运行日志")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqwls/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<EMEQWLDTO> emeqwldtos) {
        emeqwlService.saveBatch(emeqwlMapping.toDomain(emeqwldtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(this.emeqwlService.get(#emeqwl_id),'eam_practice01-EMEQWL-Update')")
    @ApiOperation(value = "更新设备运行日志", tags = {"设备运行日志" },  notes = "更新设备运行日志")
	@RequestMapping(method = RequestMethod.PUT, value = "/emeqwls/{emeqwl_id}")
    @Transactional
    public ResponseEntity<EMEQWLDTO> update(@PathVariable("emeqwl_id") String emeqwl_id, @RequestBody EMEQWLDTO emeqwldto) {
		EMEQWL domain  = emeqwlMapping.toDomain(emeqwldto);
        domain .setEmeqwlid(emeqwl_id);
		emeqwlService.update(domain );
		EMEQWLDTO dto = emeqwlMapping.toDto(domain );
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.emeqwlService.getEmeqwlByEntities(this.emeqwlMapping.toDomain(#emeqwldtos)),'eam_practice01-EMEQWL-Update')")
    @ApiOperation(value = "批量更新设备运行日志", tags = {"设备运行日志" },  notes = "批量更新设备运行日志")
	@RequestMapping(method = RequestMethod.PUT, value = "/emeqwls/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<EMEQWLDTO> emeqwldtos) {
        emeqwlService.updateBatch(emeqwlMapping.toDomain(emeqwldtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PostAuthorize("hasPermission(this.emeqwlMapping.toDomain(returnObject.body),'eam_practice01-EMEQWL-Get')")
    @ApiOperation(value = "获取设备运行日志", tags = {"设备运行日志" },  notes = "获取设备运行日志")
	@RequestMapping(method = RequestMethod.GET, value = "/emeqwls/{emeqwl_id}")
    public ResponseEntity<EMEQWLDTO> get(@PathVariable("emeqwl_id") String emeqwl_id) {
        EMEQWL domain = emeqwlService.get(emeqwl_id);
        EMEQWLDTO dto = emeqwlMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "获取设备运行日志草稿", tags = {"设备运行日志" },  notes = "获取设备运行日志草稿")
	@RequestMapping(method = RequestMethod.GET, value = "/emeqwls/getdraft")
    public ResponseEntity<EMEQWLDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(emeqwlMapping.toDto(emeqwlService.getDraft(new EMEQWL())));
    }

    @PreAuthorize("hasPermission(this.emeqwlMapping.toDomain(#emeqwldto),'eam_practice01-EMEQWL-Create')")
    @ApiOperation(value = "新建设备运行日志", tags = {"设备运行日志" },  notes = "新建设备运行日志")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqwls")
    @Transactional
    public ResponseEntity<EMEQWLDTO> create(@RequestBody EMEQWLDTO emeqwldto) {
        EMEQWL domain = emeqwlMapping.toDomain(emeqwldto);
		emeqwlService.create(domain);
        EMEQWLDTO dto = emeqwlMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.emeqwlMapping.toDomain(#emeqwldtos),'eam_practice01-EMEQWL-Create')")
    @ApiOperation(value = "批量新建设备运行日志", tags = {"设备运行日志" },  notes = "批量新建设备运行日志")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqwls/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<EMEQWLDTO> emeqwldtos) {
        emeqwlService.createBatch(emeqwlMapping.toDomain(emeqwldtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEQWL-Default-all')")
	@ApiOperation(value = "获取DEFAULT", tags = {"设备运行日志" } ,notes = "获取DEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emeqwls/fetchdefault")
	public ResponseEntity<List<EMEQWLDTO>> fetchDefault(EMEQWLSearchContext context) {
        Page<EMEQWL> domains = emeqwlService.searchDefault(context) ;
        List<EMEQWLDTO> list = emeqwlMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMEQWL-Default-all')")
	@ApiOperation(value = "查询DEFAULT", tags = {"设备运行日志" } ,notes = "查询DEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emeqwls/searchdefault")
	public ResponseEntity<Page<EMEQWLDTO>> searchDefault(@RequestBody EMEQWLSearchContext context) {
        Page<EMEQWL> domains = emeqwlService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emeqwlMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
}

