package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.access.prepost.PostAuthorize;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.ys.domain.CLASS;
import cn.ibizlab.eam.core.ys.service.ICLASSService;
import cn.ibizlab.eam.core.ys.filter.CLASSSearchContext;

@Slf4j
@Api(tags = {"班级" })
@RestController("WebApi-class")
@RequestMapping("")
public class CLASSResource {

    @Autowired
    public ICLASSService classService;

    @Autowired
    @Lazy
    public CLASSMapping classMapping;

    @ApiOperation(value = "获取班级草稿", tags = {"班级" },  notes = "获取班级草稿")
	@RequestMapping(method = RequestMethod.GET, value = "/classes/getdraft")
    public ResponseEntity<CLASSDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(classMapping.toDto(classService.getDraft(new CLASS())));
    }

    @PostAuthorize("hasPermission(this.classMapping.toDomain(returnObject.body),'eam_practice01-CLASS-Get')")
    @ApiOperation(value = "获取班级", tags = {"班级" },  notes = "获取班级")
	@RequestMapping(method = RequestMethod.GET, value = "/classes/{class_id}")
    public ResponseEntity<CLASSDTO> get(@PathVariable("class_id") String class_id) {
        CLASS domain = classService.get(class_id);
        CLASSDTO dto = classMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.classMapping.toDomain(#classdto),'eam_practice01-CLASS-Create')")
    @ApiOperation(value = "新建班级", tags = {"班级" },  notes = "新建班级")
	@RequestMapping(method = RequestMethod.POST, value = "/classes")
    @Transactional
    public ResponseEntity<CLASSDTO> create(@RequestBody CLASSDTO classdto) {
        CLASS domain = classMapping.toDomain(classdto);
		classService.create(domain);
        CLASSDTO dto = classMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.classMapping.toDomain(#classdtos),'eam_practice01-CLASS-Create')")
    @ApiOperation(value = "批量新建班级", tags = {"班级" },  notes = "批量新建班级")
	@RequestMapping(method = RequestMethod.POST, value = "/classes/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<CLASSDTO> classdtos) {
        classService.createBatch(classMapping.toDomain(classdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(this.classMapping.toDomain(#classdto),'eam_practice01-CLASS-Save')")
    @ApiOperation(value = "保存班级", tags = {"班级" },  notes = "保存班级")
	@RequestMapping(method = RequestMethod.POST, value = "/classes/save")
    public ResponseEntity<Boolean> save(@RequestBody CLASSDTO classdto) {
        return ResponseEntity.status(HttpStatus.OK).body(classService.save(classMapping.toDomain(classdto)));
    }

    @PreAuthorize("hasPermission(this.classMapping.toDomain(#classdtos),'eam_practice01-CLASS-Save')")
    @ApiOperation(value = "批量保存班级", tags = {"班级" },  notes = "批量保存班级")
	@RequestMapping(method = RequestMethod.POST, value = "/classes/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<CLASSDTO> classdtos) {
        classService.saveBatch(classMapping.toDomain(classdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(this.classService.get(#class_id),'eam_practice01-CLASS-Remove')")
    @ApiOperation(value = "删除班级", tags = {"班级" },  notes = "删除班级")
	@RequestMapping(method = RequestMethod.DELETE, value = "/classes/{class_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("class_id") String class_id) {
         return ResponseEntity.status(HttpStatus.OK).body(classService.remove(class_id));
    }

    @PreAuthorize("hasPermission(this.classService.getClassByIds(#ids),'eam_practice01-CLASS-Remove')")
    @ApiOperation(value = "批量删除班级", tags = {"班级" },  notes = "批量删除班级")
	@RequestMapping(method = RequestMethod.DELETE, value = "/classes/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        classService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(this.classService.get(#class_id),'eam_practice01-CLASS-Update')")
    @ApiOperation(value = "更新班级", tags = {"班级" },  notes = "更新班级")
	@RequestMapping(method = RequestMethod.PUT, value = "/classes/{class_id}")
    @Transactional
    public ResponseEntity<CLASSDTO> update(@PathVariable("class_id") String class_id, @RequestBody CLASSDTO classdto) {
		CLASS domain  = classMapping.toDomain(classdto);
        domain .setClassid(class_id);
		classService.update(domain );
		CLASSDTO dto = classMapping.toDto(domain );
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.classService.getClassByEntities(this.classMapping.toDomain(#classdtos)),'eam_practice01-CLASS-Update')")
    @ApiOperation(value = "批量更新班级", tags = {"班级" },  notes = "批量更新班级")
	@RequestMapping(method = RequestMethod.PUT, value = "/classes/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<CLASSDTO> classdtos) {
        classService.updateBatch(classMapping.toDomain(classdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "检查班级", tags = {"班级" },  notes = "检查班级")
	@RequestMapping(method = RequestMethod.POST, value = "/classes/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody CLASSDTO classdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(classService.checkKey(classMapping.toDomain(classdto)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-CLASS-Default-all')")
	@ApiOperation(value = "获取DEFAULT", tags = {"班级" } ,notes = "获取DEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/classes/fetchdefault")
	public ResponseEntity<List<CLASSDTO>> fetchDefault(CLASSSearchContext context) {
        Page<CLASS> domains = classService.searchDefault(context) ;
        List<CLASSDTO> list = classMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-CLASS-Default-all')")
	@ApiOperation(value = "查询DEFAULT", tags = {"班级" } ,notes = "查询DEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/classes/searchdefault")
	public ResponseEntity<Page<CLASSDTO>> searchDefault(@RequestBody CLASSSearchContext context) {
        Page<CLASS> domains = classService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(classMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
}

