package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.access.prepost.PostAuthorize;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.eam_core.domain.EMWO_EN;
import cn.ibizlab.eam.core.eam_core.service.IEMWO_ENService;
import cn.ibizlab.eam.core.eam_core.filter.EMWO_ENSearchContext;

@Slf4j
@Api(tags = {"能耗登记工单" })
@RestController("WebApi-emwo_en")
@RequestMapping("")
public class EMWO_ENResource {

    @Autowired
    public IEMWO_ENService emwo_enService;

    @Autowired
    @Lazy
    public EMWO_ENMapping emwo_enMapping;

    @PreAuthorize("hasPermission(this.emwo_enMapping.toDomain(#emwo_endto),'eam_practice01-EMWO_EN-Save')")
    @ApiOperation(value = "保存能耗登记工单", tags = {"能耗登记工单" },  notes = "保存能耗登记工单")
	@RequestMapping(method = RequestMethod.POST, value = "/emwo_ens/save")
    public ResponseEntity<Boolean> save(@RequestBody EMWO_ENDTO emwo_endto) {
        return ResponseEntity.status(HttpStatus.OK).body(emwo_enService.save(emwo_enMapping.toDomain(emwo_endto)));
    }

    @PreAuthorize("hasPermission(this.emwo_enMapping.toDomain(#emwo_endtos),'eam_practice01-EMWO_EN-Save')")
    @ApiOperation(value = "批量保存能耗登记工单", tags = {"能耗登记工单" },  notes = "批量保存能耗登记工单")
	@RequestMapping(method = RequestMethod.POST, value = "/emwo_ens/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<EMWO_ENDTO> emwo_endtos) {
        emwo_enService.saveBatch(emwo_enMapping.toDomain(emwo_endtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(this.emwo_enService.get(#emwo_en_id),'eam_practice01-EMWO_EN-Remove')")
    @ApiOperation(value = "删除能耗登记工单", tags = {"能耗登记工单" },  notes = "删除能耗登记工单")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emwo_ens/{emwo_en_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("emwo_en_id") String emwo_en_id) {
         return ResponseEntity.status(HttpStatus.OK).body(emwo_enService.remove(emwo_en_id));
    }

    @PreAuthorize("hasPermission(this.emwo_enService.getEmwoEnByIds(#ids),'eam_practice01-EMWO_EN-Remove')")
    @ApiOperation(value = "批量删除能耗登记工单", tags = {"能耗登记工单" },  notes = "批量删除能耗登记工单")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emwo_ens/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        emwo_enService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(this.emwo_enService.get(#emwo_en_id),'eam_practice01-EMWO_EN-Update')")
    @ApiOperation(value = "更新能耗登记工单", tags = {"能耗登记工单" },  notes = "更新能耗登记工单")
	@RequestMapping(method = RequestMethod.PUT, value = "/emwo_ens/{emwo_en_id}")
    @Transactional
    public ResponseEntity<EMWO_ENDTO> update(@PathVariable("emwo_en_id") String emwo_en_id, @RequestBody EMWO_ENDTO emwo_endto) {
		EMWO_EN domain  = emwo_enMapping.toDomain(emwo_endto);
        domain .setEmwoEnid(emwo_en_id);
		emwo_enService.update(domain );
		EMWO_ENDTO dto = emwo_enMapping.toDto(domain );
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.emwo_enService.getEmwoEnByEntities(this.emwo_enMapping.toDomain(#emwo_endtos)),'eam_practice01-EMWO_EN-Update')")
    @ApiOperation(value = "批量更新能耗登记工单", tags = {"能耗登记工单" },  notes = "批量更新能耗登记工单")
	@RequestMapping(method = RequestMethod.PUT, value = "/emwo_ens/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<EMWO_ENDTO> emwo_endtos) {
        emwo_enService.updateBatch(emwo_enMapping.toDomain(emwo_endtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(this.emwo_enMapping.toDomain(#emwo_endto),'eam_practice01-EMWO_EN-Create')")
    @ApiOperation(value = "新建能耗登记工单", tags = {"能耗登记工单" },  notes = "新建能耗登记工单")
	@RequestMapping(method = RequestMethod.POST, value = "/emwo_ens")
    @Transactional
    public ResponseEntity<EMWO_ENDTO> create(@RequestBody EMWO_ENDTO emwo_endto) {
        EMWO_EN domain = emwo_enMapping.toDomain(emwo_endto);
		emwo_enService.create(domain);
        EMWO_ENDTO dto = emwo_enMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.emwo_enMapping.toDomain(#emwo_endtos),'eam_practice01-EMWO_EN-Create')")
    @ApiOperation(value = "批量新建能耗登记工单", tags = {"能耗登记工单" },  notes = "批量新建能耗登记工单")
	@RequestMapping(method = RequestMethod.POST, value = "/emwo_ens/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<EMWO_ENDTO> emwo_endtos) {
        emwo_enService.createBatch(emwo_enMapping.toDomain(emwo_endtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "检查能耗登记工单", tags = {"能耗登记工单" },  notes = "检查能耗登记工单")
	@RequestMapping(method = RequestMethod.POST, value = "/emwo_ens/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody EMWO_ENDTO emwo_endto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emwo_enService.checkKey(emwo_enMapping.toDomain(emwo_endto)));
    }

    @PostAuthorize("hasPermission(this.emwo_enMapping.toDomain(returnObject.body),'eam_practice01-EMWO_EN-Get')")
    @ApiOperation(value = "获取能耗登记工单", tags = {"能耗登记工单" },  notes = "获取能耗登记工单")
	@RequestMapping(method = RequestMethod.GET, value = "/emwo_ens/{emwo_en_id}")
    public ResponseEntity<EMWO_ENDTO> get(@PathVariable("emwo_en_id") String emwo_en_id) {
        EMWO_EN domain = emwo_enService.get(emwo_en_id);
        EMWO_ENDTO dto = emwo_enMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "获取能耗登记工单草稿", tags = {"能耗登记工单" },  notes = "获取能耗登记工单草稿")
	@RequestMapping(method = RequestMethod.GET, value = "/emwo_ens/getdraft")
    public ResponseEntity<EMWO_ENDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(emwo_enMapping.toDto(emwo_enService.getDraft(new EMWO_EN())));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWO_EN-Default-all')")
	@ApiOperation(value = "获取DEFAULT", tags = {"能耗登记工单" } ,notes = "获取DEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emwo_ens/fetchdefault")
	public ResponseEntity<List<EMWO_ENDTO>> fetchDefault(EMWO_ENSearchContext context) {
        Page<EMWO_EN> domains = emwo_enService.searchDefault(context) ;
        List<EMWO_ENDTO> list = emwo_enMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWO_EN-Default-all')")
	@ApiOperation(value = "查询DEFAULT", tags = {"能耗登记工单" } ,notes = "查询DEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emwo_ens/searchdefault")
	public ResponseEntity<Page<EMWO_ENDTO>> searchDefault(@RequestBody EMWO_ENSearchContext context) {
        Page<EMWO_EN> domains = emwo_enService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emwo_enMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasPermission(this.emwo_enMapping.toDomain(#emwo_endto),'eam_practice01-EMWO_EN-Save')")
    @ApiOperation(value = "根据设备档案保存能耗登记工单", tags = {"能耗登记工单" },  notes = "根据设备档案保存能耗登记工单")
	@RequestMapping(method = RequestMethod.POST, value = "/emequips/{emequip_id}/emwo_ens/save")
    public ResponseEntity<Boolean> saveByEMEquip(@PathVariable("emequip_id") String emequip_id, @RequestBody EMWO_ENDTO emwo_endto) {
        EMWO_EN domain = emwo_enMapping.toDomain(emwo_endto);
        domain.setEquipid(emequip_id);
        return ResponseEntity.status(HttpStatus.OK).body(emwo_enService.save(domain));
    }

    @PreAuthorize("hasPermission(this.emwo_enMapping.toDomain(#emwo_endtos),'eam_practice01-EMWO_EN-Save')")
    @ApiOperation(value = "根据设备档案批量保存能耗登记工单", tags = {"能耗登记工单" },  notes = "根据设备档案批量保存能耗登记工单")
	@RequestMapping(method = RequestMethod.POST, value = "/emequips/{emequip_id}/emwo_ens/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMEquip(@PathVariable("emequip_id") String emequip_id, @RequestBody List<EMWO_ENDTO> emwo_endtos) {
        List<EMWO_EN> domainlist=emwo_enMapping.toDomain(emwo_endtos);
        for(EMWO_EN domain:domainlist){
             domain.setEquipid(emequip_id);
        }
        emwo_enService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(this.emwo_enService.get(#emwo_en_id),'eam_practice01-EMWO_EN-Remove')")
    @ApiOperation(value = "根据设备档案删除能耗登记工单", tags = {"能耗登记工单" },  notes = "根据设备档案删除能耗登记工单")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emequips/{emequip_id}/emwo_ens/{emwo_en_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMEquip(@PathVariable("emequip_id") String emequip_id, @PathVariable("emwo_en_id") String emwo_en_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emwo_enService.remove(emwo_en_id));
    }

    @PreAuthorize("hasPermission(this.emwo_enService.getEmwoEnByIds(#ids),'eam_practice01-EMWO_EN-Remove')")
    @ApiOperation(value = "根据设备档案批量删除能耗登记工单", tags = {"能耗登记工单" },  notes = "根据设备档案批量删除能耗登记工单")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emequips/{emequip_id}/emwo_ens/batch")
    public ResponseEntity<Boolean> removeBatchByEMEquip(@RequestBody List<String> ids) {
        emwo_enService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(this.emwo_enService.get(#emwo_en_id),'eam_practice01-EMWO_EN-Update')")
    @ApiOperation(value = "根据设备档案更新能耗登记工单", tags = {"能耗登记工单" },  notes = "根据设备档案更新能耗登记工单")
	@RequestMapping(method = RequestMethod.PUT, value = "/emequips/{emequip_id}/emwo_ens/{emwo_en_id}")
    @Transactional
    public ResponseEntity<EMWO_ENDTO> updateByEMEquip(@PathVariable("emequip_id") String emequip_id, @PathVariable("emwo_en_id") String emwo_en_id, @RequestBody EMWO_ENDTO emwo_endto) {
        EMWO_EN domain = emwo_enMapping.toDomain(emwo_endto);
        domain.setEquipid(emequip_id);
        domain.setEmwoEnid(emwo_en_id);
		emwo_enService.update(domain);
        EMWO_ENDTO dto = emwo_enMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.emwo_enService.getEmwoEnByEntities(this.emwo_enMapping.toDomain(#emwo_endtos)),'eam_practice01-EMWO_EN-Update')")
    @ApiOperation(value = "根据设备档案批量更新能耗登记工单", tags = {"能耗登记工单" },  notes = "根据设备档案批量更新能耗登记工单")
	@RequestMapping(method = RequestMethod.PUT, value = "/emequips/{emequip_id}/emwo_ens/batch")
    public ResponseEntity<Boolean> updateBatchByEMEquip(@PathVariable("emequip_id") String emequip_id, @RequestBody List<EMWO_ENDTO> emwo_endtos) {
        List<EMWO_EN> domainlist=emwo_enMapping.toDomain(emwo_endtos);
        for(EMWO_EN domain:domainlist){
            domain.setEquipid(emequip_id);
        }
        emwo_enService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(this.emwo_enMapping.toDomain(#emwo_endto),'eam_practice01-EMWO_EN-Create')")
    @ApiOperation(value = "根据设备档案建立能耗登记工单", tags = {"能耗登记工单" },  notes = "根据设备档案建立能耗登记工单")
	@RequestMapping(method = RequestMethod.POST, value = "/emequips/{emequip_id}/emwo_ens")
    @Transactional
    public ResponseEntity<EMWO_ENDTO> createByEMEquip(@PathVariable("emequip_id") String emequip_id, @RequestBody EMWO_ENDTO emwo_endto) {
        EMWO_EN domain = emwo_enMapping.toDomain(emwo_endto);
        domain.setEquipid(emequip_id);
		emwo_enService.create(domain);
        EMWO_ENDTO dto = emwo_enMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.emwo_enMapping.toDomain(#emwo_endtos),'eam_practice01-EMWO_EN-Create')")
    @ApiOperation(value = "根据设备档案批量建立能耗登记工单", tags = {"能耗登记工单" },  notes = "根据设备档案批量建立能耗登记工单")
	@RequestMapping(method = RequestMethod.POST, value = "/emequips/{emequip_id}/emwo_ens/batch")
    public ResponseEntity<Boolean> createBatchByEMEquip(@PathVariable("emequip_id") String emequip_id, @RequestBody List<EMWO_ENDTO> emwo_endtos) {
        List<EMWO_EN> domainlist=emwo_enMapping.toDomain(emwo_endtos);
        for(EMWO_EN domain:domainlist){
            domain.setEquipid(emequip_id);
        }
        emwo_enService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "根据设备档案检查能耗登记工单", tags = {"能耗登记工单" },  notes = "根据设备档案检查能耗登记工单")
	@RequestMapping(method = RequestMethod.POST, value = "/emequips/{emequip_id}/emwo_ens/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMEquip(@PathVariable("emequip_id") String emequip_id, @RequestBody EMWO_ENDTO emwo_endto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emwo_enService.checkKey(emwo_enMapping.toDomain(emwo_endto)));
    }

    @PostAuthorize("hasPermission(this.emwo_enMapping.toDomain(returnObject.body),'eam_practice01-EMWO_EN-Get')")
    @ApiOperation(value = "根据设备档案获取能耗登记工单", tags = {"能耗登记工单" },  notes = "根据设备档案获取能耗登记工单")
	@RequestMapping(method = RequestMethod.GET, value = "/emequips/{emequip_id}/emwo_ens/{emwo_en_id}")
    public ResponseEntity<EMWO_ENDTO> getByEMEquip(@PathVariable("emequip_id") String emequip_id, @PathVariable("emwo_en_id") String emwo_en_id) {
        EMWO_EN domain = emwo_enService.get(emwo_en_id);
        EMWO_ENDTO dto = emwo_enMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "根据设备档案获取能耗登记工单草稿", tags = {"能耗登记工单" },  notes = "根据设备档案获取能耗登记工单草稿")
    @RequestMapping(method = RequestMethod.GET, value = "/emequips/{emequip_id}/emwo_ens/getdraft")
    public ResponseEntity<EMWO_ENDTO> getDraftByEMEquip(@PathVariable("emequip_id") String emequip_id) {
        EMWO_EN domain = new EMWO_EN();
        domain.setEquipid(emequip_id);
        return ResponseEntity.status(HttpStatus.OK).body(emwo_enMapping.toDto(emwo_enService.getDraft(domain)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWO_EN-Default-all')")
	@ApiOperation(value = "根据设备档案获取DEFAULT", tags = {"能耗登记工单" } ,notes = "根据设备档案获取DEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emequips/{emequip_id}/emwo_ens/fetchdefault")
	public ResponseEntity<List<EMWO_ENDTO>> fetchEMWO_ENDefaultByEMEquip(@PathVariable("emequip_id") String emequip_id,EMWO_ENSearchContext context) {
        context.setN_equipid_eq(emequip_id);
        Page<EMWO_EN> domains = emwo_enService.searchDefault(context) ;
        List<EMWO_ENDTO> list = emwo_enMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWO_EN-Default-all')")
	@ApiOperation(value = "根据设备档案查询DEFAULT", tags = {"能耗登记工单" } ,notes = "根据设备档案查询DEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emequips/{emequip_id}/emwo_ens/searchdefault")
	public ResponseEntity<Page<EMWO_ENDTO>> searchEMWO_ENDefaultByEMEquip(@PathVariable("emequip_id") String emequip_id, @RequestBody EMWO_ENSearchContext context) {
        context.setN_equipid_eq(emequip_id);
        Page<EMWO_EN> domains = emwo_enService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emwo_enMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasPermission(this.emwo_enMapping.toDomain(#emwo_endto),'eam_practice01-EMWO_EN-Save')")
    @ApiOperation(value = "根据设备类型设备档案保存能耗登记工单", tags = {"能耗登记工单" },  notes = "根据设备类型设备档案保存能耗登记工单")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emwo_ens/save")
    public ResponseEntity<Boolean> saveByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMWO_ENDTO emwo_endto) {
        EMWO_EN domain = emwo_enMapping.toDomain(emwo_endto);
        domain.setEquipid(emequip_id);
        return ResponseEntity.status(HttpStatus.OK).body(emwo_enService.save(domain));
    }

    @PreAuthorize("hasPermission(this.emwo_enMapping.toDomain(#emwo_endtos),'eam_practice01-EMWO_EN-Save')")
    @ApiOperation(value = "根据设备类型设备档案批量保存能耗登记工单", tags = {"能耗登记工单" },  notes = "根据设备类型设备档案批量保存能耗登记工单")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emwo_ens/savebatch")
    public ResponseEntity<Boolean> saveBatchByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @RequestBody List<EMWO_ENDTO> emwo_endtos) {
        List<EMWO_EN> domainlist=emwo_enMapping.toDomain(emwo_endtos);
        for(EMWO_EN domain:domainlist){
             domain.setEquipid(emequip_id);
        }
        emwo_enService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(this.emwo_enService.get(#emwo_en_id),'eam_practice01-EMWO_EN-Remove')")
    @ApiOperation(value = "根据设备类型设备档案删除能耗登记工单", tags = {"能耗登记工单" },  notes = "根据设备类型设备档案删除能耗登记工单")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emwo_ens/{emwo_en_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emwo_en_id") String emwo_en_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emwo_enService.remove(emwo_en_id));
    }

    @PreAuthorize("hasPermission(this.emwo_enService.getEmwoEnByIds(#ids),'eam_practice01-EMWO_EN-Remove')")
    @ApiOperation(value = "根据设备类型设备档案批量删除能耗登记工单", tags = {"能耗登记工单" },  notes = "根据设备类型设备档案批量删除能耗登记工单")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emwo_ens/batch")
    public ResponseEntity<Boolean> removeBatchByEMEQTypeEMEquip(@RequestBody List<String> ids) {
        emwo_enService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(this.emwo_enService.get(#emwo_en_id),'eam_practice01-EMWO_EN-Update')")
    @ApiOperation(value = "根据设备类型设备档案更新能耗登记工单", tags = {"能耗登记工单" },  notes = "根据设备类型设备档案更新能耗登记工单")
	@RequestMapping(method = RequestMethod.PUT, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emwo_ens/{emwo_en_id}")
    @Transactional
    public ResponseEntity<EMWO_ENDTO> updateByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emwo_en_id") String emwo_en_id, @RequestBody EMWO_ENDTO emwo_endto) {
        EMWO_EN domain = emwo_enMapping.toDomain(emwo_endto);
        domain.setEquipid(emequip_id);
        domain.setEmwoEnid(emwo_en_id);
		emwo_enService.update(domain);
        EMWO_ENDTO dto = emwo_enMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.emwo_enService.getEmwoEnByEntities(this.emwo_enMapping.toDomain(#emwo_endtos)),'eam_practice01-EMWO_EN-Update')")
    @ApiOperation(value = "根据设备类型设备档案批量更新能耗登记工单", tags = {"能耗登记工单" },  notes = "根据设备类型设备档案批量更新能耗登记工单")
	@RequestMapping(method = RequestMethod.PUT, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emwo_ens/batch")
    public ResponseEntity<Boolean> updateBatchByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @RequestBody List<EMWO_ENDTO> emwo_endtos) {
        List<EMWO_EN> domainlist=emwo_enMapping.toDomain(emwo_endtos);
        for(EMWO_EN domain:domainlist){
            domain.setEquipid(emequip_id);
        }
        emwo_enService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(this.emwo_enMapping.toDomain(#emwo_endto),'eam_practice01-EMWO_EN-Create')")
    @ApiOperation(value = "根据设备类型设备档案建立能耗登记工单", tags = {"能耗登记工单" },  notes = "根据设备类型设备档案建立能耗登记工单")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emwo_ens")
    @Transactional
    public ResponseEntity<EMWO_ENDTO> createByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMWO_ENDTO emwo_endto) {
        EMWO_EN domain = emwo_enMapping.toDomain(emwo_endto);
        domain.setEquipid(emequip_id);
		emwo_enService.create(domain);
        EMWO_ENDTO dto = emwo_enMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.emwo_enMapping.toDomain(#emwo_endtos),'eam_practice01-EMWO_EN-Create')")
    @ApiOperation(value = "根据设备类型设备档案批量建立能耗登记工单", tags = {"能耗登记工单" },  notes = "根据设备类型设备档案批量建立能耗登记工单")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emwo_ens/batch")
    public ResponseEntity<Boolean> createBatchByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @RequestBody List<EMWO_ENDTO> emwo_endtos) {
        List<EMWO_EN> domainlist=emwo_enMapping.toDomain(emwo_endtos);
        for(EMWO_EN domain:domainlist){
            domain.setEquipid(emequip_id);
        }
        emwo_enService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "根据设备类型设备档案检查能耗登记工单", tags = {"能耗登记工单" },  notes = "根据设备类型设备档案检查能耗登记工单")
	@RequestMapping(method = RequestMethod.POST, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emwo_ens/checkkey")
    public ResponseEntity<Boolean> checkKeyByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMWO_ENDTO emwo_endto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emwo_enService.checkKey(emwo_enMapping.toDomain(emwo_endto)));
    }

    @PostAuthorize("hasPermission(this.emwo_enMapping.toDomain(returnObject.body),'eam_practice01-EMWO_EN-Get')")
    @ApiOperation(value = "根据设备类型设备档案获取能耗登记工单", tags = {"能耗登记工单" },  notes = "根据设备类型设备档案获取能耗登记工单")
	@RequestMapping(method = RequestMethod.GET, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emwo_ens/{emwo_en_id}")
    public ResponseEntity<EMWO_ENDTO> getByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emwo_en_id") String emwo_en_id) {
        EMWO_EN domain = emwo_enService.get(emwo_en_id);
        EMWO_ENDTO dto = emwo_enMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "根据设备类型设备档案获取能耗登记工单草稿", tags = {"能耗登记工单" },  notes = "根据设备类型设备档案获取能耗登记工单草稿")
    @RequestMapping(method = RequestMethod.GET, value = "/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emwo_ens/getdraft")
    public ResponseEntity<EMWO_ENDTO> getDraftByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id) {
        EMWO_EN domain = new EMWO_EN();
        domain.setEquipid(emequip_id);
        return ResponseEntity.status(HttpStatus.OK).body(emwo_enMapping.toDto(emwo_enService.getDraft(domain)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWO_EN-Default-all')")
	@ApiOperation(value = "根据设备类型设备档案获取DEFAULT", tags = {"能耗登记工单" } ,notes = "根据设备类型设备档案获取DEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emwo_ens/fetchdefault")
	public ResponseEntity<List<EMWO_ENDTO>> fetchEMWO_ENDefaultByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id,EMWO_ENSearchContext context) {
        context.setN_equipid_eq(emequip_id);
        Page<EMWO_EN> domains = emwo_enService.searchDefault(context) ;
        List<EMWO_ENDTO> list = emwo_enMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWO_EN-Default-all')")
	@ApiOperation(value = "根据设备类型设备档案查询DEFAULT", tags = {"能耗登记工单" } ,notes = "根据设备类型设备档案查询DEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emeqtypes/{emeqtype_id}/emequips/{emequip_id}/emwo_ens/searchdefault")
	public ResponseEntity<Page<EMWO_ENDTO>> searchEMWO_ENDefaultByEMEQTypeEMEquip(@PathVariable("emeqtype_id") String emeqtype_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMWO_ENSearchContext context) {
        context.setN_equipid_eq(emequip_id);
        Page<EMWO_EN> domains = emwo_enService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emwo_enMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasPermission(this.emwo_enMapping.toDomain(#emwo_endto),'eam_practice01-EMWO_EN-Save')")
    @ApiOperation(value = "根据班组设备档案保存能耗登记工单", tags = {"能耗登记工单" },  notes = "根据班组设备档案保存能耗登记工单")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emwo_ens/save")
    public ResponseEntity<Boolean> saveByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMWO_ENDTO emwo_endto) {
        EMWO_EN domain = emwo_enMapping.toDomain(emwo_endto);
        domain.setEquipid(emequip_id);
        return ResponseEntity.status(HttpStatus.OK).body(emwo_enService.save(domain));
    }

    @PreAuthorize("hasPermission(this.emwo_enMapping.toDomain(#emwo_endtos),'eam_practice01-EMWO_EN-Save')")
    @ApiOperation(value = "根据班组设备档案批量保存能耗登记工单", tags = {"能耗登记工单" },  notes = "根据班组设备档案批量保存能耗登记工单")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emwo_ens/savebatch")
    public ResponseEntity<Boolean> saveBatchByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @RequestBody List<EMWO_ENDTO> emwo_endtos) {
        List<EMWO_EN> domainlist=emwo_enMapping.toDomain(emwo_endtos);
        for(EMWO_EN domain:domainlist){
             domain.setEquipid(emequip_id);
        }
        emwo_enService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(this.emwo_enService.get(#emwo_en_id),'eam_practice01-EMWO_EN-Remove')")
    @ApiOperation(value = "根据班组设备档案删除能耗登记工单", tags = {"能耗登记工单" },  notes = "根据班组设备档案删除能耗登记工单")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emwo_ens/{emwo_en_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emwo_en_id") String emwo_en_id) {
		return ResponseEntity.status(HttpStatus.OK).body(emwo_enService.remove(emwo_en_id));
    }

    @PreAuthorize("hasPermission(this.emwo_enService.getEmwoEnByIds(#ids),'eam_practice01-EMWO_EN-Remove')")
    @ApiOperation(value = "根据班组设备档案批量删除能耗登记工单", tags = {"能耗登记工单" },  notes = "根据班组设备档案批量删除能耗登记工单")
	@RequestMapping(method = RequestMethod.DELETE, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emwo_ens/batch")
    public ResponseEntity<Boolean> removeBatchByPFTeamEMEquip(@RequestBody List<String> ids) {
        emwo_enService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(this.emwo_enService.get(#emwo_en_id),'eam_practice01-EMWO_EN-Update')")
    @ApiOperation(value = "根据班组设备档案更新能耗登记工单", tags = {"能耗登记工单" },  notes = "根据班组设备档案更新能耗登记工单")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emwo_ens/{emwo_en_id}")
    @Transactional
    public ResponseEntity<EMWO_ENDTO> updateByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emwo_en_id") String emwo_en_id, @RequestBody EMWO_ENDTO emwo_endto) {
        EMWO_EN domain = emwo_enMapping.toDomain(emwo_endto);
        domain.setEquipid(emequip_id);
        domain.setEmwoEnid(emwo_en_id);
		emwo_enService.update(domain);
        EMWO_ENDTO dto = emwo_enMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.emwo_enService.getEmwoEnByEntities(this.emwo_enMapping.toDomain(#emwo_endtos)),'eam_practice01-EMWO_EN-Update')")
    @ApiOperation(value = "根据班组设备档案批量更新能耗登记工单", tags = {"能耗登记工单" },  notes = "根据班组设备档案批量更新能耗登记工单")
	@RequestMapping(method = RequestMethod.PUT, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emwo_ens/batch")
    public ResponseEntity<Boolean> updateBatchByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @RequestBody List<EMWO_ENDTO> emwo_endtos) {
        List<EMWO_EN> domainlist=emwo_enMapping.toDomain(emwo_endtos);
        for(EMWO_EN domain:domainlist){
            domain.setEquipid(emequip_id);
        }
        emwo_enService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(this.emwo_enMapping.toDomain(#emwo_endto),'eam_practice01-EMWO_EN-Create')")
    @ApiOperation(value = "根据班组设备档案建立能耗登记工单", tags = {"能耗登记工单" },  notes = "根据班组设备档案建立能耗登记工单")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emwo_ens")
    @Transactional
    public ResponseEntity<EMWO_ENDTO> createByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMWO_ENDTO emwo_endto) {
        EMWO_EN domain = emwo_enMapping.toDomain(emwo_endto);
        domain.setEquipid(emequip_id);
		emwo_enService.create(domain);
        EMWO_ENDTO dto = emwo_enMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.emwo_enMapping.toDomain(#emwo_endtos),'eam_practice01-EMWO_EN-Create')")
    @ApiOperation(value = "根据班组设备档案批量建立能耗登记工单", tags = {"能耗登记工单" },  notes = "根据班组设备档案批量建立能耗登记工单")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emwo_ens/batch")
    public ResponseEntity<Boolean> createBatchByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @RequestBody List<EMWO_ENDTO> emwo_endtos) {
        List<EMWO_EN> domainlist=emwo_enMapping.toDomain(emwo_endtos);
        for(EMWO_EN domain:domainlist){
            domain.setEquipid(emequip_id);
        }
        emwo_enService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "根据班组设备档案检查能耗登记工单", tags = {"能耗登记工单" },  notes = "根据班组设备档案检查能耗登记工单")
	@RequestMapping(method = RequestMethod.POST, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emwo_ens/checkkey")
    public ResponseEntity<Boolean> checkKeyByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMWO_ENDTO emwo_endto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emwo_enService.checkKey(emwo_enMapping.toDomain(emwo_endto)));
    }

    @PostAuthorize("hasPermission(this.emwo_enMapping.toDomain(returnObject.body),'eam_practice01-EMWO_EN-Get')")
    @ApiOperation(value = "根据班组设备档案获取能耗登记工单", tags = {"能耗登记工单" },  notes = "根据班组设备档案获取能耗登记工单")
	@RequestMapping(method = RequestMethod.GET, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emwo_ens/{emwo_en_id}")
    public ResponseEntity<EMWO_ENDTO> getByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @PathVariable("emwo_en_id") String emwo_en_id) {
        EMWO_EN domain = emwo_enService.get(emwo_en_id);
        EMWO_ENDTO dto = emwo_enMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "根据班组设备档案获取能耗登记工单草稿", tags = {"能耗登记工单" },  notes = "根据班组设备档案获取能耗登记工单草稿")
    @RequestMapping(method = RequestMethod.GET, value = "/pfteams/{pfteam_id}/emequips/{emequip_id}/emwo_ens/getdraft")
    public ResponseEntity<EMWO_ENDTO> getDraftByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id) {
        EMWO_EN domain = new EMWO_EN();
        domain.setEquipid(emequip_id);
        return ResponseEntity.status(HttpStatus.OK).body(emwo_enMapping.toDto(emwo_enService.getDraft(domain)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWO_EN-Default-all')")
	@ApiOperation(value = "根据班组设备档案获取DEFAULT", tags = {"能耗登记工单" } ,notes = "根据班组设备档案获取DEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/pfteams/{pfteam_id}/emequips/{emequip_id}/emwo_ens/fetchdefault")
	public ResponseEntity<List<EMWO_ENDTO>> fetchEMWO_ENDefaultByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id,EMWO_ENSearchContext context) {
        context.setN_equipid_eq(emequip_id);
        Page<EMWO_EN> domains = emwo_enService.searchDefault(context) ;
        List<EMWO_ENDTO> list = emwo_enMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMWO_EN-Default-all')")
	@ApiOperation(value = "根据班组设备档案查询DEFAULT", tags = {"能耗登记工单" } ,notes = "根据班组设备档案查询DEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/pfteams/{pfteam_id}/emequips/{emequip_id}/emwo_ens/searchdefault")
	public ResponseEntity<Page<EMWO_ENDTO>> searchEMWO_ENDefaultByPFTeamEMEquip(@PathVariable("pfteam_id") String pfteam_id, @PathVariable("emequip_id") String emequip_id, @RequestBody EMWO_ENSearchContext context) {
        context.setN_equipid_eq(emequip_id);
        Page<EMWO_EN> domains = emwo_enService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emwo_enMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
}

