package cn.ibizlab.eam.webapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.access.prepost.PostAuthorize;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.eam.webapi.dto.*;
import cn.ibizlab.eam.webapi.mapping.*;
import cn.ibizlab.eam.core.eam_core.domain.EMItemPL;
import cn.ibizlab.eam.core.eam_core.service.IEMItemPLService;
import cn.ibizlab.eam.core.eam_core.filter.EMItemPLSearchContext;

@Slf4j
@Api(tags = {"损溢单" })
@RestController("WebApi-emitempl")
@RequestMapping("")
public class EMItemPLResource {

    @Autowired
    public IEMItemPLService emitemplService;

    @Autowired
    @Lazy
    public EMItemPLMapping emitemplMapping;

    @PreAuthorize("hasPermission(this.emitemplService.get(#emitempl_id),'eam_practice01-EMItemPL-Update')")
    @ApiOperation(value = "更新损溢单", tags = {"损溢单" },  notes = "更新损溢单")
	@RequestMapping(method = RequestMethod.PUT, value = "/emitempls/{emitempl_id}")
    @Transactional
    public ResponseEntity<EMItemPLDTO> update(@PathVariable("emitempl_id") String emitempl_id, @RequestBody EMItemPLDTO emitempldto) {
		EMItemPL domain  = emitemplMapping.toDomain(emitempldto);
        domain .setEmitemplid(emitempl_id);
		emitemplService.update(domain );
		EMItemPLDTO dto = emitemplMapping.toDto(domain );
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.emitemplService.getEmitemplByEntities(this.emitemplMapping.toDomain(#emitempldtos)),'eam_practice01-EMItemPL-Update')")
    @ApiOperation(value = "批量更新损溢单", tags = {"损溢单" },  notes = "批量更新损溢单")
	@RequestMapping(method = RequestMethod.PUT, value = "/emitempls/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<EMItemPLDTO> emitempldtos) {
        emitemplService.updateBatch(emitemplMapping.toDomain(emitempldtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(this.emitemplMapping.toDomain(#emitempldto),'eam_practice01-EMItemPL-Create')")
    @ApiOperation(value = "新建损溢单", tags = {"损溢单" },  notes = "新建损溢单")
	@RequestMapping(method = RequestMethod.POST, value = "/emitempls")
    @Transactional
    public ResponseEntity<EMItemPLDTO> create(@RequestBody EMItemPLDTO emitempldto) {
        EMItemPL domain = emitemplMapping.toDomain(emitempldto);
		emitemplService.create(domain);
        EMItemPLDTO dto = emitemplMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.emitemplMapping.toDomain(#emitempldtos),'eam_practice01-EMItemPL-Create')")
    @ApiOperation(value = "批量新建损溢单", tags = {"损溢单" },  notes = "批量新建损溢单")
	@RequestMapping(method = RequestMethod.POST, value = "/emitempls/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<EMItemPLDTO> emitempldtos) {
        emitemplService.createBatch(emitemplMapping.toDomain(emitempldtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(this.emitemplMapping.toDomain(#emitempldto),'eam_practice01-EMItemPL-Save')")
    @ApiOperation(value = "保存损溢单", tags = {"损溢单" },  notes = "保存损溢单")
	@RequestMapping(method = RequestMethod.POST, value = "/emitempls/save")
    public ResponseEntity<Boolean> save(@RequestBody EMItemPLDTO emitempldto) {
        return ResponseEntity.status(HttpStatus.OK).body(emitemplService.save(emitemplMapping.toDomain(emitempldto)));
    }

    @PreAuthorize("hasPermission(this.emitemplMapping.toDomain(#emitempldtos),'eam_practice01-EMItemPL-Save')")
    @ApiOperation(value = "批量保存损溢单", tags = {"损溢单" },  notes = "批量保存损溢单")
	@RequestMapping(method = RequestMethod.POST, value = "/emitempls/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<EMItemPLDTO> emitempldtos) {
        emitemplService.saveBatch(emitemplMapping.toDomain(emitempldtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "检查损溢单", tags = {"损溢单" },  notes = "检查损溢单")
	@RequestMapping(method = RequestMethod.POST, value = "/emitempls/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody EMItemPLDTO emitempldto) {
        return  ResponseEntity.status(HttpStatus.OK).body(emitemplService.checkKey(emitemplMapping.toDomain(emitempldto)));
    }

    @PreAuthorize("hasPermission(this.emitemplService.get(#emitempl_id),'eam_practice01-EMItemPL-Remove')")
    @ApiOperation(value = "删除损溢单", tags = {"损溢单" },  notes = "删除损溢单")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emitempls/{emitempl_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("emitempl_id") String emitempl_id) {
         return ResponseEntity.status(HttpStatus.OK).body(emitemplService.remove(emitempl_id));
    }

    @PreAuthorize("hasPermission(this.emitemplService.getEmitemplByIds(#ids),'eam_practice01-EMItemPL-Remove')")
    @ApiOperation(value = "批量删除损溢单", tags = {"损溢单" },  notes = "批量删除损溢单")
	@RequestMapping(method = RequestMethod.DELETE, value = "/emitempls/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        emitemplService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PostAuthorize("hasPermission(this.emitemplMapping.toDomain(returnObject.body),'eam_practice01-EMItemPL-Get')")
    @ApiOperation(value = "获取损溢单", tags = {"损溢单" },  notes = "获取损溢单")
	@RequestMapping(method = RequestMethod.GET, value = "/emitempls/{emitempl_id}")
    public ResponseEntity<EMItemPLDTO> get(@PathVariable("emitempl_id") String emitempl_id) {
        EMItemPL domain = emitemplService.get(emitempl_id);
        EMItemPLDTO dto = emitemplMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "获取损溢单草稿", tags = {"损溢单" },  notes = "获取损溢单草稿")
	@RequestMapping(method = RequestMethod.GET, value = "/emitempls/getdraft")
    public ResponseEntity<EMItemPLDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(emitemplMapping.toDto(emitemplService.getDraft(new EMItemPL())));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMItemPL-Default-all')")
	@ApiOperation(value = "获取DEFAULT", tags = {"损溢单" } ,notes = "获取DEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/emitempls/fetchdefault")
	public ResponseEntity<List<EMItemPLDTO>> fetchDefault(EMItemPLSearchContext context) {
        Page<EMItemPL> domains = emitemplService.searchDefault(context) ;
        List<EMItemPLDTO> list = emitemplMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','eam_practice01-EMItemPL-Default-all')")
	@ApiOperation(value = "查询DEFAULT", tags = {"损溢单" } ,notes = "查询DEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/emitempls/searchdefault")
	public ResponseEntity<Page<EMItemPLDTO>> searchDefault(@RequestBody EMItemPLSearchContext context) {
        Page<EMItemPL> domains = emitemplService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(emitemplMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
}

