/**
 * WFIndexView 部件模型
 *
 * @export
 * @class WFIndexViewModel
 */
export default class WFIndexViewModel {

    /**
     * 菜单项集合
     *
     * @private
     * @type {any[]}
     * @memberof WFIndexViewModel
     */
    private items: any[] = [
        {
	id: 'DE6BF5A8-9640-47AF-9AE7-7C73C5FCC8BF',
	name: 'menuitem1',
	text: '流程定义',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '流程定义',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: '_2',
	resourcetag: '',
},
        {
	id: 'A2004B9C-B0CE-4180-8C76-6FD90059F17B',
	name: 'menuitem2',
	text: '用户组',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '用户组',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: '_3',
	resourcetag: '',
},
    ];

	/**
	 * 应用功能集合
	 *
	 * @private
	 * @type {any[]}
	 * @memberof WFIndexViewModel
	 */
	private funcs: any[] = [
        {
            appfunctag: '_2',
            appfuncyype: 'APPVIEW',
            openmode: '',
            codename: 'wfprocessdefinitiongridview',
            deResParameters: [],
            routepath: '/wfindexview/:wfindexview?/wfprocessdefinitions/:wfprocessdefinition?/gridview/:gridview?',
            parameters: [
                { pathName: 'wfprocessdefinitions', parameterName: 'wfprocessdefinition' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
        },
        {
            appfunctag: '_3',
            appfuncyype: 'APPVIEW',
            openmode: '',
            codename: 'wfgroupgridview',
            deResParameters: [],
            routepath: '/wfindexview/:wfindexview?/wfgroups/:wfgroup?/gridview/:gridview?',
            parameters: [
                { pathName: 'wfgroups', parameterName: 'wfgroup' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
        },
	];

    /**
     * 获取所有菜单项集合
     *
     * @returns {any[]}
     * @memberof WFIndexViewModel
     */
    public getAppMenuItems(): any[] {
        return this.items;
    }

    /**
     * 获取所有应用功能集合
     *
     * @returns {any[]}
     * @memberof WFIndexViewModel
     */
    public getAppFuncs(): any[] {
        return this.funcs;
    }
}