package cn.ibizlab.core.workflow.domain;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.util.ObjectUtils;
import org.springframework.util.DigestUtils;
import cn.ibizlab.util.domain.EntityBase;
import cn.ibizlab.util.annotation.DEField;
import cn.ibizlab.util.enums.DEPredefinedFieldType;
import cn.ibizlab.util.enums.DEFieldDefaultValueType;
import cn.ibizlab.util.helper.DataObject;
import cn.ibizlab.util.enums.DupCheck;
import java.io.Serializable;
import lombok.*;
import org.springframework.data.annotation.Transient;
import cn.ibizlab.util.annotation.Audit;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;


/**
 * [操作路径] 对象
 */
@Builder
@Getter
@Setter
@NoArgsConstructor
@AllArgsConstructor
@ApiModel("操作路径")
public class WFTaskWay extends EntityBase implements Serializable {

    /**
     * 路径标识
     */
    @DEField(name = "wayid", isKeyField = true)
    @JSONField(name = "sequenceFlowId")
    @JsonProperty("sequenceFlowId")
    @ApiModelProperty("路径标识")
    private String sequenceflowid;

    /**
     * 路径标识
     */
    @DEField(name = "wayname")
    @JSONField(name = "sequenceFlowName")
    @JsonProperty("sequenceFlowName")
    @ApiModelProperty("路径标识")
    private String sequenceflowname;

    /**
     * 任务标识
     */
    @JSONField(name = "taskId")
    @JsonProperty("taskId")
    @ApiModelProperty("任务标识")
    private String taskid;

    /**
     * TaskDefinitionKey
     */
    @JSONField(name = "taskDefinitionKey")
    @JsonProperty("taskDefinitionKey")
    @ApiModelProperty("TaskDefinitionKey")
    private String taskdefinitionkey;

    /**
     * 实例标识
     */
    @DEField(name = "instanceid")
    @JSONField(name = "processInstanceId")
    @JsonProperty("processInstanceId")
    @ApiModelProperty("实例标识")
    private String processinstanceid;

    /**
     * DefinitionKey
     */
    @DEField(name = "definitionkey")
    @JSONField(name = "processDefinitionKey")
    @JsonProperty("processDefinitionKey")
    @ApiModelProperty("DefinitionKey")
    private String processdefinitionkey;

    /**
     * 业务键值
     */
    @DEField(name = "businesskey")
    @JSONField(name = "processInstanceBusinessKey")
    @JsonProperty("processInstanceBusinessKey")
    @ApiModelProperty("业务键值")
    private String processinstancebusinesskey;

    /**
     * 引用视图
     */
    @JSONField(name = "refViewKey")
    @JsonProperty("refViewKey")
    @ApiModelProperty("引用视图")
    private String refviewkey;




}


