package cn.ibizlab.core.workflow.domain;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import java.math.BigDecimal;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.util.ObjectUtils;
import org.springframework.util.DigestUtils;
import cn.ibizlab.util.domain.EntityBase;
import cn.ibizlab.util.annotation.DEField;
import cn.ibizlab.util.enums.DEPredefinedFieldType;
import cn.ibizlab.util.enums.DEFieldDefaultValueType;
import java.io.Serializable;
import lombok.*;
import org.springframework.data.annotation.Transient;

import cn.ibizlab.util.domain.EntityClient;

/**
 * ServiceApi [流程实例] 对象
 */
@Data
public class WFProcessInstance extends EntityClient implements Serializable {

    /**
     * 实例标识
     */
    @DEField(name = "instanceid" , isKeyField=true)
    @JSONField(name = "id")
    @JsonProperty("id")
    private String id;

    /**
     * 实例名称
     */
    @DEField(name = "instancename")
    @JSONField(name = "name")
    @JsonProperty("name")
    private String name;

    /**
     * DefinitionKey
     */
    @DEField(name = "definitionkey")
    @JSONField(name = "processDefinitionKey")
    @JsonProperty("processDefinitionKey")
    private String processdefinitionkey;

    /**
     * 流程定义名称
     */
    @DEField(name = "definitionname")
    @JSONField(name = "processDefinitionName")
    @JsonProperty("processDefinitionName")
    private String processdefinitionname;

    /**
     * 业务键值
     */
    @JSONField(name = "businessKey")
    @JsonProperty("businessKey")
    private String businesskey;

    /**
     * 启动时间
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "startTime" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("startTime")
    private Timestamp starttime;

    /**
     * 结束时间
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "endTime" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("endTime")
    private Timestamp endtime;

    /**
     * 发起人标识
     */
    @JSONField(name = "startUserId")
    @JsonProperty("startUserId")
    private String startuserid;

    /**
     * 发起人
     */
    @JSONField(name = "startUserName")
    @JsonProperty("startUserName")
    private String startusername;





    /**
     * 设置 [实例名称]
     */
    public void setName(String name){
        this.name = name ;
        this.modify("instancename",name);
    }
    /**
     * 设置 [DefinitionKey]
     */
    public void setProcessdefinitionkey(String processdefinitionkey){
        this.processdefinitionkey = processdefinitionkey ;
        this.modify("definitionkey",processdefinitionkey);
    }
    /**
     * 设置 [流程定义名称]
     */
    public void setProcessdefinitionname(String processdefinitionname){
        this.processdefinitionname = processdefinitionname ;
        this.modify("definitionname",processdefinitionname);
    }
    /**
     * 设置 [业务键值]
     */
    public void setBusinesskey(String businesskey){
        this.businesskey = businesskey ;
        this.modify("businesskey",businesskey);
    }
    /**
     * 设置 [启动时间]
     */
    public void setStarttime(Timestamp starttime){
        this.starttime = starttime ;
        this.modify("starttime",starttime);
    }
    /**
     * 设置 [结束时间]
     */
    public void setEndtime(Timestamp endtime){
        this.endtime = endtime ;
        this.modify("endtime",endtime);
    }
    /**
     * 设置 [发起人标识]
     */
    public void setStartuserid(String startuserid){
        this.startuserid = startuserid ;
        this.modify("startuserid",startuserid);
    }
    /**
     * 设置 [发起人]
     */
    public void setStartusername(String startusername){
        this.startusername = startusername ;
        this.modify("startusername",startusername);
    }

}


