package cn.ibizlab.util.service;

import com.alibaba.fastjson.JSONObject;
import cn.ibizlab.util.client.IBZOUFeignClient;
import cn.ibizlab.util.client.IBZUAAFeignClient;
import cn.ibizlab.util.security.AuthenticationUser;
import cn.ibizlab.util.security.AuthorizationLogin;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;
import org.springframework.util.DigestUtils;
import org.springframework.util.StringUtils;

/**
 * 实体[IBZUSER] 服务对象接口实现
 */
//@Primary
@Service("IBZUAAUserService")
public class IBZUAAUserService implements AuthenticationUserService{

	@Autowired
	private IBZUAAFeignClient uaaFeignClient;

	@Override
	public AuthenticationUser loadUserByUsername(String username) {

		String[] data=username.split("[|]");
		String loginname=username;
		String domains="";
		String password="";

		if(data.length==3) {
			loginname=data[0].trim();
			domains=data[1].trim();
			password=data[2].trim();
		}
		else if(data.length==2) {
			loginname=data[0].trim();
			password=data[1].trim();
		}
		AuthorizationLogin user = new AuthorizationLogin();
		user.setDomain(domains);
		user.setLoginname(loginname);
		user.setPassword(password);
		return uaaFeignClient.login(user);
	}

	@Override
	public AuthenticationUser loadUserByLogin(String username, String password) {
		AuthenticationUser authuserdetail = loadUserByUsername(username+"|"+password);
		return authuserdetail;
	}

	@Override
	public AuthenticationUser loadUserByLogin(String domain, String username, String password) {
		if(!StringUtils.isEmpty(domain))
			username = username+"|"+domain;
		return loadUserByLogin(username,password);
	}

	@Override
	public void resetByUsername(String username) {

	}

}
