package cn.ibizlab.util.client.uaa;

import com.alibaba.fastjson.JSONObject;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;
import java.util.Map;

@FeignClient(value = "ibzuaa",fallback = UAAFallback.class)
public interface UAAFeignClient
{

	/**
	 * 从uaa中获取当前用户权限
	 * @param userId
	 * @param systemId
	 * @return
	 */
	@GetMapping(value = "/uaa/permission/{userid}")
    JSONObject getUserPermissionData(@PathVariable("userid") String userId, @RequestParam("systemid") String systemId);

	/**
	 * 推送系统权限数据到uaa
	 * @param systemPermissionData
	 * @param systemId
	 * @return
	 */
	@PostMapping("/uaa/permission/save")
	Map<String,Object> pushSystemPermissionData(@RequestBody Map<String, Object> systemPermissionData,  @RequestParam("systemid") String systemId);

}
