package cn.ibizlab;

import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.context.annotation.Configuration;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.springframework.boot.SpringApplication;
import org.springframework.cloud.openfeign.EnableFeignClients;

@Slf4j
@EnableDiscoveryClient
@Configuration
@EnableTransactionManagement
@SpringBootApplication
@EnableFeignClients(basePackages = {"cn.ibizlab" })
public class DevBootApplication{

    public static void main(String[] args) {
        SpringApplication.run(DevBootApplication.class,args);
    }
}
