/**
 * Main 部件模型
 *
 * @export
 * @class MainModel
 */
export default class MainModel {

    /**
     * 菜单项集合
     *
     * @private
     * @type {any[]}
     * @memberof MainModel
     */
    private items: any[] = [
        {
	id: 'f59655c22753740bbcf200f5cfee8a54',
	name: 'menuitem3',
	text: '用户管理',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '用户管理',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'Auto5',
	resourcetag: '',
},
        {
	id: 'db3e0d48d6e76a66784adc84edd90cdc',
	name: 'menuitem6',
	text: '角色',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '角色',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'Auto10',
	resourcetag: '',
},
        {
	id: 'aa34fa65ba436d9267830d242fcda6c5',
	name: 'menuitem7',
	text: '用户角色',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '用户角色',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'Auto8',
	resourcetag: '',
},
        {
	id: '6177ea33605de953767d48b120145efb',
	name: 'menuitem10',
	text: '权限',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '权限',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'Auto7',
	resourcetag: '',
},
        {
	id: '2794bbcfc7b3c81b431d1f2e808a793b',
	name: 'menuitem1',
	text: '角色权限',
	type: 'MENUITEM',
	counterid: '',
	tooltip: '角色权限',
	expanded: false,
	separator: false,
	hidden: false,
	hidesidebar: false,
	opendefault: false,
	iconcls: '',
	icon: '',
	textcls: '',
	appfunctag: 'Auto1',
	resourcetag: '',
},
    ];

	/**
	 * 应用功能集合
	 *
	 * @private
	 * @type {any[]}
	 * @memberof MainModel
	 */
	private funcs: any[] = [
        {
            appfunctag: 'Auto1',
            appfuncyype: 'APPVIEW',
            openmode: '',
            codename: 'sys_role_permissiongridview',
            deResParameters: [],
            routepath: '/index/:index?/sys_role_permissions/:sys_role_permission?/gridview/:gridview?',
            parameters: [
                { pathName: 'sys_role_permissions', parameterName: 'sys_role_permission' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
        },
        {
            appfunctag: 'Auto10',
            appfuncyype: 'APPVIEW',
            openmode: '',
            codename: 'sys_rolegridview',
            deResParameters: [],
            routepath: '/index/:index?/sys_roles/:sys_role?/gridview/:gridview?',
            parameters: [
                { pathName: 'sys_roles', parameterName: 'sys_role' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
        },
        {
            appfunctag: 'Auto5',
            appfuncyype: 'APPVIEW',
            openmode: '',
            codename: 'sys_usergridview',
            deResParameters: [],
            routepath: '/index/:index?/sys_users/:sys_user?/gridview/:gridview?',
            parameters: [
                { pathName: 'sys_users', parameterName: 'sys_user' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
        },
        {
            appfunctag: 'Auto8',
            appfuncyype: 'APPVIEW',
            openmode: '',
            codename: 'sys_user_rolegridview',
            deResParameters: [],
            routepath: '/index/:index?/sys_user_roles/:sys_user_role?/gridview/:gridview?',
            parameters: [
                { pathName: 'sys_user_roles', parameterName: 'sys_user_role' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
        },
        {
            appfunctag: 'Auto7',
            appfuncyype: 'APPVIEW',
            openmode: '',
            codename: 'sys_permissiongridview',
            deResParameters: [],
            routepath: '/index/:index?/sys_permissions/:sys_permission?/gridview/:gridview?',
            parameters: [
                { pathName: 'sys_permissions', parameterName: 'sys_permission' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
        },
	];

    /**
     * 获取所有菜单项集合
     *
     * @returns {any[]}
     * @memberof MainModel
     */
    public getAppMenuItems(): any[] {
        return this.items;
    }

    /**
     * 获取所有应用功能集合
     *
     * @returns {any[]}
     * @memberof MainModel
     */
    public getAppFuncs(): any[] {
        return this.funcs;
    }
}