/**
 * Main 部件模型
 *
 * @export
 * @class MainModel
 */
export default class MainModel {

	/**
	 * 是否是实体数据导出
	 *
	 * @returns {any[]}
	 * @memberof MainGridMode
	 */
	public isDEExport: boolean = false;

	/**
	 * 获取数据项集合
	 *
	 * @returns {any[]}
	 * @memberof MainGridMode
	 */
	public getDataItems(): any[] {
    if(this.isDEExport){
		  return [
      ]
    }else{
		  return [
        {
          name: 'accessname',
          prop: 'name',
          dataType: 'TEXT',
        },
        {
          name: 'redirect_uri',
          prop: 'redirect_uri',
          dataType: 'TEXT',
        },
        {
          name: 'region_id',
          prop: 'region_id',
          dataType: 'TEXT',
        },
        {
          name: 'access_key',
          prop: 'access_key',
          dataType: 'TEXT',
        },
        {
          name: 'accessid',
          prop: 'id',
          dataType: 'TEXT',
        },
        {
          name: 'open_type',
          prop: 'open_type',
          dataType: 'SSCODELIST',
        },
        {
          name: 'srfmajortext',
          prop: 'name',
          dataType: 'TEXT',
        },
        {
          name: 'srfdataaccaction',
          prop: 'id',
          dataType: 'TEXT',
        },
        {
          name: 'srfkey',
          prop: 'id',
          dataType: 'TEXT',
          isEditable:true
        },
        {
          name: 'disabled',
          prop: 'disabled',
          dataType: 'YESNO',
        },
        {
          name: 'sysopenaccess',
          prop: 'id',
        },
      {
        name: 'n_accessname_like',
        prop: 'n_accessname_like',
        dataType: 'TEXT',
      },
      {
        name: 'n_open_type_eq',
        prop: 'n_open_type_eq',
        dataType: 'SSCODELIST',
      },

        {
          name:'size',
          prop:'size'
        },
        {
          name:'query',
          prop:'query'
        },
        {
          name:'filter',
          prop:'filter'
        },
        {
          name:'page',
          prop:'page'
        },
        {
          name:'sort',
          prop:'sort'
        },
        {
          name:'srfparentdata',
          prop:'srfparentdata'
        },
        // 前端新增修改标识，新增为"0",修改为"1"或未设值
        {
          name: 'srffrontuf',
          prop: 'srffrontuf',
          dataType: 'TEXT',
        },
      ]
    }
  }

}