import { Http,Util } from '@/utils';
import EntityService from '../entity-service';



/**
 * 系统用户服务对象基类
 *
 * @export
 * @class SYS_USERServiceBase
 * @extends {EntityServie}
 */
export default class SYS_USERServiceBase extends EntityService {

    /**
     * Creates an instance of  SYS_USERServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  SYS_USERServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础数据
     *
     * @memberof SYS_USERServiceBase
     */
    public initBasicData(){
        this.APPLYDEKEY ='sys_user';
        this.APPDEKEY = 'userid';
        this.APPDENAME = 'sys_users';
        this.APPDETEXT = 'personname';
        this.APPNAME = 'web';
        this.SYSTEMNAME = 'ibzuaa';
    }

// 实体接口

    /**
     * Select接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof SYS_USERServiceBase
     */
    public async Select(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
            return Http.getInstance().get(`/sys_users/${context.sys_user}/select`,isloading);
    }

    /**
     * Remove接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof SYS_USERServiceBase
     */
    public async Remove(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
            return Http.getInstance().delete(`/sys_users/${context.sys_user}`,isloading);

    }

    /**
     * Update接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof SYS_USERServiceBase
     */
    public async Update(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let masterData:any = {};
        let sys_user_rolesData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_sys_user_roles'),'undefined')){
            sys_user_rolesData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_sys_user_roles') as any);
            if(sys_user_rolesData && sys_user_rolesData.length && sys_user_rolesData.length > 0){
                sys_user_rolesData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.userroleid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.sys_user_roles = sys_user_rolesData;
        Object.assign(data,masterData);
            let res:any = await  Http.getInstance().put(`/sys_users/${context.sys_user}`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_sys_user_roles',JSON.stringify(res.data.sys_user_roles));
            return res;
    }

    /**
     * CheckKey接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof SYS_USERServiceBase
     */
    public async CheckKey(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
            return Http.getInstance().post(`/sys_users/${context.sys_user}/checkkey`,data,isloading);
    }

    /**
     * Get接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof SYS_USERServiceBase
     */
    public async Get(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
            let res:any = await Http.getInstance().get(`/sys_users/${context.sys_user}`,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_sys_user_roles',JSON.stringify(res.data.sys_user_roles));
            return res;

    }

    /**
     * Save接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof SYS_USERServiceBase
     */
    public async Save(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let masterData:any = {};
        let sys_user_rolesData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_sys_user_roles'),'undefined')){
            sys_user_rolesData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_sys_user_roles') as any);
            if(sys_user_rolesData && sys_user_rolesData.length && sys_user_rolesData.length > 0){
                sys_user_rolesData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.userroleid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.sys_user_roles = sys_user_rolesData;
        Object.assign(data,masterData);
            let res:any = await  Http.getInstance().post(`/sys_users/${context.sys_user}/save`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_sys_user_roles',JSON.stringify(res.data.sys_user_roles));
            return res;
    }

    /**
     * GetDraft接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof SYS_USERServiceBase
     */
    public async GetDraft(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let res:any = await  Http.getInstance().get(`/sys_users/getdraft`,isloading);
        res.data.sys_user = data.sys_user;
            this.tempStorage.setItem(context.srfsessionkey+'_sys_user_roles',JSON.stringify(res.data.sys_user_roles));
        return res;
    }

    /**
     * Create接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof SYS_USERServiceBase
     */
    public async Create(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let masterData:any = {};
        let sys_user_rolesData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_sys_user_roles'),'undefined')){
            sys_user_rolesData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_sys_user_roles') as any);
            if(sys_user_rolesData && sys_user_rolesData.length && sys_user_rolesData.length > 0){
                sys_user_rolesData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.userroleid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.sys_user_roles = sys_user_rolesData;
        Object.assign(data,masterData);
        if(!data.srffrontuf || data.srffrontuf !== "1"){
            data[this.APPDEKEY] = null;
        }
        if(data.srffrontuf){
            delete data.srffrontuf;
        }
        let tempContext:any = JSON.parse(JSON.stringify(context));
        let res:any = await Http.getInstance().post(`/sys_users`,data,isloading);
        this.tempStorage.setItem(tempContext.srfsessionkey+'_sys_user_roles',JSON.stringify(res.data.sys_user_roles));
        return res;
    }

    /**
     * FetchDefault接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof SYS_USERServiceBase
     */
    public async FetchDefault(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let tempData:any = JSON.parse(JSON.stringify(data));
        return Http.getInstance().get(`/sys_users/fetchdefault`,tempData,isloading);
    }
}