import { Http,Util } from '@/utils';
import EntityService from '../entity-service';



/**
 * 用户角色关系服务对象基类
 *
 * @export
 * @class SYS_USER_ROLEServiceBase
 * @extends {EntityServie}
 */
export default class SYS_USER_ROLEServiceBase extends EntityService {

    /**
     * Creates an instance of  SYS_USER_ROLEServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  SYS_USER_ROLEServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础数据
     *
     * @memberof SYS_USER_ROLEServiceBase
     */
    public initBasicData(){
        this.APPLYDEKEY ='sys_user_role';
        this.APPDEKEY = 'userroleid';
        this.APPDENAME = 'sys_user_roles';
        this.APPDETEXT = 'userrolename';
        this.APPNAME = 'web';
        this.SYSTEMNAME = 'ibzuaa';
    }

// 实体接口

    /**
     * Select接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof SYS_USER_ROLEServiceBase
     */
    public async Select(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.sys_user && context.sys_user_role){
            return Http.getInstance().get(`/sys_users/${context.sys_user}/sys_user_roles/${context.sys_user_role}/select`,isloading);
        }
        if(context.sys_role && context.sys_user_role){
            return Http.getInstance().get(`/sys_roles/${context.sys_role}/sys_user_roles/${context.sys_user_role}/select`,isloading);
        }
            return Http.getInstance().get(`/sys_user_roles/${context.sys_user_role}/select`,isloading);
    }

    /**
     * CheckKey接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof SYS_USER_ROLEServiceBase
     */
    public async CheckKey(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.sys_user && context.sys_user_role){
            return Http.getInstance().post(`/sys_users/${context.sys_user}/sys_user_roles/${context.sys_user_role}/checkkey`,data,isloading);
        }
        if(context.sys_role && context.sys_user_role){
            return Http.getInstance().post(`/sys_roles/${context.sys_role}/sys_user_roles/${context.sys_user_role}/checkkey`,data,isloading);
        }
            return Http.getInstance().post(`/sys_user_roles/${context.sys_user_role}/checkkey`,data,isloading);
    }

    /**
     * GetDraft接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof SYS_USER_ROLEServiceBase
     */
    public async GetDraft(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.sys_user && true){
            return Http.getInstance().get(`/sys_users/${context.sys_user}/sys_user_roles/getdraft`,isloading);
        }
        if(context.sys_role && true){
            return Http.getInstance().get(`/sys_roles/${context.sys_role}/sys_user_roles/getdraft`,isloading);
        }
        let res:any = await  Http.getInstance().get(`/sys_user_roles/getdraft`,isloading);
        res.data.sys_user_role = data.sys_user_role;
        return res;
    }

    /**
     * Update接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof SYS_USER_ROLEServiceBase
     */
    public async Update(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.sys_user && context.sys_user_role){
            return Http.getInstance().put(`/sys_users/${context.sys_user}/sys_user_roles/${context.sys_user_role}`,data,isloading);
        }
        if(context.sys_role && context.sys_user_role){
            return Http.getInstance().put(`/sys_roles/${context.sys_role}/sys_user_roles/${context.sys_user_role}`,data,isloading);
        }
        let masterData:any = {};
        Object.assign(data,masterData);
            let res:any = await  Http.getInstance().put(`/sys_user_roles/${context.sys_user_role}`,data,isloading);
            return res;
    }

    /**
     * Remove接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof SYS_USER_ROLEServiceBase
     */
    public async Remove(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.sys_user && context.sys_user_role){
            return Http.getInstance().delete(`/sys_users/${context.sys_user}/sys_user_roles/${context.sys_user_role}`,isloading);
        }
        if(context.sys_role && context.sys_user_role){
            return Http.getInstance().delete(`/sys_roles/${context.sys_role}/sys_user_roles/${context.sys_user_role}`,isloading);
        }
            return Http.getInstance().delete(`/sys_user_roles/${context.sys_user_role}`,isloading);

    }

    /**
     * Create接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof SYS_USER_ROLEServiceBase
     */
    public async Create(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.sys_user && true){
            if(!data.srffrontuf || data.srffrontuf !== "1"){
                data[this.APPDEKEY] = null;
            }
            if(data.srffrontuf){
                delete data.srffrontuf;
            }
            return Http.getInstance().post(`/sys_users/${context.sys_user}/sys_user_roles`,data,isloading);
        }
        if(context.sys_role && true){
            if(!data.srffrontuf || data.srffrontuf !== "1"){
                data[this.APPDEKEY] = null;
            }
            if(data.srffrontuf){
                delete data.srffrontuf;
            }
            return Http.getInstance().post(`/sys_roles/${context.sys_role}/sys_user_roles`,data,isloading);
        }
        let masterData:any = {};
        Object.assign(data,masterData);
        if(!data.srffrontuf || data.srffrontuf !== "1"){
            data[this.APPDEKEY] = null;
        }
        if(data.srffrontuf){
            delete data.srffrontuf;
        }
        let tempContext:any = JSON.parse(JSON.stringify(context));
        let res:any = await Http.getInstance().post(`/sys_user_roles`,data,isloading);
        return res;
    }

    /**
     * Get接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof SYS_USER_ROLEServiceBase
     */
    public async Get(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.sys_user && context.sys_user_role){
            return Http.getInstance().get(`/sys_users/${context.sys_user}/sys_user_roles/${context.sys_user_role}`,isloading);
        }
        if(context.sys_role && context.sys_user_role){
            return Http.getInstance().get(`/sys_roles/${context.sys_role}/sys_user_roles/${context.sys_user_role}`,isloading);
        }
            let res:any = await Http.getInstance().get(`/sys_user_roles/${context.sys_user_role}`,isloading);
            return res;

    }

    /**
     * Save接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof SYS_USER_ROLEServiceBase
     */
    public async Save(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.sys_user && context.sys_user_role){
            return Http.getInstance().post(`/sys_users/${context.sys_user}/sys_user_roles/${context.sys_user_role}/save`,data,isloading);
        }
        if(context.sys_role && context.sys_user_role){
            return Http.getInstance().post(`/sys_roles/${context.sys_role}/sys_user_roles/${context.sys_user_role}/save`,data,isloading);
        }
        let masterData:any = {};
        Object.assign(data,masterData);
            let res:any = await  Http.getInstance().post(`/sys_user_roles/${context.sys_user_role}/save`,data,isloading);
            return res;
    }

    /**
     * FetchDefault接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof SYS_USER_ROLEServiceBase
     */
    public async FetchDefault(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.sys_user && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/sys_users/${context.sys_user}/sys_user_roles/fetchdefault`,tempData,isloading);
        }
        if(context.sys_role && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/sys_roles/${context.sys_role}/sys_user_roles/fetchdefault`,tempData,isloading);
        }
        let tempData:any = JSON.parse(JSON.stringify(data));
        return Http.getInstance().get(`/sys_user_roles/fetchdefault`,tempData,isloading);
    }
}