import { Http,Util } from '@/utils';
import EntityService from '../entity-service';



/**
 * 系统角色服务对象基类
 *
 * @export
 * @class SYS_ROLEServiceBase
 * @extends {EntityServie}
 */
export default class SYS_ROLEServiceBase extends EntityService {

    /**
     * Creates an instance of  SYS_ROLEServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  SYS_ROLEServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础数据
     *
     * @memberof SYS_ROLEServiceBase
     */
    public initBasicData(){
        this.APPLYDEKEY ='sys_role';
        this.APPDEKEY = 'roleid';
        this.APPDENAME = 'sys_roles';
        this.APPDETEXT = 'rolename';
        this.APPNAME = 'web';
        this.SYSTEMNAME = 'ibzuaa';
    }

// 实体接口

    /**
     * Select接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof SYS_ROLEServiceBase
     */
    public async Select(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
            return Http.getInstance().get(`/sys_roles/${context.sys_role}/select`,isloading);
    }

    /**
     * Save接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof SYS_ROLEServiceBase
     */
    public async Save(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let masterData:any = {};
        let sys_role_permissionsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_sys_role_permissions'),'undefined')){
            sys_role_permissionsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_sys_role_permissions') as any);
            if(sys_role_permissionsData && sys_role_permissionsData.length && sys_role_permissionsData.length > 0){
                sys_role_permissionsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.rolepermissionid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.sys_role_permissions = sys_role_permissionsData;
        let sys_user_rolesData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_sys_user_roles'),'undefined')){
            sys_user_rolesData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_sys_user_roles') as any);
            if(sys_user_rolesData && sys_user_rolesData.length && sys_user_rolesData.length > 0){
                sys_user_rolesData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.userroleid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.sys_user_roles = sys_user_rolesData;
        Object.assign(data,masterData);
            let res:any = await  Http.getInstance().post(`/sys_roles/${context.sys_role}/save`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_sys_role_permissions',JSON.stringify(res.data.sys_role_permissions));
            this.tempStorage.setItem(context.srfsessionkey+'_sys_user_roles',JSON.stringify(res.data.sys_user_roles));
            return res;
    }

    /**
     * Update接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof SYS_ROLEServiceBase
     */
    public async Update(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let masterData:any = {};
        let sys_role_permissionsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_sys_role_permissions'),'undefined')){
            sys_role_permissionsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_sys_role_permissions') as any);
            if(sys_role_permissionsData && sys_role_permissionsData.length && sys_role_permissionsData.length > 0){
                sys_role_permissionsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.rolepermissionid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.sys_role_permissions = sys_role_permissionsData;
        let sys_user_rolesData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_sys_user_roles'),'undefined')){
            sys_user_rolesData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_sys_user_roles') as any);
            if(sys_user_rolesData && sys_user_rolesData.length && sys_user_rolesData.length > 0){
                sys_user_rolesData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.userroleid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.sys_user_roles = sys_user_rolesData;
        Object.assign(data,masterData);
            let res:any = await  Http.getInstance().put(`/sys_roles/${context.sys_role}`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_sys_role_permissions',JSON.stringify(res.data.sys_role_permissions));
            this.tempStorage.setItem(context.srfsessionkey+'_sys_user_roles',JSON.stringify(res.data.sys_user_roles));
            return res;
    }

    /**
     * Create接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof SYS_ROLEServiceBase
     */
    public async Create(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let masterData:any = {};
        let sys_role_permissionsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_sys_role_permissions'),'undefined')){
            sys_role_permissionsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_sys_role_permissions') as any);
            if(sys_role_permissionsData && sys_role_permissionsData.length && sys_role_permissionsData.length > 0){
                sys_role_permissionsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.rolepermissionid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.sys_role_permissions = sys_role_permissionsData;
        let sys_user_rolesData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_sys_user_roles'),'undefined')){
            sys_user_rolesData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_sys_user_roles') as any);
            if(sys_user_rolesData && sys_user_rolesData.length && sys_user_rolesData.length > 0){
                sys_user_rolesData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.userroleid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.sys_user_roles = sys_user_rolesData;
        Object.assign(data,masterData);
        if(!data.srffrontuf || data.srffrontuf !== "1"){
            data[this.APPDEKEY] = null;
        }
        if(data.srffrontuf){
            delete data.srffrontuf;
        }
        let tempContext:any = JSON.parse(JSON.stringify(context));
        let res:any = await Http.getInstance().post(`/sys_roles`,data,isloading);
        this.tempStorage.setItem(tempContext.srfsessionkey+'_sys_role_permissions',JSON.stringify(res.data.sys_role_permissions));
        this.tempStorage.setItem(tempContext.srfsessionkey+'_sys_user_roles',JSON.stringify(res.data.sys_user_roles));
        return res;
    }

    /**
     * Get接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof SYS_ROLEServiceBase
     */
    public async Get(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
            let res:any = await Http.getInstance().get(`/sys_roles/${context.sys_role}`,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_sys_role_permissions',JSON.stringify(res.data.sys_role_permissions));
            this.tempStorage.setItem(context.srfsessionkey+'_sys_user_roles',JSON.stringify(res.data.sys_user_roles));
            return res;

    }

    /**
     * Remove接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof SYS_ROLEServiceBase
     */
    public async Remove(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
            return Http.getInstance().delete(`/sys_roles/${context.sys_role}`,isloading);

    }

    /**
     * GetDraft接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof SYS_ROLEServiceBase
     */
    public async GetDraft(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let res:any = await  Http.getInstance().get(`/sys_roles/getdraft`,isloading);
        res.data.sys_role = data.sys_role;
            this.tempStorage.setItem(context.srfsessionkey+'_sys_role_permissions',JSON.stringify(res.data.sys_role_permissions));
            this.tempStorage.setItem(context.srfsessionkey+'_sys_user_roles',JSON.stringify(res.data.sys_user_roles));
        return res;
    }

    /**
     * CheckKey接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof SYS_ROLEServiceBase
     */
    public async CheckKey(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
            return Http.getInstance().post(`/sys_roles/${context.sys_role}/checkkey`,data,isloading);
    }

    /**
     * FetchDefault接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof SYS_ROLEServiceBase
     */
    public async FetchDefault(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let tempData:any = JSON.parse(JSON.stringify(data));
        return Http.getInstance().get(`/sys_roles/fetchdefault`,tempData,isloading);
    }
}