import { Http,Util } from '@/utils';
import EntityService from '../entity-service';



/**
 * 角色权限关系服务对象基类
 *
 * @export
 * @class SYS_ROLE_PERMISSIONServiceBase
 * @extends {EntityServie}
 */
export default class SYS_ROLE_PERMISSIONServiceBase extends EntityService {

    /**
     * Creates an instance of  SYS_ROLE_PERMISSIONServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  SYS_ROLE_PERMISSIONServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础数据
     *
     * @memberof SYS_ROLE_PERMISSIONServiceBase
     */
    public initBasicData(){
        this.APPLYDEKEY ='sys_role_permission';
        this.APPDEKEY = 'rolepermissionid';
        this.APPDENAME = 'sys_role_permissions';
        this.APPDETEXT = 'rolepermission';
        this.APPNAME = 'web';
        this.SYSTEMNAME = 'ibzuaa';
    }

// 实体接口

    /**
     * Select接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof SYS_ROLE_PERMISSIONServiceBase
     */
    public async Select(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.sys_role && context.sys_role_permission){
            return Http.getInstance().get(`/sys_roles/${context.sys_role}/sys_role_permissions/${context.sys_role_permission}/select`,isloading);
        }
        if(context.sys_permission && context.sys_role_permission){
            return Http.getInstance().get(`/sys_permissions/${context.sys_permission}/sys_role_permissions/${context.sys_role_permission}/select`,isloading);
        }
            return Http.getInstance().get(`/sys_role_permissions/${context.sys_role_permission}/select`,isloading);
    }

    /**
     * Get接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof SYS_ROLE_PERMISSIONServiceBase
     */
    public async Get(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.sys_role && context.sys_role_permission){
            return Http.getInstance().get(`/sys_roles/${context.sys_role}/sys_role_permissions/${context.sys_role_permission}`,isloading);
        }
        if(context.sys_permission && context.sys_role_permission){
            return Http.getInstance().get(`/sys_permissions/${context.sys_permission}/sys_role_permissions/${context.sys_role_permission}`,isloading);
        }
            let res:any = await Http.getInstance().get(`/sys_role_permissions/${context.sys_role_permission}`,isloading);
            return res;

    }

    /**
     * Remove接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof SYS_ROLE_PERMISSIONServiceBase
     */
    public async Remove(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.sys_role && context.sys_role_permission){
            return Http.getInstance().delete(`/sys_roles/${context.sys_role}/sys_role_permissions/${context.sys_role_permission}`,isloading);
        }
        if(context.sys_permission && context.sys_role_permission){
            return Http.getInstance().delete(`/sys_permissions/${context.sys_permission}/sys_role_permissions/${context.sys_role_permission}`,isloading);
        }
            return Http.getInstance().delete(`/sys_role_permissions/${context.sys_role_permission}`,isloading);

    }

    /**
     * GetDraft接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof SYS_ROLE_PERMISSIONServiceBase
     */
    public async GetDraft(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.sys_role && true){
            return Http.getInstance().get(`/sys_roles/${context.sys_role}/sys_role_permissions/getdraft`,isloading);
        }
        if(context.sys_permission && true){
            return Http.getInstance().get(`/sys_permissions/${context.sys_permission}/sys_role_permissions/getdraft`,isloading);
        }
        let res:any = await  Http.getInstance().get(`/sys_role_permissions/getdraft`,isloading);
        res.data.sys_role_permission = data.sys_role_permission;
        return res;
    }

    /**
     * Create接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof SYS_ROLE_PERMISSIONServiceBase
     */
    public async Create(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.sys_role && true){
            if(!data.srffrontuf || data.srffrontuf !== "1"){
                data[this.APPDEKEY] = null;
            }
            if(data.srffrontuf){
                delete data.srffrontuf;
            }
            return Http.getInstance().post(`/sys_roles/${context.sys_role}/sys_role_permissions`,data,isloading);
        }
        if(context.sys_permission && true){
            if(!data.srffrontuf || data.srffrontuf !== "1"){
                data[this.APPDEKEY] = null;
            }
            if(data.srffrontuf){
                delete data.srffrontuf;
            }
            return Http.getInstance().post(`/sys_permissions/${context.sys_permission}/sys_role_permissions`,data,isloading);
        }
        let masterData:any = {};
        Object.assign(data,masterData);
        if(!data.srffrontuf || data.srffrontuf !== "1"){
            data[this.APPDEKEY] = null;
        }
        if(data.srffrontuf){
            delete data.srffrontuf;
        }
        let tempContext:any = JSON.parse(JSON.stringify(context));
        let res:any = await Http.getInstance().post(`/sys_role_permissions`,data,isloading);
        return res;
    }

    /**
     * CheckKey接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof SYS_ROLE_PERMISSIONServiceBase
     */
    public async CheckKey(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.sys_role && context.sys_role_permission){
            return Http.getInstance().post(`/sys_roles/${context.sys_role}/sys_role_permissions/${context.sys_role_permission}/checkkey`,data,isloading);
        }
        if(context.sys_permission && context.sys_role_permission){
            return Http.getInstance().post(`/sys_permissions/${context.sys_permission}/sys_role_permissions/${context.sys_role_permission}/checkkey`,data,isloading);
        }
            return Http.getInstance().post(`/sys_role_permissions/${context.sys_role_permission}/checkkey`,data,isloading);
    }

    /**
     * Save接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof SYS_ROLE_PERMISSIONServiceBase
     */
    public async Save(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.sys_role && context.sys_role_permission){
            return Http.getInstance().post(`/sys_roles/${context.sys_role}/sys_role_permissions/${context.sys_role_permission}/save`,data,isloading);
        }
        if(context.sys_permission && context.sys_role_permission){
            return Http.getInstance().post(`/sys_permissions/${context.sys_permission}/sys_role_permissions/${context.sys_role_permission}/save`,data,isloading);
        }
        let masterData:any = {};
        Object.assign(data,masterData);
            let res:any = await  Http.getInstance().post(`/sys_role_permissions/${context.sys_role_permission}/save`,data,isloading);
            return res;
    }

    /**
     * Update接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof SYS_ROLE_PERMISSIONServiceBase
     */
    public async Update(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.sys_role && context.sys_role_permission){
            return Http.getInstance().put(`/sys_roles/${context.sys_role}/sys_role_permissions/${context.sys_role_permission}`,data,isloading);
        }
        if(context.sys_permission && context.sys_role_permission){
            return Http.getInstance().put(`/sys_permissions/${context.sys_permission}/sys_role_permissions/${context.sys_role_permission}`,data,isloading);
        }
        let masterData:any = {};
        Object.assign(data,masterData);
            let res:any = await  Http.getInstance().put(`/sys_role_permissions/${context.sys_role_permission}`,data,isloading);
            return res;
    }

    /**
     * FetchDefault接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof SYS_ROLE_PERMISSIONServiceBase
     */
    public async FetchDefault(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        if(context.sys_role && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/sys_roles/${context.sys_role}/sys_role_permissions/fetchdefault`,tempData,isloading);
        }
        if(context.sys_permission && true){
            let tempData:any = JSON.parse(JSON.stringify(data));
            return Http.getInstance().get(`/sys_permissions/${context.sys_permission}/sys_role_permissions/fetchdefault`,tempData,isloading);
        }
        let tempData:any = JSON.parse(JSON.stringify(data));
        return Http.getInstance().get(`/sys_role_permissions/fetchdefault`,tempData,isloading);
    }
}