import { Http,Util } from '@/utils';
import EntityService from '../entity-service';



/**
 * 权限/资源服务对象基类
 *
 * @export
 * @class SYS_PERMISSIONServiceBase
 * @extends {EntityServie}
 */
export default class SYS_PERMISSIONServiceBase extends EntityService {

    /**
     * Creates an instance of  SYS_PERMISSIONServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  SYS_PERMISSIONServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 初始化基础数据
     *
     * @memberof SYS_PERMISSIONServiceBase
     */
    public initBasicData(){
        this.APPLYDEKEY ='sys_permission';
        this.APPDEKEY = 'permissionid';
        this.APPDENAME = 'sys_permissions';
        this.APPDETEXT = 'permissionname';
        this.APPNAME = 'web';
        this.SYSTEMNAME = 'ibzuaa';
    }

// 实体接口

    /**
     * Select接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof SYS_PERMISSIONServiceBase
     */
    public async Select(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
            return Http.getInstance().get(`/sys_permissions/${context.sys_permission}/select`,isloading);
    }

    /**
     * Save接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof SYS_PERMISSIONServiceBase
     */
    public async Save(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let masterData:any = {};
        let sys_role_permissionsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_sys_role_permissions'),'undefined')){
            sys_role_permissionsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_sys_role_permissions') as any);
            if(sys_role_permissionsData && sys_role_permissionsData.length && sys_role_permissionsData.length > 0){
                sys_role_permissionsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.rolepermissionid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.sys_role_permissions = sys_role_permissionsData;
        Object.assign(data,masterData);
            let res:any = await  Http.getInstance().post(`/sys_permissions/${context.sys_permission}/save`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_sys_role_permissions',JSON.stringify(res.data.sys_role_permissions));
            return res;
    }

    /**
     * GetDraft接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof SYS_PERMISSIONServiceBase
     */
    public async GetDraft(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let res:any = await  Http.getInstance().get(`/sys_permissions/getdraft`,isloading);
        res.data.sys_permission = data.sys_permission;
            this.tempStorage.setItem(context.srfsessionkey+'_sys_role_permissions',JSON.stringify(res.data.sys_role_permissions));
        return res;
    }

    /**
     * Remove接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof SYS_PERMISSIONServiceBase
     */
    public async Remove(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
            return Http.getInstance().delete(`/sys_permissions/${context.sys_permission}`,isloading);

    }

    /**
     * Update接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof SYS_PERMISSIONServiceBase
     */
    public async Update(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let masterData:any = {};
        let sys_role_permissionsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_sys_role_permissions'),'undefined')){
            sys_role_permissionsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_sys_role_permissions') as any);
            if(sys_role_permissionsData && sys_role_permissionsData.length && sys_role_permissionsData.length > 0){
                sys_role_permissionsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.rolepermissionid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.sys_role_permissions = sys_role_permissionsData;
        Object.assign(data,masterData);
            let res:any = await  Http.getInstance().put(`/sys_permissions/${context.sys_permission}`,data,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_sys_role_permissions',JSON.stringify(res.data.sys_role_permissions));
            return res;
    }

    /**
     * Create接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof SYS_PERMISSIONServiceBase
     */
    public async Create(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let masterData:any = {};
        let sys_role_permissionsData:any = [];
        if(!Object.is(this.tempStorage.getItem(context.srfsessionkey+'_sys_role_permissions'),'undefined')){
            sys_role_permissionsData = JSON.parse(this.tempStorage.getItem(context.srfsessionkey+'_sys_role_permissions') as any);
            if(sys_role_permissionsData && sys_role_permissionsData.length && sys_role_permissionsData.length > 0){
                sys_role_permissionsData.forEach((item:any) => {
                    if(item.srffrontuf){
                        if(Object.is(item.srffrontuf,"0")){
                            item.rolepermissionid = null;
                        }
                        delete item.srffrontuf;
                    }
                });
            }
        }
        masterData.sys_role_permissions = sys_role_permissionsData;
        Object.assign(data,masterData);
        if(!data.srffrontuf || data.srffrontuf !== "1"){
            data[this.APPDEKEY] = null;
        }
        if(data.srffrontuf){
            delete data.srffrontuf;
        }
        let tempContext:any = JSON.parse(JSON.stringify(context));
        let res:any = await Http.getInstance().post(`/sys_permissions`,data,isloading);
        this.tempStorage.setItem(tempContext.srfsessionkey+'_sys_role_permissions',JSON.stringify(res.data.sys_role_permissions));
        return res;
    }

    /**
     * CheckKey接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof SYS_PERMISSIONServiceBase
     */
    public async CheckKey(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
            return Http.getInstance().post(`/sys_permissions/${context.sys_permission}/checkkey`,data,isloading);
    }

    /**
     * Get接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof SYS_PERMISSIONServiceBase
     */
    public async Get(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
            let res:any = await Http.getInstance().get(`/sys_permissions/${context.sys_permission}`,isloading);
            this.tempStorage.setItem(context.srfsessionkey+'_sys_role_permissions',JSON.stringify(res.data.sys_role_permissions));
            return res;

    }

    /**
     * FetchDefault接口方法
     *
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof SYS_PERMISSIONServiceBase
     */
    public async FetchDefault(context: any = {},data: any = {}, isloading?: boolean): Promise<any> {
        let tempData:any = JSON.parse(JSON.stringify(data));
        return Http.getInstance().get(`/sys_permissions/fetchdefault`,tempData,isloading);
    }
}