import Vue from 'vue';
import Router from 'vue-router';
import { AuthGuard } from '@/utils';
import qs from 'qs';
import { globalRoutes, indexRoutes} from '@/router'

Vue.use(Router);

const router = new Router({
    routes: [
        {
            path: '/index/:index?',
            beforeEnter: (to: any, from: any, next: any) => {
                const routerParamsName = 'index';
                const params: any = {};
                if (to.params && to.params[routerParamsName]) {
                    Object.assign(params, qs.parse(to.params[routerParamsName], { delimiter: ';' }));
                }
                const url: string = '/appdata';
                const auth: Promise<any> = AuthGuard.getInstance().authGuard(url, params, router);
                auth.then(() => {
                    next();
                }).catch(() => {
                    next();
                });
            },
            meta: {  
                caption: 'app.views.index.caption',
                viewType: 'APPINDEX',
                parameters: [
                    { pathName: 'index', parameterName: 'index' },
                ],
                requireAuth: true,
            },
            component: () => import('@pages/uaa/index/index.vue'),
            children: [
                {
                    path: 'sys_permissions/:sys_permission?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.sys_permission.views.pickupgridview.caption',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'sys_permissions', parameterName: 'sys_permission' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/uaa/sys-permissionpickup-grid-view/sys-permissionpickup-grid-view.vue'),
                },
                {
                    path: 'sys_roles/:sys_role?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.sys_role.views.pickupview.caption',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'sys_roles', parameterName: 'sys_role' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/uaa/sys-rolepickup-view/sys-rolepickup-view.vue'),
                },
                {
                    path: 'sys_users/:sys_user?/mpickupview/:mpickupview?',
                    meta: {
                        caption: 'entities.sys_user.views.mpickupview.caption',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'sys_users', parameterName: 'sys_user' },
                            { pathName: 'mpickupview', parameterName: 'mpickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/uaa/sys-usermpickup-view/sys-usermpickup-view.vue'),
                },
                {
                    path: 'sys_users/:sys_user?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.sys_user.views.pickupgridview.caption',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'sys_users', parameterName: 'sys_user' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/uaa/sys-userpickup-grid-view/sys-userpickup-grid-view.vue'),
                },
                {
                    path: 'sys_roles/:sys_role?/editview/:editview?',
                    meta: {
                        caption: 'entities.sys_role.views.editview.caption',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'sys_roles', parameterName: 'sys_role' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/uaa/sys-roleedit-view/sys-roleedit-view.vue'),
                },
                {
                    path: 'sys_users/:sys_user?/sys_user_roles/:sys_user_role?/editview/:editview?',
                    meta: {
                        caption: 'entities.sys_user_role.views.editview.caption',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'sys_users', parameterName: 'sys_user' },
                            { pathName: 'sys_user_roles', parameterName: 'sys_user_role' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/uaa/sys-user-roleedit-view/sys-user-roleedit-view.vue'),
                },
                {
                    path: 'sys_roles/:sys_role?/sys_user_roles/:sys_user_role?/editview/:editview?',
                    meta: {
                        caption: 'entities.sys_user_role.views.editview.caption',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'sys_roles', parameterName: 'sys_role' },
                            { pathName: 'sys_user_roles', parameterName: 'sys_user_role' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/uaa/sys-user-roleedit-view/sys-user-roleedit-view.vue'),
                },
                {
                    path: 'sys_user_roles/:sys_user_role?/editview/:editview?',
                    meta: {
                        caption: 'entities.sys_user_role.views.editview.caption',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'sys_user_roles', parameterName: 'sys_user_role' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/uaa/sys-user-roleedit-view/sys-user-roleedit-view.vue'),
                },
                {
                    path: 'sys_permissions/:sys_permission?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.sys_permission.views.pickupview.caption',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'sys_permissions', parameterName: 'sys_permission' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/uaa/sys-permissionpickup-view/sys-permissionpickup-view.vue'),
                },
                {
                    path: 'sys_roles/:sys_role?/mpickupview/:mpickupview?',
                    meta: {
                        caption: 'entities.sys_role.views.mpickupview.caption',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'sys_roles', parameterName: 'sys_role' },
                            { pathName: 'mpickupview', parameterName: 'mpickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/uaa/sys-rolempickup-view/sys-rolempickup-view.vue'),
                },
                {
                    path: 'sys_permissions/:sys_permission?/editview/:editview?',
                    meta: {
                        caption: 'entities.sys_permission.views.editview.caption',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'sys_permissions', parameterName: 'sys_permission' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/uaa/sys-permissionedit-view/sys-permissionedit-view.vue'),
                },
                {
                    path: 'sys_roles/:sys_role?/sys_role_permissions/:sys_role_permission?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.sys_role_permission.views.gridview.caption',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'sys_roles', parameterName: 'sys_role' },
                            { pathName: 'sys_role_permissions', parameterName: 'sys_role_permission' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/uaa/sys-role-permissiongrid-view/sys-role-permissiongrid-view.vue'),
                },
                {
                    path: 'sys_permissions/:sys_permission?/sys_role_permissions/:sys_role_permission?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.sys_role_permission.views.gridview.caption',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'sys_permissions', parameterName: 'sys_permission' },
                            { pathName: 'sys_role_permissions', parameterName: 'sys_role_permission' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/uaa/sys-role-permissiongrid-view/sys-role-permissiongrid-view.vue'),
                },
                {
                    path: 'sys_role_permissions/:sys_role_permission?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.sys_role_permission.views.gridview.caption',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'sys_role_permissions', parameterName: 'sys_role_permission' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/uaa/sys-role-permissiongrid-view/sys-role-permissiongrid-view.vue'),
                },
                {
                    path: 'sys_users/:sys_user?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.sys_user.views.pickupview.caption',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'sys_users', parameterName: 'sys_user' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/uaa/sys-userpickup-view/sys-userpickup-view.vue'),
                },
                {
                    path: 'sys_roles/:sys_role?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.sys_role.views.gridview.caption',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'sys_roles', parameterName: 'sys_role' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/uaa/sys-rolegrid-view/sys-rolegrid-view.vue'),
                },
                {
                    path: 'sys_permissions/:sys_permission?/mpickupview/:mpickupview?',
                    meta: {
                        caption: 'entities.sys_permission.views.mpickupview.caption',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'sys_permissions', parameterName: 'sys_permission' },
                            { pathName: 'mpickupview', parameterName: 'mpickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/uaa/sys-permissionmpickup-view/sys-permissionmpickup-view.vue'),
                },
                {
                    path: 'sys_users/:sys_user?/editview/:editview?',
                    meta: {
                        caption: 'entities.sys_user.views.editview.caption',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'sys_users', parameterName: 'sys_user' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/uaa/sys-useredit-view/sys-useredit-view.vue'),
                },
                {
                    path: 'sys_roles/:sys_role?/sys_role_permissions/:sys_role_permission?/editview/:editview?',
                    meta: {
                        caption: 'entities.sys_role_permission.views.editview.caption',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'sys_roles', parameterName: 'sys_role' },
                            { pathName: 'sys_role_permissions', parameterName: 'sys_role_permission' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/uaa/sys-role-permissionedit-view/sys-role-permissionedit-view.vue'),
                },
                {
                    path: 'sys_permissions/:sys_permission?/sys_role_permissions/:sys_role_permission?/editview/:editview?',
                    meta: {
                        caption: 'entities.sys_role_permission.views.editview.caption',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'sys_permissions', parameterName: 'sys_permission' },
                            { pathName: 'sys_role_permissions', parameterName: 'sys_role_permission' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/uaa/sys-role-permissionedit-view/sys-role-permissionedit-view.vue'),
                },
                {
                    path: 'sys_role_permissions/:sys_role_permission?/editview/:editview?',
                    meta: {
                        caption: 'entities.sys_role_permission.views.editview.caption',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'sys_role_permissions', parameterName: 'sys_role_permission' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/uaa/sys-role-permissionedit-view/sys-role-permissionedit-view.vue'),
                },
                {
                    path: 'sys_users/:sys_user?/sys_user_roles/:sys_user_role?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.sys_user_role.views.gridview.caption',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'sys_users', parameterName: 'sys_user' },
                            { pathName: 'sys_user_roles', parameterName: 'sys_user_role' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/uaa/sys-user-rolegrid-view/sys-user-rolegrid-view.vue'),
                },
                {
                    path: 'sys_roles/:sys_role?/sys_user_roles/:sys_user_role?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.sys_user_role.views.gridview.caption',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'sys_roles', parameterName: 'sys_role' },
                            { pathName: 'sys_user_roles', parameterName: 'sys_user_role' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/uaa/sys-user-rolegrid-view/sys-user-rolegrid-view.vue'),
                },
                {
                    path: 'sys_user_roles/:sys_user_role?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.sys_user_role.views.gridview.caption',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'sys_user_roles', parameterName: 'sys_user_role' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/uaa/sys-user-rolegrid-view/sys-user-rolegrid-view.vue'),
                },
                {
                    path: 'sys_permissions/:sys_permission?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.sys_permission.views.gridview.caption',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'sys_permissions', parameterName: 'sys_permission' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/uaa/sys-permissiongrid-view/sys-permissiongrid-view.vue'),
                },
                {
                    path: 'sys_roles/:sys_role?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.sys_role.views.pickupgridview.caption',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'sys_roles', parameterName: 'sys_role' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/uaa/sys-rolepickup-grid-view/sys-rolepickup-grid-view.vue'),
                },
                {
                    path: 'sys_users/:sys_user?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.sys_user.views.gridview.caption',
                        parameters: [
                            { pathName: 'index', parameterName: 'index' },
                            { pathName: 'sys_users', parameterName: 'sys_user' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/uaa/sys-usergrid-view/sys-usergrid-view.vue'),
                },
            {
                path: 'sys_user_roleredirectview/:sys_user_roleredirectview?',
                meta: {
                    caption: 'entities.sys_user_role.views.redirectview.caption',
                    parameters: [
                        { pathName: 'sys_user_roleredirectview', parameterName: 'sys_user_roleredirectview' },
                    ],
                    requireAuth: true,
                },
                component: () => import('@pages/uaa/sys-user-roleredirect-view/sys-user-roleredirect-view.vue'),
            },
            {
                path: 'sys_role_permissionredirectview/:sys_role_permissionredirectview?',
                meta: {
                    caption: 'entities.sys_role_permission.views.redirectview.caption',
                    parameters: [
                        { pathName: 'sys_role_permissionredirectview', parameterName: 'sys_role_permissionredirectview' },
                    ],
                    requireAuth: true,
                },
                component: () => import('@pages/uaa/sys-role-permissionredirect-view/sys-role-permissionredirect-view.vue'),
            },
            {
                path: 'sys_userredirectview/:sys_userredirectview?',
                meta: {
                    caption: 'entities.sys_user.views.redirectview.caption',
                    parameters: [
                        { pathName: 'sys_userredirectview', parameterName: 'sys_userredirectview' },
                    ],
                    requireAuth: true,
                },
                component: () => import('@pages/uaa/sys-userredirect-view/sys-userredirect-view.vue'),
            },
            {
                path: 'sys_roleredirectview/:sys_roleredirectview?',
                meta: {
                    caption: 'entities.sys_role.views.redirectview.caption',
                    parameters: [
                        { pathName: 'sys_roleredirectview', parameterName: 'sys_roleredirectview' },
                    ],
                    requireAuth: true,
                },
                component: () => import('@pages/uaa/sys-roleredirect-view/sys-roleredirect-view.vue'),
            },
            {
                path: 'sys_permissionredirectview/:sys_permissionredirectview?',
                meta: {
                    caption: 'entities.sys_permission.views.redirectview.caption',
                    parameters: [
                        { pathName: 'sys_permissionredirectview', parameterName: 'sys_permissionredirectview' },
                    ],
                    requireAuth: true,
                },
                component: () => import('@pages/uaa/sys-permissionredirect-view/sys-permissionredirect-view.vue'),
            },
            ...indexRoutes,
            ],
        },
    {
        path: '/sys_roles/:sys_role?/pickupgridview/:pickupgridview?',
        meta: {
            caption: 'entities.sys_role.views.pickupgridview.caption',
            parameters: [
                { pathName: 'sys_roles', parameterName: 'sys_role' },
                { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/uaa/sys-rolepickup-grid-view/sys-rolepickup-grid-view.vue'),
    },
    {
        path: '/sys_users/:sys_user?/sys_user_roles/:sys_user_role?/editview/:editview?',
        meta: {
            caption: 'entities.sys_user_role.views.editview.caption',
            parameters: [
                { pathName: 'sys_users', parameterName: 'sys_user' },
                { pathName: 'sys_user_roles', parameterName: 'sys_user_role' },
                { pathName: 'editview', parameterName: 'editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/uaa/sys-user-roleedit-view/sys-user-roleedit-view.vue'),
    },
    {
        path: '/sys_roles/:sys_role?/sys_user_roles/:sys_user_role?/editview/:editview?',
        meta: {
            caption: 'entities.sys_user_role.views.editview.caption',
            parameters: [
                { pathName: 'sys_roles', parameterName: 'sys_role' },
                { pathName: 'sys_user_roles', parameterName: 'sys_user_role' },
                { pathName: 'editview', parameterName: 'editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/uaa/sys-user-roleedit-view/sys-user-roleedit-view.vue'),
    },
    {
        path: '/sys_user_roles/:sys_user_role?/editview/:editview?',
        meta: {
            caption: 'entities.sys_user_role.views.editview.caption',
            parameters: [
                { pathName: 'sys_user_roles', parameterName: 'sys_user_role' },
                { pathName: 'editview', parameterName: 'editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/uaa/sys-user-roleedit-view/sys-user-roleedit-view.vue'),
    },
    {
        path: '/sys_users/:sys_user?/mpickupview/:mpickupview?',
        meta: {
            caption: 'entities.sys_user.views.mpickupview.caption',
            parameters: [
                { pathName: 'sys_users', parameterName: 'sys_user' },
                { pathName: 'mpickupview', parameterName: 'mpickupview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/uaa/sys-usermpickup-view/sys-usermpickup-view.vue'),
    },
    {
        path: '/sys_permissions/:sys_permission?/gridview/:gridview?',
        meta: {
            caption: 'entities.sys_permission.views.gridview.caption',
            parameters: [
                { pathName: 'sys_permissions', parameterName: 'sys_permission' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/uaa/sys-permissiongrid-view/sys-permissiongrid-view.vue'),
    },
    {
        path: '/sys_roles/:sys_role?/sys_role_permissions/:sys_role_permission?/gridview/:gridview?',
        meta: {
            caption: 'entities.sys_role_permission.views.gridview.caption',
            parameters: [
                { pathName: 'sys_roles', parameterName: 'sys_role' },
                { pathName: 'sys_role_permissions', parameterName: 'sys_role_permission' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/uaa/sys-role-permissiongrid-view/sys-role-permissiongrid-view.vue'),
    },
    {
        path: '/sys_permissions/:sys_permission?/sys_role_permissions/:sys_role_permission?/gridview/:gridview?',
        meta: {
            caption: 'entities.sys_role_permission.views.gridview.caption',
            parameters: [
                { pathName: 'sys_permissions', parameterName: 'sys_permission' },
                { pathName: 'sys_role_permissions', parameterName: 'sys_role_permission' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/uaa/sys-role-permissiongrid-view/sys-role-permissiongrid-view.vue'),
    },
    {
        path: '/sys_role_permissions/:sys_role_permission?/gridview/:gridview?',
        meta: {
            caption: 'entities.sys_role_permission.views.gridview.caption',
            parameters: [
                { pathName: 'sys_role_permissions', parameterName: 'sys_role_permission' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/uaa/sys-role-permissiongrid-view/sys-role-permissiongrid-view.vue'),
    },
    {
        path: '/sys_roles/:sys_role?/editview/:editview?',
        meta: {
            caption: 'entities.sys_role.views.editview.caption',
            parameters: [
                { pathName: 'sys_roles', parameterName: 'sys_role' },
                { pathName: 'editview', parameterName: 'editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/uaa/sys-roleedit-view/sys-roleedit-view.vue'),
    },
    {
        path: '/sys_roles/:sys_role?/sys_role_permissions/:sys_role_permission?/editview/:editview?',
        meta: {
            caption: 'entities.sys_role_permission.views.editview.caption',
            parameters: [
                { pathName: 'sys_roles', parameterName: 'sys_role' },
                { pathName: 'sys_role_permissions', parameterName: 'sys_role_permission' },
                { pathName: 'editview', parameterName: 'editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/uaa/sys-role-permissionedit-view/sys-role-permissionedit-view.vue'),
    },
    {
        path: '/sys_permissions/:sys_permission?/sys_role_permissions/:sys_role_permission?/editview/:editview?',
        meta: {
            caption: 'entities.sys_role_permission.views.editview.caption',
            parameters: [
                { pathName: 'sys_permissions', parameterName: 'sys_permission' },
                { pathName: 'sys_role_permissions', parameterName: 'sys_role_permission' },
                { pathName: 'editview', parameterName: 'editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/uaa/sys-role-permissionedit-view/sys-role-permissionedit-view.vue'),
    },
    {
        path: '/sys_role_permissions/:sys_role_permission?/editview/:editview?',
        meta: {
            caption: 'entities.sys_role_permission.views.editview.caption',
            parameters: [
                { pathName: 'sys_role_permissions', parameterName: 'sys_role_permission' },
                { pathName: 'editview', parameterName: 'editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/uaa/sys-role-permissionedit-view/sys-role-permissionedit-view.vue'),
    },
    {
        path: '/sys_roles/:sys_role?/pickupview/:pickupview?',
        meta: {
            caption: 'entities.sys_role.views.pickupview.caption',
            parameters: [
                { pathName: 'sys_roles', parameterName: 'sys_role' },
                { pathName: 'pickupview', parameterName: 'pickupview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/uaa/sys-rolepickup-view/sys-rolepickup-view.vue'),
    },
    {
        path: '/sys_permissions/:sys_permission?/pickupview/:pickupview?',
        meta: {
            caption: 'entities.sys_permission.views.pickupview.caption',
            parameters: [
                { pathName: 'sys_permissions', parameterName: 'sys_permission' },
                { pathName: 'pickupview', parameterName: 'pickupview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/uaa/sys-permissionpickup-view/sys-permissionpickup-view.vue'),
    },
    {
        path: '/sys_users/:sys_user?/pickupgridview/:pickupgridview?',
        meta: {
            caption: 'entities.sys_user.views.pickupgridview.caption',
            parameters: [
                { pathName: 'sys_users', parameterName: 'sys_user' },
                { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/uaa/sys-userpickup-grid-view/sys-userpickup-grid-view.vue'),
    },
    {
        path: '/sys_users/:sys_user?/editview/:editview?',
        meta: {
            caption: 'entities.sys_user.views.editview.caption',
            parameters: [
                { pathName: 'sys_users', parameterName: 'sys_user' },
                { pathName: 'editview', parameterName: 'editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/uaa/sys-useredit-view/sys-useredit-view.vue'),
    },
    {
        path: '/sys_permissions/:sys_permission?/pickupgridview/:pickupgridview?',
        meta: {
            caption: 'entities.sys_permission.views.pickupgridview.caption',
            parameters: [
                { pathName: 'sys_permissions', parameterName: 'sys_permission' },
                { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/uaa/sys-permissionpickup-grid-view/sys-permissionpickup-grid-view.vue'),
    },
    {
        path: '/sys_roles/:sys_role?/gridview/:gridview?',
        meta: {
            caption: 'entities.sys_role.views.gridview.caption',
            parameters: [
                { pathName: 'sys_roles', parameterName: 'sys_role' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/uaa/sys-rolegrid-view/sys-rolegrid-view.vue'),
    },
    {
        path: '/sys_permissions/:sys_permission?/mpickupview/:mpickupview?',
        meta: {
            caption: 'entities.sys_permission.views.mpickupview.caption',
            parameters: [
                { pathName: 'sys_permissions', parameterName: 'sys_permission' },
                { pathName: 'mpickupview', parameterName: 'mpickupview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/uaa/sys-permissionmpickup-view/sys-permissionmpickup-view.vue'),
    },
    {
        path: '/sys_users/:sys_user?/gridview/:gridview?',
        meta: {
            caption: 'entities.sys_user.views.gridview.caption',
            parameters: [
                { pathName: 'sys_users', parameterName: 'sys_user' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/uaa/sys-usergrid-view/sys-usergrid-view.vue'),
    },
    {
        path: '/sys_roles/:sys_role?/mpickupview/:mpickupview?',
        meta: {
            caption: 'entities.sys_role.views.mpickupview.caption',
            parameters: [
                { pathName: 'sys_roles', parameterName: 'sys_role' },
                { pathName: 'mpickupview', parameterName: 'mpickupview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/uaa/sys-rolempickup-view/sys-rolempickup-view.vue'),
    },
    {
        path: '/sys_users/:sys_user?/pickupview/:pickupview?',
        meta: {
            caption: 'entities.sys_user.views.pickupview.caption',
            parameters: [
                { pathName: 'sys_users', parameterName: 'sys_user' },
                { pathName: 'pickupview', parameterName: 'pickupview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/uaa/sys-userpickup-view/sys-userpickup-view.vue'),
    },
    {
        path: '/sys_permissions/:sys_permission?/editview/:editview?',
        meta: {
            caption: 'entities.sys_permission.views.editview.caption',
            parameters: [
                { pathName: 'sys_permissions', parameterName: 'sys_permission' },
                { pathName: 'editview', parameterName: 'editview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/uaa/sys-permissionedit-view/sys-permissionedit-view.vue'),
    },
    {
        path: '/sys_users/:sys_user?/sys_user_roles/:sys_user_role?/gridview/:gridview?',
        meta: {
            caption: 'entities.sys_user_role.views.gridview.caption',
            parameters: [
                { pathName: 'sys_users', parameterName: 'sys_user' },
                { pathName: 'sys_user_roles', parameterName: 'sys_user_role' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/uaa/sys-user-rolegrid-view/sys-user-rolegrid-view.vue'),
    },
    {
        path: '/sys_roles/:sys_role?/sys_user_roles/:sys_user_role?/gridview/:gridview?',
        meta: {
            caption: 'entities.sys_user_role.views.gridview.caption',
            parameters: [
                { pathName: 'sys_roles', parameterName: 'sys_role' },
                { pathName: 'sys_user_roles', parameterName: 'sys_user_role' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/uaa/sys-user-rolegrid-view/sys-user-rolegrid-view.vue'),
    },
    {
        path: '/sys_user_roles/:sys_user_role?/gridview/:gridview?',
        meta: {
            caption: 'entities.sys_user_role.views.gridview.caption',
            parameters: [
                { pathName: 'sys_user_roles', parameterName: 'sys_user_role' },
                { pathName: 'gridview', parameterName: 'gridview' },
            ],
            requireAuth: true,
        },
        component: () => import('@pages/uaa/sys-user-rolegrid-view/sys-user-rolegrid-view.vue'),
    },
        ...globalRoutes,
        {
            path: '/login/:login?',
            name: 'login',
            meta: {  
                caption: '登录',
                viewType: 'login',
                requireAuth: false,
                ignoreAddPage: true,
            },
            beforeEnter: (to: any, from: any, next: any) => {
                router.app.$store.commit('resetRootStateData');
                next();
            },
            component: () => import('@components/login/login.vue'),
        },
        {
            path: '/404',
            component: () => import('@components/404/404.vue')
        },
        {
            path: '/500',
            component: () => import('@components/500/500.vue')
        },
        {
            path: '*',
            redirect: 'index'
        },
    ],
});

export default router;
