import AuthService from '../auth-service';

/**
 * 任务调度日志权限服务对象基类
 *
 * @export
 * @class JobsLogAuthServiceBase
 * @extends {AuthService}
 */
export default class JobsLogAuthServiceBase extends AuthService {

    /**
     * Creates an instance of  JobsLogAuthServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  JobsLogAuthServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 根据当前数据获取实体操作标识
     *
     * @param {*} mainSateOPPrivs 传入数据操作标识
     * @returns {any}
     * @memberof JobsLogAuthServiceBase
     */
    public getOPPrivs(mainSateOPPrivs:any):any{
        let curDefaultOPPrivs:any = JSON.parse(JSON.stringify(this.defaultOPPrivs));
        if(mainSateOPPrivs){
            Object.assign(curDefaultOPPrivs,mainSateOPPrivs);
        }
        return curDefaultOPPrivs;
    }

}