package cn.ibizlab.api.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;

import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;

import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;

import cn.ibizlab.api.dto.*;
import cn.ibizlab.api.mapping.*;
import cn.ibizlab.core.ou.domain.IBZDepartment;
import cn.ibizlab.core.ou.service.IIBZDepartmentService;
import cn.ibizlab.core.ou.filter.IBZDepartmentSearchContext;




@Slf4j
@Api(tags = {"IBZDepartment" })
@RestController("api-ibzdepartment")
@RequestMapping("")
public class IBZDepartmentResource {

    @Autowired
    private IIBZDepartmentService ibzdepartmentService;

    @Autowired
    @Lazy
    public IBZDepartmentMapping ibzdepartmentMapping;

    public IBZDepartmentDTO permissionDTO=new IBZDepartmentDTO();

    @PreAuthorize("hasPermission('','Create',{'Sql',this.ibzdepartmentMapping,#ibzdepartmentdto})")
    @ApiOperation(value = "Create", tags = {"IBZDepartment" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/ibzdepartments")
    @Transactional
    public ResponseEntity<IBZDepartmentDTO> create(@RequestBody IBZDepartmentDTO ibzdepartmentdto) {
        IBZDepartment domain = ibzdepartmentMapping.toDomain(ibzdepartmentdto);
		ibzdepartmentService.create(domain);
        IBZDepartmentDTO dto = ibzdepartmentMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.humanMapping,#humandtos})")
    @ApiOperation(value = "createBatch", tags = {"IBZDepartment" },  notes = "createBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/ibzdepartments/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<IBZDepartmentDTO> ibzdepartmentdtos) {
        ibzdepartmentService.createBatch(ibzdepartmentMapping.toDomain(ibzdepartmentdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#ibzdepartment_id,'Get',{'Sql',this.ibzdepartmentMapping,this.permissionDTO})")
    @ApiOperation(value = "Get", tags = {"IBZDepartment" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/ibzdepartments/{ibzdepartment_id}")
    public ResponseEntity<IBZDepartmentDTO> get(@PathVariable("ibzdepartment_id") String ibzdepartment_id) {
        IBZDepartment domain = ibzdepartmentService.get(ibzdepartment_id);
        IBZDepartmentDTO dto = ibzdepartmentMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzou-IBZDepartment-Save-all')")
    @ApiOperation(value = "Save", tags = {"IBZDepartment" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/ibzdepartments/save")
    public ResponseEntity<Boolean> save(@RequestBody IBZDepartmentDTO ibzdepartmentdto) {
        return ResponseEntity.status(HttpStatus.OK).body(ibzdepartmentService.save(ibzdepartmentMapping.toDomain(ibzdepartmentdto)));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.humanMapping,#humandtos})")
    @ApiOperation(value = "SaveBatch", tags = {"IBZDepartment" },  notes = "SaveBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/ibzdepartments/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<IBZDepartmentDTO> ibzdepartmentdtos) {
        ibzdepartmentService.saveBatch(ibzdepartmentMapping.toDomain(ibzdepartmentdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzou-IBZDepartment-CheckKey-all')")
    @ApiOperation(value = "CheckKey", tags = {"IBZDepartment" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/ibzdepartments/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody IBZDepartmentDTO ibzdepartmentdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(ibzdepartmentService.checkKey(ibzdepartmentMapping.toDomain(ibzdepartmentdto)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzou-IBZDepartment-GetDraft-all')")
    @ApiOperation(value = "GetDraft", tags = {"IBZDepartment" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/ibzdepartments/getdraft")
    public ResponseEntity<IBZDepartmentDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(ibzdepartmentMapping.toDto(ibzdepartmentService.getDraft(new IBZDepartment())));
    }

    @PreAuthorize("hasPermission(#ibzdepartment_id,'Remove',{'Sql',this.ibzdepartmentMapping,this.permissionDTO})")
    @ApiOperation(value = "Remove", tags = {"IBZDepartment" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/ibzdepartments/{ibzdepartment_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("ibzdepartment_id") String ibzdepartment_id) {
         return ResponseEntity.status(HttpStatus.OK).body(ibzdepartmentService.remove(ibzdepartment_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.humanMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatch", tags = {"IBZDepartment" },  notes = "RemoveBatch")
	@RequestMapping(method = RequestMethod.DELETE, value = "/ibzdepartments/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        ibzdepartmentService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(#ibzdepartment_id,'Update',{'Sql',this.ibzdepartmentMapping,#ibzdepartmentdto})")
    @ApiOperation(value = "Update", tags = {"IBZDepartment" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/ibzdepartments/{ibzdepartment_id}")
    @Transactional
    public ResponseEntity<IBZDepartmentDTO> update(@PathVariable("ibzdepartment_id") String ibzdepartment_id, @RequestBody IBZDepartmentDTO ibzdepartmentdto) {
		IBZDepartment domain = ibzdepartmentMapping.toDomain(ibzdepartmentdto);
        domain.setDeptid(ibzdepartment_id);
		ibzdepartmentService.update(domain);
		IBZDepartmentDTO dto = ibzdepartmentMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.humanMapping,#humandtos})")
    @ApiOperation(value = "UpdateBatch", tags = {"IBZDepartment" },  notes = "UpdateBatch")
	@RequestMapping(method = RequestMethod.PUT, value = "/ibzdepartments/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<IBZDepartmentDTO> ibzdepartmentdtos) {
        ibzdepartmentService.updateBatch(ibzdepartmentMapping.toDomain(ibzdepartmentdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzou-IBZDepartment-CurDept-all')")
	@ApiOperation(value = "fetchCurDept", tags = {"IBZDepartment" } ,notes = "fetchCurDept")
    @RequestMapping(method= RequestMethod.GET , value="/ibzdepartments/fetchcurdept")
	public ResponseEntity<List<IBZDepartmentDTO>> fetchCurDept(IBZDepartmentSearchContext context) {
        Page<IBZDepartment> domains = ibzdepartmentService.searchCurDept(context) ;
        List<IBZDepartmentDTO> list = ibzdepartmentMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzou-IBZDepartment-CurDept-all')")
	@ApiOperation(value = "searchCurDept", tags = {"IBZDepartment" } ,notes = "searchCurDept")
    @RequestMapping(method= RequestMethod.POST , value="/ibzdepartments/searchcurdept")
	public ResponseEntity<Page<IBZDepartmentDTO>> searchCurDept(@RequestBody IBZDepartmentSearchContext context) {
        Page<IBZDepartment> domains = ibzdepartmentService.searchCurDept(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(ibzdepartmentMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzou-IBZDepartment-Default-all')")
	@ApiOperation(value = "fetchDEFAULT", tags = {"IBZDepartment" } ,notes = "fetchDEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/ibzdepartments/fetchdefault")
	public ResponseEntity<List<IBZDepartmentDTO>> fetchDefault(IBZDepartmentSearchContext context) {
        Page<IBZDepartment> domains = ibzdepartmentService.searchDefault(context) ;
        List<IBZDepartmentDTO> list = ibzdepartmentMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzou-IBZDepartment-Default-all')")
	@ApiOperation(value = "searchDEFAULT", tags = {"IBZDepartment" } ,notes = "searchDEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/ibzdepartments/searchdefault")
	public ResponseEntity<Page<IBZDepartmentDTO>> searchDefault(@RequestBody IBZDepartmentSearchContext context) {
        Page<IBZDepartment> domains = ibzdepartmentService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(ibzdepartmentMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    //@PreAuthorize("hasPermission('','Create',{'Sql',this.ibzdepartmentMapping,#ibzdepartmentdto})")
    @ApiOperation(value = "CreateByIBZOrganization", tags = {"IBZDepartment" },  notes = "CreateByIBZOrganization")
	@RequestMapping(method = RequestMethod.POST, value = "/ibzorganizations/{ibzorganization_id}/ibzdepartments")
    @Transactional
    public ResponseEntity<IBZDepartmentDTO> createByIBZOrganization(@PathVariable("ibzorganization_id") String ibzorganization_id, @RequestBody IBZDepartmentDTO ibzdepartmentdto) {
        IBZDepartment domain = ibzdepartmentMapping.toDomain(ibzdepartmentdto);
        domain.setOrgid(ibzorganization_id);
		ibzdepartmentService.create(domain);
        IBZDepartmentDTO dto = ibzdepartmentMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Create',{'Sql',this.humanMapping,#humandtos})")
    @ApiOperation(value = "createBatchByIBZOrganization", tags = {"IBZDepartment" },  notes = "createBatchByIBZOrganization")
	@RequestMapping(method = RequestMethod.POST, value = "/ibzorganizations/{ibzorganization_id}/ibzdepartments/batch")
    public ResponseEntity<Boolean> createBatchByIBZOrganization(@PathVariable("ibzorganization_id") String ibzorganization_id, @RequestBody List<IBZDepartmentDTO> ibzdepartmentdtos) {
        List<IBZDepartment> domainlist=ibzdepartmentMapping.toDomain(ibzdepartmentdtos);
        for(IBZDepartment domain:domainlist){
            domain.setOrgid(ibzorganization_id);
        }
        ibzdepartmentService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    //@PreAuthorize("hasPermission(#ibzdepartment_id,'Get',{'Sql',this.ibzdepartmentMapping,this.permissionDTO})")
    @ApiOperation(value = "GetByIBZOrganization", tags = {"IBZDepartment" },  notes = "GetByIBZOrganization")
	@RequestMapping(method = RequestMethod.GET, value = "/ibzorganizations/{ibzorganization_id}/ibzdepartments/{ibzdepartment_id}")
    public ResponseEntity<IBZDepartmentDTO> getByIBZOrganization(@PathVariable("ibzorganization_id") String ibzorganization_id, @PathVariable("ibzdepartment_id") String ibzdepartment_id) {
        IBZDepartment domain = ibzdepartmentService.get(ibzdepartment_id);
        IBZDepartmentDTO dto = ibzdepartmentMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzou-IBZDepartment-Save-all')")
    @ApiOperation(value = "SaveByIBZOrganization", tags = {"IBZDepartment" },  notes = "SaveByIBZOrganization")
	@RequestMapping(method = RequestMethod.POST, value = "/ibzorganizations/{ibzorganization_id}/ibzdepartments/save")
    public ResponseEntity<Boolean> saveByIBZOrganization(@PathVariable("ibzorganization_id") String ibzorganization_id, @RequestBody IBZDepartmentDTO ibzdepartmentdto) {
        IBZDepartment domain = ibzdepartmentMapping.toDomain(ibzdepartmentdto);
        domain.setOrgid(ibzorganization_id);
        return ResponseEntity.status(HttpStatus.OK).body(ibzdepartmentService.save(domain));
    }

    @PreAuthorize("hasPermission('Save',{'Sql',this.humanMapping,#humandtos})")
    @ApiOperation(value = "SaveBatchByIBZOrganization", tags = {"IBZDepartment" },  notes = "SaveBatchByIBZOrganization")
	@RequestMapping(method = RequestMethod.POST, value = "/ibzorganizations/{ibzorganization_id}/ibzdepartments/savebatch")
    public ResponseEntity<Boolean> saveBatchByIBZOrganization(@PathVariable("ibzorganization_id") String ibzorganization_id, @RequestBody List<IBZDepartmentDTO> ibzdepartmentdtos) {
        List<IBZDepartment> domainlist=ibzdepartmentMapping.toDomain(ibzdepartmentdtos);
        for(IBZDepartment domain:domainlist){
             domain.setOrgid(ibzorganization_id);
        }
        ibzdepartmentService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzou-IBZDepartment-CheckKey-all')")
    @ApiOperation(value = "CheckKeyByIBZOrganization", tags = {"IBZDepartment" },  notes = "CheckKeyByIBZOrganization")
	@RequestMapping(method = RequestMethod.POST, value = "/ibzorganizations/{ibzorganization_id}/ibzdepartments/checkkey")
    public ResponseEntity<Boolean> checkKeyByIBZOrganization(@PathVariable("ibzorganization_id") String ibzorganization_id, @RequestBody IBZDepartmentDTO ibzdepartmentdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(ibzdepartmentService.checkKey(ibzdepartmentMapping.toDomain(ibzdepartmentdto)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzou-IBZDepartment-GetDraft-all')")
    @ApiOperation(value = "GetDraftByIBZOrganization", tags = {"IBZDepartment" },  notes = "GetDraftByIBZOrganization")
    @RequestMapping(method = RequestMethod.GET, value = "/ibzorganizations/{ibzorganization_id}/ibzdepartments/getdraft")
    public ResponseEntity<IBZDepartmentDTO> getDraftByIBZOrganization(@PathVariable("ibzorganization_id") String ibzorganization_id) {
        IBZDepartment domain = new IBZDepartment();
        domain.setOrgid(ibzorganization_id);
        return ResponseEntity.status(HttpStatus.OK).body(ibzdepartmentMapping.toDto(ibzdepartmentService.getDraft(domain)));
    }

    //@PreAuthorize("hasPermission(#ibzdepartment_id,'Remove',{'Sql',this.ibzdepartmentMapping,this.permissionDTO})")
    @ApiOperation(value = "RemoveByIBZOrganization", tags = {"IBZDepartment" },  notes = "RemoveByIBZOrganization")
	@RequestMapping(method = RequestMethod.DELETE, value = "/ibzorganizations/{ibzorganization_id}/ibzdepartments/{ibzdepartment_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByIBZOrganization(@PathVariable("ibzorganization_id") String ibzorganization_id, @PathVariable("ibzdepartment_id") String ibzdepartment_id) {
		return ResponseEntity.status(HttpStatus.OK).body(ibzdepartmentService.remove(ibzdepartment_id));
    }

    @PreAuthorize("hasPermission('Remove',{'Sql',this.humanMapping,this.permissionDTO,#ids})")
    @ApiOperation(value = "RemoveBatchByIBZOrganization", tags = {"IBZDepartment" },  notes = "RemoveBatchByIBZOrganization")
	@RequestMapping(method = RequestMethod.DELETE, value = "/ibzorganizations/{ibzorganization_id}/ibzdepartments/batch")
    public ResponseEntity<Boolean> removeBatchByIBZOrganization(@RequestBody List<String> ids) {
        ibzdepartmentService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    //@PreAuthorize("hasPermission(#ibzdepartment_id,'Update',{'Sql',this.ibzdepartmentMapping,#ibzdepartmentdto})")
    @ApiOperation(value = "UpdateByIBZOrganization", tags = {"IBZDepartment" },  notes = "UpdateByIBZOrganization")
	@RequestMapping(method = RequestMethod.PUT, value = "/ibzorganizations/{ibzorganization_id}/ibzdepartments/{ibzdepartment_id}")
    @Transactional
    public ResponseEntity<IBZDepartmentDTO> updateByIBZOrganization(@PathVariable("ibzorganization_id") String ibzorganization_id, @PathVariable("ibzdepartment_id") String ibzdepartment_id, @RequestBody IBZDepartmentDTO ibzdepartmentdto) {
        IBZDepartment domain = ibzdepartmentMapping.toDomain(ibzdepartmentdto);
        domain.setOrgid(ibzorganization_id);
        domain.setDeptid(ibzdepartment_id);
		ibzdepartmentService.update(domain);
        IBZDepartmentDTO dto = ibzdepartmentMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('Update',{'Sql',this.humanMapping,#humandtos})")
    @ApiOperation(value = "UpdateBatchByIBZOrganization", tags = {"IBZDepartment" },  notes = "UpdateBatchByIBZOrganization")
	@RequestMapping(method = RequestMethod.PUT, value = "/ibzorganizations/{ibzorganization_id}/ibzdepartments/batch")
    public ResponseEntity<Boolean> updateBatchByIBZOrganization(@PathVariable("ibzorganization_id") String ibzorganization_id, @RequestBody List<IBZDepartmentDTO> ibzdepartmentdtos) {
        List<IBZDepartment> domainlist=ibzdepartmentMapping.toDomain(ibzdepartmentdtos);
        for(IBZDepartment domain:domainlist){
            domain.setOrgid(ibzorganization_id);
        }
        ibzdepartmentService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzou-IBZDepartment-CurDept-all')")
	@ApiOperation(value = "fetchCurDeptByIBZOrganization", tags = {"IBZDepartment" } ,notes = "fetchCurDeptByIBZOrganization")
    @RequestMapping(method= RequestMethod.GET , value="/ibzorganizations/{ibzorganization_id}/ibzdepartments/fetchcurdept")
	public ResponseEntity<List<IBZDepartmentDTO>> fetchIBZDepartmentCurDeptByIBZOrganization(@PathVariable("ibzorganization_id") String ibzorganization_id,IBZDepartmentSearchContext context) {
        context.setN_orgid_eq(ibzorganization_id);
        Page<IBZDepartment> domains = ibzdepartmentService.searchCurDept(context) ;
        List<IBZDepartmentDTO> list = ibzdepartmentMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzou-IBZDepartment-CurDept-all')")
	@ApiOperation(value = "searchCurDeptByIBZOrganization", tags = {"IBZDepartment" } ,notes = "searchCurDeptByIBZOrganization")
    @RequestMapping(method= RequestMethod.POST , value="/ibzorganizations/{ibzorganization_id}/ibzdepartments/searchcurdept")
	public ResponseEntity<Page<IBZDepartmentDTO>> searchIBZDepartmentCurDeptByIBZOrganization(@PathVariable("ibzorganization_id") String ibzorganization_id, @RequestBody IBZDepartmentSearchContext context) {
        context.setN_orgid_eq(ibzorganization_id);
        Page<IBZDepartment> domains = ibzdepartmentService.searchCurDept(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(ibzdepartmentMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzou-IBZDepartment-Default-all')")
	@ApiOperation(value = "fetchDEFAULTByIBZOrganization", tags = {"IBZDepartment" } ,notes = "fetchDEFAULTByIBZOrganization")
    @RequestMapping(method= RequestMethod.GET , value="/ibzorganizations/{ibzorganization_id}/ibzdepartments/fetchdefault")
	public ResponseEntity<List<IBZDepartmentDTO>> fetchIBZDepartmentDefaultByIBZOrganization(@PathVariable("ibzorganization_id") String ibzorganization_id,IBZDepartmentSearchContext context) {
        context.setN_orgid_eq(ibzorganization_id);
        Page<IBZDepartment> domains = ibzdepartmentService.searchDefault(context) ;
        List<IBZDepartmentDTO> list = ibzdepartmentMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzou-IBZDepartment-Default-all')")
	@ApiOperation(value = "searchDEFAULTByIBZOrganization", tags = {"IBZDepartment" } ,notes = "searchDEFAULTByIBZOrganization")
    @RequestMapping(method= RequestMethod.POST , value="/ibzorganizations/{ibzorganization_id}/ibzdepartments/searchdefault")
	public ResponseEntity<Page<IBZDepartmentDTO>> searchIBZDepartmentDefaultByIBZOrganization(@PathVariable("ibzorganization_id") String ibzorganization_id, @RequestBody IBZDepartmentSearchContext context) {
        context.setN_orgid_eq(ibzorganization_id);
        Page<IBZDepartment> domains = ibzdepartmentService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(ibzdepartmentMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
}
