package cn.ibizlab.api.rest.extensions;


import cn.ibizlab.core.ou.service.IIBZOrganizationService;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;
import java.util.List;

/**
 * 上下级组织信息查询服务
 */
@RestController
public class OrgFeignService {


    @Autowired
    IIBZOrganizationService orgService;

    /**
     * 获取上下级组织、部门信息
     * @return
     */
    @GetMapping("/ibzou/org/{loginname}")
    public JSONObject getOrgInfo(@PathVariable("loginname") String loginName){

        String orgLevel="";
        String deptLevel="";
        JSONObject orgInfo= new JSONObject();
        JSONObject org = new JSONObject();
        JSONObject orgDept = new JSONObject();

        //查询用户的levelCode
        List<JSONObject> empInfo= orgService.select(String.format("select t1.ORGCODE, t2.DEPTCODE, t1.ORGLEVEL,t2.DEPTLEVEL from ibzemp t  left join ibzorg t1  on t.orgid =t1.orgid   left join ibzdept t2 on t.MDEPTID=t2.DEPTID  where t.LOGINNAME='%s' ",loginName));

        if(empInfo.size()==0)
            return null;

        orgLevel=empInfo.get(0).getString("ORGLEVEL");
        deptLevel=empInfo.get(0).getString("DEPTLEVEL");

        //通过levelCode查询上下级组织信息
        List<JSONObject> pOrgLists= orgService.select(String.format("select orgcode from ibzorg t where INSTR('%s', t.orglevel )=1 ",orgLevel));
        List<JSONObject> sOrgLists= orgService.select(String.format("select orgcode from ibzorg t where INSTR(t.orglevel ,'%s' )=1 ",orgLevel));
        List<JSONObject> pOrgDeptLists= orgService.select(String.format("select deptcode from ibzdept t where INSTR('%s',t.deptlevel)=1 ",deptLevel));
        List<JSONObject> sOrgDeptLists= orgService.select(String.format("select deptcode from ibzdept t where INSTR(t.deptlevel,'%s')=1 ",deptLevel));

        org.put("porg",parseData(pOrgLists,"orgcode"));
        org.put("sorg",parseData(sOrgLists,"orgcode"));

        orgDept.put("porgdept",parseData(pOrgDeptLists,"deptcode"));
        orgDept.put("sorgdept",parseData(sOrgDeptLists,"deptcode"));

        orgInfo.put("org",org);
        orgInfo.put("orgdept",orgDept);

        //设置当前用户组织、部门信息
        JSONObject curUser=new JSONObject();
        curUser.put("org",empInfo.get(0).getString("ORGCODE"));
        curUser.put("orgdept",empInfo.get(0).getString("DEPTCODE"));
        orgInfo.put("curuser",curUser);

        return orgInfo;
    }


    /**
     * 数据解析
     * @param datas
     * @return
     */
    private JSONArray parseData(List<JSONObject>  datas , String field ){

        JSONArray array=new JSONArray();

        if(datas.size()>0){
            for(JSONObject org: datas){
                array.add(org.getString(field));
            }
        }
        return array;
    }


}
