package cn.ibizlab.api.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;

import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;

import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;

import cn.ibizlab.api.dto.*;
import cn.ibizlab.api.mapping.*;
import cn.ibizlab.core.ou.domain.IBZEmployee;
import cn.ibizlab.core.ou.service.IIBZEmployeeService;
import cn.ibizlab.core.ou.filter.IBZEmployeeSearchContext;




@Slf4j
@Api(tags = {"IBZEmployee" })
@RestController("api-ibzemployee")
@RequestMapping("")
public class IBZEmployeeResource {

    @Autowired
    private IIBZEmployeeService ibzemployeeService;

    @Autowired
    @Lazy
    private IBZEmployeeMapping ibzemployeeMapping;




    @PreAuthorize("hasPermission('Remove',{#ibzemployee_id,{this.getEntity(),'Sql'}})")
    @ApiOperation(value = "Remove", tags = {"IBZEmployee" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/ibzemployees/{ibzemployee_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("ibzemployee_id") String ibzemployee_id) {
         return ResponseEntity.status(HttpStatus.OK).body(ibzemployeeService.remove(ibzemployee_id));
    }

    @ApiOperation(value = "RemoveBatch", tags = {"IBZEmployee" },  notes = "RemoveBatch")
	@RequestMapping(method = RequestMethod.DELETE, value = "/ibzemployees/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        ibzemployeeService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @ApiOperation(value = "初始化密码", tags = {"IBZEmployee" },  notes = "初始化密码")
	@RequestMapping(method = RequestMethod.POST, value = "/ibzemployees/{ibzemployee_id}/initpwd")
    @Transactional
    public ResponseEntity<IBZEmployeeDTO> initPwd(@PathVariable("ibzemployee_id") String ibzemployee_id, @RequestBody IBZEmployeeDTO ibzemployeedto) {
        IBZEmployee ibzemployee = ibzemployeeMapping.toDomain(ibzemployeedto);
        ibzemployee = ibzemployeeService.initPwd(ibzemployee);
        ibzemployeedto = ibzemployeeMapping.toDto(ibzemployee);
        return ResponseEntity.status(HttpStatus.OK).body(ibzemployeedto);
    }




    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Create", tags = {"IBZEmployee" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/ibzemployees")
    @Transactional
    public ResponseEntity<IBZEmployeeDTO> create(@RequestBody IBZEmployeeDTO ibzemployeedto) {
        IBZEmployee domain = ibzemployeeMapping.toDomain(ibzemployeedto);
		ibzemployeeService.create(domain);
        IBZEmployeeDTO dto = ibzemployeeMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission('','Create',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "createBatch", tags = {"IBZEmployee" },  notes = "createBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/ibzemployees/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<IBZEmployeeDTO> ibzemployeedtos) {
        ibzemployeeService.createBatch(ibzemployeeMapping.toDomain(ibzemployeedtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @ApiOperation(value = "CheckKey", tags = {"IBZEmployee" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/ibzemployees/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody IBZEmployeeDTO ibzemployeedto) {
        return  ResponseEntity.status(HttpStatus.OK).body(ibzemployeeService.checkKey(ibzemployeeMapping.toDomain(ibzemployeedto)));
    }




    @PreAuthorize("hasPermission(#ibzemployee_id,'Update',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Update", tags = {"IBZEmployee" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/ibzemployees/{ibzemployee_id}")
    @Transactional
    public ResponseEntity<IBZEmployeeDTO> update(@PathVariable("ibzemployee_id") String ibzemployee_id, @RequestBody IBZEmployeeDTO ibzemployeedto) {
		IBZEmployee domain = ibzemployeeMapping.toDomain(ibzemployeedto);
        domain.setUserid(ibzemployee_id);
		ibzemployeeService.update(domain);
		IBZEmployeeDTO dto = ibzemployeeMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(#ibzemployee_id,'Update',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "UpdateBatch", tags = {"IBZEmployee" },  notes = "UpdateBatch")
	@RequestMapping(method = RequestMethod.PUT, value = "/ibzemployees/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<IBZEmployeeDTO> ibzemployeedtos) {
        ibzemployeeService.updateBatch(ibzemployeeMapping.toDomain(ibzemployeedtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @ApiOperation(value = "Save", tags = {"IBZEmployee" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/ibzemployees/save")
    public ResponseEntity<Boolean> save(@RequestBody IBZEmployeeDTO ibzemployeedto) {
        return ResponseEntity.status(HttpStatus.OK).body(ibzemployeeService.save(ibzemployeeMapping.toDomain(ibzemployeedto)));
    }

    @ApiOperation(value = "SaveBatch", tags = {"IBZEmployee" },  notes = "SaveBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/ibzemployees/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<IBZEmployeeDTO> ibzemployeedtos) {
        ibzemployeeService.saveBatch(ibzemployeeMapping.toDomain(ibzemployeedtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }




    @PreAuthorize("hasPermission(#ibzemployee_id,'Get',{this.getEntity(),'Sql'})")
    @ApiOperation(value = "Get", tags = {"IBZEmployee" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/ibzemployees/{ibzemployee_id}")
    public ResponseEntity<IBZEmployeeDTO> get(@PathVariable("ibzemployee_id") String ibzemployee_id) {
        IBZEmployee domain = ibzemployeeService.get(ibzemployee_id);
        IBZEmployeeDTO dto = ibzemployeeMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }




    @ApiOperation(value = "GetDraft", tags = {"IBZEmployee" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/ibzemployees/getdraft")
    public ResponseEntity<IBZEmployeeDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(ibzemployeeMapping.toDto(ibzemployeeService.getDraft(new IBZEmployee())));
    }

    @PreAuthorize("hasPermission('Get',{#context,'Default',this.getEntity(),'Sql'})")
	@ApiOperation(value = "fetchDEFAULT", tags = {"IBZEmployee" } ,notes = "fetchDEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/ibzemployees/fetchdefault")
	public ResponseEntity<List<IBZEmployeeDTO>> fetchDefault(IBZEmployeeSearchContext context) {
        Page<IBZEmployee> domains = ibzemployeeService.searchDefault(context) ;
        List<IBZEmployeeDTO> list = ibzemployeeMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasPermission('Get',{#context,'Default',this.getEntity(),'Sql'})")
	@ApiOperation(value = "searchDEFAULT", tags = {"IBZEmployee" } ,notes = "searchDEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/ibzemployees/searchdefault")
	public ResponseEntity<Page<IBZEmployeeDTO>> searchDefault(IBZEmployeeSearchContext context) {
        Page<IBZEmployee> domains = ibzemployeeService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(ibzemployeeMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}



    @ApiOperation(value = "RemoveByIBZDepartment", tags = {"IBZEmployee" },  notes = "RemoveByIBZDepartment")
	@RequestMapping(method = RequestMethod.DELETE, value = "/ibzdepartments/{ibzdepartment_id}/ibzemployees/{ibzemployee_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByIBZDepartment(@PathVariable("ibzdepartment_id") String ibzdepartment_id, @PathVariable("ibzemployee_id") String ibzemployee_id) {
		return ResponseEntity.status(HttpStatus.OK).body(ibzemployeeService.remove(ibzemployee_id));
    }

    @ApiOperation(value = "RemoveBatchByIBZDepartment", tags = {"IBZEmployee" },  notes = "RemoveBatchByIBZDepartment")
	@RequestMapping(method = RequestMethod.DELETE, value = "/ibzdepartments/{ibzdepartment_id}/ibzemployees/batch")
    public ResponseEntity<Boolean> removeBatchByIBZDepartment(@RequestBody List<String> ids) {
        ibzemployeeService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "初始化密码ByIBZDepartment", tags = {"IBZEmployee" },  notes = "初始化密码ByIBZDepartment")
	@RequestMapping(method = RequestMethod.POST, value = "/ibzdepartments/{ibzdepartment_id}/ibzemployees/{ibzemployeeuserid}/initpwd")
    @Transactional
    public ResponseEntity<IBZEmployeeDTO> initPwdByIBZDepartment(@PathVariable("ibzdepartment_id") String ibzdepartment_id, @PathVariable("ibzemployee_id") String ibzemployee_id, @RequestBody IBZEmployeeDTO ibzemployeedto) {
        IBZEmployee domain = ibzemployeeMapping.toDomain(ibzemployeedto);
        domain.setMdeptid(ibzdepartment_id);
        domain = ibzemployeeService.initPwd(domain) ;
        ibzemployeedto = ibzemployeeMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(ibzemployeedto);
    }

    @ApiOperation(value = "CreateByIBZDepartment", tags = {"IBZEmployee" },  notes = "CreateByIBZDepartment")
	@RequestMapping(method = RequestMethod.POST, value = "/ibzdepartments/{ibzdepartment_id}/ibzemployees")
    @Transactional
    public ResponseEntity<IBZEmployeeDTO> createByIBZDepartment(@PathVariable("ibzdepartment_id") String ibzdepartment_id, @RequestBody IBZEmployeeDTO ibzemployeedto) {
        IBZEmployee domain = ibzemployeeMapping.toDomain(ibzemployeedto);
        domain.setMdeptid(ibzdepartment_id);
		ibzemployeeService.create(domain);
        IBZEmployeeDTO dto = ibzemployeeMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "createBatchByIBZDepartment", tags = {"IBZEmployee" },  notes = "createBatchByIBZDepartment")
	@RequestMapping(method = RequestMethod.POST, value = "/ibzdepartments/{ibzdepartment_id}/ibzemployees/batch")
    public ResponseEntity<Boolean> createBatchByIBZDepartment(@PathVariable("ibzdepartment_id") String ibzdepartment_id, @RequestBody List<IBZEmployeeDTO> ibzemployeedtos) {
        List<IBZEmployee> domainlist=ibzemployeeMapping.toDomain(ibzemployeedtos);
        for(IBZEmployee domain:domainlist){
            domain.setMdeptid(ibzdepartment_id);
        }
        ibzemployeeService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "CheckKeyByIBZDepartment", tags = {"IBZEmployee" },  notes = "CheckKeyByIBZDepartment")
	@RequestMapping(method = RequestMethod.POST, value = "/ibzdepartments/{ibzdepartment_id}/ibzemployees/checkkey")
    public ResponseEntity<Boolean> checkKeyByIBZDepartment(@PathVariable("ibzdepartment_id") String ibzdepartment_id, @RequestBody IBZEmployeeDTO ibzemployeedto) {
        return  ResponseEntity.status(HttpStatus.OK).body(ibzemployeeService.checkKey(ibzemployeeMapping.toDomain(ibzemployeedto)));
    }

    @ApiOperation(value = "UpdateByIBZDepartment", tags = {"IBZEmployee" },  notes = "UpdateByIBZDepartment")
	@RequestMapping(method = RequestMethod.PUT, value = "/ibzdepartments/{ibzdepartment_id}/ibzemployees/{ibzemployee_id}")
    @Transactional
    public ResponseEntity<IBZEmployeeDTO> updateByIBZDepartment(@PathVariable("ibzdepartment_id") String ibzdepartment_id, @PathVariable("ibzemployee_id") String ibzemployee_id, @RequestBody IBZEmployeeDTO ibzemployeedto) {
        IBZEmployee domain = ibzemployeeMapping.toDomain(ibzemployeedto);
        domain.setMdeptid(ibzdepartment_id);
        domain.setUserid(ibzemployee_id);
		ibzemployeeService.update(domain);
        IBZEmployeeDTO dto = ibzemployeeMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateBatchByIBZDepartment", tags = {"IBZEmployee" },  notes = "UpdateBatchByIBZDepartment")
	@RequestMapping(method = RequestMethod.PUT, value = "/ibzdepartments/{ibzdepartment_id}/ibzemployees/batch")
    public ResponseEntity<Boolean> updateBatchByIBZDepartment(@PathVariable("ibzdepartment_id") String ibzdepartment_id, @RequestBody List<IBZEmployeeDTO> ibzemployeedtos) {
        List<IBZEmployee> domainlist=ibzemployeeMapping.toDomain(ibzemployeedtos);
        for(IBZEmployee domain:domainlist){
            domain.setMdeptid(ibzdepartment_id);
        }
        ibzemployeeService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "SaveByIBZDepartment", tags = {"IBZEmployee" },  notes = "SaveByIBZDepartment")
	@RequestMapping(method = RequestMethod.POST, value = "/ibzdepartments/{ibzdepartment_id}/ibzemployees/save")
    public ResponseEntity<Boolean> saveByIBZDepartment(@PathVariable("ibzdepartment_id") String ibzdepartment_id, @RequestBody IBZEmployeeDTO ibzemployeedto) {
        IBZEmployee domain = ibzemployeeMapping.toDomain(ibzemployeedto);
        domain.setMdeptid(ibzdepartment_id);
        return ResponseEntity.status(HttpStatus.OK).body(ibzemployeeService.save(domain));
    }

    @ApiOperation(value = "SaveBatchByIBZDepartment", tags = {"IBZEmployee" },  notes = "SaveBatchByIBZDepartment")
	@RequestMapping(method = RequestMethod.POST, value = "/ibzdepartments/{ibzdepartment_id}/ibzemployees/savebatch")
    public ResponseEntity<Boolean> saveBatchByIBZDepartment(@PathVariable("ibzdepartment_id") String ibzdepartment_id, @RequestBody List<IBZEmployeeDTO> ibzemployeedtos) {
        List<IBZEmployee> domainlist=ibzemployeeMapping.toDomain(ibzemployeedtos);
        for(IBZEmployee domain:domainlist){
             domain.setMdeptid(ibzdepartment_id);
        }
        ibzemployeeService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetByIBZDepartment", tags = {"IBZEmployee" },  notes = "GetByIBZDepartment")
	@RequestMapping(method = RequestMethod.GET, value = "/ibzdepartments/{ibzdepartment_id}/ibzemployees/{ibzemployee_id}")
    public ResponseEntity<IBZEmployeeDTO> getByIBZDepartment(@PathVariable("ibzdepartment_id") String ibzdepartment_id, @PathVariable("ibzemployee_id") String ibzemployee_id) {
        IBZEmployee domain = ibzemployeeService.get(ibzemployee_id);
        IBZEmployeeDTO dto = ibzemployeeMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "GetDraftByIBZDepartment", tags = {"IBZEmployee" },  notes = "GetDraftByIBZDepartment")
    @RequestMapping(method = RequestMethod.GET, value = "/ibzdepartments/{ibzdepartment_id}/ibzemployees/getdraft")
    public ResponseEntity<IBZEmployeeDTO> getDraftByIBZDepartment(@PathVariable("ibzdepartment_id") String ibzdepartment_id) {
        IBZEmployee domain = new IBZEmployee();
        domain.setMdeptid(ibzdepartment_id);
        return ResponseEntity.status(HttpStatus.OK).body(ibzemployeeMapping.toDto(ibzemployeeService.getDraft(domain)));
    }

	@ApiOperation(value = "fetchDEFAULTByIBZDepartment", tags = {"IBZEmployee" } ,notes = "fetchDEFAULTByIBZDepartment")
    @RequestMapping(method= RequestMethod.GET , value="/ibzdepartments/{ibzdepartment_id}/ibzemployees/fetchdefault")
	public ResponseEntity<List<IBZEmployeeDTO>> fetchIBZEmployeeDefaultByIBZDepartment(@PathVariable("ibzdepartment_id") String ibzdepartment_id,IBZEmployeeSearchContext context) {
        context.setN_mdeptid_eq(ibzdepartment_id);
        Page<IBZEmployee> domains = ibzemployeeService.searchDefault(context) ;
        List<IBZEmployeeDTO> list = ibzemployeeMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "searchDEFAULTByIBZDepartment", tags = {"IBZEmployee" } ,notes = "searchDEFAULTByIBZDepartment")
    @RequestMapping(method= RequestMethod.GET , value="/ibzdepartments/{ibzdepartment_id}/ibzemployees/searchdefault")
	public ResponseEntity<Page<IBZEmployeeDTO>> searchIBZEmployeeDefaultByIBZDepartment(@PathVariable("ibzdepartment_id") String ibzdepartment_id,IBZEmployeeSearchContext context) {
        context.setN_mdeptid_eq(ibzdepartment_id);
        Page<IBZEmployee> domains = ibzemployeeService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(ibzemployeeMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}



    @ApiOperation(value = "RemoveByIBZOrganization", tags = {"IBZEmployee" },  notes = "RemoveByIBZOrganization")
	@RequestMapping(method = RequestMethod.DELETE, value = "/ibzorganizations/{ibzorganization_id}/ibzemployees/{ibzemployee_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByIBZOrganization(@PathVariable("ibzorganization_id") String ibzorganization_id, @PathVariable("ibzemployee_id") String ibzemployee_id) {
		return ResponseEntity.status(HttpStatus.OK).body(ibzemployeeService.remove(ibzemployee_id));
    }

    @ApiOperation(value = "RemoveBatchByIBZOrganization", tags = {"IBZEmployee" },  notes = "RemoveBatchByIBZOrganization")
	@RequestMapping(method = RequestMethod.DELETE, value = "/ibzorganizations/{ibzorganization_id}/ibzemployees/batch")
    public ResponseEntity<Boolean> removeBatchByIBZOrganization(@RequestBody List<String> ids) {
        ibzemployeeService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "初始化密码ByIBZOrganization", tags = {"IBZEmployee" },  notes = "初始化密码ByIBZOrganization")
	@RequestMapping(method = RequestMethod.POST, value = "/ibzorganizations/{ibzorganization_id}/ibzemployees/{ibzemployeeuserid}/initpwd")
    @Transactional
    public ResponseEntity<IBZEmployeeDTO> initPwdByIBZOrganization(@PathVariable("ibzorganization_id") String ibzorganization_id, @PathVariable("ibzemployee_id") String ibzemployee_id, @RequestBody IBZEmployeeDTO ibzemployeedto) {
        IBZEmployee domain = ibzemployeeMapping.toDomain(ibzemployeedto);
        domain.setOrgid(ibzorganization_id);
        domain = ibzemployeeService.initPwd(domain) ;
        ibzemployeedto = ibzemployeeMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(ibzemployeedto);
    }

    @ApiOperation(value = "CreateByIBZOrganization", tags = {"IBZEmployee" },  notes = "CreateByIBZOrganization")
	@RequestMapping(method = RequestMethod.POST, value = "/ibzorganizations/{ibzorganization_id}/ibzemployees")
    @Transactional
    public ResponseEntity<IBZEmployeeDTO> createByIBZOrganization(@PathVariable("ibzorganization_id") String ibzorganization_id, @RequestBody IBZEmployeeDTO ibzemployeedto) {
        IBZEmployee domain = ibzemployeeMapping.toDomain(ibzemployeedto);
        domain.setOrgid(ibzorganization_id);
		ibzemployeeService.create(domain);
        IBZEmployeeDTO dto = ibzemployeeMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "createBatchByIBZOrganization", tags = {"IBZEmployee" },  notes = "createBatchByIBZOrganization")
	@RequestMapping(method = RequestMethod.POST, value = "/ibzorganizations/{ibzorganization_id}/ibzemployees/batch")
    public ResponseEntity<Boolean> createBatchByIBZOrganization(@PathVariable("ibzorganization_id") String ibzorganization_id, @RequestBody List<IBZEmployeeDTO> ibzemployeedtos) {
        List<IBZEmployee> domainlist=ibzemployeeMapping.toDomain(ibzemployeedtos);
        for(IBZEmployee domain:domainlist){
            domain.setOrgid(ibzorganization_id);
        }
        ibzemployeeService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "CheckKeyByIBZOrganization", tags = {"IBZEmployee" },  notes = "CheckKeyByIBZOrganization")
	@RequestMapping(method = RequestMethod.POST, value = "/ibzorganizations/{ibzorganization_id}/ibzemployees/checkkey")
    public ResponseEntity<Boolean> checkKeyByIBZOrganization(@PathVariable("ibzorganization_id") String ibzorganization_id, @RequestBody IBZEmployeeDTO ibzemployeedto) {
        return  ResponseEntity.status(HttpStatus.OK).body(ibzemployeeService.checkKey(ibzemployeeMapping.toDomain(ibzemployeedto)));
    }

    @ApiOperation(value = "UpdateByIBZOrganization", tags = {"IBZEmployee" },  notes = "UpdateByIBZOrganization")
	@RequestMapping(method = RequestMethod.PUT, value = "/ibzorganizations/{ibzorganization_id}/ibzemployees/{ibzemployee_id}")
    @Transactional
    public ResponseEntity<IBZEmployeeDTO> updateByIBZOrganization(@PathVariable("ibzorganization_id") String ibzorganization_id, @PathVariable("ibzemployee_id") String ibzemployee_id, @RequestBody IBZEmployeeDTO ibzemployeedto) {
        IBZEmployee domain = ibzemployeeMapping.toDomain(ibzemployeedto);
        domain.setOrgid(ibzorganization_id);
        domain.setUserid(ibzemployee_id);
		ibzemployeeService.update(domain);
        IBZEmployeeDTO dto = ibzemployeeMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateBatchByIBZOrganization", tags = {"IBZEmployee" },  notes = "UpdateBatchByIBZOrganization")
	@RequestMapping(method = RequestMethod.PUT, value = "/ibzorganizations/{ibzorganization_id}/ibzemployees/batch")
    public ResponseEntity<Boolean> updateBatchByIBZOrganization(@PathVariable("ibzorganization_id") String ibzorganization_id, @RequestBody List<IBZEmployeeDTO> ibzemployeedtos) {
        List<IBZEmployee> domainlist=ibzemployeeMapping.toDomain(ibzemployeedtos);
        for(IBZEmployee domain:domainlist){
            domain.setOrgid(ibzorganization_id);
        }
        ibzemployeeService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "SaveByIBZOrganization", tags = {"IBZEmployee" },  notes = "SaveByIBZOrganization")
	@RequestMapping(method = RequestMethod.POST, value = "/ibzorganizations/{ibzorganization_id}/ibzemployees/save")
    public ResponseEntity<Boolean> saveByIBZOrganization(@PathVariable("ibzorganization_id") String ibzorganization_id, @RequestBody IBZEmployeeDTO ibzemployeedto) {
        IBZEmployee domain = ibzemployeeMapping.toDomain(ibzemployeedto);
        domain.setOrgid(ibzorganization_id);
        return ResponseEntity.status(HttpStatus.OK).body(ibzemployeeService.save(domain));
    }

    @ApiOperation(value = "SaveBatchByIBZOrganization", tags = {"IBZEmployee" },  notes = "SaveBatchByIBZOrganization")
	@RequestMapping(method = RequestMethod.POST, value = "/ibzorganizations/{ibzorganization_id}/ibzemployees/savebatch")
    public ResponseEntity<Boolean> saveBatchByIBZOrganization(@PathVariable("ibzorganization_id") String ibzorganization_id, @RequestBody List<IBZEmployeeDTO> ibzemployeedtos) {
        List<IBZEmployee> domainlist=ibzemployeeMapping.toDomain(ibzemployeedtos);
        for(IBZEmployee domain:domainlist){
             domain.setOrgid(ibzorganization_id);
        }
        ibzemployeeService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetByIBZOrganization", tags = {"IBZEmployee" },  notes = "GetByIBZOrganization")
	@RequestMapping(method = RequestMethod.GET, value = "/ibzorganizations/{ibzorganization_id}/ibzemployees/{ibzemployee_id}")
    public ResponseEntity<IBZEmployeeDTO> getByIBZOrganization(@PathVariable("ibzorganization_id") String ibzorganization_id, @PathVariable("ibzemployee_id") String ibzemployee_id) {
        IBZEmployee domain = ibzemployeeService.get(ibzemployee_id);
        IBZEmployeeDTO dto = ibzemployeeMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "GetDraftByIBZOrganization", tags = {"IBZEmployee" },  notes = "GetDraftByIBZOrganization")
    @RequestMapping(method = RequestMethod.GET, value = "/ibzorganizations/{ibzorganization_id}/ibzemployees/getdraft")
    public ResponseEntity<IBZEmployeeDTO> getDraftByIBZOrganization(@PathVariable("ibzorganization_id") String ibzorganization_id) {
        IBZEmployee domain = new IBZEmployee();
        domain.setOrgid(ibzorganization_id);
        return ResponseEntity.status(HttpStatus.OK).body(ibzemployeeMapping.toDto(ibzemployeeService.getDraft(domain)));
    }

	@ApiOperation(value = "fetchDEFAULTByIBZOrganization", tags = {"IBZEmployee" } ,notes = "fetchDEFAULTByIBZOrganization")
    @RequestMapping(method= RequestMethod.GET , value="/ibzorganizations/{ibzorganization_id}/ibzemployees/fetchdefault")
	public ResponseEntity<List<IBZEmployeeDTO>> fetchIBZEmployeeDefaultByIBZOrganization(@PathVariable("ibzorganization_id") String ibzorganization_id,IBZEmployeeSearchContext context) {
        context.setN_orgid_eq(ibzorganization_id);
        Page<IBZEmployee> domains = ibzemployeeService.searchDefault(context) ;
        List<IBZEmployeeDTO> list = ibzemployeeMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "searchDEFAULTByIBZOrganization", tags = {"IBZEmployee" } ,notes = "searchDEFAULTByIBZOrganization")
    @RequestMapping(method= RequestMethod.GET , value="/ibzorganizations/{ibzorganization_id}/ibzemployees/searchdefault")
	public ResponseEntity<Page<IBZEmployeeDTO>> searchIBZEmployeeDefaultByIBZOrganization(@PathVariable("ibzorganization_id") String ibzorganization_id,IBZEmployeeSearchContext context) {
        context.setN_orgid_eq(ibzorganization_id);
        Page<IBZEmployee> domains = ibzemployeeService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(ibzemployeeMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}




    @ApiOperation(value = "RemoveByIBZOrganizationIBZDepartment", tags = {"IBZEmployee" },  notes = "RemoveByIBZOrganizationIBZDepartment")
	@RequestMapping(method = RequestMethod.DELETE, value = "/ibzorganizations/{ibzorganization_id}/ibzdepartments/{ibzdepartment_id}/ibzemployees/{ibzemployee_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByIBZOrganizationIBZDepartment(@PathVariable("ibzorganization_id") String ibzorganization_id, @PathVariable("ibzdepartment_id") String ibzdepartment_id, @PathVariable("ibzemployee_id") String ibzemployee_id) {
		return ResponseEntity.status(HttpStatus.OK).body(ibzemployeeService.remove(ibzemployee_id));
    }

    @ApiOperation(value = "RemoveBatchByIBZOrganizationIBZDepartment", tags = {"IBZEmployee" },  notes = "RemoveBatchByIBZOrganizationIBZDepartment")
	@RequestMapping(method = RequestMethod.DELETE, value = "/ibzorganizations/{ibzorganization_id}/ibzdepartments/{ibzdepartment_id}/ibzemployees/batch")
    public ResponseEntity<Boolean> removeBatchByIBZOrganizationIBZDepartment(@RequestBody List<String> ids) {
        ibzemployeeService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "初始化密码ByIBZOrganizationIBZDepartment", tags = {"IBZEmployee" },  notes = "初始化密码ByIBZOrganizationIBZDepartment")
	@RequestMapping(method = RequestMethod.POST, value = "/ibzorganizations/{ibzorganization_id}/ibzdepartments/{ibzdepartment_id}/ibzemployees/{ibzemployeeuserid}/initpwd")
    @Transactional
    public ResponseEntity<IBZEmployeeDTO> initPwdByIBZOrganizationIBZDepartment(@PathVariable("ibzorganization_id") String ibzorganization_id, @PathVariable("ibzdepartment_id") String ibzdepartment_id, @PathVariable("ibzemployee_id") String ibzemployee_id, @RequestBody IBZEmployeeDTO ibzemployeedto) {
        IBZEmployee domain = ibzemployeeMapping.toDomain(ibzemployeedto);
        domain.setMdeptid(ibzdepartment_id);
        domain = ibzemployeeService.initPwd(domain) ;
        ibzemployeedto = ibzemployeeMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(ibzemployeedto);
    }

    @ApiOperation(value = "CreateByIBZOrganizationIBZDepartment", tags = {"IBZEmployee" },  notes = "CreateByIBZOrganizationIBZDepartment")
	@RequestMapping(method = RequestMethod.POST, value = "/ibzorganizations/{ibzorganization_id}/ibzdepartments/{ibzdepartment_id}/ibzemployees")
    @Transactional
    public ResponseEntity<IBZEmployeeDTO> createByIBZOrganizationIBZDepartment(@PathVariable("ibzorganization_id") String ibzorganization_id, @PathVariable("ibzdepartment_id") String ibzdepartment_id, @RequestBody IBZEmployeeDTO ibzemployeedto) {
        IBZEmployee domain = ibzemployeeMapping.toDomain(ibzemployeedto);
        domain.setMdeptid(ibzdepartment_id);
		ibzemployeeService.create(domain);
        IBZEmployeeDTO dto = ibzemployeeMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "createBatchByIBZOrganizationIBZDepartment", tags = {"IBZEmployee" },  notes = "createBatchByIBZOrganizationIBZDepartment")
	@RequestMapping(method = RequestMethod.POST, value = "/ibzorganizations/{ibzorganization_id}/ibzdepartments/{ibzdepartment_id}/ibzemployees/batch")
    public ResponseEntity<Boolean> createBatchByIBZOrganizationIBZDepartment(@PathVariable("ibzorganization_id") String ibzorganization_id, @PathVariable("ibzdepartment_id") String ibzdepartment_id, @RequestBody List<IBZEmployeeDTO> ibzemployeedtos) {
        List<IBZEmployee> domainlist=ibzemployeeMapping.toDomain(ibzemployeedtos);
        for(IBZEmployee domain:domainlist){
            domain.setMdeptid(ibzdepartment_id);
        }
        ibzemployeeService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "CheckKeyByIBZOrganizationIBZDepartment", tags = {"IBZEmployee" },  notes = "CheckKeyByIBZOrganizationIBZDepartment")
	@RequestMapping(method = RequestMethod.POST, value = "/ibzorganizations/{ibzorganization_id}/ibzdepartments/{ibzdepartment_id}/ibzemployees/checkkey")
    public ResponseEntity<Boolean> checkKeyByIBZOrganizationIBZDepartment(@PathVariable("ibzorganization_id") String ibzorganization_id, @PathVariable("ibzdepartment_id") String ibzdepartment_id, @RequestBody IBZEmployeeDTO ibzemployeedto) {
        return  ResponseEntity.status(HttpStatus.OK).body(ibzemployeeService.checkKey(ibzemployeeMapping.toDomain(ibzemployeedto)));
    }

    @ApiOperation(value = "UpdateByIBZOrganizationIBZDepartment", tags = {"IBZEmployee" },  notes = "UpdateByIBZOrganizationIBZDepartment")
	@RequestMapping(method = RequestMethod.PUT, value = "/ibzorganizations/{ibzorganization_id}/ibzdepartments/{ibzdepartment_id}/ibzemployees/{ibzemployee_id}")
    @Transactional
    public ResponseEntity<IBZEmployeeDTO> updateByIBZOrganizationIBZDepartment(@PathVariable("ibzorganization_id") String ibzorganization_id, @PathVariable("ibzdepartment_id") String ibzdepartment_id, @PathVariable("ibzemployee_id") String ibzemployee_id, @RequestBody IBZEmployeeDTO ibzemployeedto) {
        IBZEmployee domain = ibzemployeeMapping.toDomain(ibzemployeedto);
        domain.setMdeptid(ibzdepartment_id);
        domain.setUserid(ibzemployee_id);
		ibzemployeeService.update(domain);
        IBZEmployeeDTO dto = ibzemployeeMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "UpdateBatchByIBZOrganizationIBZDepartment", tags = {"IBZEmployee" },  notes = "UpdateBatchByIBZOrganizationIBZDepartment")
	@RequestMapping(method = RequestMethod.PUT, value = "/ibzorganizations/{ibzorganization_id}/ibzdepartments/{ibzdepartment_id}/ibzemployees/batch")
    public ResponseEntity<Boolean> updateBatchByIBZOrganizationIBZDepartment(@PathVariable("ibzorganization_id") String ibzorganization_id, @PathVariable("ibzdepartment_id") String ibzdepartment_id, @RequestBody List<IBZEmployeeDTO> ibzemployeedtos) {
        List<IBZEmployee> domainlist=ibzemployeeMapping.toDomain(ibzemployeedtos);
        for(IBZEmployee domain:domainlist){
            domain.setMdeptid(ibzdepartment_id);
        }
        ibzemployeeService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "SaveByIBZOrganizationIBZDepartment", tags = {"IBZEmployee" },  notes = "SaveByIBZOrganizationIBZDepartment")
	@RequestMapping(method = RequestMethod.POST, value = "/ibzorganizations/{ibzorganization_id}/ibzdepartments/{ibzdepartment_id}/ibzemployees/save")
    public ResponseEntity<Boolean> saveByIBZOrganizationIBZDepartment(@PathVariable("ibzorganization_id") String ibzorganization_id, @PathVariable("ibzdepartment_id") String ibzdepartment_id, @RequestBody IBZEmployeeDTO ibzemployeedto) {
        IBZEmployee domain = ibzemployeeMapping.toDomain(ibzemployeedto);
        domain.setMdeptid(ibzdepartment_id);
        return ResponseEntity.status(HttpStatus.OK).body(ibzemployeeService.save(domain));
    }

    @ApiOperation(value = "SaveBatchByIBZOrganizationIBZDepartment", tags = {"IBZEmployee" },  notes = "SaveBatchByIBZOrganizationIBZDepartment")
	@RequestMapping(method = RequestMethod.POST, value = "/ibzorganizations/{ibzorganization_id}/ibzdepartments/{ibzdepartment_id}/ibzemployees/savebatch")
    public ResponseEntity<Boolean> saveBatchByIBZOrganizationIBZDepartment(@PathVariable("ibzorganization_id") String ibzorganization_id, @PathVariable("ibzdepartment_id") String ibzdepartment_id, @RequestBody List<IBZEmployeeDTO> ibzemployeedtos) {
        List<IBZEmployee> domainlist=ibzemployeeMapping.toDomain(ibzemployeedtos);
        for(IBZEmployee domain:domainlist){
             domain.setMdeptid(ibzdepartment_id);
        }
        ibzemployeeService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetByIBZOrganizationIBZDepartment", tags = {"IBZEmployee" },  notes = "GetByIBZOrganizationIBZDepartment")
	@RequestMapping(method = RequestMethod.GET, value = "/ibzorganizations/{ibzorganization_id}/ibzdepartments/{ibzdepartment_id}/ibzemployees/{ibzemployee_id}")
    public ResponseEntity<IBZEmployeeDTO> getByIBZOrganizationIBZDepartment(@PathVariable("ibzorganization_id") String ibzorganization_id, @PathVariable("ibzdepartment_id") String ibzdepartment_id, @PathVariable("ibzemployee_id") String ibzemployee_id) {
        IBZEmployee domain = ibzemployeeService.get(ibzemployee_id);
        IBZEmployeeDTO dto = ibzemployeeMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "GetDraftByIBZOrganizationIBZDepartment", tags = {"IBZEmployee" },  notes = "GetDraftByIBZOrganizationIBZDepartment")
    @RequestMapping(method = RequestMethod.GET, value = "/ibzorganizations/{ibzorganization_id}/ibzdepartments/{ibzdepartment_id}/ibzemployees/getdraft")
    public ResponseEntity<IBZEmployeeDTO> getDraftByIBZOrganizationIBZDepartment(@PathVariable("ibzorganization_id") String ibzorganization_id, @PathVariable("ibzdepartment_id") String ibzdepartment_id) {
        IBZEmployee domain = new IBZEmployee();
        domain.setMdeptid(ibzdepartment_id);
        return ResponseEntity.status(HttpStatus.OK).body(ibzemployeeMapping.toDto(ibzemployeeService.getDraft(domain)));
    }

	@ApiOperation(value = "fetchDEFAULTByIBZOrganizationIBZDepartment", tags = {"IBZEmployee" } ,notes = "fetchDEFAULTByIBZOrganizationIBZDepartment")
    @RequestMapping(method= RequestMethod.GET , value="/ibzorganizations/{ibzorganization_id}/ibzdepartments/{ibzdepartment_id}/ibzemployees/fetchdefault")
	public ResponseEntity<List<IBZEmployeeDTO>> fetchIBZEmployeeDefaultByIBZOrganizationIBZDepartment(@PathVariable("ibzorganization_id") String ibzorganization_id, @PathVariable("ibzdepartment_id") String ibzdepartment_id,IBZEmployeeSearchContext context) {
        context.setN_mdeptid_eq(ibzdepartment_id);
        Page<IBZEmployee> domains = ibzemployeeService.searchDefault(context) ;
        List<IBZEmployeeDTO> list = ibzemployeeMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

	@ApiOperation(value = "searchDEFAULTByIBZOrganizationIBZDepartment", tags = {"IBZEmployee" } ,notes = "searchDEFAULTByIBZOrganizationIBZDepartment")
    @RequestMapping(method= RequestMethod.GET , value="/ibzorganizations/{ibzorganization_id}/ibzdepartments/{ibzdepartment_id}/ibzemployees/searchdefault")
	public ResponseEntity<Page<IBZEmployeeDTO>> searchIBZEmployeeDefaultByIBZOrganizationIBZDepartment(@PathVariable("ibzorganization_id") String ibzorganization_id, @PathVariable("ibzdepartment_id") String ibzdepartment_id,IBZEmployeeSearchContext context) {
        context.setN_mdeptid_eq(ibzdepartment_id);
        Page<IBZEmployee> domains = ibzemployeeService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(ibzemployeeMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}


    /**
     * 用户权限校验
     * @return
     */
	public IBZEmployee getEntity(){
        return new IBZEmployee();
    }

}
