package cn.ibizlab.util.rest;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import cn.ibizlab.util.security.AuthenticationUser;

@RestController
@RequestMapping(value = "")
public class AppController {

	@RequestMapping(method = RequestMethod.GET, value = "/appdata")
	public ResponseEntity<JSONObject> getAppData() {

		JSONObject appData = new JSONObject() ;
		JSONArray uniRes=new JSONArray();
		JSONObject userPermission=AuthenticationUser.getAuthenticationUser().getPermissionList();
		if(!ObjectUtils.isEmpty(userPermission)){
			uniRes = userPermission.getJSONArray("unires");
		}
		appData.put("unires",uniRes);
		return ResponseEntity.status(HttpStatus.OK).body(appData);
	}

}
