package cn.ibizlab.api.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.access.prepost.PostAuthorize;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.api.dto.*;
import cn.ibizlab.api.mapping.*;
import cn.ibizlab.core.ou.domain.IBZOrganization;
import cn.ibizlab.core.ou.service.IIBZOrganizationService;
import cn.ibizlab.core.ou.filter.IBZOrganizationSearchContext;

@Slf4j
@Api(tags = {"IBZOrganization" })
@RestController("api-ibzorganization")
@RequestMapping("")
public class IBZOrganizationResource {

    @Autowired
    public IIBZOrganizationService ibzorganizationService;

    @Autowired
    @Lazy
    public IBZOrganizationMapping ibzorganizationMapping;

    @ApiOperation(value = "CheckKey", tags = {"IBZOrganization" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/ibzorganizations/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody IBZOrganizationDTO ibzorganizationdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(ibzorganizationService.checkKey(ibzorganizationMapping.toDomain(ibzorganizationdto)));
    }

    @PreAuthorize("hasPermission(this.ibzorganizationService.get(#ibzorganization_id),'ibzou-IBZOrganization-Update')")
    @ApiOperation(value = "Update", tags = {"IBZOrganization" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/ibzorganizations/{ibzorganization_id}")
    @Transactional
    public ResponseEntity<IBZOrganizationDTO> update(@PathVariable("ibzorganization_id") String ibzorganization_id, @RequestBody IBZOrganizationDTO ibzorganizationdto) {
		IBZOrganization domain  = ibzorganizationMapping.toDomain(ibzorganizationdto);
        domain .setOrgid(ibzorganization_id);
		ibzorganizationService.update(domain );
		IBZOrganizationDTO dto = ibzorganizationMapping.toDto(domain );
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    //@PreAuthorize("hasPermission(this.ibzorganizationMapping.toDomain(#ibzorganizationdtos),'ibzou-IBZOrganization-Update')")
    @ApiOperation(value = "UpdateBatch", tags = {"IBZOrganization" },  notes = "UpdateBatch")
	@RequestMapping(method = RequestMethod.PUT, value = "/ibzorganizations/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<IBZOrganizationDTO> ibzorganizationdtos) {
        ibzorganizationService.updateBatch(ibzorganizationMapping.toDomain(ibzorganizationdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(this.ibzorganizationMapping.toDomain(#ibzorganizationdto),'ibzou-IBZOrganization-Create')")
    @ApiOperation(value = "Create", tags = {"IBZOrganization" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/ibzorganizations")
    @Transactional
    public ResponseEntity<IBZOrganizationDTO> create(@RequestBody IBZOrganizationDTO ibzorganizationdto) {
        IBZOrganization domain = ibzorganizationMapping.toDomain(ibzorganizationdto);
		ibzorganizationService.create(domain);
        IBZOrganizationDTO dto = ibzorganizationMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    //@PreAuthorize("hasPermission(this.ibzorganizationMapping.toDomain(#ibzorganizationdtos),'ibzou-IBZOrganization-Create')")
    @ApiOperation(value = "createBatch", tags = {"IBZOrganization" },  notes = "createBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/ibzorganizations/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<IBZOrganizationDTO> ibzorganizationdtos) {
        ibzorganizationService.createBatch(ibzorganizationMapping.toDomain(ibzorganizationdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(this.ibzorganizationMapping.toDomain(#ibzorganizationdto),'ibzou-IBZOrganization-Save')")
    @ApiOperation(value = "Save", tags = {"IBZOrganization" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/ibzorganizations/save")
    public ResponseEntity<Boolean> save(@RequestBody IBZOrganizationDTO ibzorganizationdto) {
        return ResponseEntity.status(HttpStatus.OK).body(ibzorganizationService.save(ibzorganizationMapping.toDomain(ibzorganizationdto)));
    }

    //@PreAuthorize("hasPermission(this.ibzorganizationMapping.toDomain(#ibzorganizationdtos),'ibzou-IBZOrganization-Save')")
    @ApiOperation(value = "SaveBatch", tags = {"IBZOrganization" },  notes = "SaveBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/ibzorganizations/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<IBZOrganizationDTO> ibzorganizationdtos) {
        ibzorganizationService.saveBatch(ibzorganizationMapping.toDomain(ibzorganizationdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(this.ibzorganizationService.get(#ibzorganization_id),'ibzou-IBZOrganization-Remove')")
    @ApiOperation(value = "Remove", tags = {"IBZOrganization" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/ibzorganizations/{ibzorganization_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("ibzorganization_id") String ibzorganization_id) {
         return ResponseEntity.status(HttpStatus.OK).body(ibzorganizationService.remove(ibzorganization_id));
    }

    //
    @ApiOperation(value = "RemoveBatch", tags = {"IBZOrganization" },  notes = "RemoveBatch")
	@RequestMapping(method = RequestMethod.DELETE, value = "/ibzorganizations/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        ibzorganizationService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PostAuthorize("hasPermission(this.ibzorganizationMapping.toDomain(returnObject.body),'ibzou-IBZOrganization-Get')")
    @ApiOperation(value = "Get", tags = {"IBZOrganization" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/ibzorganizations/{ibzorganization_id}")
    public ResponseEntity<IBZOrganizationDTO> get(@PathVariable("ibzorganization_id") String ibzorganization_id) {
        IBZOrganization domain = ibzorganizationService.get(ibzorganization_id);
        IBZOrganizationDTO dto = ibzorganizationMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "GetDraft", tags = {"IBZOrganization" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/ibzorganizations/getdraft")
    public ResponseEntity<IBZOrganizationDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(ibzorganizationMapping.toDto(ibzorganizationService.getDraft(new IBZOrganization())));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzou-IBZOrganization-SelectSOrg-all')")
	@ApiOperation(value = "fetch查询下级单位", tags = {"IBZOrganization" } ,notes = "fetch查询下级单位")
    @RequestMapping(method= RequestMethod.GET , value="/ibzorganizations/fetchselectsorg")
	public ResponseEntity<List<IBZOrganizationDTO>> fetchSelectSOrg(IBZOrganizationSearchContext context) {
        Page<IBZOrganization> domains = ibzorganizationService.searchSelectSOrg(context) ;
        List<IBZOrganizationDTO> list = ibzorganizationMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzou-IBZOrganization-SelectSOrg-all')")
	@ApiOperation(value = "search查询下级单位", tags = {"IBZOrganization" } ,notes = "search查询下级单位")
    @RequestMapping(method= RequestMethod.POST , value="/ibzorganizations/searchselectsorg")
	public ResponseEntity<Page<IBZOrganizationDTO>> searchSelectSOrg(@RequestBody IBZOrganizationSearchContext context) {
        Page<IBZOrganization> domains = ibzorganizationService.searchSelectSOrg(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(ibzorganizationMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzou-IBZOrganization-SelectPOrg-all')")
	@ApiOperation(value = "fetch查询上级单位", tags = {"IBZOrganization" } ,notes = "fetch查询上级单位")
    @RequestMapping(method= RequestMethod.GET , value="/ibzorganizations/fetchselectporg")
	public ResponseEntity<List<IBZOrganizationDTO>> fetchSelectPOrg(IBZOrganizationSearchContext context) {
        Page<IBZOrganization> domains = ibzorganizationService.searchSelectPOrg(context) ;
        List<IBZOrganizationDTO> list = ibzorganizationMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzou-IBZOrganization-SelectPOrg-all')")
	@ApiOperation(value = "search查询上级单位", tags = {"IBZOrganization" } ,notes = "search查询上级单位")
    @RequestMapping(method= RequestMethod.POST , value="/ibzorganizations/searchselectporg")
	public ResponseEntity<Page<IBZOrganizationDTO>> searchSelectPOrg(@RequestBody IBZOrganizationSearchContext context) {
        Page<IBZOrganization> domains = ibzorganizationService.searchSelectPOrg(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(ibzorganizationMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzou-IBZOrganization-Default-all')")
	@ApiOperation(value = "fetchDEFAULT", tags = {"IBZOrganization" } ,notes = "fetchDEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/ibzorganizations/fetchdefault")
	public ResponseEntity<List<IBZOrganizationDTO>> fetchDefault(IBZOrganizationSearchContext context) {
        Page<IBZOrganization> domains = ibzorganizationService.searchDefault(context) ;
        List<IBZOrganizationDTO> list = ibzorganizationMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzou-IBZOrganization-Default-all')")
	@ApiOperation(value = "searchDEFAULT", tags = {"IBZOrganization" } ,notes = "searchDEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/ibzorganizations/searchdefault")
	public ResponseEntity<Page<IBZOrganizationDTO>> searchDefault(@RequestBody IBZOrganizationSearchContext context) {
        Page<IBZOrganization> domains = ibzorganizationService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(ibzorganizationMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
}
