package cn.ibizlab.api.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.access.prepost.PostAuthorize;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.api.dto.*;
import cn.ibizlab.api.mapping.*;
import cn.ibizlab.core.ou.domain.IBZDeptMember;
import cn.ibizlab.core.ou.service.IIBZDeptMemberService;
import cn.ibizlab.core.ou.filter.IBZDeptMemberSearchContext;

@Slf4j
@Api(tags = {"IBZDeptMember" })
@RestController("api-ibzdeptmember")
@RequestMapping("")
public class IBZDeptMemberResource {

    @Autowired
    public IIBZDeptMemberService ibzdeptmemberService;

    @Autowired
    @Lazy
    public IBZDeptMemberMapping ibzdeptmemberMapping;

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzou-IBZDeptMember-Update-all')")
    @ApiOperation(value = "Update", tags = {"IBZDeptMember" },  notes = "Update")
	@RequestMapping(method = RequestMethod.PUT, value = "/ibzdeptmembers/{ibzdeptmember_id}")
    @Transactional
    public ResponseEntity<IBZDeptMemberDTO> update(@PathVariable("ibzdeptmember_id") String ibzdeptmember_id, @RequestBody IBZDeptMemberDTO ibzdeptmemberdto) {
		IBZDeptMember domain  = ibzdeptmemberMapping.toDomain(ibzdeptmemberdto);
        domain .setMemberid(ibzdeptmember_id);
		ibzdeptmemberService.update(domain );
		IBZDeptMemberDTO dto = ibzdeptmemberMapping.toDto(domain );
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    //@PreAuthorize("hasPermission(this.ibzdeptmemberMapping.toDomain(#ibzdeptmemberdtos),'ibzou-IBZDeptMember-Update')")
    @ApiOperation(value = "UpdateBatch", tags = {"IBZDeptMember" },  notes = "UpdateBatch")
	@RequestMapping(method = RequestMethod.PUT, value = "/ibzdeptmembers/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<IBZDeptMemberDTO> ibzdeptmemberdtos) {
        ibzdeptmemberService.updateBatch(ibzdeptmemberMapping.toDomain(ibzdeptmemberdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzou-IBZDeptMember-Create-all')")
    @ApiOperation(value = "Create", tags = {"IBZDeptMember" },  notes = "Create")
	@RequestMapping(method = RequestMethod.POST, value = "/ibzdeptmembers")
    @Transactional
    public ResponseEntity<IBZDeptMemberDTO> create(@RequestBody IBZDeptMemberDTO ibzdeptmemberdto) {
        IBZDeptMember domain = ibzdeptmemberMapping.toDomain(ibzdeptmemberdto);
		ibzdeptmemberService.create(domain);
        IBZDeptMemberDTO dto = ibzdeptmemberMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    //@PreAuthorize("hasPermission(this.ibzdeptmemberMapping.toDomain(#ibzdeptmemberdtos),'ibzou-IBZDeptMember-Create')")
    @ApiOperation(value = "createBatch", tags = {"IBZDeptMember" },  notes = "createBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/ibzdeptmembers/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<IBZDeptMemberDTO> ibzdeptmemberdtos) {
        ibzdeptmemberService.createBatch(ibzdeptmemberMapping.toDomain(ibzdeptmemberdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzou-IBZDeptMember-Save-all')")
    @ApiOperation(value = "Save", tags = {"IBZDeptMember" },  notes = "Save")
	@RequestMapping(method = RequestMethod.POST, value = "/ibzdeptmembers/save")
    public ResponseEntity<Boolean> save(@RequestBody IBZDeptMemberDTO ibzdeptmemberdto) {
        return ResponseEntity.status(HttpStatus.OK).body(ibzdeptmemberService.save(ibzdeptmemberMapping.toDomain(ibzdeptmemberdto)));
    }

    //@PreAuthorize("hasPermission(this.ibzdeptmemberMapping.toDomain(#ibzdeptmemberdtos),'ibzou-IBZDeptMember-Save')")
    @ApiOperation(value = "SaveBatch", tags = {"IBZDeptMember" },  notes = "SaveBatch")
	@RequestMapping(method = RequestMethod.POST, value = "/ibzdeptmembers/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<IBZDeptMemberDTO> ibzdeptmemberdtos) {
        ibzdeptmemberService.saveBatch(ibzdeptmemberMapping.toDomain(ibzdeptmemberdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetDraft", tags = {"IBZDeptMember" },  notes = "GetDraft")
	@RequestMapping(method = RequestMethod.GET, value = "/ibzdeptmembers/getdraft")
    public ResponseEntity<IBZDeptMemberDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(ibzdeptmemberMapping.toDto(ibzdeptmemberService.getDraft(new IBZDeptMember())));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzou-IBZDeptMember-Get-all')")
    @ApiOperation(value = "Get", tags = {"IBZDeptMember" },  notes = "Get")
	@RequestMapping(method = RequestMethod.GET, value = "/ibzdeptmembers/{ibzdeptmember_id}")
    public ResponseEntity<IBZDeptMemberDTO> get(@PathVariable("ibzdeptmember_id") String ibzdeptmember_id) {
        IBZDeptMember domain = ibzdeptmemberService.get(ibzdeptmember_id);
        IBZDeptMemberDTO dto = ibzdeptmemberMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzou-IBZDeptMember-Remove-all')")
    @ApiOperation(value = "Remove", tags = {"IBZDeptMember" },  notes = "Remove")
	@RequestMapping(method = RequestMethod.DELETE, value = "/ibzdeptmembers/{ibzdeptmember_id}")
    @Transactional
    public ResponseEntity<Boolean> remove(@PathVariable("ibzdeptmember_id") String ibzdeptmember_id) {
         return ResponseEntity.status(HttpStatus.OK).body(ibzdeptmemberService.remove(ibzdeptmember_id));
    }

    //
    @ApiOperation(value = "RemoveBatch", tags = {"IBZDeptMember" },  notes = "RemoveBatch")
	@RequestMapping(method = RequestMethod.DELETE, value = "/ibzdeptmembers/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        ibzdeptmemberService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "CheckKey", tags = {"IBZDeptMember" },  notes = "CheckKey")
	@RequestMapping(method = RequestMethod.POST, value = "/ibzdeptmembers/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody IBZDeptMemberDTO ibzdeptmemberdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(ibzdeptmemberService.checkKey(ibzdeptmemberMapping.toDomain(ibzdeptmemberdto)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzou-IBZDeptMember-Default-all')")
	@ApiOperation(value = "fetchDEFAULT", tags = {"IBZDeptMember" } ,notes = "fetchDEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/ibzdeptmembers/fetchdefault")
	public ResponseEntity<List<IBZDeptMemberDTO>> fetchDefault(IBZDeptMemberSearchContext context) {
        Page<IBZDeptMember> domains = ibzdeptmemberService.searchDefault(context) ;
        List<IBZDeptMemberDTO> list = ibzdeptmemberMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzou-IBZDeptMember-Default-all')")
	@ApiOperation(value = "searchDEFAULT", tags = {"IBZDeptMember" } ,notes = "searchDEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/ibzdeptmembers/searchdefault")
	public ResponseEntity<Page<IBZDeptMemberDTO>> searchDefault(@RequestBody IBZDeptMemberSearchContext context) {
        Page<IBZDeptMember> domains = ibzdeptmemberService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(ibzdeptmemberMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzou-IBZDeptMember-Update-all')")
    @ApiOperation(value = "UpdateByIBZEmployee", tags = {"IBZDeptMember" },  notes = "UpdateByIBZEmployee")
	@RequestMapping(method = RequestMethod.PUT, value = "/ibzemployees/{ibzemployee_id}/ibzdeptmembers/{ibzdeptmember_id}")
    @Transactional
    public ResponseEntity<IBZDeptMemberDTO> updateByIBZEmployee(@PathVariable("ibzemployee_id") String ibzemployee_id, @PathVariable("ibzdeptmember_id") String ibzdeptmember_id, @RequestBody IBZDeptMemberDTO ibzdeptmemberdto) {
        IBZDeptMember domain = ibzdeptmemberMapping.toDomain(ibzdeptmemberdto);
        domain.setUserid(ibzemployee_id);
        domain.setMemberid(ibzdeptmember_id);
		ibzdeptmemberService.update(domain);
        IBZDeptMemberDTO dto = ibzdeptmemberMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    //@PreAuthorize("hasPermission(this.ibzdeptmemberMapping.toDomain(#ibzdeptmemberdtos),'ibzou-IBZDeptMember-Update')")
    @ApiOperation(value = "UpdateBatchByIBZEmployee", tags = {"IBZDeptMember" },  notes = "UpdateBatchByIBZEmployee")
	@RequestMapping(method = RequestMethod.PUT, value = "/ibzemployees/{ibzemployee_id}/ibzdeptmembers/batch")
    public ResponseEntity<Boolean> updateBatchByIBZEmployee(@PathVariable("ibzemployee_id") String ibzemployee_id, @RequestBody List<IBZDeptMemberDTO> ibzdeptmemberdtos) {
        List<IBZDeptMember> domainlist=ibzdeptmemberMapping.toDomain(ibzdeptmemberdtos);
        for(IBZDeptMember domain:domainlist){
            domain.setUserid(ibzemployee_id);
        }
        ibzdeptmemberService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzou-IBZDeptMember-Create-all')")
    @ApiOperation(value = "CreateByIBZEmployee", tags = {"IBZDeptMember" },  notes = "CreateByIBZEmployee")
	@RequestMapping(method = RequestMethod.POST, value = "/ibzemployees/{ibzemployee_id}/ibzdeptmembers")
    @Transactional
    public ResponseEntity<IBZDeptMemberDTO> createByIBZEmployee(@PathVariable("ibzemployee_id") String ibzemployee_id, @RequestBody IBZDeptMemberDTO ibzdeptmemberdto) {
        IBZDeptMember domain = ibzdeptmemberMapping.toDomain(ibzdeptmemberdto);
        domain.setUserid(ibzemployee_id);
		ibzdeptmemberService.create(domain);
        IBZDeptMemberDTO dto = ibzdeptmemberMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    //@PreAuthorize("hasPermission(this.ibzdeptmemberMapping.toDomain(#ibzdeptmemberdtos),'ibzou-IBZDeptMember-Create')")
    @ApiOperation(value = "createBatchByIBZEmployee", tags = {"IBZDeptMember" },  notes = "createBatchByIBZEmployee")
	@RequestMapping(method = RequestMethod.POST, value = "/ibzemployees/{ibzemployee_id}/ibzdeptmembers/batch")
    public ResponseEntity<Boolean> createBatchByIBZEmployee(@PathVariable("ibzemployee_id") String ibzemployee_id, @RequestBody List<IBZDeptMemberDTO> ibzdeptmemberdtos) {
        List<IBZDeptMember> domainlist=ibzdeptmemberMapping.toDomain(ibzdeptmemberdtos);
        for(IBZDeptMember domain:domainlist){
            domain.setUserid(ibzemployee_id);
        }
        ibzdeptmemberService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzou-IBZDeptMember-Save-all')")
    @ApiOperation(value = "SaveByIBZEmployee", tags = {"IBZDeptMember" },  notes = "SaveByIBZEmployee")
	@RequestMapping(method = RequestMethod.POST, value = "/ibzemployees/{ibzemployee_id}/ibzdeptmembers/save")
    public ResponseEntity<Boolean> saveByIBZEmployee(@PathVariable("ibzemployee_id") String ibzemployee_id, @RequestBody IBZDeptMemberDTO ibzdeptmemberdto) {
        IBZDeptMember domain = ibzdeptmemberMapping.toDomain(ibzdeptmemberdto);
        domain.setUserid(ibzemployee_id);
        return ResponseEntity.status(HttpStatus.OK).body(ibzdeptmemberService.save(domain));
    }

    //@PreAuthorize("hasPermission(this.ibzdeptmemberMapping.toDomain(#ibzdeptmemberdtos),'ibzou-IBZDeptMember-Save')")
    @ApiOperation(value = "SaveBatchByIBZEmployee", tags = {"IBZDeptMember" },  notes = "SaveBatchByIBZEmployee")
	@RequestMapping(method = RequestMethod.POST, value = "/ibzemployees/{ibzemployee_id}/ibzdeptmembers/savebatch")
    public ResponseEntity<Boolean> saveBatchByIBZEmployee(@PathVariable("ibzemployee_id") String ibzemployee_id, @RequestBody List<IBZDeptMemberDTO> ibzdeptmemberdtos) {
        List<IBZDeptMember> domainlist=ibzdeptmemberMapping.toDomain(ibzdeptmemberdtos);
        for(IBZDeptMember domain:domainlist){
             domain.setUserid(ibzemployee_id);
        }
        ibzdeptmemberService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetDraftByIBZEmployee", tags = {"IBZDeptMember" },  notes = "GetDraftByIBZEmployee")
    @RequestMapping(method = RequestMethod.GET, value = "/ibzemployees/{ibzemployee_id}/ibzdeptmembers/getdraft")
    public ResponseEntity<IBZDeptMemberDTO> getDraftByIBZEmployee(@PathVariable("ibzemployee_id") String ibzemployee_id) {
        IBZDeptMember domain = new IBZDeptMember();
        domain.setUserid(ibzemployee_id);
        return ResponseEntity.status(HttpStatus.OK).body(ibzdeptmemberMapping.toDto(ibzdeptmemberService.getDraft(domain)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzou-IBZDeptMember-Get-all')")
    @ApiOperation(value = "GetByIBZEmployee", tags = {"IBZDeptMember" },  notes = "GetByIBZEmployee")
	@RequestMapping(method = RequestMethod.GET, value = "/ibzemployees/{ibzemployee_id}/ibzdeptmembers/{ibzdeptmember_id}")
    public ResponseEntity<IBZDeptMemberDTO> getByIBZEmployee(@PathVariable("ibzemployee_id") String ibzemployee_id, @PathVariable("ibzdeptmember_id") String ibzdeptmember_id) {
        IBZDeptMember domain = ibzdeptmemberService.get(ibzdeptmember_id);
        IBZDeptMemberDTO dto = ibzdeptmemberMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzou-IBZDeptMember-Remove-all')")
    @ApiOperation(value = "RemoveByIBZEmployee", tags = {"IBZDeptMember" },  notes = "RemoveByIBZEmployee")
	@RequestMapping(method = RequestMethod.DELETE, value = "/ibzemployees/{ibzemployee_id}/ibzdeptmembers/{ibzdeptmember_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByIBZEmployee(@PathVariable("ibzemployee_id") String ibzemployee_id, @PathVariable("ibzdeptmember_id") String ibzdeptmember_id) {
		return ResponseEntity.status(HttpStatus.OK).body(ibzdeptmemberService.remove(ibzdeptmember_id));
    }

    //
    @ApiOperation(value = "RemoveBatchByIBZEmployee", tags = {"IBZDeptMember" },  notes = "RemoveBatchByIBZEmployee")
	@RequestMapping(method = RequestMethod.DELETE, value = "/ibzemployees/{ibzemployee_id}/ibzdeptmembers/batch")
    public ResponseEntity<Boolean> removeBatchByIBZEmployee(@RequestBody List<String> ids) {
        ibzdeptmemberService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "CheckKeyByIBZEmployee", tags = {"IBZDeptMember" },  notes = "CheckKeyByIBZEmployee")
	@RequestMapping(method = RequestMethod.POST, value = "/ibzemployees/{ibzemployee_id}/ibzdeptmembers/checkkey")
    public ResponseEntity<Boolean> checkKeyByIBZEmployee(@PathVariable("ibzemployee_id") String ibzemployee_id, @RequestBody IBZDeptMemberDTO ibzdeptmemberdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(ibzdeptmemberService.checkKey(ibzdeptmemberMapping.toDomain(ibzdeptmemberdto)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzou-IBZDeptMember-Default-all')")
	@ApiOperation(value = "fetchDEFAULTByIBZEmployee", tags = {"IBZDeptMember" } ,notes = "fetchDEFAULTByIBZEmployee")
    @RequestMapping(method= RequestMethod.GET , value="/ibzemployees/{ibzemployee_id}/ibzdeptmembers/fetchdefault")
	public ResponseEntity<List<IBZDeptMemberDTO>> fetchIBZDeptMemberDefaultByIBZEmployee(@PathVariable("ibzemployee_id") String ibzemployee_id,IBZDeptMemberSearchContext context) {
        context.setN_userid_eq(ibzemployee_id);
        Page<IBZDeptMember> domains = ibzdeptmemberService.searchDefault(context) ;
        List<IBZDeptMemberDTO> list = ibzdeptmemberMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzou-IBZDeptMember-Default-all')")
	@ApiOperation(value = "searchDEFAULTByIBZEmployee", tags = {"IBZDeptMember" } ,notes = "searchDEFAULTByIBZEmployee")
    @RequestMapping(method= RequestMethod.POST , value="/ibzemployees/{ibzemployee_id}/ibzdeptmembers/searchdefault")
	public ResponseEntity<Page<IBZDeptMemberDTO>> searchIBZDeptMemberDefaultByIBZEmployee(@PathVariable("ibzemployee_id") String ibzemployee_id, @RequestBody IBZDeptMemberSearchContext context) {
        context.setN_userid_eq(ibzemployee_id);
        Page<IBZDeptMember> domains = ibzdeptmemberService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(ibzdeptmemberMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzou-IBZDeptMember-Update-all')")
    @ApiOperation(value = "UpdateByIBZDepartmentIBZEmployee", tags = {"IBZDeptMember" },  notes = "UpdateByIBZDepartmentIBZEmployee")
	@RequestMapping(method = RequestMethod.PUT, value = "/ibzdepartments/{ibzdepartment_id}/ibzemployees/{ibzemployee_id}/ibzdeptmembers/{ibzdeptmember_id}")
    @Transactional
    public ResponseEntity<IBZDeptMemberDTO> updateByIBZDepartmentIBZEmployee(@PathVariable("ibzdepartment_id") String ibzdepartment_id, @PathVariable("ibzemployee_id") String ibzemployee_id, @PathVariable("ibzdeptmember_id") String ibzdeptmember_id, @RequestBody IBZDeptMemberDTO ibzdeptmemberdto) {
        IBZDeptMember domain = ibzdeptmemberMapping.toDomain(ibzdeptmemberdto);
        domain.setUserid(ibzemployee_id);
        domain.setMemberid(ibzdeptmember_id);
		ibzdeptmemberService.update(domain);
        IBZDeptMemberDTO dto = ibzdeptmemberMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    //@PreAuthorize("hasPermission(this.ibzdeptmemberMapping.toDomain(#ibzdeptmemberdtos),'ibzou-IBZDeptMember-Update')")
    @ApiOperation(value = "UpdateBatchByIBZDepartmentIBZEmployee", tags = {"IBZDeptMember" },  notes = "UpdateBatchByIBZDepartmentIBZEmployee")
	@RequestMapping(method = RequestMethod.PUT, value = "/ibzdepartments/{ibzdepartment_id}/ibzemployees/{ibzemployee_id}/ibzdeptmembers/batch")
    public ResponseEntity<Boolean> updateBatchByIBZDepartmentIBZEmployee(@PathVariable("ibzdepartment_id") String ibzdepartment_id, @PathVariable("ibzemployee_id") String ibzemployee_id, @RequestBody List<IBZDeptMemberDTO> ibzdeptmemberdtos) {
        List<IBZDeptMember> domainlist=ibzdeptmemberMapping.toDomain(ibzdeptmemberdtos);
        for(IBZDeptMember domain:domainlist){
            domain.setUserid(ibzemployee_id);
        }
        ibzdeptmemberService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzou-IBZDeptMember-Create-all')")
    @ApiOperation(value = "CreateByIBZDepartmentIBZEmployee", tags = {"IBZDeptMember" },  notes = "CreateByIBZDepartmentIBZEmployee")
	@RequestMapping(method = RequestMethod.POST, value = "/ibzdepartments/{ibzdepartment_id}/ibzemployees/{ibzemployee_id}/ibzdeptmembers")
    @Transactional
    public ResponseEntity<IBZDeptMemberDTO> createByIBZDepartmentIBZEmployee(@PathVariable("ibzdepartment_id") String ibzdepartment_id, @PathVariable("ibzemployee_id") String ibzemployee_id, @RequestBody IBZDeptMemberDTO ibzdeptmemberdto) {
        IBZDeptMember domain = ibzdeptmemberMapping.toDomain(ibzdeptmemberdto);
        domain.setUserid(ibzemployee_id);
		ibzdeptmemberService.create(domain);
        IBZDeptMemberDTO dto = ibzdeptmemberMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    //@PreAuthorize("hasPermission(this.ibzdeptmemberMapping.toDomain(#ibzdeptmemberdtos),'ibzou-IBZDeptMember-Create')")
    @ApiOperation(value = "createBatchByIBZDepartmentIBZEmployee", tags = {"IBZDeptMember" },  notes = "createBatchByIBZDepartmentIBZEmployee")
	@RequestMapping(method = RequestMethod.POST, value = "/ibzdepartments/{ibzdepartment_id}/ibzemployees/{ibzemployee_id}/ibzdeptmembers/batch")
    public ResponseEntity<Boolean> createBatchByIBZDepartmentIBZEmployee(@PathVariable("ibzdepartment_id") String ibzdepartment_id, @PathVariable("ibzemployee_id") String ibzemployee_id, @RequestBody List<IBZDeptMemberDTO> ibzdeptmemberdtos) {
        List<IBZDeptMember> domainlist=ibzdeptmemberMapping.toDomain(ibzdeptmemberdtos);
        for(IBZDeptMember domain:domainlist){
            domain.setUserid(ibzemployee_id);
        }
        ibzdeptmemberService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzou-IBZDeptMember-Save-all')")
    @ApiOperation(value = "SaveByIBZDepartmentIBZEmployee", tags = {"IBZDeptMember" },  notes = "SaveByIBZDepartmentIBZEmployee")
	@RequestMapping(method = RequestMethod.POST, value = "/ibzdepartments/{ibzdepartment_id}/ibzemployees/{ibzemployee_id}/ibzdeptmembers/save")
    public ResponseEntity<Boolean> saveByIBZDepartmentIBZEmployee(@PathVariable("ibzdepartment_id") String ibzdepartment_id, @PathVariable("ibzemployee_id") String ibzemployee_id, @RequestBody IBZDeptMemberDTO ibzdeptmemberdto) {
        IBZDeptMember domain = ibzdeptmemberMapping.toDomain(ibzdeptmemberdto);
        domain.setUserid(ibzemployee_id);
        return ResponseEntity.status(HttpStatus.OK).body(ibzdeptmemberService.save(domain));
    }

    //@PreAuthorize("hasPermission(this.ibzdeptmemberMapping.toDomain(#ibzdeptmemberdtos),'ibzou-IBZDeptMember-Save')")
    @ApiOperation(value = "SaveBatchByIBZDepartmentIBZEmployee", tags = {"IBZDeptMember" },  notes = "SaveBatchByIBZDepartmentIBZEmployee")
	@RequestMapping(method = RequestMethod.POST, value = "/ibzdepartments/{ibzdepartment_id}/ibzemployees/{ibzemployee_id}/ibzdeptmembers/savebatch")
    public ResponseEntity<Boolean> saveBatchByIBZDepartmentIBZEmployee(@PathVariable("ibzdepartment_id") String ibzdepartment_id, @PathVariable("ibzemployee_id") String ibzemployee_id, @RequestBody List<IBZDeptMemberDTO> ibzdeptmemberdtos) {
        List<IBZDeptMember> domainlist=ibzdeptmemberMapping.toDomain(ibzdeptmemberdtos);
        for(IBZDeptMember domain:domainlist){
             domain.setUserid(ibzemployee_id);
        }
        ibzdeptmemberService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetDraftByIBZDepartmentIBZEmployee", tags = {"IBZDeptMember" },  notes = "GetDraftByIBZDepartmentIBZEmployee")
    @RequestMapping(method = RequestMethod.GET, value = "/ibzdepartments/{ibzdepartment_id}/ibzemployees/{ibzemployee_id}/ibzdeptmembers/getdraft")
    public ResponseEntity<IBZDeptMemberDTO> getDraftByIBZDepartmentIBZEmployee(@PathVariable("ibzdepartment_id") String ibzdepartment_id, @PathVariable("ibzemployee_id") String ibzemployee_id) {
        IBZDeptMember domain = new IBZDeptMember();
        domain.setUserid(ibzemployee_id);
        return ResponseEntity.status(HttpStatus.OK).body(ibzdeptmemberMapping.toDto(ibzdeptmemberService.getDraft(domain)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzou-IBZDeptMember-Get-all')")
    @ApiOperation(value = "GetByIBZDepartmentIBZEmployee", tags = {"IBZDeptMember" },  notes = "GetByIBZDepartmentIBZEmployee")
	@RequestMapping(method = RequestMethod.GET, value = "/ibzdepartments/{ibzdepartment_id}/ibzemployees/{ibzemployee_id}/ibzdeptmembers/{ibzdeptmember_id}")
    public ResponseEntity<IBZDeptMemberDTO> getByIBZDepartmentIBZEmployee(@PathVariable("ibzdepartment_id") String ibzdepartment_id, @PathVariable("ibzemployee_id") String ibzemployee_id, @PathVariable("ibzdeptmember_id") String ibzdeptmember_id) {
        IBZDeptMember domain = ibzdeptmemberService.get(ibzdeptmember_id);
        IBZDeptMemberDTO dto = ibzdeptmemberMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzou-IBZDeptMember-Remove-all')")
    @ApiOperation(value = "RemoveByIBZDepartmentIBZEmployee", tags = {"IBZDeptMember" },  notes = "RemoveByIBZDepartmentIBZEmployee")
	@RequestMapping(method = RequestMethod.DELETE, value = "/ibzdepartments/{ibzdepartment_id}/ibzemployees/{ibzemployee_id}/ibzdeptmembers/{ibzdeptmember_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByIBZDepartmentIBZEmployee(@PathVariable("ibzdepartment_id") String ibzdepartment_id, @PathVariable("ibzemployee_id") String ibzemployee_id, @PathVariable("ibzdeptmember_id") String ibzdeptmember_id) {
		return ResponseEntity.status(HttpStatus.OK).body(ibzdeptmemberService.remove(ibzdeptmember_id));
    }

    //
    @ApiOperation(value = "RemoveBatchByIBZDepartmentIBZEmployee", tags = {"IBZDeptMember" },  notes = "RemoveBatchByIBZDepartmentIBZEmployee")
	@RequestMapping(method = RequestMethod.DELETE, value = "/ibzdepartments/{ibzdepartment_id}/ibzemployees/{ibzemployee_id}/ibzdeptmembers/batch")
    public ResponseEntity<Boolean> removeBatchByIBZDepartmentIBZEmployee(@RequestBody List<String> ids) {
        ibzdeptmemberService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "CheckKeyByIBZDepartmentIBZEmployee", tags = {"IBZDeptMember" },  notes = "CheckKeyByIBZDepartmentIBZEmployee")
	@RequestMapping(method = RequestMethod.POST, value = "/ibzdepartments/{ibzdepartment_id}/ibzemployees/{ibzemployee_id}/ibzdeptmembers/checkkey")
    public ResponseEntity<Boolean> checkKeyByIBZDepartmentIBZEmployee(@PathVariable("ibzdepartment_id") String ibzdepartment_id, @PathVariable("ibzemployee_id") String ibzemployee_id, @RequestBody IBZDeptMemberDTO ibzdeptmemberdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(ibzdeptmemberService.checkKey(ibzdeptmemberMapping.toDomain(ibzdeptmemberdto)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzou-IBZDeptMember-Default-all')")
	@ApiOperation(value = "fetchDEFAULTByIBZDepartmentIBZEmployee", tags = {"IBZDeptMember" } ,notes = "fetchDEFAULTByIBZDepartmentIBZEmployee")
    @RequestMapping(method= RequestMethod.GET , value="/ibzdepartments/{ibzdepartment_id}/ibzemployees/{ibzemployee_id}/ibzdeptmembers/fetchdefault")
	public ResponseEntity<List<IBZDeptMemberDTO>> fetchIBZDeptMemberDefaultByIBZDepartmentIBZEmployee(@PathVariable("ibzdepartment_id") String ibzdepartment_id, @PathVariable("ibzemployee_id") String ibzemployee_id,IBZDeptMemberSearchContext context) {
        context.setN_userid_eq(ibzemployee_id);
        Page<IBZDeptMember> domains = ibzdeptmemberService.searchDefault(context) ;
        List<IBZDeptMemberDTO> list = ibzdeptmemberMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzou-IBZDeptMember-Default-all')")
	@ApiOperation(value = "searchDEFAULTByIBZDepartmentIBZEmployee", tags = {"IBZDeptMember" } ,notes = "searchDEFAULTByIBZDepartmentIBZEmployee")
    @RequestMapping(method= RequestMethod.POST , value="/ibzdepartments/{ibzdepartment_id}/ibzemployees/{ibzemployee_id}/ibzdeptmembers/searchdefault")
	public ResponseEntity<Page<IBZDeptMemberDTO>> searchIBZDeptMemberDefaultByIBZDepartmentIBZEmployee(@PathVariable("ibzdepartment_id") String ibzdepartment_id, @PathVariable("ibzemployee_id") String ibzemployee_id, @RequestBody IBZDeptMemberSearchContext context) {
        context.setN_userid_eq(ibzemployee_id);
        Page<IBZDeptMember> domains = ibzdeptmemberService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(ibzdeptmemberMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzou-IBZDeptMember-Update-all')")
    @ApiOperation(value = "UpdateByIBZOrganizationIBZEmployee", tags = {"IBZDeptMember" },  notes = "UpdateByIBZOrganizationIBZEmployee")
	@RequestMapping(method = RequestMethod.PUT, value = "/ibzorganizations/{ibzorganization_id}/ibzemployees/{ibzemployee_id}/ibzdeptmembers/{ibzdeptmember_id}")
    @Transactional
    public ResponseEntity<IBZDeptMemberDTO> updateByIBZOrganizationIBZEmployee(@PathVariable("ibzorganization_id") String ibzorganization_id, @PathVariable("ibzemployee_id") String ibzemployee_id, @PathVariable("ibzdeptmember_id") String ibzdeptmember_id, @RequestBody IBZDeptMemberDTO ibzdeptmemberdto) {
        IBZDeptMember domain = ibzdeptmemberMapping.toDomain(ibzdeptmemberdto);
        domain.setUserid(ibzemployee_id);
        domain.setMemberid(ibzdeptmember_id);
		ibzdeptmemberService.update(domain);
        IBZDeptMemberDTO dto = ibzdeptmemberMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    //@PreAuthorize("hasPermission(this.ibzdeptmemberMapping.toDomain(#ibzdeptmemberdtos),'ibzou-IBZDeptMember-Update')")
    @ApiOperation(value = "UpdateBatchByIBZOrganizationIBZEmployee", tags = {"IBZDeptMember" },  notes = "UpdateBatchByIBZOrganizationIBZEmployee")
	@RequestMapping(method = RequestMethod.PUT, value = "/ibzorganizations/{ibzorganization_id}/ibzemployees/{ibzemployee_id}/ibzdeptmembers/batch")
    public ResponseEntity<Boolean> updateBatchByIBZOrganizationIBZEmployee(@PathVariable("ibzorganization_id") String ibzorganization_id, @PathVariable("ibzemployee_id") String ibzemployee_id, @RequestBody List<IBZDeptMemberDTO> ibzdeptmemberdtos) {
        List<IBZDeptMember> domainlist=ibzdeptmemberMapping.toDomain(ibzdeptmemberdtos);
        for(IBZDeptMember domain:domainlist){
            domain.setUserid(ibzemployee_id);
        }
        ibzdeptmemberService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzou-IBZDeptMember-Create-all')")
    @ApiOperation(value = "CreateByIBZOrganizationIBZEmployee", tags = {"IBZDeptMember" },  notes = "CreateByIBZOrganizationIBZEmployee")
	@RequestMapping(method = RequestMethod.POST, value = "/ibzorganizations/{ibzorganization_id}/ibzemployees/{ibzemployee_id}/ibzdeptmembers")
    @Transactional
    public ResponseEntity<IBZDeptMemberDTO> createByIBZOrganizationIBZEmployee(@PathVariable("ibzorganization_id") String ibzorganization_id, @PathVariable("ibzemployee_id") String ibzemployee_id, @RequestBody IBZDeptMemberDTO ibzdeptmemberdto) {
        IBZDeptMember domain = ibzdeptmemberMapping.toDomain(ibzdeptmemberdto);
        domain.setUserid(ibzemployee_id);
		ibzdeptmemberService.create(domain);
        IBZDeptMemberDTO dto = ibzdeptmemberMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    //@PreAuthorize("hasPermission(this.ibzdeptmemberMapping.toDomain(#ibzdeptmemberdtos),'ibzou-IBZDeptMember-Create')")
    @ApiOperation(value = "createBatchByIBZOrganizationIBZEmployee", tags = {"IBZDeptMember" },  notes = "createBatchByIBZOrganizationIBZEmployee")
	@RequestMapping(method = RequestMethod.POST, value = "/ibzorganizations/{ibzorganization_id}/ibzemployees/{ibzemployee_id}/ibzdeptmembers/batch")
    public ResponseEntity<Boolean> createBatchByIBZOrganizationIBZEmployee(@PathVariable("ibzorganization_id") String ibzorganization_id, @PathVariable("ibzemployee_id") String ibzemployee_id, @RequestBody List<IBZDeptMemberDTO> ibzdeptmemberdtos) {
        List<IBZDeptMember> domainlist=ibzdeptmemberMapping.toDomain(ibzdeptmemberdtos);
        for(IBZDeptMember domain:domainlist){
            domain.setUserid(ibzemployee_id);
        }
        ibzdeptmemberService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzou-IBZDeptMember-Save-all')")
    @ApiOperation(value = "SaveByIBZOrganizationIBZEmployee", tags = {"IBZDeptMember" },  notes = "SaveByIBZOrganizationIBZEmployee")
	@RequestMapping(method = RequestMethod.POST, value = "/ibzorganizations/{ibzorganization_id}/ibzemployees/{ibzemployee_id}/ibzdeptmembers/save")
    public ResponseEntity<Boolean> saveByIBZOrganizationIBZEmployee(@PathVariable("ibzorganization_id") String ibzorganization_id, @PathVariable("ibzemployee_id") String ibzemployee_id, @RequestBody IBZDeptMemberDTO ibzdeptmemberdto) {
        IBZDeptMember domain = ibzdeptmemberMapping.toDomain(ibzdeptmemberdto);
        domain.setUserid(ibzemployee_id);
        return ResponseEntity.status(HttpStatus.OK).body(ibzdeptmemberService.save(domain));
    }

    //@PreAuthorize("hasPermission(this.ibzdeptmemberMapping.toDomain(#ibzdeptmemberdtos),'ibzou-IBZDeptMember-Save')")
    @ApiOperation(value = "SaveBatchByIBZOrganizationIBZEmployee", tags = {"IBZDeptMember" },  notes = "SaveBatchByIBZOrganizationIBZEmployee")
	@RequestMapping(method = RequestMethod.POST, value = "/ibzorganizations/{ibzorganization_id}/ibzemployees/{ibzemployee_id}/ibzdeptmembers/savebatch")
    public ResponseEntity<Boolean> saveBatchByIBZOrganizationIBZEmployee(@PathVariable("ibzorganization_id") String ibzorganization_id, @PathVariable("ibzemployee_id") String ibzemployee_id, @RequestBody List<IBZDeptMemberDTO> ibzdeptmemberdtos) {
        List<IBZDeptMember> domainlist=ibzdeptmemberMapping.toDomain(ibzdeptmemberdtos);
        for(IBZDeptMember domain:domainlist){
             domain.setUserid(ibzemployee_id);
        }
        ibzdeptmemberService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetDraftByIBZOrganizationIBZEmployee", tags = {"IBZDeptMember" },  notes = "GetDraftByIBZOrganizationIBZEmployee")
    @RequestMapping(method = RequestMethod.GET, value = "/ibzorganizations/{ibzorganization_id}/ibzemployees/{ibzemployee_id}/ibzdeptmembers/getdraft")
    public ResponseEntity<IBZDeptMemberDTO> getDraftByIBZOrganizationIBZEmployee(@PathVariable("ibzorganization_id") String ibzorganization_id, @PathVariable("ibzemployee_id") String ibzemployee_id) {
        IBZDeptMember domain = new IBZDeptMember();
        domain.setUserid(ibzemployee_id);
        return ResponseEntity.status(HttpStatus.OK).body(ibzdeptmemberMapping.toDto(ibzdeptmemberService.getDraft(domain)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzou-IBZDeptMember-Get-all')")
    @ApiOperation(value = "GetByIBZOrganizationIBZEmployee", tags = {"IBZDeptMember" },  notes = "GetByIBZOrganizationIBZEmployee")
	@RequestMapping(method = RequestMethod.GET, value = "/ibzorganizations/{ibzorganization_id}/ibzemployees/{ibzemployee_id}/ibzdeptmembers/{ibzdeptmember_id}")
    public ResponseEntity<IBZDeptMemberDTO> getByIBZOrganizationIBZEmployee(@PathVariable("ibzorganization_id") String ibzorganization_id, @PathVariable("ibzemployee_id") String ibzemployee_id, @PathVariable("ibzdeptmember_id") String ibzdeptmember_id) {
        IBZDeptMember domain = ibzdeptmemberService.get(ibzdeptmember_id);
        IBZDeptMemberDTO dto = ibzdeptmemberMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzou-IBZDeptMember-Remove-all')")
    @ApiOperation(value = "RemoveByIBZOrganizationIBZEmployee", tags = {"IBZDeptMember" },  notes = "RemoveByIBZOrganizationIBZEmployee")
	@RequestMapping(method = RequestMethod.DELETE, value = "/ibzorganizations/{ibzorganization_id}/ibzemployees/{ibzemployee_id}/ibzdeptmembers/{ibzdeptmember_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByIBZOrganizationIBZEmployee(@PathVariable("ibzorganization_id") String ibzorganization_id, @PathVariable("ibzemployee_id") String ibzemployee_id, @PathVariable("ibzdeptmember_id") String ibzdeptmember_id) {
		return ResponseEntity.status(HttpStatus.OK).body(ibzdeptmemberService.remove(ibzdeptmember_id));
    }

    //
    @ApiOperation(value = "RemoveBatchByIBZOrganizationIBZEmployee", tags = {"IBZDeptMember" },  notes = "RemoveBatchByIBZOrganizationIBZEmployee")
	@RequestMapping(method = RequestMethod.DELETE, value = "/ibzorganizations/{ibzorganization_id}/ibzemployees/{ibzemployee_id}/ibzdeptmembers/batch")
    public ResponseEntity<Boolean> removeBatchByIBZOrganizationIBZEmployee(@RequestBody List<String> ids) {
        ibzdeptmemberService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "CheckKeyByIBZOrganizationIBZEmployee", tags = {"IBZDeptMember" },  notes = "CheckKeyByIBZOrganizationIBZEmployee")
	@RequestMapping(method = RequestMethod.POST, value = "/ibzorganizations/{ibzorganization_id}/ibzemployees/{ibzemployee_id}/ibzdeptmembers/checkkey")
    public ResponseEntity<Boolean> checkKeyByIBZOrganizationIBZEmployee(@PathVariable("ibzorganization_id") String ibzorganization_id, @PathVariable("ibzemployee_id") String ibzemployee_id, @RequestBody IBZDeptMemberDTO ibzdeptmemberdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(ibzdeptmemberService.checkKey(ibzdeptmemberMapping.toDomain(ibzdeptmemberdto)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzou-IBZDeptMember-Default-all')")
	@ApiOperation(value = "fetchDEFAULTByIBZOrganizationIBZEmployee", tags = {"IBZDeptMember" } ,notes = "fetchDEFAULTByIBZOrganizationIBZEmployee")
    @RequestMapping(method= RequestMethod.GET , value="/ibzorganizations/{ibzorganization_id}/ibzemployees/{ibzemployee_id}/ibzdeptmembers/fetchdefault")
	public ResponseEntity<List<IBZDeptMemberDTO>> fetchIBZDeptMemberDefaultByIBZOrganizationIBZEmployee(@PathVariable("ibzorganization_id") String ibzorganization_id, @PathVariable("ibzemployee_id") String ibzemployee_id,IBZDeptMemberSearchContext context) {
        context.setN_userid_eq(ibzemployee_id);
        Page<IBZDeptMember> domains = ibzdeptmemberService.searchDefault(context) ;
        List<IBZDeptMemberDTO> list = ibzdeptmemberMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzou-IBZDeptMember-Default-all')")
	@ApiOperation(value = "searchDEFAULTByIBZOrganizationIBZEmployee", tags = {"IBZDeptMember" } ,notes = "searchDEFAULTByIBZOrganizationIBZEmployee")
    @RequestMapping(method= RequestMethod.POST , value="/ibzorganizations/{ibzorganization_id}/ibzemployees/{ibzemployee_id}/ibzdeptmembers/searchdefault")
	public ResponseEntity<Page<IBZDeptMemberDTO>> searchIBZDeptMemberDefaultByIBZOrganizationIBZEmployee(@PathVariable("ibzorganization_id") String ibzorganization_id, @PathVariable("ibzemployee_id") String ibzemployee_id, @RequestBody IBZDeptMemberSearchContext context) {
        context.setN_userid_eq(ibzemployee_id);
        Page<IBZDeptMember> domains = ibzdeptmemberService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(ibzdeptmemberMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzou-IBZDeptMember-Update-all')")
    @ApiOperation(value = "UpdateByIBZOrganizationIBZDepartmentIBZEmployee", tags = {"IBZDeptMember" },  notes = "UpdateByIBZOrganizationIBZDepartmentIBZEmployee")
	@RequestMapping(method = RequestMethod.PUT, value = "/ibzorganizations/{ibzorganization_id}/ibzdepartments/{ibzdepartment_id}/ibzemployees/{ibzemployee_id}/ibzdeptmembers/{ibzdeptmember_id}")
    @Transactional
    public ResponseEntity<IBZDeptMemberDTO> updateByIBZOrganizationIBZDepartmentIBZEmployee(@PathVariable("ibzorganization_id") String ibzorganization_id, @PathVariable("ibzdepartment_id") String ibzdepartment_id, @PathVariable("ibzemployee_id") String ibzemployee_id, @PathVariable("ibzdeptmember_id") String ibzdeptmember_id, @RequestBody IBZDeptMemberDTO ibzdeptmemberdto) {
        IBZDeptMember domain = ibzdeptmemberMapping.toDomain(ibzdeptmemberdto);
        domain.setUserid(ibzemployee_id);
        domain.setMemberid(ibzdeptmember_id);
		ibzdeptmemberService.update(domain);
        IBZDeptMemberDTO dto = ibzdeptmemberMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    //@PreAuthorize("hasPermission(this.ibzdeptmemberMapping.toDomain(#ibzdeptmemberdtos),'ibzou-IBZDeptMember-Update')")
    @ApiOperation(value = "UpdateBatchByIBZOrganizationIBZDepartmentIBZEmployee", tags = {"IBZDeptMember" },  notes = "UpdateBatchByIBZOrganizationIBZDepartmentIBZEmployee")
	@RequestMapping(method = RequestMethod.PUT, value = "/ibzorganizations/{ibzorganization_id}/ibzdepartments/{ibzdepartment_id}/ibzemployees/{ibzemployee_id}/ibzdeptmembers/batch")
    public ResponseEntity<Boolean> updateBatchByIBZOrganizationIBZDepartmentIBZEmployee(@PathVariable("ibzorganization_id") String ibzorganization_id, @PathVariable("ibzdepartment_id") String ibzdepartment_id, @PathVariable("ibzemployee_id") String ibzemployee_id, @RequestBody List<IBZDeptMemberDTO> ibzdeptmemberdtos) {
        List<IBZDeptMember> domainlist=ibzdeptmemberMapping.toDomain(ibzdeptmemberdtos);
        for(IBZDeptMember domain:domainlist){
            domain.setUserid(ibzemployee_id);
        }
        ibzdeptmemberService.updateBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzou-IBZDeptMember-Create-all')")
    @ApiOperation(value = "CreateByIBZOrganizationIBZDepartmentIBZEmployee", tags = {"IBZDeptMember" },  notes = "CreateByIBZOrganizationIBZDepartmentIBZEmployee")
	@RequestMapping(method = RequestMethod.POST, value = "/ibzorganizations/{ibzorganization_id}/ibzdepartments/{ibzdepartment_id}/ibzemployees/{ibzemployee_id}/ibzdeptmembers")
    @Transactional
    public ResponseEntity<IBZDeptMemberDTO> createByIBZOrganizationIBZDepartmentIBZEmployee(@PathVariable("ibzorganization_id") String ibzorganization_id, @PathVariable("ibzdepartment_id") String ibzdepartment_id, @PathVariable("ibzemployee_id") String ibzemployee_id, @RequestBody IBZDeptMemberDTO ibzdeptmemberdto) {
        IBZDeptMember domain = ibzdeptmemberMapping.toDomain(ibzdeptmemberdto);
        domain.setUserid(ibzemployee_id);
		ibzdeptmemberService.create(domain);
        IBZDeptMemberDTO dto = ibzdeptmemberMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    //@PreAuthorize("hasPermission(this.ibzdeptmemberMapping.toDomain(#ibzdeptmemberdtos),'ibzou-IBZDeptMember-Create')")
    @ApiOperation(value = "createBatchByIBZOrganizationIBZDepartmentIBZEmployee", tags = {"IBZDeptMember" },  notes = "createBatchByIBZOrganizationIBZDepartmentIBZEmployee")
	@RequestMapping(method = RequestMethod.POST, value = "/ibzorganizations/{ibzorganization_id}/ibzdepartments/{ibzdepartment_id}/ibzemployees/{ibzemployee_id}/ibzdeptmembers/batch")
    public ResponseEntity<Boolean> createBatchByIBZOrganizationIBZDepartmentIBZEmployee(@PathVariable("ibzorganization_id") String ibzorganization_id, @PathVariable("ibzdepartment_id") String ibzdepartment_id, @PathVariable("ibzemployee_id") String ibzemployee_id, @RequestBody List<IBZDeptMemberDTO> ibzdeptmemberdtos) {
        List<IBZDeptMember> domainlist=ibzdeptmemberMapping.toDomain(ibzdeptmemberdtos);
        for(IBZDeptMember domain:domainlist){
            domain.setUserid(ibzemployee_id);
        }
        ibzdeptmemberService.createBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzou-IBZDeptMember-Save-all')")
    @ApiOperation(value = "SaveByIBZOrganizationIBZDepartmentIBZEmployee", tags = {"IBZDeptMember" },  notes = "SaveByIBZOrganizationIBZDepartmentIBZEmployee")
	@RequestMapping(method = RequestMethod.POST, value = "/ibzorganizations/{ibzorganization_id}/ibzdepartments/{ibzdepartment_id}/ibzemployees/{ibzemployee_id}/ibzdeptmembers/save")
    public ResponseEntity<Boolean> saveByIBZOrganizationIBZDepartmentIBZEmployee(@PathVariable("ibzorganization_id") String ibzorganization_id, @PathVariable("ibzdepartment_id") String ibzdepartment_id, @PathVariable("ibzemployee_id") String ibzemployee_id, @RequestBody IBZDeptMemberDTO ibzdeptmemberdto) {
        IBZDeptMember domain = ibzdeptmemberMapping.toDomain(ibzdeptmemberdto);
        domain.setUserid(ibzemployee_id);
        return ResponseEntity.status(HttpStatus.OK).body(ibzdeptmemberService.save(domain));
    }

    //@PreAuthorize("hasPermission(this.ibzdeptmemberMapping.toDomain(#ibzdeptmemberdtos),'ibzou-IBZDeptMember-Save')")
    @ApiOperation(value = "SaveBatchByIBZOrganizationIBZDepartmentIBZEmployee", tags = {"IBZDeptMember" },  notes = "SaveBatchByIBZOrganizationIBZDepartmentIBZEmployee")
	@RequestMapping(method = RequestMethod.POST, value = "/ibzorganizations/{ibzorganization_id}/ibzdepartments/{ibzdepartment_id}/ibzemployees/{ibzemployee_id}/ibzdeptmembers/savebatch")
    public ResponseEntity<Boolean> saveBatchByIBZOrganizationIBZDepartmentIBZEmployee(@PathVariable("ibzorganization_id") String ibzorganization_id, @PathVariable("ibzdepartment_id") String ibzdepartment_id, @PathVariable("ibzemployee_id") String ibzemployee_id, @RequestBody List<IBZDeptMemberDTO> ibzdeptmemberdtos) {
        List<IBZDeptMember> domainlist=ibzdeptmemberMapping.toDomain(ibzdeptmemberdtos);
        for(IBZDeptMember domain:domainlist){
             domain.setUserid(ibzemployee_id);
        }
        ibzdeptmemberService.saveBatch(domainlist);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "GetDraftByIBZOrganizationIBZDepartmentIBZEmployee", tags = {"IBZDeptMember" },  notes = "GetDraftByIBZOrganizationIBZDepartmentIBZEmployee")
    @RequestMapping(method = RequestMethod.GET, value = "/ibzorganizations/{ibzorganization_id}/ibzdepartments/{ibzdepartment_id}/ibzemployees/{ibzemployee_id}/ibzdeptmembers/getdraft")
    public ResponseEntity<IBZDeptMemberDTO> getDraftByIBZOrganizationIBZDepartmentIBZEmployee(@PathVariable("ibzorganization_id") String ibzorganization_id, @PathVariable("ibzdepartment_id") String ibzdepartment_id, @PathVariable("ibzemployee_id") String ibzemployee_id) {
        IBZDeptMember domain = new IBZDeptMember();
        domain.setUserid(ibzemployee_id);
        return ResponseEntity.status(HttpStatus.OK).body(ibzdeptmemberMapping.toDto(ibzdeptmemberService.getDraft(domain)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzou-IBZDeptMember-Get-all')")
    @ApiOperation(value = "GetByIBZOrganizationIBZDepartmentIBZEmployee", tags = {"IBZDeptMember" },  notes = "GetByIBZOrganizationIBZDepartmentIBZEmployee")
	@RequestMapping(method = RequestMethod.GET, value = "/ibzorganizations/{ibzorganization_id}/ibzdepartments/{ibzdepartment_id}/ibzemployees/{ibzemployee_id}/ibzdeptmembers/{ibzdeptmember_id}")
    public ResponseEntity<IBZDeptMemberDTO> getByIBZOrganizationIBZDepartmentIBZEmployee(@PathVariable("ibzorganization_id") String ibzorganization_id, @PathVariable("ibzdepartment_id") String ibzdepartment_id, @PathVariable("ibzemployee_id") String ibzemployee_id, @PathVariable("ibzdeptmember_id") String ibzdeptmember_id) {
        IBZDeptMember domain = ibzdeptmemberService.get(ibzdeptmember_id);
        IBZDeptMemberDTO dto = ibzdeptmemberMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzou-IBZDeptMember-Remove-all')")
    @ApiOperation(value = "RemoveByIBZOrganizationIBZDepartmentIBZEmployee", tags = {"IBZDeptMember" },  notes = "RemoveByIBZOrganizationIBZDepartmentIBZEmployee")
	@RequestMapping(method = RequestMethod.DELETE, value = "/ibzorganizations/{ibzorganization_id}/ibzdepartments/{ibzdepartment_id}/ibzemployees/{ibzemployee_id}/ibzdeptmembers/{ibzdeptmember_id}")
    @Transactional
    public ResponseEntity<Boolean> removeByIBZOrganizationIBZDepartmentIBZEmployee(@PathVariable("ibzorganization_id") String ibzorganization_id, @PathVariable("ibzdepartment_id") String ibzdepartment_id, @PathVariable("ibzemployee_id") String ibzemployee_id, @PathVariable("ibzdeptmember_id") String ibzdeptmember_id) {
		return ResponseEntity.status(HttpStatus.OK).body(ibzdeptmemberService.remove(ibzdeptmember_id));
    }

    //
    @ApiOperation(value = "RemoveBatchByIBZOrganizationIBZDepartmentIBZEmployee", tags = {"IBZDeptMember" },  notes = "RemoveBatchByIBZOrganizationIBZDepartmentIBZEmployee")
	@RequestMapping(method = RequestMethod.DELETE, value = "/ibzorganizations/{ibzorganization_id}/ibzdepartments/{ibzdepartment_id}/ibzemployees/{ibzemployee_id}/ibzdeptmembers/batch")
    public ResponseEntity<Boolean> removeBatchByIBZOrganizationIBZDepartmentIBZEmployee(@RequestBody List<String> ids) {
        ibzdeptmemberService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "CheckKeyByIBZOrganizationIBZDepartmentIBZEmployee", tags = {"IBZDeptMember" },  notes = "CheckKeyByIBZOrganizationIBZDepartmentIBZEmployee")
	@RequestMapping(method = RequestMethod.POST, value = "/ibzorganizations/{ibzorganization_id}/ibzdepartments/{ibzdepartment_id}/ibzemployees/{ibzemployee_id}/ibzdeptmembers/checkkey")
    public ResponseEntity<Boolean> checkKeyByIBZOrganizationIBZDepartmentIBZEmployee(@PathVariable("ibzorganization_id") String ibzorganization_id, @PathVariable("ibzdepartment_id") String ibzdepartment_id, @PathVariable("ibzemployee_id") String ibzemployee_id, @RequestBody IBZDeptMemberDTO ibzdeptmemberdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(ibzdeptmemberService.checkKey(ibzdeptmemberMapping.toDomain(ibzdeptmemberdto)));
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzou-IBZDeptMember-Default-all')")
	@ApiOperation(value = "fetchDEFAULTByIBZOrganizationIBZDepartmentIBZEmployee", tags = {"IBZDeptMember" } ,notes = "fetchDEFAULTByIBZOrganizationIBZDepartmentIBZEmployee")
    @RequestMapping(method= RequestMethod.GET , value="/ibzorganizations/{ibzorganization_id}/ibzdepartments/{ibzdepartment_id}/ibzemployees/{ibzemployee_id}/ibzdeptmembers/fetchdefault")
	public ResponseEntity<List<IBZDeptMemberDTO>> fetchIBZDeptMemberDefaultByIBZOrganizationIBZDepartmentIBZEmployee(@PathVariable("ibzorganization_id") String ibzorganization_id, @PathVariable("ibzdepartment_id") String ibzdepartment_id, @PathVariable("ibzemployee_id") String ibzemployee_id,IBZDeptMemberSearchContext context) {
        context.setN_userid_eq(ibzemployee_id);
        Page<IBZDeptMember> domains = ibzdeptmemberService.searchDefault(context) ;
        List<IBZDeptMemberDTO> list = ibzdeptmemberMapping.toDto(domains.getContent());
	    return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','ibzou-IBZDeptMember-Default-all')")
	@ApiOperation(value = "searchDEFAULTByIBZOrganizationIBZDepartmentIBZEmployee", tags = {"IBZDeptMember" } ,notes = "searchDEFAULTByIBZOrganizationIBZDepartmentIBZEmployee")
    @RequestMapping(method= RequestMethod.POST , value="/ibzorganizations/{ibzorganization_id}/ibzdepartments/{ibzdepartment_id}/ibzemployees/{ibzemployee_id}/ibzdeptmembers/searchdefault")
	public ResponseEntity<Page<IBZDeptMemberDTO>> searchIBZDeptMemberDefaultByIBZOrganizationIBZDepartmentIBZEmployee(@PathVariable("ibzorganization_id") String ibzorganization_id, @PathVariable("ibzdepartment_id") String ibzdepartment_id, @PathVariable("ibzemployee_id") String ibzemployee_id, @RequestBody IBZDeptMemberSearchContext context) {
        context.setN_userid_eq(ibzemployee_id);
        Page<IBZDeptMember> domains = ibzdeptmemberService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(ibzdeptmemberMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}
}
