package cn.ibizlab.util.client;

import cn.ibizlab.util.security.AuthenticationUser;
import cn.ibizlab.util.security.AuthorizationLogin;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;
import com.alibaba.fastjson.JSONObject;

@FeignClient(value = "ibzuaa-api",fallback = IBZUAAFallback.class)
public interface IBZUAAFeignClient
{
	/**
	 * 推送系统权限数据到uaa
	 * @param systemid
	 * @param systemPermissionData
	 * @return
	 */
	@PostMapping("/syspssystems/{systemid}/permissiondata")
	boolean pushSystemPermissionData(@PathVariable("systemid") String systemid,@RequestBody JSONObject systemPermissionData);

	/**
	 * 用户登录
	 * @param authorizationLogin 登录信息
	 * @return
	 */
	@PostMapping(value = "/uaa/login")
	AuthenticationUser login(@RequestBody AuthorizationLogin authorizationLogin);


	@PostMapping(value = "/uaa/loginbyusername")
	AuthenticationUser loginByUsername(@RequestBody String username);
}
