package cn.ibizlab.util.helper;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;

/**
 * 实体对象属性缓存类
 */
public class DEFieldCacheMap {

	private static Hashtable<String, Hashtable<String,Field>> cacheMap = new Hashtable<>();

	private static Hashtable<String, List<Field>> cacheList = new Hashtable<>();

	private static Hashtable<String, Hashtable<String,String>> cacheKey = new Hashtable<>();


	private static Object objLock1=new Object();
	private static Object objLock2=new Object();
	private static Object objLock3=new Object();

	/**
	 * 将实体对象中的属性存入缓存中
	 * @param className
	 * @return
	 */
	public static Hashtable<String,Field> getFieldMap(String className) {
		if(className.indexOf("_$")>0)
			className=className.substring(0, className.lastIndexOf("_$"));

		if(cacheMap.containsKey(className))
			return cacheMap.get(className);

		synchronized (objLock1) {

			if(cacheMap.containsKey(className))
				return cacheMap.get(className);

			Class clazz = null;
			try {
				clazz = Class.forName(className);
			}
			catch (Exception ex) {
				cacheMap.put(className, new Hashtable<String,Field>());
				return cacheMap.get(className);
			}

			Hashtable<String,Field> result = cacheMap.get(className);
			if (result == null) {
				result=new Hashtable<String,Field>();
				Field[] fields=clazz.getDeclaredFields();
				for(Field field:fields){
					result.put(field.getName(),field);
				}
				cacheMap.put(className, result);
			}
			return result;
		}
	}

	/**
	 * 从缓存中查询实体对象属性列表
	 * @param className
	 * @return
	 */
	public static List<Field> getFields(String className) {
		if(className.indexOf("_$")>0)
			className=className.substring(0, className.lastIndexOf("_$"));

		if(cacheList.containsKey(className))
			return cacheList.get(className);

		synchronized (objLock2) {
			if (cacheList.containsKey(className))
				return cacheList.get(className);
			Hashtable<String,Field> fieldmap=DEFieldCacheMap.getFieldMap(className);
			Iterator it = fieldmap.keySet().iterator();
			List<Field> list=new ArrayList<Field>();
			while(it.hasNext()) {
				Object key = it.next();
				if(fieldmap.get(key.toString())!=null)
					list.add(fieldmap.get(key.toString()));
			}
			cacheList.put(className,list);
			return list;
		}
	}

	/**
	 * 从缓存中查询实体对象属性列表
	 * @param className
	 * @return
	 */
	public static Hashtable<String,String> getFieldKeys(String className) {
		if(className.indexOf("_$")>0)
			className=className.substring(0, className.lastIndexOf("_$"));

		if(cacheKey.containsKey(className))
			return cacheKey.get(className);

		synchronized (objLock3) {
			if (cacheKey.containsKey(className))
				return cacheKey.get(className);
			Hashtable<String,Field> fieldmap=DEFieldCacheMap.getFieldMap(className);
			Iterator it = fieldmap.keySet().iterator();
			Hashtable<String,String> list=new Hashtable<String,String>();
			while(it.hasNext()) {
				Object key = it.next();
				list.put(key.toString().toLowerCase(),key.toString());
			}
			cacheKey.put(className,list);
			return list;
		}
	}

}