package cn.ibizlab.util.service;


import cn.ibizlab.util.errors.BadRequestAlertException;
import cn.ibizlab.util.security.AuthenticationUser;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.stereotype.Service;


public interface AuthenticationUserService extends UserDetailsService {

    @Override
    @Cacheable( value="ibzdict_users",key = "'getByUsername:'+#p0")
    AuthenticationUser loadUserByUsername(String username);

    @Cacheable( value="ibzdict_users",key = "'getByUsername:'+#p0")
    AuthenticationUser loadUserByLogin(String username,String password);

    @Cacheable( value="ibzdict_users",key = "'getByUsername:'+#p1")
    AuthenticationUser loadUserByLogin(String domain,String username,String password);

    @CacheEvict( value="ibzdict_users",key = "'getByUsername:'+#p0")
    void resetByUsername(String username);
}
